/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.animation.ArrayKeyframe;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.GenericTreeElement;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeList;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BScrollPane;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Vector;

public class TextureTrack
extends Track {
    ObjectInfo info;
    Timecourse tc;
    int smoothingMethod;
    WeightTrack theWeight;
    TextureParameter[] param;

    public TextureTrack(ObjectInfo info) {
        super("Texture");
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.theWeight = new WeightTrack(this);
        this.param = info.object.getParameters();
    }

    public void apply(double time) {
        ArrayKeyframe val = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (val == null) {
            return;
        }
        TextureParameter[] texParam = this.info.object.getParameters();
        ParameterValue[] paramValue = this.info.object.getParameterValues();
        double weight = this.theWeight.getWeight(time);
        for (int i = 0; i < texParam.length; ++i) {
            for (int j = 0; j < this.param.length; ++j) {
                if (!texParam[i].equals(this.param[j])) continue;
                double v = weight == 1.0 ? val.val[j] : (1.0 - weight) * paramValue[i].getAverageValue() + weight * val.val[j];
                if (v < texParam[i].minVal) {
                    v = texParam[i].minVal;
                }
                if (v > texParam[i].maxVal) {
                    v = texParam[i].maxVal;
                }
                paramValue[i] = new ConstantParameterValue(v);
            }
        }
        this.info.object.setParameterValues(paramValue);
    }

    public Track duplicate(Object obj) {
        TextureTrack t = new TextureTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        t.param = this.param;
        return t;
    }

    public void copy(Track tr) {
        TextureTrack t = (TextureTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.info);
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
        this.param = t.param;
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        TextureParameter[] texParam = this.info.object.getParameters();
        ParameterValue[] paramValue = this.info.object.getParameterValues();
        double[] d = new double[this.param.length];
        for (int i = 0; i < texParam.length; ++i) {
            for (int j = 0; j < this.param.length; ++j) {
                if (!texParam[i].equals(this.param[j])) continue;
                d[j] = paramValue[i].getAverageValue();
            }
        }
        ArrayKeyframe k = new ArrayKeyframe(d);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public Keyframe setKeyframeIfModified(double time, Scene sc) {
        TextureParameter[] texParam = this.info.object.getParameters();
        ParameterValue[] paramValue = this.info.object.getParameterValues();
        double[] d = new double[this.param.length];
        boolean change = false;
        ArrayKeyframe key = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        for (int i = 0; i < texParam.length; ++i) {
            for (int j = 0; j < this.param.length; ++j) {
                if (!texParam[i].equals(this.param[j])) continue;
                d[j] = paramValue[i].getAverageValue();
                if (key != null && d[j] == key.val[j]) continue;
                change = true;
            }
        }
        if (change) {
            ArrayKeyframe k = new ArrayKeyframe(d);
            this.tc.addTimepoint(k, time, new Smoothness());
            return k;
        }
        return null;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        String[] names = new String[this.param.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.param[i].name;
        }
        return names;
    }

    public double[] getDefaultGraphValues() {
        TextureParameter[] texParam = this.info.object.getParameters();
        ParameterValue[] paramValue = this.info.object.getParameterValues();
        double[] d = new double[this.param.length];
        for (int i = 0; i < texParam.length; ++i) {
            for (int j = 0; j < this.param.length; ++j) {
                if (!texParam[i].equals(this.param[j])) continue;
                d[j] = paramValue[i].getAverageValue();
            }
        }
        return d;
    }

    public double[][] getValueRange() {
        double[][] range = new double[this.param.length][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = this.param[i].minVal;
            range[i][1] = this.param[i].maxVal;
        }
        return range;
    }

    public ObjectInfo[] getDependencies() {
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
    }

    public void parametersChanged() {
        TextureParameter[] texParam = this.info.object.getParameters();
        boolean[] exists = new boolean[this.param.length];
        int num = 0;
        block0: for (int i = 0; i < this.param.length; ++i) {
            for (int j = 0; j < texParam.length; ++j) {
                if (!this.param[i].equals(texParam[j])) continue;
                exists[i] = true;
                ++num;
                continue block0;
            }
        }
        TextureParameter[] newparam = new TextureParameter[num];
        int j = 0;
        for (int i = 0; i < exists.length; ++i) {
            if (!exists[i]) continue;
            newparam[j++] = this.param[i];
        }
        this.param = newparam;
        Keyframe[] key = this.tc.getValues();
        for (int k = 0; k < key.length; ++k) {
            double[] newval = new double[num];
            int j2 = 0;
            for (int i = 0; i < exists.length; ++i) {
                if (!exists[i]) continue;
                newval[j2++] = ((ArrayKeyframe)key[k]).val[i];
            }
            ((ArrayKeyframe)key[k]).val = newval;
        }
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        int i;
        TextureParameter[] texParam = this.info.object.getParameters();
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeShort(this.param.length);
        int[] index = new int[this.param.length];
        for (i = 0; i < this.param.length; ++i) {
            for (int j = 0; j < texParam.length; ++j) {
                if (!this.param[i].equals(texParam[j])) continue;
                index[i] = j;
            }
        }
        for (i = 0; i < index.length; ++i) {
            out.writeShort(index[i]);
        }
        out.writeInt(t.length);
        for (i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            ((ArrayKeyframe)v[i]).writeToStream(out);
            s[i].writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        short numParams = in.readShort();
        this.param = new TextureParameter[numParams];
        TextureParameter[] texParam = this.info.object.getParameters();
        for (int i = 0; i < this.param.length; ++i) {
            this.param[i] = texParam[in.readShort()];
        }
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            v[i] = new ArrayKeyframe(in, this);
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
        this.theWeight.initFromStream(in, scene);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        ArrayKeyframe key = (ArrayKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !s.isForceSame());
        Widget[] widget = new Widget[this.param.length + 5];
        String[] label = new String[this.param.length + 5];
        for (int i = 0; i < this.param.length; ++i) {
            widget[i] = this.param[i].getEditingWidget(key.val[i]);
            label[i] = this.param[i].name;
        }
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        int n = this.param.length;
        widget[n] = timeField;
        widget[n + 1] = sameBox;
        widget[n + 2] = new BLabel(Translate.text("Smoothness") + ':');
        widget[n + 3] = s1Slider;
        widget[n + 4] = s2Slider;
        label[n] = Translate.text("Time");
        label[n + 3] = "(" + Translate.text("left") + ")";
        label[n + 4] = "(" + Translate.text("right") + ")";
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("editKeyframe"), widget, label);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        for (int i = 0; i < this.param.length; ++i) {
            key.val[i] = widget[i] instanceof ValueField ? ((ValueField)widget[i]).getValue() : ((ValueSlider)widget[i]).getValue();
        }
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        BTextField nameField = new BTextField(this.getName());
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        TreeList tree = new TreeList(win);
        BScrollPane sp = new BScrollPane(tree);
        Vector<GenericTreeElement> elements = new Vector<GenericTreeElement>();
        TextureParameter[] texParam = this.info.object.getParameters();
        ParameterValue[] paramValue = this.info.object.getParameterValues();
        if (this.info.object.getTextureMapping() instanceof LayeredMapping) {
            LayeredMapping map = (LayeredMapping)this.info.object.getTextureMapping();
            Texture[] layer = map.getLayers();
            for (int i = 0; i < layer.length; ++i) {
                Vector<GenericTreeElement> v = new Vector<GenericTreeElement>();
                TextureParameter[] p = map.getLayerParameters(i);
                for (int j = 0; j < p.length; ++j) {
                    int k = 0;
                    while (!texParam[k].equals(p[j])) {
                        ++k;
                    }
                    if (!(paramValue[k] instanceof ConstantParameterValue)) continue;
                    GenericTreeElement el = new GenericTreeElement(p[j].name, p[j].duplicate(), null, tree, null);
                    for (k = 0; k < this.param.length; ++k) {
                        if (!this.param[k].equals(p[j])) continue;
                        el.setSelected(true);
                    }
                    v.addElement(el);
                }
                if (v.size() == 0) {
                    GenericTreeElement el = new GenericTreeElement(Translate.text("noAdjustableParams"), null, null, tree, null);
                    el.setSelectable(false);
                    v.addElement(el);
                }
                GenericTreeElement el = new GenericTreeElement(Translate.text("layerLabel", Integer.toString(i + 1), layer[i].getName()), null, null, tree, v);
                el.setSelectable(false);
                el.setExpanded(true);
                elements.addElement(el);
            }
        } else {
            for (int i = 0; i < texParam.length; ++i) {
                if (!(paramValue[i] instanceof ConstantParameterValue)) continue;
                elements.addElement(new GenericTreeElement(texParam[i].name, texParam[i], null, tree, null));
            }
        }
        if (elements.size() == 0) {
            GenericTreeElement el = new GenericTreeElement(Translate.text("noAdjustableParams"), null, null, tree, null);
            el.setSelectable(false);
            elements.addElement(el);
        }
        GenericTreeElement texElem = new GenericTreeElement(Translate.text("Texture"), null, null, tree, elements);
        texElem.setSelectable(false);
        texElem.setExpanded(true);
        tree.addElement(texElem);
        tree.setPreferredSize(new Dimension(150, 100));
        sp.setPreferredViewSize(new Dimension(150, 250));
        sp.setForceWidth(true);
        sp.setForceHeight(true);
        tree.setBackground(Color.white);
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("paramTrackTitle"), new Widget[]{nameField, smoothChoice, Translate.label("selectTrackParams"), sp}, new String[]{Translate.text("trackName"), Translate.text("SmoothingMethod"), null, null});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        Object[] selected = tree.getSelectedObjects();
        int[] index = new int[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            index[i] = -1;
            for (int j = 0; j < this.param.length; ++j) {
                if (!this.param[j].equals((TextureParameter)selected[i])) continue;
                index[i] = j;
            }
        }
        this.param = new TextureParameter[selected.length];
        System.arraycopy(selected, 0, this.param, 0, selected.length);
        Keyframe[] key = this.tc.getValues();
        for (int i = 0; i < key.length; ++i) {
            double[] newval = new double[this.param.length];
            for (int j = 0; j < newval.length; ++j) {
                if (index[j] > -1) {
                    newval[j] = ((ArrayKeyframe)key[i]).val[index[j]];
                    continue;
                }
                for (int k = 0; k < texParam.length; ++k) {
                    if (!texParam[k].equals(this.param[j])) continue;
                    newval[j] = paramValue[k].getAverageValue();
                }
            }
            ((ArrayKeyframe)key[i]).val = newval;
        }
    }
}

