/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.IKSolver;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.EventProcessor;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BComboBox;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.text.NumberFormat;

public class SkeletonTool
extends EditingTool {
    private static final int CLICK_TOL = 6;
    private static final int HANDLE_SIZE = 4;
    private static final int NO_HANDLES = 0;
    private static final int UNLOCKED_HANDLES = 1;
    private static final int ALL_HANDLES = 2;
    private static Image icon;
    private static Image selectedIcon;
    private static int whichHandles;
    private Point clickPoint;
    private Vec3 clickPos;
    private static Vec3[] HANDLEPOS;
    private boolean[] hideHandle;
    private boolean invertDragDir;
    private int clickedHandle;
    private IKSolver ik;
    private Mesh oldMesh;
    private Mesh mesh;
    private UndoRecord undo;
    private EventProcessor process;
    private boolean allowCreating;
    private String helpText;

    public SkeletonTool(EditingWindow fr, boolean allowCreating) {
        super(fr);
        this.allowCreating = allowCreating;
        icon = this.loadImage("skeleton.gif");
        selectedIcon = this.loadImage("selected/skeleton.gif");
        this.clickedHandle = -1;
        this.helpText = Translate.text(allowCreating ? "skeletonTool.helpText" : "skeletonTool.helpTextNoCreate");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(this.helpText);
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("skeletonTool.tipText");
    }

    public Point[] getScreenPosOfHandles(MeshViewer mv, Joint j) {
        Camera cam = mv.getCamera();
        CoordinateSystem objCoords = mv.getDisplayCoordinates();
        Mat4 objToScreen = cam.getWorldToScreen().times(objCoords.fromLocal());
        double scale = 70.0 / cam.getScale();
        Vec3 jointPos = new Vec3(j.coords.getOrigin());
        objToScreen.transform(jointPos);
        int jointX = (int)jointPos.x;
        int jointY = (int)jointPos.y;
        Point[] result = new Point[HANDLEPOS.length];
        for (int i = 0; i < HANDLEPOS.length; ++i) {
            if (this.hideHandle[i]) {
                result[i] = null;
                continue;
            }
            Vec3 handlePos = HANDLEPOS[i].times(scale);
            j.coords.fromLocal().transformDirection(handlePos);
            handlePos.add(j.coords.getOrigin());
            objToScreen.transform(handlePos);
            int x = (int)handlePos.x;
            int y = (int)handlePos.y;
            result[i] = x == jointX && y == jointY ? null : new Point(x, y);
        }
        return result;
    }

    public void drawOverlay(Graphics g, ViewerCanvas view) {
        if (this.ik != null) {
            return;
        }
        MeshViewer mv = (MeshViewer)view;
        int selected = mv.getSelectedJoint();
        this.mesh = this.oldMesh == null ? (Mesh)((Object)mv.getObject().object) : this.oldMesh;
        Skeleton s = this.mesh.getSkeleton();
        Joint j = s.getJoint(selected);
        if (j == null) {
            return;
        }
        Camera cam = mv.getCamera();
        CoordinateSystem objCoords = mv.getDisplayCoordinates();
        Mat4 objToScreen = cam.getWorldToScreen().times(objCoords.fromLocal());
        if (this.clickedHandle == -1) {
            this.hideHandle = j.parent == null || whichHandles == 0 ? new boolean[]{true, true, true, true} : (whichHandles == 1 ? new boolean[]{j.angle1.fixed, j.angle2.fixed, j.length.fixed, j.twist.fixed} : new boolean[4]);
            Vec3 jointPos = new Vec3(j.coords.getOrigin());
            objToScreen.transform(jointPos);
            int jointX = (int)jointPos.x;
            int jointY = (int)jointPos.y;
            g.setPaintMode();
            Point[] handleScrPos = this.getScreenPosOfHandles(mv, j);
            for (int i = 0; i < this.hideHandle.length; ++i) {
                if (handleScrPos[i] == null) continue;
                int x = handleScrPos[i].x;
                int y = handleScrPos[i].y;
                g.setColor(Color.darkGray);
                g.drawLine(jointX, jointY, x, y);
                g.setColor(Color.red);
                g.fillRect(x - 2, y - 2, 4, 4);
            }
        } else if (this.clickedHandle < 2) {
            int i;
            Mat4 m2;
            Mat4 m1;
            double len = j.length.pos;
            if (this.clickedHandle == 0) {
                m1 = Mat4.zrotation(j.twist.pos * Math.PI / 180.0);
                m2 = j.parent.coords.fromLocal().times(Mat4.yrotation(j.angle2.pos * Math.PI / 180.0));
            } else {
                m1 = Mat4.xrotation(j.angle1.pos * Math.PI / 180.0).times(Mat4.zrotation(j.twist.pos * Math.PI / 180.0));
                m2 = j.parent.coords.fromLocal();
            }
            m2 = objToScreen.times(m2);
            Point[] pos = new Point[64];
            for (i = 0; i < pos.length; ++i) {
                double angle = (double)i * 2.0 * Math.PI / (double)pos.length;
                Vec3 p = new Vec3(0.0, 0.0, len);
                p = m1.timesDirection(p);
                p = this.clickedHandle == 0 ? m2.times(Mat4.xrotation(angle).timesDirection(p)) : m2.times(Mat4.yrotation(angle).timesDirection(p));
                pos[i] = new Point((int)p.x, (int)p.y);
            }
            g.setColor(Color.darkGray);
            for (i = 1; i < pos.length; ++i) {
                g.drawLine(pos[i - 1].x, pos[i - 1].y, pos[i].x, pos[i].y);
            }
            g.drawLine(pos[0].x, pos[0].y, pos[pos.length - 1].x, pos[pos.length - 1].y);
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        int i;
        MeshViewer mv = (MeshViewer)view;
        this.mesh = (Mesh)((Object)mv.getObject().object);
        Skeleton s = this.mesh.getSkeleton();
        Camera cam = mv.getCamera();
        CoordinateSystem objCoords = mv.getDisplayCoordinates();
        this.clickPoint = e.getPoint();
        if (e.isControlDown() && this.allowCreating) {
            Joint j;
            double distToJoint;
            this.undo = new UndoRecord(this.theWindow, false, 0, new Object[]{this.mesh, this.mesh.duplicate()});
            Joint parent = s.getJoint(mv.getSelectedJoint());
            if (parent == null) {
                distToJoint = cam.getDistToScreen();
                this.clickPos = cam.convertScreenToWorld(this.clickPoint, distToJoint);
                objCoords.toLocal().transform(this.clickPos);
                j = new Joint(new CoordinateSystem(this.clickPos, Vec3.vz(), Vec3.vy()), null, "Root " + s.getNextJointID());
                j.angle2.fixed = true;
                j.angle1.fixed = true;
                s.addJoint(j, -1);
            } else {
                distToJoint = cam.getWorldToView().timesZ(parent.coords.getOrigin());
                this.clickPos = cam.convertScreenToWorld(this.clickPoint, distToJoint);
                objCoords.toLocal().transform(this.clickPos);
                Vec3 zdir = this.clickPos.minus(parent.coords.getOrigin());
                zdir.normalize();
                Vec3 ydir = cam.getCameraCoordinates().getZDirection().cross(zdir);
                ydir.normalize();
                j = new Joint(new CoordinateSystem(this.clickPos, zdir, ydir), parent, "Bone " + s.getNextJointID());
                s.addJoint(j, parent.id);
            }
            mv.setSelectedJoint(j.id);
            boolean[] moving = new boolean[s.getNumJoints()];
            moving[s.findJointIndex((int)j.id)] = true;
            this.ik = new IKSolver(s, mv.getLockedJoints(), moving);
            view.updateImage();
            view.repaint();
            this.theWindow.updateMenus();
            this.oldMesh = (Mesh)((Object)this.mesh.duplicate());
            return;
        }
        if (this.hideHandle != null) {
            Joint selectedJoint = s.getJoint(mv.getSelectedJoint());
            Point[] handleScrPos = this.getScreenPosOfHandles(mv, selectedJoint);
            for (int i2 = 0; i2 < handleScrPos.length; ++i2) {
                if (handleScrPos[i2] == null || !((double)Math.abs(handleScrPos[i2].x - this.clickPoint.x) <= 3.0) || !((double)Math.abs(handleScrPos[i2].y - this.clickPoint.y) <= 3.0)) continue;
                this.clickedHandle = i2;
                this.oldMesh = (Mesh)((Object)this.mesh.duplicate());
                Mat4 objToScreen = cam.getWorldToScreen().times(objCoords.fromLocal());
                Vec2 jointPos = objToScreen.timesXY(selectedJoint.coords.getOrigin());
                this.invertDragDir = (double)handleScrPos[i2].x < jointPos.x;
                view.updateImage();
                view.repaint();
                return;
            }
        }
        Joint[] joint = s.getJoints();
        Mat4 objToScreen = cam.getWorldToScreen().times(objCoords.fromLocal());
        for (i = 0; i < joint.length; ++i) {
            Vec2 pos = objToScreen.timesXY(joint[i].coords.getOrigin());
            if ((double)this.clickPoint.x > pos.x - 6.0 && (double)this.clickPoint.x < pos.x + 6.0 && (double)this.clickPoint.y > pos.y - 6.0 && (double)this.clickPoint.y < pos.y + 6.0) break;
        }
        if (i == joint.length) {
            mv.setSelectedJoint(-1);
            view.updateImage();
            view.repaint();
            this.theWindow.updateMenus();
            return;
        }
        if (e.isShiftDown()) {
            if (mv.isJointLocked(joint[i].id)) {
                mv.unlockJoint(joint[i].id);
            } else {
                mv.lockJoint(joint[i].id);
            }
            view.updateImage();
            view.repaint();
            return;
        }
        mv.setSelectedJoint(joint[i].id);
        this.clickPos = joint[i].coords.getOrigin();
        view.updateImage();
        view.repaint();
        this.theWindow.updateMenus();
        boolean[] moving = new boolean[s.getNumJoints()];
        moving[s.findJointIndex((int)joint[i].id)] = true;
        this.ik = new IKSolver(s, mv.getLockedJoints(), moving);
        this.oldMesh = (Mesh)((Object)this.mesh.duplicate());
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        MeshViewer mv = (MeshViewer)view;
        CoordinateSystem objCoords = mv.getDisplayCoordinates();
        Camera cam = mv.getCamera();
        Mesh mesh = (Mesh)((Object)mv.getObject().object);
        Skeleton s = mesh.getSkeleton();
        Joint selectedJoint = s.getJoint(mv.getSelectedJoint());
        if (this.clickedHandle > -1) {
            if (this.undo == null) {
                this.undo = new UndoRecord(this.getWindow(), false, 0, new Object[]{mesh, mesh.duplicate()});
            }
            double dist = this.clickPoint.x - e.getPoint().x;
            if (this.invertDragDir) {
                dist = -dist;
            }
            Joint origJoint = this.oldMesh.getSkeleton().getJoint(mv.getSelectedJoint());
            Joint.DOF dof = null;
            Joint.DOF origDof = null;
            String name = null;
            switch (this.clickedHandle) {
                case 0: {
                    dof = selectedJoint.angle1;
                    origDof = origJoint.angle1;
                    dist *= 0.5729577951308232;
                    name = "X Bend";
                    break;
                }
                case 1: {
                    dof = selectedJoint.angle2;
                    origDof = origJoint.angle2;
                    dist *= -0.5729577951308232;
                    name = "Y Bend";
                    break;
                }
                case 2: {
                    dof = selectedJoint.length;
                    origDof = origJoint.length;
                    dist /= -cam.getScale();
                    name = "Length";
                    break;
                }
                case 3: {
                    dof = selectedJoint.twist;
                    origDof = origJoint.twist;
                    dist *= 0.5729577951308232;
                    name = "Twist";
                }
            }
            dof.set(origDof.pos + dist);
            selectedJoint.recalcCoords(true);
            if (!mv.getSkeletonDetached()) {
                Skeleton.adjustMesh(this.oldMesh, mesh);
            }
            mv.objectChanged();
            mv.updateImage();
            mv.repaint();
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(3);
            this.theWindow.setHelpText(name + ": " + nf.format(dof.pos));
            return;
        }
        if (this.ik == null) {
            return;
        }
        boolean converged = false;
        Vec3[] target = new Vec3[s.getNumJoints()];
        int jointIndex = s.findJointIndex(selectedJoint.id);
        ActionProcessor process = view.getActionProcessor();
        do {
            Vec3 jointPos = objCoords.fromLocal().times(selectedJoint.coords.getOrigin());
            double distToJoint = cam.getWorldToView().timesZ(jointPos);
            Vec3 goal = cam.convertScreenToWorld(e.getPoint(), distToJoint);
            objCoords.toLocal().transform(goal);
            if (this.undo == null) {
                this.undo = new UndoRecord(this.getWindow(), false, 0, new Object[]{mesh, mesh.duplicate()});
            }
            target[jointIndex] = goal;
            converged = this.ik.solve(target, 100);
            if (!mv.getSkeletonDetached()) {
                this.adjustMesh(mesh);
            }
            mv.objectChanged();
            mv.updateImage();
            mv.repaint();
        } while (!converged && (process == null || !process.hasEvent() && !process.hasBeenStopped()));
        mesh.getSkeleton().informChanged(this, "object editor drag");
        if (!mv.getSkeletonDetached()) {
            mesh.informChanged(this, "object editor drag");
        }
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.undo == null && e.getClickCount() == 2 && !e.isShiftDown() && !e.isControlDown()) {
            ((MeshEditorWindow)this.theWindow).editJointCommand();
        }
        this.ik = null;
        this.clickedHandle = -1;
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
            this.mesh.getSkeleton().informChanged(this, "object editor");
        }
        this.oldMesh = null;
        this.mesh = null;
        this.undo = null;
        this.theWindow.setHelpText(this.helpText);
    }

    public void iconDoubleClicked() {
        BComboBox dofChoice = new BComboBox(new String[]{Translate.text("noDOF"), Translate.text("unlockedDOF"), Translate.text("allDOF")});
        dofChoice.setSelectedIndex(whichHandles);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("skeletonToolTitle"), new Widget[]{dofChoice}, new String[]{null});
        if (!dlg.clickedOk()) {
            return;
        }
        whichHandles = dofChoice.getSelectedIndex();
        this.theWindow.updateImage();
    }

    protected void adjustMesh(Mesh newMesh) {
        Skeleton.adjustMesh(this.oldMesh, newMesh);
    }

    static {
        whichHandles = 1;
        HANDLEPOS = new Vec3[]{new Vec3(0.0, 1.0, 0.0), new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(-0.6, -0.6, 0.4)};
    }
}

