/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.TextureParameter;
import artofillusion.animation.Gesture;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.VertexParameterValue;

public abstract class MeshGesture
implements Gesture {
    protected abstract Mesh getMesh();

    protected abstract Vec3[] getVertexPositions();

    protected abstract void setVertexPositions(Vec3[] var1);

    public Gesture blend(Gesture[] p, double[] weight) {
        MeshGesture average = (MeshGesture)this.duplicate();
        MeshGesture[] p2 = new MeshGesture[p.length];
        for (int i = 0; i < p.length; ++i) {
            p2[i] = (MeshGesture)p[i];
        }
        this.blendSkeleton(average, p2, weight);
        this.blendSurface(average, p2, weight);
        return average;
    }

    public void blendSkeleton(MeshGesture average, MeshGesture[] p, double[] weight) {
        Skeleton[] s = new Skeleton[p.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = p[i].getSkeleton();
        }
        this.getSkeleton().blend(average.getSkeleton(), s, weight);
    }

    public void blendSurface(MeshGesture average, MeshGesture[] p, double[] weight) {
        Skeleton skeleton = this.getSkeleton();
        Joint[] joint = skeleton.getJoints();
        Joint[] jt = average.getSkeleton().getJoints();
        Vec3 temp = new Vec3();
        Mesh mesh = this.getMesh();
        MeshVertex[] vertex = mesh.getVertices();
        Vec3[] vertPos = this.getVertexPositions();
        Vec3[] avgPos = average.getVertexPositions();
        for (int j = 0; j < vertPos.length; ++j) {
            MeshVertex v = vertex[j];
            int index = skeleton.findJointIndex(v.ikJoint);
            if (index == -1) continue;
            Joint j1 = joint[index];
            Joint j2 = jt[index];
            double wt = j2.parent == null ? 1.0 : v.ikWeight;
            avgPos[j].set(vertPos[j]);
            j1.coords.toLocal().transform(avgPos[j]);
            j2.coords.fromLocal().transform(avgPos[j]);
            if (!(wt < 1.0)) continue;
            avgPos[j].scale(wt);
            temp.set(vertPos[j]);
            j1.parent.coords.toLocal().transform(temp);
            j2.parent.coords.fromLocal().transform(temp);
            temp.scale(1.0 - wt);
            avgPos[j].add(temp);
        }
        Vec3 temp1 = new Vec3();
        Vec3 temp2 = new Vec3();
        for (int i = 0; i < weight.length; ++i) {
            MeshGesture key = p[i];
            Vec3[] keyPos = key.getVertexPositions();
            for (int j = 0; j < vertPos.length; ++j) {
                MeshVertex v = vertex[j];
                int index = skeleton.findJointIndex(v.ikJoint);
                if (index == -1) {
                    avgPos[j].add(keyPos[j].minus(vertPos[j]).times(weight[i]));
                    continue;
                }
                Joint j1 = joint[index];
                Joint j2 = jt[index];
                Joint j3 = key.getSkeleton().getJoint(j1.id);
                double wt = j1.parent == null ? 1.0 : v.ikWeight;
                temp1.set(keyPos[j]);
                temp2.set(vertPos[j]);
                j3.coords.toLocal().transform(temp1);
                j1.coords.toLocal().transform(temp2);
                temp1.subtract(temp2);
                j2.coords.fromLocal().transformDirection(temp1);
                temp1.scale(wt * weight[i]);
                avgPos[j].add(temp1);
                if (!(wt < 1.0)) continue;
                temp1.set(keyPos[j]);
                temp2.set(vertPos[j]);
                j3.parent.coords.toLocal().transform(temp1);
                j1.parent.coords.toLocal().transform(temp2);
                temp1.subtract(temp2);
                j2.parent.coords.fromLocal().transformDirection(temp1);
                temp1.scale((1.0 - wt) * weight[i]);
                avgPos[j].add(temp1);
            }
            TextureParameter[] params = mesh.getParameters();
            for (int j = 0; j < params.length; ++j) {
                int m;
                Object kv;
                Object tv;
                ParameterValue val = average.getTextureParameter(params[j]);
                if (val instanceof ConstantParameterValue) {
                    tv = (ConstantParameterValue)val;
                    kv = (ConstantParameterValue)key.getTextureParameter(params[j]);
                    ((ConstantParameterValue)tv).setValue(((ConstantParameterValue)tv).getValue() + weight[i] * (((ConstantParameterValue)kv).getValue() - ((ConstantParameterValue)tv).getValue()));
                    continue;
                }
                if (val instanceof VertexParameterValue) {
                    tv = ((VertexParameterValue)val).getValue();
                    kv = ((VertexParameterValue)key.getTextureParameter(params[j])).getValue();
                    for (m = 0; m < ((Object)tv).length; ++m) {
                        Object object = tv;
                        int n = m;
                        object[n] = object[n] + weight[i] * (kv[m] - tv[m]);
                    }
                    ((VertexParameterValue)val).setValue((double[])tv);
                    continue;
                }
                if (val instanceof FaceParameterValue) {
                    tv = ((FaceParameterValue)val).getValue();
                    kv = ((FaceParameterValue)key.getTextureParameter(params[j])).getValue();
                    for (m = 0; m < ((Object)tv).length; ++m) {
                        Object object = tv;
                        int n = m;
                        object[n] = object[n] + weight[i] * (kv[m] - tv[m]);
                    }
                    ((FaceParameterValue)val).setValue((double[])tv);
                    continue;
                }
                if (!(val instanceof FaceVertexParameterValue)) continue;
                tv = ((FaceVertexParameterValue)val).getValue();
                kv = ((FaceVertexParameterValue)this.getTextureParameter(params[j])).getValue();
                for (m = 0; m < ((Object)tv).length; ++m) {
                    for (int n = 0; n < ((Object)tv[m]).length; ++n) {
                        Object object = tv[m];
                        int n2 = n;
                        object[n2] = object[n2] + weight[i] * (kv[m][n] - tv[m][n]);
                    }
                }
                ((FaceVertexParameterValue)val).setValue((double[][])tv);
            }
        }
    }

    private double findOffset(Joint.DOF gesture, Joint.DOF defaultPose) {
        double diff;
        if (gesture.loop) {
            double range = gesture.max - gesture.min;
            for (diff = gesture.pos - defaultPose.pos; diff > gesture.max; diff -= range) {
            }
            while (diff < gesture.min) {
                diff += range;
            }
        }
        return diff;
    }
}

