/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ModelEvent;
import artofillusion.ModelListener;
import artofillusion.SkeletonControlHolder;
import artofillusion.UndoRecord;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BTextField;
import buoy.widget.BorderContainer;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.util.Iterator;

public class JointEditorDialog
extends BDialog
implements ModelListener {
    private MeshEditorWindow window;
    private Mesh theMesh;
    private Object3D oldMesh;
    private Skeleton skeleton;
    SkeletonControlHolder skelControlHolder;
    private Joint joint;
    private BTextField nameField;
    private DOFPanel ang1Panel;
    private DOFPanel ang2Panel;
    private DOFPanel twistPanel;
    private DOFPanel lengthPanel;
    private BButton okButton;
    private BButton cancelButton;
    private boolean disableUpdating;
    Widget propertyPanel;
    static JointEditorDialog propertyDialog = null;
    static /* synthetic */ Class class$buoy$event$ValueChangedEvent;
    static /* synthetic */ Class class$buoy$event$MousePressedEvent;
    static /* synthetic */ Class class$buoy$event$MouseReleasedEvent;
    static /* synthetic */ Class class$buoy$event$MouseDraggedEvent;
    static /* synthetic */ Class class$buoy$event$RepaintEvent;

    public static void openPropertyDialog(MeshEditorWindow win, MeshViewer view) {
        if (propertyDialog != null) {
            return;
        }
        propertyDialog = new JointEditorDialog(win, view, -1);
    }

    public static void closePropertyDialog() {
        if (propertyDialog == null) {
            return;
        }
        propertyDialog.cancelAndClose();
    }

    public JointEditorDialog(MeshEditorWindow win, MeshViewer view, int jointID) {
        super(win, "Edit Bone", false);
        this.window = win;
        this.theMesh = (Mesh)((Object)view.getObject().object);
        this.oldMesh = ((Object3D)((Object)this.theMesh)).duplicate();
        this.skeleton = this.theMesh.getSkeleton();
        this.skelControlHolder = view.getSkeletonControlHolder();
        this.skelControlHolder.getModelEvent().addListener(this);
        this.skeleton.getModelEvent().addListener(this);
        this.propertyPanel = this.createPropertiesPanel();
        this.setContent(this.propertyPanel);
        this.editJoint(jointID);
        this.pack();
        this.setVisible(true);
    }

    public Widget createPropertiesPanel() {
        BorderContainer content = new BorderContainer();
        RowContainer nameRow = new RowContainer();
        nameRow.add(Translate.label("Name"));
        this.nameField = new BTextField("", 20);
        nameRow.add(this.nameField);
        content.add(nameRow, BorderContainer.NORTH, new LayoutInfo());
        FormContainer center = new FormContainer(4, 2);
        center.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(5, 5, 5, 5), null));
        this.ang1Panel = new DOFPanel("X Bend", -180.0, 180.0, null);
        center.add(this.makeBorder(this.ang1Panel), 0, 0);
        center.add(this.ang1Panel.getGraph(), 1, 0);
        this.ang2Panel = new DOFPanel("Y Bend", -180.0, 180.0, null);
        center.add(this.makeBorder(this.ang2Panel), 2, 0);
        center.add(this.ang2Panel.getGraph(), 3, 0);
        this.twistPanel = new DOFPanel("Twist", -180.0, 180.0, null);
        center.add(this.makeBorder(this.twistPanel), 0, 1);
        center.add(this.twistPanel.getGraph(), 1, 1);
        this.lengthPanel = new DOFPanel("Length", 0.0, Double.MAX_VALUE, null);
        center.add(this.makeBorder(this.lengthPanel), 2, 1);
        content.add(center, BorderContainer.CENTER);
        RowContainer buttons = new RowContainer();
        this.okButton = Translate.button("ok", this, "doOk");
        buttons.add(this.okButton);
        this.cancelButton = Translate.button("cancel", this, "doCancel");
        buttons.add(this.cancelButton);
        content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
        this.setResizable(false);
        return content;
    }

    public void cancelAndClose() {
        ((Object3D)((Object)this.theMesh)).copyObject(this.oldMesh);
        ((Object3D)((Object)this.theMesh)).informChanged(this, "dont know");
        this.skelControlHolder.getModelEvent().removeListener(this);
        this.skeleton.getModelEvent().removeListener(this);
        this.dispose();
    }

    protected void releaseCurrentJoint() {
        if (this.joint != null && this.joint.id != -1) {
            this.joint.getModelEvent().removeListener(this);
            this.valueChanged();
            this.joint.name = this.nameField.getText();
            this.window.setUndoRecord(new UndoRecord(this.window, false, 0, new Object[]{this.theMesh, this.oldMesh}));
        }
    }

    protected void editJoint(int jointID) {
        this.joint = this.skeleton.getJoint(jointID);
        if (this.joint == null) {
            this.joint = Joint.createDefaultJoint();
        }
        this.joint.getModelEvent().addListener(this);
        this.transferToDialog();
    }

    protected void transferToDialog() {
        this.nameField.setText(this.joint.name);
        this.ang1Panel.transferToPanel(this.joint.angle1);
        this.ang2Panel.transferToPanel(this.joint.angle2);
        this.twistPanel.transferToPanel(this.joint.twist);
        this.lengthPanel.transferToPanel(this.joint.length);
        this.lengthPanel.setEnabled(this.joint.parent != null);
    }

    public void modelEventHappened(ModelEvent event) {
        System.out.println("JointEditorDialog.modelEventHappened " + event.getSource());
        if (event.getSource() == this.skelControlHolder) {
            if (event.hasKey("joint deselected")) {
                this.releaseCurrentJoint();
            } else if (event.hasKey("joint selected")) {
                this.editJoint((Integer)event.getValue("joint selected"));
            }
        } else if (event.getSource() == this.skeleton) {
            if (event.hasKey("skeleton changed") && event.getCause() != this) {
                System.out.println("JointEditorDialog.modelEventHappened updateComponents");
                this.joint.getModelEvent().removeListener(this);
                this.editJoint(this.joint.getId());
            }
        } else if (event.getSource() == this.joint) {
            System.out.println("Some Joint Moved " + ((Joint)event.getSource()).id);
            if (event.hasKey("joint dof changed") && event.getCause() != this) {
                System.out.println("Event joint moved");
                this.ang1Panel.updateComponents();
                this.ang2Panel.updateComponents();
                this.twistPanel.updateComponents();
                this.lengthPanel.updateComponents();
            }
        }
    }

    private Widget makeBorder(Widget w) {
        return BOutline.createBevelBorder(BOutline.createEmptyBorder(w, 4), false);
    }

    private void doOk() {
        this.valueChanged();
        this.joint.name = this.nameField.getText();
        this.window.setUndoRecord(new UndoRecord(this.window, false, 0, new Object[]{this.theMesh, this.oldMesh}));
        this.dispose();
    }

    private void doCancel() {
        ((Object3D)((Object)this.theMesh)).copyObject(this.oldMesh);
        this.dispose();
    }

    private void valueChanged() {
        boolean ok = this.ang1Panel.isValid() && this.ang2Panel.isValid() && this.twistPanel.isValid() && this.lengthPanel.isValid();
        this.okButton.setEnabled(ok);
        if (!ok) {
            return;
        }
        this.ang1Panel.recordValues();
        this.ang2Panel.recordValues();
        this.twistPanel.recordValues();
        this.lengthPanel.recordValues();
        this.joint.recalcCoords(true);
        this.joint.informChanged(this, "dont know");
        if (!this.skeleton.getSkeletonDetached()) {
            Skeleton.adjustMesh((Mesh)((Object)this.oldMesh), this.theMesh);
            ((Object3D)((Object)this.theMesh)).informChanged(this, "dont know");
        }
        this.skeleton.informChanged(this, "dont know");
    }

    private class DOFGraph
    extends CustomWidget {
        private DOFPanel panel;
        private int dragging;
        private double lastAngle;
        private ActionProcessor process;
        private static final int SIZE = 64;
        private static final int RADIUS1 = 64;
        private static final int RADIUS2 = 58;
        private static final int RADIUS3 = 52;
        private static final int HANDLE_SIZE = 6;
        private static final int OFFSET1 = 3;
        private static final int OFFSET2 = 6;
        private static final int OFFSET3 = 9;

        public DOFGraph(DOFPanel dp) {
            this.panel = dp;
            this.dragging = -1;
            this.addEventLink(class$buoy$event$MousePressedEvent == null ? (class$buoy$event$MousePressedEvent = JointEditorDialog.class$("buoy.event.MousePressedEvent")) : class$buoy$event$MousePressedEvent, (Object)this, "mousePressed");
            this.addEventLink(class$buoy$event$MouseReleasedEvent == null ? (class$buoy$event$MouseReleasedEvent = JointEditorDialog.class$("buoy.event.MouseReleasedEvent")) : class$buoy$event$MouseReleasedEvent, (Object)this, "mouseReleased");
            this.addEventLink(class$buoy$event$MouseDraggedEvent == null ? (class$buoy$event$MouseDraggedEvent = JointEditorDialog.class$("buoy.event.MouseDraggedEvent")) : class$buoy$event$MouseDraggedEvent, (Object)this, "mouseDragged");
            this.addEventLink(class$buoy$event$RepaintEvent == null ? (class$buoy$event$RepaintEvent = JointEditorDialog.class$("buoy.event.RepaintEvent")) : class$buoy$event$RepaintEvent, (Object)this, "paint");
            this.setPreferredSize(new Dimension(70, 70));
        }

        private void mousePressed(MousePressedEvent ev) {
            Point v;
            this.process = new ActionProcessor();
            this.lastAngle = 0.0;
            if (this.panel.fixedBox.getState()) {
                return;
            }
            Point c = ev.getPoint();
            if (this.clicked(c, v = this.getAnglePosition(this.panel.valField.getValue(), 64))) {
                this.dragging = 0;
                JointEditorDialog.this.disableUpdating = true;
                return;
            }
            if (!this.panel.rangeBox.getState()) {
                return;
            }
            v = this.getAnglePosition(this.panel.maxField.getValue(), 58);
            if (this.clicked(c, v)) {
                this.dragging = 2;
            }
            if (this.clicked(c, v = this.getAnglePosition(this.panel.minField.getValue(), 58))) {
                this.dragging = 1;
            }
            if (this.dragging > -1) {
                JointEditorDialog.this.disableUpdating = true;
            }
            if (!this.panel.comfortBox.getState()) {
                return;
            }
            v = this.getAnglePosition(this.panel.maxComfortField.getValue(), 52);
            if (this.clicked(c, v)) {
                this.dragging = 4;
            }
            if (this.clicked(c, v = this.getAnglePosition(this.panel.minComfortField.getValue(), 52))) {
                this.dragging = 3;
            }
            if (this.dragging > -1) {
                JointEditorDialog.this.disableUpdating = true;
            }
        }

        private void mouseReleased(MouseReleasedEvent ev) {
            if (this.process != null) {
                this.process.stopProcessing();
            }
            this.process = null;
            this.dragging = -1;
            JointEditorDialog.this.disableUpdating = false;
        }

        private void mouseDragged(final MouseDraggedEvent ev) {
            this.process.addEvent(new Runnable(){

                public void run() {
                    DOFGraph.this.dealWithDrag(ev);
                }
            });
        }

        private void dealWithDrag(MouseDraggedEvent ev) {
            if (this.dragging == -1) {
                return;
            }
            System.out.println("DOFGraph dealWithDrag");
            Point pos = ev.getPoint();
            double angle = Math.atan2(pos.x - 3 - 32, 35 - pos.y) * 180.0 / Math.PI;
            angle = Math.rint(angle);
            if (this.lastAngle - angle > 270.0) {
                angle += 360.0;
            } else if (angle - this.lastAngle > 270.0) {
                angle -= 360.0;
            }
            double val = this.panel.dof.pos;
            boolean range = this.panel.rangeBox.getState();
            double minv = range ? this.panel.dof.min : this.panel.min;
            double maxv = range ? this.panel.dof.max : this.panel.max;
            double minComfort = this.panel.dof.minComfort;
            double maxComfort = this.panel.dof.maxComfort;
            if (this.dragging != 1 && angle < minv) {
                angle = minv;
            }
            if (this.dragging != 2 && angle > maxv) {
                angle = maxv;
            }
            if (this.dragging == 1 && angle > val || this.dragging == 2 && angle < val) {
                angle = val;
            }
            if (this.dragging == 3 && angle > maxComfort) {
                angle = maxComfort;
            }
            if (this.dragging == 4 && angle < minComfort) {
                angle = minComfort;
            }
            if (this.panel.dof.comfort) {
                if (this.dragging == 1 && angle > minComfort) {
                    angle = minComfort;
                }
                if (this.dragging == 2 && angle < maxComfort) {
                    angle = maxComfort;
                }
            }
            if (this.dragging == 0) {
                this.panel.valField.setValue(angle);
            } else if (this.dragging == 1) {
                this.panel.minField.setValue(angle);
            } else if (this.dragging == 2) {
                this.panel.maxField.setValue(angle);
            } else if (this.dragging == 3) {
                this.panel.minComfortField.setValue(angle);
            } else if (this.dragging == 4) {
                this.panel.maxComfortField.setValue(angle);
            }
            this.lastAngle = angle;
            this.panel.recordValues();
            this.repaint();
            JointEditorDialog.this.valueChanged();
        }

        private void paint(RepaintEvent ev) {
            Graphics2D g = ev.getGraphics();
            if (this.panel.fixedBox.getState()) {
                g.setColor(Color.lightGray);
                g.fillOval(0, 0, 67, 67);
                g.setColor(Color.black);
                Point p = this.getAnglePosition(this.panel.valField.getValue(), 64);
                g.drawLine(35, 35, p.x, p.y);
                return;
            }
            g.setColor(Color.white);
            g.fillOval(3, 3, 64, 64);
            int min = (int)(this.panel.rangeBox.getState() ? this.panel.minField.getValue() : this.panel.min);
            int max = (int)(this.panel.rangeBox.getState() ? this.panel.maxField.getValue() : this.panel.max);
            g.setColor(Color.black);
            g.fillArc(6, 6, 58, 58, 90 - min, 360 - max + min);
            if (this.panel.rangeBox.getState() && this.panel.comfortBox.getState()) {
                g.setColor(Color.lightGray);
                int minComfort = (int)this.panel.minComfortField.getValue();
                int maxComfort = (int)this.panel.maxComfortField.getValue();
                g.fillArc(9, 9, 52, 52, 90 - minComfort, minComfort - min);
                g.fillArc(9, 9, 52, 52, 90 - max, max - maxComfort);
                min = minComfort;
                max = maxComfort;
                g.setColor(Color.black);
            }
            g.drawOval(3, 3, 64, 64);
            Point p = this.getAnglePosition(this.panel.valField.getValue(), 64);
            g.drawLine(35, 35, p.x, p.y);
            g.fillRect(p.x - 3, p.y - 3, 6, 6);
            if (this.panel.rangeBox.getState()) {
                p = this.getAnglePosition(this.panel.minField.getValue(), 58);
                g.fillRect(p.x - 3, p.y - 3, 6, 6);
                p = this.getAnglePosition(this.panel.maxField.getValue(), 58);
                g.fillRect(p.x - 3, p.y - 3, 6, 6);
            }
            if (this.panel.rangeBox.getState() && this.panel.comfortBox.getState()) {
                p = this.getAnglePosition(this.panel.minComfortField.getValue(), 52);
                g.fillRect(p.x - 3, p.y - 3, 6, 6);
                p = this.getAnglePosition(this.panel.maxComfortField.getValue(), 52);
                g.fillRect(p.x - 3, p.y - 3, 6, 6);
            }
        }

        private Point getAnglePosition(double angle, int radius) {
            return new Point((int)(0.5 * (64.0 + (double)radius * Math.sin(angle * Math.PI / 180.0))) + 3, (int)(0.5 * (64.0 - (double)radius * Math.cos(angle * Math.PI / 180.0))) + 3);
        }

        public boolean clicked(Point clickPos, Point targetPos) {
            return clickPos.x >= targetPos.x - 3 && clickPos.x <= targetPos.x + 3 && clickPos.y >= targetPos.y - 3 && clickPos.y <= targetPos.y + 3;
        }
    }

    private class DOFPanel
    extends FormContainer {
        public ValueField valField;
        public ValueField minField;
        public ValueField maxField;
        public ValueField minComfortField;
        public ValueField maxComfortField;
        public ValueSlider stiffnessSlider;
        public BCheckBox fixedBox;
        public BCheckBox rangeBox;
        public BCheckBox comfortBox;
        public double min;
        public double max;
        public Joint.DOF dof;
        private DOFGraph graph;

        public DOFPanel(String name, double min, double max, Joint.DOF dof) {
            super(3, 7);
            this.min = min;
            this.max = max;
            this.dof = dof;
            this.valField = new ValueField(0.0, 0, 5);
            this.minField = new ValueField(0.0, 0, 5);
            this.maxField = new ValueField(Double.NaN, 0, 5);
            this.minComfortField = new ValueField(0.0, 0, 5);
            this.maxComfortField = new ValueField(Double.NaN, 0, 5);
            this.valField.setValueChecker(new ValueChecker(){

                public boolean isValid(double val) {
                    double lower = DOFPanel.this.rangeBox.getState() ? DOFPanel.this.minField.getValue() : DOFPanel.this.min;
                    double upper = DOFPanel.this.rangeBox.getState() ? DOFPanel.this.maxField.getValue() : DOFPanel.this.max;
                    return val >= lower && val <= upper;
                }
            });
            this.minField.setValueChecker(new ValueChecker(){

                public boolean isValid(double val) {
                    if (!DOFPanel.this.rangeBox.getState()) {
                        return true;
                    }
                    if (DOFPanel.this.comfortBox.getState() && val > DOFPanel.this.minComfortField.getValue()) {
                        return false;
                    }
                    return val <= DOFPanel.this.valField.getValue() && val >= DOFPanel.this.min;
                }
            });
            this.maxField.setValueChecker(new ValueChecker(){

                public boolean isValid(double val) {
                    if (!DOFPanel.this.rangeBox.getState()) {
                        return true;
                    }
                    if (DOFPanel.this.comfortBox.getState() && val < DOFPanel.this.maxComfortField.getValue()) {
                        return false;
                    }
                    return val >= DOFPanel.this.valField.getValue() && val <= DOFPanel.this.max;
                }
            });
            this.minComfortField.setValueChecker(new ValueChecker(){

                public boolean isValid(double val) {
                    if (!DOFPanel.this.comfortBox.getState() || !DOFPanel.this.rangeBox.getState()) {
                        return true;
                    }
                    double lower = DOFPanel.this.minField.getValue();
                    double upper = Math.min(DOFPanel.this.maxField.getValue(), DOFPanel.this.maxComfortField.getValue());
                    return val >= lower && val <= upper;
                }
            });
            this.maxComfortField.setValueChecker(new ValueChecker(){

                public boolean isValid(double val) {
                    if (!DOFPanel.this.comfortBox.getState() || !DOFPanel.this.rangeBox.getState()) {
                        return true;
                    }
                    double lower = Math.max(DOFPanel.this.minField.getValue(), DOFPanel.this.minComfortField.getValue());
                    double upper = DOFPanel.this.maxField.getValue();
                    return val >= lower && val <= upper;
                }
            });
            Object tl = new Object(){

                void processEvent() {
                    DOFPanel.this.valField.checkIfValid();
                    DOFPanel.this.minField.checkIfValid();
                    DOFPanel.this.maxField.checkIfValid();
                    DOFPanel.this.minComfortField.checkIfValid();
                    DOFPanel.this.maxComfortField.checkIfValid();
                    JointEditorDialog.this.valueChanged();
                    if (DOFPanel.this.graph != null) {
                        DOFPanel.this.graph.repaint();
                    }
                }
            };
            this.valField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = JointEditorDialog.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, tl);
            this.minField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = JointEditorDialog.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, tl);
            this.maxField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = JointEditorDialog.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, tl);
            this.minComfortField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = JointEditorDialog.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, tl);
            this.maxComfortField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = JointEditorDialog.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, tl);
            this.valField.sendValidEventsOnly(false);
            this.minField.sendValidEventsOnly(false);
            this.maxField.sendValidEventsOnly(false);
            this.minComfortField.sendValidEventsOnly(false);
            this.maxComfortField.sendValidEventsOnly(false);
            this.stiffnessSlider = new ValueSlider(0.0, 1.0, 50, 0.0);
            this.fixedBox = new BCheckBox(Translate.text("Lock"), false);
            this.rangeBox = new BCheckBox(Translate.text("restrictTotalRange"), false);
            this.comfortBox = new BCheckBox(Translate.text("restrictComfortRange"), false);
            this.fixedBox.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = JointEditorDialog.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "checkboxChanged");
            this.rangeBox.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = JointEditorDialog.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "checkboxChanged");
            this.comfortBox.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = JointEditorDialog.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "checkboxChanged");
            this.add(new BLabel(name), 0, 0);
            this.add(this.valField, 1, 0);
            this.add(this.fixedBox, 2, 0);
            this.add(this.rangeBox, 0, 1, 3, 1);
            this.add(this.minField, 0, 2);
            this.add(Translate.label("to"), 1, 2);
            this.add(this.maxField, 2, 2);
            this.add(this.comfortBox, 0, 3, 3, 1);
            this.add(this.minComfortField, 0, 4);
            this.add(Translate.label("to"), 1, 4);
            this.add(this.maxComfortField, 2, 4);
            this.add(new BLabel("Stiffness"), 0, 5, 3, 1);
            this.add(this.stiffnessSlider, 0, 6, 3, 1);
            if (dof != null) {
                this.internTransferToPanel();
                this.updateComponents();
            }
        }

        private void internTransferToPanel() {
            this.valField.setValue(this.dof.pos);
            this.minField.setValue(this.dof.min);
            this.maxField.setValue(this.dof.max == Double.MAX_VALUE ? Double.NaN : this.dof.max);
            this.minComfortField.setValue(this.dof.minComfort);
            this.maxComfortField.setValue(this.dof.maxComfort == Double.MAX_VALUE ? Double.NaN : this.dof.maxComfort);
            this.stiffnessSlider.setValue(this.dof.stiffness);
            this.fixedBox.setState(this.dof.fixed);
            this.rangeBox.setState(this.dof.min > this.min || this.dof.max < this.max || this.dof.comfort);
            this.comfortBox.setState(this.dof.comfort);
            this.updateComponents();
        }

        public void transferToPanel(Joint.DOF newdof) {
            this.dof = newdof;
            this.internTransferToPanel();
        }

        public void updateComponents() {
            boolean fixed = this.fixedBox.getState();
            boolean range = !fixed && this.rangeBox.getState();
            boolean comfort = range && this.comfortBox.getState();
            this.valField.setEnabled(!fixed);
            this.minField.setEnabled(range);
            this.maxField.setEnabled(range);
            this.minComfortField.setEnabled(comfort);
            this.maxComfortField.setEnabled(comfort);
            this.valField.setEditable(!fixed);
            this.minField.setEditable(range);
            this.maxField.setEditable(range);
            this.minComfortField.setEditable(comfort);
            this.maxComfortField.setEditable(comfort);
            this.stiffnessSlider.setEnabled(!fixed);
            this.rangeBox.setEnabled(!fixed);
            this.comfortBox.setEnabled(range);
            this.valField.setValue(this.dof.pos);
            if (this.graph != null) {
                System.out.println("DOFPanel.updateComponents repaint " + this.dof.pos);
                this.graph.repaint();
            }
        }

        private void checkboxChanged(WidgetEvent ev) {
            if (ev.getWidget() == this.comfortBox && this.comfortBox.getState()) {
                if (this.minComfortField.getValue() < this.minField.getValue()) {
                    this.minComfortField.setValue(this.minField.getValue());
                }
                if (this.maxComfortField.getValue() > this.maxField.getValue()) {
                    this.maxComfortField.setValue(this.maxField.getValue());
                }
            }
            this.updateComponents();
            this.valField.checkIfValid();
            this.minField.checkIfValid();
            this.maxField.checkIfValid();
            this.minComfortField.checkIfValid();
            this.maxComfortField.checkIfValid();
            if (this.graph != null) {
                this.graph.repaint();
            }
            JointEditorDialog.this.valueChanged();
        }

        public boolean isValid() {
            if (this.fixedBox.getState()) {
                return true;
            }
            return this.valField.isValid(this.valField.getValue()) && this.minField.isValid(this.minField.getValue()) && this.maxField.isValid(this.maxField.getValue()) && this.minComfortField.isValid(this.minComfortField.getValue()) && this.maxComfortField.isValid(this.maxComfortField.getValue());
        }

        public void recordValues() {
            this.dof.fixed = this.fixedBox.getState();
            boolean range = !this.dof.fixed && this.rangeBox.getState();
            this.dof.pos = this.valField.getValue();
            if (range) {
                this.dof.min = this.minField.getValue();
                this.dof.max = this.maxField.getValue();
                if (Double.isNaN(this.dof.max)) {
                    this.dof.max = Double.MAX_VALUE;
                }
            } else {
                this.dof.min = this.min;
                this.dof.max = this.max;
            }
            this.dof.minComfort = this.minComfortField.getValue();
            this.dof.maxComfort = this.maxComfortField.getValue();
            if (Double.isNaN(this.dof.maxComfort)) {
                this.dof.maxComfort = Double.MAX_VALUE;
            }
            this.dof.stiffness = this.stiffnessSlider.getValue();
            this.dof.comfort = range && this.comfortBox.getState();
            this.dof.loop = this.max - this.min == 360.0 && (!range || this.dof.max - this.dof.min == 360.0);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            Iterator child = this.getChildren();
            while (child.hasNext()) {
                ((Widget)child.next()).setEnabled(enabled);
            }
        }

        public DOFGraph getGraph() {
            if (this.graph == null) {
                this.graph = new DOFGraph(this);
            }
            return this.graph;
        }
    }
}

