/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.object.SceneCamera;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BStandardDialog;
import buoy.widget.ColumnContainer;
import buoy.widget.CustomWidget;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.text.NumberFormat;
import java.util.Enumeration;

public class AnimationPreviewer
implements Runnable {
    LayoutWindow window;
    double originalTime;
    ValueField widthField;
    ValueField heightField;
    ValueField startField;
    ValueField endField;
    ValueField fpsField;
    BLabel timeLabel;
    BLabel frameLabel;
    Scene theScene;
    ObjectInfo sceneCamera;
    BComboBox camChoice;
    CustomWidget canvas;
    Thread previewThread;
    BDialog display;
    Image theImage;
    Graphics imageGraphics;
    byte[][] imageData;
    int[] sourceData;
    MemoryImageSource imSource;
    NumberFormat format;
    static int currentCamera = 0;
    static int width = 320;
    static int height = 240;
    static int fps = 15;
    static double startTime = 0.0;
    static double endTime = 1.0;

    public AnimationPreviewer(LayoutWindow parent) {
        ObjectInfo obj;
        int i;
        this.window = parent;
        this.theScene = this.window.getScene();
        int count = 0;
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            obj = this.theScene.getObject(i);
            if (!(obj.object instanceof SceneCamera)) continue;
            ++count;
        }
        if (count == 0) {
            new BStandardDialog("", Translate.text("noCameraError"), BStandardDialog.INFORMATION).showMessageDialog(this.window);
            return;
        }
        if (count <= currentCamera) {
            currentCamera = 0;
        }
        ObjectInfo[] cameras = new ObjectInfo[count];
        count = 0;
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            obj = this.theScene.getObject(i);
            if (!(obj.object instanceof SceneCamera)) continue;
            cameras[count++] = obj;
        }
        this.camChoice = new BComboBox();
        for (i = 0; i < cameras.length; ++i) {
            this.camChoice.add(cameras[i].name);
        }
        this.camChoice.setSelectedIndex(currentCamera);
        this.widthField = new ValueField((double)width, 7);
        this.heightField = new ValueField((double)height, 7);
        this.startField = new ValueField(startTime, 0);
        this.endField = new ValueField(endTime, 0);
        this.fpsField = new ValueField(fps, 7);
        ComponentsDialog dlg = new ComponentsDialog(this.window, Translate.text("renderPreview"), new Widget[]{this.camChoice, this.startField, this.endField, this.widthField, this.heightField, this.fpsField}, new String[]{Translate.text("Camera"), Translate.text("StartTime"), Translate.text("EndTime"), Translate.text("Width"), Translate.text("Height"), Translate.text("FramesPerSec")});
        if (!dlg.clickedOk()) {
            return;
        }
        currentCamera = this.camChoice.getSelectedIndex();
        this.sceneCamera = cameras[currentCamera];
        width = (int)this.widthField.getValue();
        height = (int)this.heightField.getValue();
        startTime = this.startField.getValue();
        endTime = this.endField.getValue();
        fps = (int)this.fpsField.getValue();
        this.originalTime = this.theScene.getTime();
        this.display = new BDialog(this.window, Translate.text("Preview"), true);
        this.format = NumberFormat.getNumberInstance();
        this.format.setMaximumFractionDigits(3);
        ColumnContainer content = new ColumnContainer();
        this.display.setContent(BOutline.createEmptyBorder(content, ModellingApp.standardDialogInsets));
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(2, 0, 2, 0), null));
        this.timeLabel = new BLabel();
        content.add(this.timeLabel);
        this.frameLabel = new BLabel();
        content.add(this.frameLabel);
        this.setLabels(0.0, 0);
        this.canvas = new CustomWidget();
        content.add(this.canvas);
        this.canvas.setPreferredSize(new Dimension(width, height));
        content.add(Translate.button("close", this, "doClose"), new LayoutInfo());
        this.display.pack();
        UIUtilities.centerDialog(this.display, this.window);
        this.display.setResizable(false);
        this.theImage = this.canvas.getComponent().createImage(width, height);
        this.imageGraphics = this.theImage.getGraphics();
        this.previewThread = new Thread(this);
        this.previewThread.start();
        this.display.setVisible(true);
    }

    public void run() {
        long ms;
        double time;
        int i;
        int totalFrames = (int)Math.ceil((endTime - startTime) * (double)fps);
        if (totalFrames <= 0) {
            totalFrames = 1;
        }
        int dataSize = (int)Math.ceil((double)(width * height) / 8.0);
        this.imageData = new byte[totalFrames][dataSize];
        Camera cam = new Camera();
        cam.setSize(width, height);
        long lastUpdate = 0L;
        long delay = 1000 / fps;
        for (i = 0; i < totalFrames; ++i) {
            time = startTime + (double)i / (double)fps;
            this.setLabels(time, i);
            this.theScene.setTime(time);
            SceneCamera sc = (SceneCamera)this.sceneCamera.object;
            cam.setCameraCoordinates(this.sceneCamera.coords.duplicate());
            cam.setDistToScreen((double)height / 200.0 / Math.tan(sc.getFieldOfView() * Math.PI / 360.0));
            this.imageGraphics.setColor(Color.white);
            this.imageGraphics.fillRect(0, 0, width, height);
            this.imageGraphics.setColor(Color.black);
            for (int j = 0; j < this.theScene.getNumObjects(); ++j) {
                ObjectInfo obj = this.theScene.getObject(j);
                if (!obj.visible) continue;
                this.drawObject(obj, cam, this.imageGraphics);
            }
            Graphics g = this.canvas.getComponent().getGraphics();
            g.drawImage(this.theImage, 0, 0, null);
            g.dispose();
            this.recordImage(this.imageData[i]);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ms = System.currentTimeMillis();
            if (ms < lastUpdate + delay) {
                try {
                    Thread.sleep(lastUpdate + delay - ms);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
            lastUpdate = System.currentTimeMillis();
        }
        this.sourceData = new int[width * height];
        this.imSource = new MemoryImageSource(width, height, this.sourceData, 0, width);
        this.imSource.setAnimated(true);
        this.theImage = Toolkit.getDefaultToolkit().createImage(this.imSource);
        while (!Thread.currentThread().isInterrupted()) {
            for (i = 0; i < totalFrames; ++i) {
                time = startTime + (double)i / (double)fps;
                this.setLabels(time, i);
                this.retrieveImage(this.imageData[i]);
                Graphics g = this.canvas.getComponent().getGraphics();
                g.drawImage(this.theImage, 0, 0, null);
                g.dispose();
                ms = System.currentTimeMillis();
                if (ms < lastUpdate + delay) {
                    try {
                        Thread.sleep(lastUpdate + delay - ms);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
                lastUpdate = System.currentTimeMillis();
            }
        }
    }

    private void doClose() {
        this.previewThread.interrupt();
        try {
            this.previewThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.theScene.setTime(this.originalTime);
        this.imageGraphics.dispose();
        this.display.dispose();
    }

    private void drawObject(ObjectInfo obj, Camera cam, Graphics g) {
        Object3D theObject = obj.object;
        while (theObject instanceof ObjectWrapper) {
            theObject = ((ObjectWrapper)theObject).getWrappedObject();
        }
        if (theObject instanceof ObjectCollection) {
            Enumeration enumeration = ((ObjectCollection)theObject).getObjects(obj, true, this.theScene);
            while (enumeration.hasMoreElements()) {
                ObjectInfo info = (ObjectInfo)enumeration.nextElement();
                CoordinateSystem coords = info.coords.duplicate();
                coords.transformCoordinates(obj.coords.fromLocal());
                cam.setObjectTransform(coords.fromLocal());
                info.draw(g, cam);
            }
            return;
        }
        cam.setObjectTransform(obj.coords.fromLocal());
        obj.draw(g, cam);
    }

    private void setLabels(double time, int frame) {
        this.timeLabel.setText(Translate.text("Time") + ": " + this.format.format(time));
        this.frameLabel.setText(Translate.text("Frame") + ": " + (frame + 1));
    }

    private void recordImage(byte[] bytes) {
        int[] data;
        try {
            PixelGrabber pg = new PixelGrabber(this.theImage, 0, 0, -1, -1, true);
            pg.grabPixels();
            data = (int[])pg.getPixels();
        }
        catch (InterruptedException ex) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == -1) continue;
            int i1 = i / 8;
            int i2 = i & 7;
            int n = i1;
            bytes[n] = (byte)(bytes[n] | 1 << i2);
        }
    }

    public void retrieveImage(byte[] bytes) {
        for (int i = 0; i < this.sourceData.length; ++i) {
            int i1 = i / 8;
            int i2 = i & 7;
            this.sourceData[i] = (bytes[i1] & 1 << i2) == 0 ? -1 : -16777216;
        }
        this.imSource.newPixels();
    }
}

