/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.animation.Actor;
import artofillusion.animation.Gesture;
import artofillusion.animation.Joint;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.CommandEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.BStandardDialog;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Cursor;
import java.awt.Insets;
import java.text.NumberFormat;

public class ActorEditorWindow
extends BDialog {
    private Actor theObject;
    private Actor oldObject;
    private ObjectInfo objInfo;
    private EditingWindow theWindow;
    private BList gestureList;
    private BList currentPoseList;
    private BButton addButton;
    private BButton removeButton;
    private BButton saveButton;
    private BButton extractButton;
    private BButton editButton;
    private BButton renameButton;
    private BButton copyButton;
    private BButton deleteButton;
    private BButton okButton;
    private BButton cancelButton;
    private ValueField weightField;
    private Actor.ActorKeyframe currentPose;
    private Actor.ActorKeyframe key;
    private ObjectPreviewCanvas preview;
    private Runnable onClose;
    private boolean canModifyGestures;

    public ActorEditorWindow(EditingWindow parent, ObjectInfo info, Actor obj, Actor.ActorKeyframe key, Runnable cb) {
        super(parent.getFrame(), key == null ? info.name : Translate.text("editKeyframeFor", info.name), false);
        this.objInfo = info;
        this.oldObject = obj;
        this.theObject = (Actor)obj.duplicate();
        this.theWindow = parent;
        this.key = key;
        if (key != null) {
            this.theObject.applyPoseKeyframe(key);
        }
        this.currentPose = (Actor.ActorKeyframe)this.theObject.getPoseKeyframe();
        this.onClose = cb;
        this.canModifyGestures = info.object == obj;
        for (int i = this.currentPose.id.length - 1; i >= 0; --i) {
            int which = this.theObject.findPoseIndex(this.currentPose.id[i]);
            if (which != -1) continue;
            this.currentPose.deleteGesture(i);
        }
        FormContainer content = new FormContainer(new double[]{0.0, 0.0, 1.0}, new double[]{0.0, 1.0, 0.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        ColumnContainer leftPanel = new ColumnContainer();
        content.add(leftPanel, 0, 0, 1, 2);
        leftPanel.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        this.gestureList = new BList();
        leftPanel.add(UIUtilities.createScrollingList(this.gestureList), new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.gestureList.setPreferredVisibleRows(10);
        for (int i = 0; i < this.theObject.gestureName.length; ++i) {
            this.gestureList.add(this.theObject.gestureName[i]);
        }
        this.gestureList.setMultipleSelectionEnabled(false);
        this.gestureList.addEventLink(SelectionChangedEvent.class, (Object)this, "updateComponents");
        this.gestureList.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent(MouseClickedEvent ev) {
                if (ev.getClickCount() == 2) {
                    ActorEditorWindow.this.doEdit();
                }
            }
        });
        this.editButton = Translate.button("edit", this, "doEdit");
        leftPanel.add(this.editButton);
        this.renameButton = Translate.button("rename", this, "doRename");
        leftPanel.add(this.renameButton);
        this.copyButton = Translate.button("duplicate", this, "doDuplicate");
        leftPanel.add(this.copyButton);
        this.deleteButton = Translate.button("delete", this, "doDelete");
        leftPanel.add(this.deleteButton);
        ColumnContainer addRemovePanel = new ColumnContainer();
        content.add(addRemovePanel, 1, 0);
        addRemovePanel.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        this.addButton = Translate.button("add", ">>", this, "doAdd");
        addRemovePanel.add(this.addButton);
        this.removeButton = new BButton("<< " + Translate.text("button.remove"));
        addRemovePanel.add(this.removeButton);
        this.saveButton = Translate.button("save", "...", this, "doSave");
        addRemovePanel.add(this.saveButton);
        this.extractButton = Translate.button("extract", "...", this, "doExtract");
        addRemovePanel.add(this.extractButton);
        this.removeButton.addEventLink(CommandEvent.class, (Object)this, "doRemove");
        FormContainer posePanel = new FormContainer(new double[]{0.0, 1.0}, new double[]{0.0, 1.0, 0.0});
        content.add(posePanel, 2, 0);
        posePanel.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
        posePanel.add(Translate.label("currentPose"), 0, 0, 2, 1);
        this.currentPoseList = new BList();
        posePanel.add(UIUtilities.createScrollingList(this.currentPoseList), 0, 1, 2, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.currentPoseList.setPreferredVisibleRows(4);
        posePanel.add(new BLabel(Translate.text("Weight") + ": "), 0, 2);
        this.weightField = new ValueField(Double.NaN, 0, 5);
        posePanel.add(this.weightField, 1, 2);
        this.currentPoseList.setMultipleSelectionEnabled(false);
        this.currentPoseList.addEventLink(SelectionChangedEvent.class, (Object)this, "updateComponents");
        this.weightField.addEventLink(ValueChangedEvent.class, (Object)this, "weightChanged");
        this.buildCurrentPoseList();
        this.preview = new ObjectPreviewCanvas(new ObjectInfo(this.theObject, new CoordinateSystem(), ""));
        content.add(this.preview, 1, 1, 2, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        RowContainer bottomPanel = new RowContainer();
        content.add(bottomPanel, 0, 2, 3, 1, new LayoutInfo());
        this.okButton = Translate.button("ok", this, "doOk");
        bottomPanel.add(this.okButton);
        this.cancelButton = Translate.button("cancel", this, "dispose");
        bottomPanel.add(this.cancelButton);
        this.pack();
        UIUtilities.centerDialog(this, parent.getFrame());
        this.updateComponents();
        this.setVisible(true);
    }

    private void buildCurrentPoseList() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(4);
        this.currentPoseList.removeAll();
        for (int i = 0; i < this.currentPose.id.length; ++i) {
            int which = this.theObject.findPoseIndex(this.currentPose.id[i]);
            this.currentPoseList.add(this.theObject.gestureName[which] + " (" + nf.format(this.currentPose.weight[i]) + ")");
        }
        int items = this.currentPoseList.getItemCount();
        if (items > 0) {
            this.currentPoseList.setSelected(items - 1, true);
            this.weightField.setValue(this.currentPose.weight[items - 1]);
        } else {
            this.weightField.setValue(Double.NaN);
        }
    }

    private void doAdd() {
        this.currentPose.addGesture(this.theObject.gestureID[this.gestureList.getSelectedIndex()], 1.0);
        this.buildCurrentPoseList();
        this.updateComponents();
        this.updateDisplay();
    }

    private void doRemove() {
        this.currentPose.deleteGesture(this.currentPoseList.getSelectedIndex());
        this.buildCurrentPoseList();
        this.updateComponents();
        this.updateDisplay();
    }

    private void doSave() {
        BStandardDialog dlg = new BStandardDialog("", Translate.text("savePoseAsGesture"), BStandardDialog.PLAIN);
        String name = dlg.showInputDialog(this, null, "New Gesture");
        if (name == null) {
            return;
        }
        this.theObject.addGesture((Gesture)this.theObject.getWrappedObject().getPoseKeyframe(), name);
        this.gestureList.add(name);
        this.gestureList.setSelected(this.gestureList.getItemCount() - 1, true);
        this.updateComponents();
    }

    private void doExtract() {
        BStandardDialog dlg = new BStandardDialog("", Translate.text("savePoseAsObject"), BStandardDialog.PLAIN);
        String name = dlg.showInputDialog(this, null, "Extracted Pose");
        if (name == null) {
            return;
        }
        ObjectInfo info = new ObjectInfo(this.theObject.getWrappedObject().duplicate(), new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy()), name);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        if (this.theWindow instanceof LayoutWindow) {
            ((LayoutWindow)this.theWindow).addObject(info, null);
        } else {
            this.theWindow.getScene().addObject(info, null);
        }
        this.theWindow.updateImage();
    }

    private void doEdit() {
        if (this.canModifyGestures) {
            this.editGesture(this.gestureList.getSelectedIndex());
        }
    }

    private void doRename() {
        int which = this.gestureList.getSelectedIndex();
        BStandardDialog dlg = new BStandardDialog("", Translate.text("enterNewNameForGesture"), BStandardDialog.PLAIN);
        String name = dlg.showInputDialog(this, null, this.theObject.gestureName[which]);
        if (name == null) {
            return;
        }
        this.theObject.gestureName[which] = name;
        this.gestureList.replace(which, this.theObject.gestureName[which]);
        this.gestureList.setSelected(which, true);
    }

    private void doDuplicate() {
        int which = this.gestureList.getSelectedIndex();
        BStandardDialog dlg = new BStandardDialog("", Translate.text("enterNameForNewGesture"), BStandardDialog.PLAIN);
        String name = dlg.showInputDialog(this, null, "Copy of " + this.theObject.gestureName[which]);
        if (name == null) {
            return;
        }
        this.theObject.addGesture((Gesture)this.theObject.gesture[which].duplicate(this.theObject.getWrappedObject()), name);
        this.gestureList.add(name);
        this.gestureList.setSelected(this.gestureList.getItemCount() - 1, true);
        this.updateComponents();
        this.editGesture(this.gestureList.getItemCount() - 1);
    }

    private void doDelete() {
        int which = this.gestureList.getSelectedIndex();
        String[] options = new String[]{Translate.text("Yes"), Translate.text("No")};
        int choice = new BStandardDialog("", Translate.text("deleteGesture", this.theObject.gestureName[which]), BStandardDialog.QUESTION).showOptionDialog(this, options, options[0]);
        if (choice == 1) {
            return;
        }
        for (int i = 0; i < this.currentPose.id.length; ++i) {
            if (this.currentPose.id[i] != this.theObject.gestureID[which]) continue;
            this.currentPose.deleteGesture(i);
        }
        this.theObject.deleteGestureWithID(this.theObject.gestureID[which]);
        this.gestureList.remove(which);
        this.buildCurrentPoseList();
        this.updateComponents();
    }

    private void doOk() {
        this.oldObject.copyObject(this.theObject);
        if (this.key != null) {
            this.key.copy(this.currentPose);
            this.theWindow.getScene().applyTracksToObject(this.objInfo);
            this.theWindow.updateImage();
        }
        this.dispose();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    private void editGesture(int which) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object3D editObj = this.theObject.getWrappedObject().duplicate();
        editObj.applyPoseKeyframe(this.theObject.gesture[which]);
        EditCallback cb = new EditCallback(editObj, this.theObject.gestureID[which]);
        ObjectInfo info = this.objInfo.duplicate(editObj);
        info.name = this.theObject.gestureName[which];
        editObj.editGesture(this.theWindow, info, cb, this.objInfo);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void weightChanged() {
        int selected = this.currentPoseList.getSelectedIndex();
        if (selected == -1 || this.currentPose.weight[selected] == this.weightField.getValue()) {
            return;
        }
        this.currentPose.weight[selected] = this.weightField.getValue();
        int which = this.theObject.findPoseIndex(this.currentPose.id[selected]);
        this.currentPoseList.replace(selected, this.theObject.gestureName[which] + " (" + this.currentPose.weight[selected] + ")");
        this.currentPoseList.setSelected(selected, true);
        this.updateDisplay();
    }

    private void updateComponents() {
        int selected = this.gestureList.getSelectedIndex();
        if (selected == -1) {
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.copyButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            int i;
            this.editButton.setEnabled(this.canModifyGestures);
            this.renameButton.setEnabled(this.canModifyGestures && selected > 0);
            this.copyButton.setEnabled(this.canModifyGestures);
            this.deleteButton.setEnabled(this.canModifyGestures && selected > 0);
            int id = this.theObject.gestureID[this.gestureList.getSelectedIndex()];
            for (i = 0; i < this.currentPose.id.length && this.currentPose.id[i] != id; ++i) {
            }
            this.addButton.setEnabled(selected > 0 && i == this.currentPose.id.length);
        }
        selected = this.currentPoseList.getSelectedIndex();
        this.removeButton.setEnabled(selected != -1);
        this.saveButton.setEnabled(this.canModifyGestures);
        if (selected == -1) {
            this.weightField.setValue(Double.NaN);
            this.weightField.setEnabled(false);
        } else {
            this.weightField.setValue(this.currentPose.weight[this.currentPoseList.getSelectedIndex()]);
            this.weightField.setEnabled(true);
        }
    }

    private void updateDisplay() {
        this.theObject.applyPoseKeyframe(this.currentPose);
        this.preview.objectChanged();
        this.preview.updateImage();
        this.preview.repaint();
    }

    private class EditCallback
    implements Runnable {
        public Object3D editObject;
        public int editID;

        public EditCallback(Object3D obj, int id) {
            this.editObject = obj;
            this.editID = id;
        }

        public void run() {
            int which = ActorEditorWindow.this.theObject.findPoseIndex(this.editID);
            ActorEditorWindow.this.theObject.getWrappedObject().copyObject(this.editObject);
            ((ActorEditorWindow)ActorEditorWindow.this).theObject.gesture[which] = (Gesture)ActorEditorWindow.this.theObject.getWrappedObject().getPoseKeyframe();
            Skeleton s = ((ActorEditorWindow)ActorEditorWindow.this).theObject.gesture[which].getSkeleton();
            if (s != null) {
                for (int i = 0; i < ((ActorEditorWindow)ActorEditorWindow.this).theObject.gesture.length; ++i) {
                    if (i == which) continue;
                    Skeleton olds = ((ActorEditorWindow)ActorEditorWindow.this).theObject.gesture[i].getSkeleton();
                    Skeleton news = s.duplicate();
                    Joint[] joint = news.getJoints();
                    for (int j = 0; j < joint.length; ++j) {
                        Joint j2 = olds.getJoint(joint[j].id);
                        if (j2 == null) continue;
                        joint[j].copy(j2);
                    }
                    ((ActorEditorWindow)ActorEditorWindow.this).theObject.gesture[i].setSkeleton(news);
                }
            }
            ActorEditorWindow.this.updateDisplay();
        }
    }
}

