/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.ModelEvent;
import artofillusion.ModelListener;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.WireframeMesh;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.EditingTool;
import artofillusion.ui.PopupMenuManager;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.view.VertexShader;
import buoy.event.MouseDraggedEvent;
import buoy.event.MouseMovedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BComboBox;
import buoy.widget.CustomWidget;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.io.File;

public abstract class ViewerCanvas
extends CustomWidget
implements ModelListener {
    protected Image theImage;
    protected Camera theCamera;
    protected ObjectInfo boundCamera;
    protected EditingTool currentTool;
    protected EditingTool activeTool;
    protected EditingTool metaTool;
    protected EditingTool altTool;
    protected BComboBox viewChoice;
    protected BComboBox perspectiveChoice;
    protected ValueField scaleField;
    protected PopupMenuManager popupManager;
    protected int renderMode;
    protected int gridSubdivisions;
    protected int[] pixel;
    protected int[] zbuffer;
    protected double gridSpacing;
    protected Graphics gr;
    protected boolean hideBackfaces;
    protected boolean showGrid;
    protected boolean snapToGrid;
    protected boolean drawFocus;
    protected boolean showTemplate;
    protected boolean showAxes;
    protected ActionProcessor mouseProcessor;
    protected Image templateImage;
    protected boolean visible;
    protected int[] templatePixel;
    private static Vec2[] reuseVec2;
    public static final int RENDER_WIREFRAME = 0;
    public static final int RENDER_FLAT = 1;
    public static final int RENDER_SMOOTH = 2;
    public static final int RENDER_TEXTURED = 3;
    public static final int RENDER_TRANSPARENT = 4;

    public ViewerCanvas() {
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        this.theCamera = new Camera();
        this.theCamera.setCameraCoordinates(coords);
        this.setBackground(Color.white);
        this.hideBackfaces = true;
        this.setFocusable(true);
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        this.addEventLink(MousePressedEvent.class, (Object)this, "processMousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "processMouseReleased");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "processMouseDragged");
        this.addEventLink(MouseMovedEvent.class, (Object)this, "processMouseDragged");
        if (reuseVec2 == null) {
            reuseVec2 = new Vec2[10000];
            for (int i = 0; i < reuseVec2.length; ++i) {
                ViewerCanvas.reuseVec2[i] = new Vec2();
            }
        }
    }

    public void dispose() {
    }

    protected void buildChoices(RowContainer row) {
        this.viewChoice = new BComboBox(new String[]{Translate.text("Front"), Translate.text("Back"), Translate.text("Left"), Translate.text("Right"), Translate.text("Top"), Translate.text("Bottom"), Translate.text("Other")});
        row.add(this.viewChoice);
        this.viewChoice.setSelectedIndex(0);
        this.viewChoice.addEventLink(ValueChangedEvent.class, (Object)this, "choiceChanged");
        this.perspectiveChoice = new BComboBox(new String[]{Translate.text("Perspective"), Translate.text("Parallel")});
        row.add(this.perspectiveChoice);
        this.perspectiveChoice.setSelectedIndex(1);
        this.perspectiveChoice.addEventLink(ValueChangedEvent.class, (Object)this, "choiceChanged");
        this.scaleField = new ValueField(100.0, 3, 5);
        row.add(this.scaleField);
        this.scaleField.setText("100");
        this.scaleField.setMinDecimalPlaces(1);
        this.scaleField.addEventLink(ValueChangedEvent.class, (Object)this, "scaleChanged");
    }

    private void processMousePressed(WidgetMouseEvent ev) {
        if (this.mouseProcessor != null) {
            this.mouseProcessor.stopProcessing();
        }
        this.mousePressed(ev);
        this.mouseProcessor = new ActionProcessor();
    }

    private void processMouseDragged(final WidgetMouseEvent ev) {
        if (this.mouseProcessor != null) {
            this.mouseProcessor.addEvent(new Runnable(){

                public void run() {
                    ViewerCanvas.this.mouseDragged(ev);
                }
            });
        }
    }

    private void processMouseReleased(WidgetMouseEvent ev) {
        if (this.mouseProcessor != null) {
            this.mouseProcessor.stopProcessing();
            this.mouseProcessor = null;
            this.mouseReleased(ev);
        }
    }

    protected void mousePressed(WidgetMouseEvent ev) {
    }

    protected void mouseDragged(WidgetMouseEvent ev) {
    }

    protected void mouseReleased(WidgetMouseEvent ev) {
    }

    public ActionProcessor getActionProcessor() {
        return this.mouseProcessor;
    }

    public Camera getCamera() {
        return this.theCamera;
    }

    public void setTool(EditingTool tool) {
        this.currentTool = tool;
        this.updateImage();
        this.repaint();
    }

    public EditingTool getCurrentTool() {
        return this.currentTool;
    }

    public void setMetaTool(EditingTool tool) {
        this.metaTool = tool;
    }

    public void setAltTool(EditingTool tool) {
        this.altTool = tool;
    }

    public void setPerspective(boolean perspective) {
        this.perspectiveChoice.setSelectedIndex(perspective ? 0 : 1);
        this.scaleField.setEnabled(!perspective);
    }

    public boolean isPerspective() {
        return this.perspectiveChoice.getSelectedIndex() == 0;
    }

    public double getScale() {
        if (this.isPerspective()) {
            return 100.0;
        }
        return this.scaleField.getValue();
    }

    public void setScale(double scale) {
        if (scale > 0.0) {
            this.scaleField.setValue(scale);
        }
    }

    public void setDrawFocus(boolean draw) {
        this.drawFocus = draw;
    }

    public boolean getShowAxes() {
        return this.showAxes;
    }

    public void setShowAxes(boolean show) {
        this.showAxes = show;
    }

    public boolean getTemplateShown() {
        return this.showTemplate;
    }

    public void setShowTemplate(boolean show) {
        this.showTemplate = show;
    }

    public Image getTemplateImage() {
        return this.templateImage;
    }

    public void setTemplateImage(Image im) throws InterruptedException {
        this.templateImage = im;
        PixelGrabber pg = new PixelGrabber(im, 0, 0, -1, -1, true);
        pg.grabPixels();
        this.templatePixel = (int[])pg.getPixels();
    }

    public void setTemplateImage(File f) throws InterruptedException {
        Image im = Toolkit.getDefaultToolkit().getImage(f.getAbsolutePath());
        MediaTracker mt = new MediaTracker(this.getComponent());
        mt.addImage(im, 0);
        mt.waitForID(0);
        if (mt.isErrorID(0)) {
            throw new InterruptedException();
        }
        this.setTemplateImage(im);
    }

    public void setPopupMenuManager(PopupMenuManager manager) {
        this.popupManager = manager;
    }

    protected void showPopupIfNeeded(WidgetMouseEvent ev) {
        if (!ev.isPopupTrigger() || this.popupManager == null) {
            return;
        }
        Point pos = ev.getPoint();
        this.popupManager.showPopupMenu(this, pos.x, pos.y);
    }

    public synchronized void paint(RepaintEvent ev) {
        Graphics2D g = ev.getGraphics();
        Rectangle bounds = this.getBounds();
        if (this.theImage == null || this.theImage.getWidth(null) != bounds.width || this.theImage.getHeight(null) != bounds.height) {
            this.updateImage();
        }
        g.drawImage(this.theImage, 0, 0, null);
        this.currentTool.drawOverlay(g, this);
    }

    public void drawImage(Graphics g) {
        Rectangle bounds = this.getBounds();
        if (this.theImage == null || this.theImage.getWidth(null) != bounds.width || this.theImage.getHeight(null) != bounds.height) {
            this.updateImage();
        }
        g.drawImage(this.theImage, 0, 0, null);
    }

    public void adjustCamera(boolean perspective) {
        Rectangle bounds = this.getBounds();
        double scale = this.getScale();
        if (perspective) {
            this.theCamera.setScreenParams(0.0, scale, bounds.width, bounds.height);
        } else {
            this.theCamera.setScreenParamsParallel(scale, bounds.width, bounds.height);
        }
    }

    public ObjectInfo getBoundCamera() {
        return this.boundCamera;
    }

    public void setGrid(double spacing, int subdivisions, boolean show, boolean snap) {
        this.gridSpacing = spacing;
        this.gridSubdivisions = subdivisions;
        this.showGrid = show;
        this.snapToGrid = snap;
        if (snap) {
            this.theCamera.setGrid(spacing / (double)subdivisions);
        } else {
            this.theCamera.setGrid(0.0);
        }
    }

    public void frameBox(BoundingBox bb) {
        double scale;
        if (this.boundCamera != null) {
            return;
        }
        Rectangle bounds = this.getBounds();
        if (this.perspectiveChoice.getSelectedIndex() == 0) {
            this.theCamera.setScreenParams(0.0, 100.0, bounds.width, bounds.height);
        } else {
            this.theCamera.setScreenParamsParallel(100.0, bounds.width, bounds.height);
        }
        double startDist = 20.0 + Math.max(Math.max(bb.maxx - bb.minx, bb.maxy - bb.miny), bb.maxz - bb.minz);
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        Vec3 boxCenter = bb.getCenter();
        coords.setOrigin(boxCenter.minus(coords.getZDirection().times(startDist)));
        this.theCamera.setCameraCoordinates(coords);
        this.theCamera.setObjectTransform(Mat4.identity());
        Rectangle screenBounds = this.theCamera.findScreenBounds(bb);
        double scalex = (double)bounds.width / (double)screenBounds.width;
        double scaley = (double)bounds.height / (double)screenBounds.height;
        double d = scale = scalex < scaley ? scalex : scaley;
        if (this.perspectiveChoice.getSelectedIndex() == 0) {
            coords.setOrigin(boxCenter.minus(coords.getZDirection().times(1.1 * startDist / scale)));
            this.scaleField.setValue(100.0);
        } else {
            this.scaleField.setValue(scale * 100.0);
        }
        this.theCamera.setCameraCoordinates(coords);
    }

    public synchronized void updateImage() {
        block22: {
            Rectangle bounds = this.getBounds();
            if (bounds.height <= 0) {
                return;
            }
            if (this.boundCamera != null) {
                this.boundCamera.coords.copyCoords(this.theCamera.getCameraCoordinates());
                this.theCamera.setDistToScreen((double)bounds.height / 200.0 / Math.tan(((SceneCamera)this.boundCamera.object).getFieldOfView() * Math.PI / 360.0));
            } else {
                this.theCamera.setDistToScreen(20.0);
            }
            if (this.theImage == null || this.theImage.getWidth(null) != bounds.width || this.theImage.getHeight(null) != bounds.height) {
                if (this.gr != null) {
                    this.gr.dispose();
                }
                if (bounds.width < 0 || bounds.height < 0) {
                    bounds.height = 0;
                    bounds.width = 0;
                }
                this.theImage = new BufferedImage(bounds.width, bounds.height, 3);
                this.gr = this.theImage.getGraphics();
                this.pixel = ((DataBufferInt)((BufferedImage)this.theImage).getRaster().getDataBuffer()).getData();
                if (this.renderMode != 0) {
                    this.zbuffer = new int[bounds.width * bounds.height];
                }
            }
            if (this.renderMode == 0) {
                this.gr.setColor(Color.white);
                this.gr.fillRect(0, 0, bounds.width, bounds.height);
            } else {
                for (int i = 0; i < this.pixel.length; ++i) {
                    this.pixel[i] = -1;
                    this.zbuffer[i] = Integer.MAX_VALUE;
                }
            }
            if (this.showTemplate) {
                if (this.renderMode == 0) {
                    this.gr.drawImage(this.templateImage, 0, 0, null);
                } else {
                    int width = this.templateImage.getWidth(null);
                    int height = this.templateImage.getHeight(null);
                    int maxi = height < bounds.height ? height : bounds.height;
                    int maxj = width < bounds.width ? width : bounds.width;
                    boolean frombase = false;
                    boolean tobase = false;
                    for (int i = 0; i < maxi; ++i) {
                        System.arraycopy(this.templatePixel, width * i, this.pixel, bounds.width * i, maxj);
                    }
                }
            }
            if (!this.showGrid) break block22;
            if (this.perspectiveChoice.getSelectedIndex() == 1) {
                Vec2 v1 = this.theCamera.getViewToScreen().timesXY(new Vec3());
                Vec2 v2 = this.theCamera.getViewToScreen().timesXY(new Vec3(this.gridSpacing, this.gridSpacing, 1.0));
                Vec2 v3 = this.theCamera.getWorldToScreen().timesXY(new Vec3());
                double space = Math.abs(v1.x - v2.x);
                int origin = (int)v3.x;
                double pos = Math.IEEEremainder(v3.x, space);
                if (pos < 0.0) {
                    pos += space;
                }
                while ((int)pos < bounds.width) {
                    int x;
                    this.drawVRule(x, (x = (int)pos) == origin ? Color.darkGray : Color.lightGray);
                    pos += space;
                }
                space = Math.abs(v1.y - v2.y);
                origin = (int)v3.y;
                pos = Math.IEEEremainder(v3.y, space);
                if (pos < 0.0) {
                    pos += space;
                }
                while ((int)pos < bounds.height) {
                    int y;
                    this.drawHRule(y, (y = (int)pos) == origin ? Color.darkGray : Color.lightGray);
                    pos += space;
                }
            } else {
                int i;
                this.theCamera.setObjectTransform(Mat4.identity());
                int size = (int)Math.max(10.0, 10.0 / this.gridSpacing);
                for (i = -size; i <= size; ++i) {
                    Vec3 end1 = new Vec3((double)i * this.gridSpacing, 0.0, (double)(-size) * this.gridSpacing);
                    Vec3 end2 = new Vec3((double)i * this.gridSpacing, 0.0, (double)size * this.gridSpacing);
                    this.renderLine(end1, end2, this.theCamera, i == 0 ? Color.darkGray : Color.lightGray);
                }
                for (i = -size; i <= size; ++i) {
                    Vec3 end1 = new Vec3((double)(-size) * this.gridSpacing, 0.0, (double)i * this.gridSpacing);
                    Vec3 end2 = new Vec3((double)size * this.gridSpacing, 0.0, (double)i * this.gridSpacing);
                    this.renderLine(end1, end2, this.theCamera, i == 0 ? Color.darkGray : Color.lightGray);
                }
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    protected void drawCoordinateAxes() {
        int y;
        int x;
        Vec2 labelPos;
        Vec2 dir2;
        Rectangle bounds = this.getBounds();
        int axisLength = 50;
        if (axisLength * 5 > bounds.width) {
            axisLength = bounds.width / 5;
        }
        if (axisLength * 5 > bounds.height) {
            axisLength = bounds.height / 5;
        }
        double len = (double)axisLength / this.getScale();
        Vec2 offset = new Vec2(0.5 * (double)bounds.width - (double)axisLength - 15.0, 0.5 * (double)bounds.height - (double)axisLength - 15.0);
        CoordinateSystem cameraCoords = this.theCamera.getCameraCoordinates();
        Vec3 center = cameraCoords.getOrigin().plus(cameraCoords.getZDirection().times(this.theCamera.getDistToScreen()));
        Vec3 xpos = center.plus(new Vec3(len, 0.0, 0.0));
        Vec3 ypos = center.plus(new Vec3(0.0, len, 0.0));
        Vec3 zpos = center.plus(new Vec3(0.0, 0.0, len));
        Vec2 screenCenter = this.theCamera.getWorldToScreen().timesXY(center).plus(offset);
        Vec2 screenX = this.theCamera.getWorldToScreen().timesXY(xpos).plus(offset);
        Vec2 screenY = this.theCamera.getWorldToScreen().timesXY(ypos).plus(offset);
        Vec2 screenZ = this.theCamera.getWorldToScreen().timesXY(zpos).plus(offset);
        Point centerPoint = new Point((int)Math.round(screenCenter.x), (int)Math.round(screenCenter.y));
        this.drawLine(centerPoint, new Point((int)screenX.x, (int)screenX.y), Color.black);
        this.drawLine(centerPoint, new Point((int)screenY.x, (int)screenY.y), Color.black);
        this.drawLine(centerPoint, new Point((int)screenZ.x, (int)screenZ.y), Color.black);
        if (screenX.minus(screenCenter).length() > 2.0) {
            dir2 = screenX.minus(screenCenter);
            labelPos = screenX.plus(dir2.times(8.0 / dir2.length()));
            x = (int)labelPos.x;
            y = (int)labelPos.y;
            this.drawLine(new Point(x - 4, y - 4), new Point(x + 4, y + 4), Color.black);
            this.drawLine(new Point(x - 4, y + 4), new Point(x + 4, y - 4), Color.black);
        }
        if (screenY.minus(screenCenter).length() > 2.0) {
            dir2 = screenY.minus(screenCenter);
            labelPos = screenY.plus(dir2.times(8.0 / dir2.length()));
            x = (int)labelPos.x;
            y = (int)labelPos.y;
            this.drawLine(new Point(x - 4, y - 4), new Point(x, y), Color.black);
            this.drawLine(new Point(x + 4, y - 4), new Point(x, y), Color.black);
            this.drawLine(new Point(x, y), new Point(x, y + 4), Color.black);
        }
        if (screenZ.minus(screenCenter).length() > 2.0) {
            dir2 = screenZ.minus(screenCenter);
            labelPos = screenZ.plus(dir2.times(8.0 / dir2.length()));
            x = (int)labelPos.x;
            y = (int)labelPos.y;
            this.drawLine(new Point(x - 4, y - 4), new Point(x + 4, y - 4), Color.black);
            this.drawLine(new Point(x + 4, y - 4), new Point(x - 4, y + 4), Color.black);
            this.drawLine(new Point(x - 4, y + 4), new Point(x + 4, y + 4), Color.black);
        }
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public void setRenderMode(int mode) {
        this.renderMode = mode;
        this.theImage = null;
    }

    void moveToGrid(WidgetMouseEvent e) {
        Point pos = e.getPoint();
        if (!this.snapToGrid || this.perspectiveChoice.getSelectedIndex() == 0) {
            return;
        }
        Vec3 v = this.theCamera.convertScreenToWorld(pos, this.theCamera.getDistToScreen());
        Vec2 v2 = this.theCamera.getWorldToScreen().timesXY(v);
        e.translatePoint((int)v2.x - pos.x, (int)v2.y - pos.y);
    }

    protected void choiceChanged(WidgetEvent ev) {
        if (ev.getWidget() == this.viewChoice) {
            this.selectOrientation(this.viewChoice.getSelectedIndex());
        }
        this.scaleField.setEnabled(!this.isPerspective());
        this.updateImage();
        this.repaint();
    }

    public void modelEventHappened(ModelEvent event) {
        this.handleModelEvent(event);
    }

    protected boolean handleModelEvent(ModelEvent event) {
        return false;
    }

    protected void scaleChanged() {
        this.updateImage();
        this.repaint();
    }

    public void selectOrientation(int which) {
        double dist;
        if (this.viewChoice.getSelectedIndex() != which) {
            this.viewChoice.setSelectedIndex(which);
        }
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        boolean perspective = this.perspectiveChoice.getSelectedIndex() == 0;
        double d = dist = perspective ? coords.getOrigin().length() : 20.0;
        if (which == 0) {
            coords = new CoordinateSystem(new Vec3(0.0, 0.0, dist), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        } else if (which == 1) {
            coords = new CoordinateSystem(new Vec3(0.0, 0.0, -dist), Vec3.vz(), Vec3.vy());
        } else if (which == 2) {
            coords = new CoordinateSystem(new Vec3(-dist, 0.0, 0.0), Vec3.vx(), Vec3.vy());
        } else if (which == 3) {
            coords = new CoordinateSystem(new Vec3(dist, 0.0, 0.0), new Vec3(-1.0, 0.0, 0.0), Vec3.vy());
        } else if (which == 4) {
            coords = new CoordinateSystem(new Vec3(0.0, dist, 0.0), new Vec3(0.0, -1.0, 0.0), new Vec3(0.0, 0.0, -1.0));
        } else if (which == 5) {
            coords = new CoordinateSystem(new Vec3(0.0, -dist, 0.0), Vec3.vy(), Vec3.vz());
        }
        this.theCamera.setCameraCoordinates(coords);
    }

    public void copyOrientationFromCamera() {
        if (this.boundCamera == null) {
            return;
        }
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        coords.copyCoords(this.boundCamera.coords);
        this.theCamera.setCameraCoordinates(coords);
    }

    public void orientationChanged() {
        if (this.viewChoice != null && this.viewChoice.getSelectedIndex() < 6) {
            this.viewChoice.setSelectedIndex(this.viewChoice.getItemCount() - 1);
        }
    }

    public void drawBorder() {
        Rectangle bounds = this.getBounds();
        if (this.gr != null) {
            this.gr.setColor(Color.black);
            this.gr.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
            if (this.drawFocus) {
                this.gr.drawRect(1, 1, bounds.width - 2, bounds.height - 2);
            }
            return;
        }
        int index1 = 0;
        int index2 = bounds.width - 1;
        int i = 0;
        while (i < bounds.height) {
            this.pixel[index2] = -16777216;
            this.pixel[index1] = -16777216;
            if (this.drawFocus) {
                this.pixel[index2 - 1] = -16777216;
                this.pixel[index1 + 1] = -16777216;
            }
            ++i;
            index1 += bounds.width;
            index2 += bounds.width;
        }
        index1 = bounds.width * (bounds.height - 1);
        for (i = 1; i < bounds.width - 1; ++i) {
            this.pixel[index1 + i] = -16777216;
            this.pixel[i] = -16777216;
            if (!this.drawFocus) continue;
            this.pixel[index1 + i - bounds.width] = -16777216;
            this.pixel[i + bounds.width] = -16777216;
        }
    }

    public void drawHRule(int y, Color color) {
        Rectangle bounds = this.getBounds();
        int index = y * bounds.width;
        if (this.gr != null) {
            this.gr.setColor(color);
            this.gr.drawLine(1, y, bounds.width - 1, y);
        } else {
            int col = color.getRGB();
            int i = 0;
            while (i < bounds.width) {
                this.pixel[index] = col;
                ++i;
                ++index;
            }
        }
    }

    public void drawVRule(int x, Color color) {
        Rectangle bounds = this.getBounds();
        int index = x;
        if (this.gr != null) {
            this.gr.setColor(color);
            this.gr.drawLine(x, 1, x, bounds.height - 1);
        } else {
            int col = color.getRGB();
            int i = 0;
            while (i < bounds.height) {
                this.pixel[index] = col;
                ++i;
                index += bounds.width;
            }
        }
    }

    public void drawBox(int x, int y, int width, int height, Color color) {
        Rectangle bounds = this.getBounds();
        if (this.gr != null) {
            this.gr.setColor(color);
            this.gr.fillRect(x, y, width, height);
        } else {
            int col = color.getRGB();
            int maxx = x + width;
            int maxy = y + height;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (maxx > bounds.width) {
                maxx = bounds.width;
            }
            if (maxy > bounds.height) {
                maxy = bounds.height;
            }
            width = maxx - x;
            int i = y;
            int index = y * bounds.width + x;
            while (i < maxy) {
                for (int j = 0; j < width; ++j) {
                    this.pixel[index + j] = col;
                }
                ++i;
                index += bounds.width;
            }
        }
    }

    public void renderBox(int x, int y, int width, int height, double depth, Color color) {
        Rectangle bounds = this.getBounds();
        int col = color.getRGB();
        int z = (int)(depth * 65535.0);
        int maxx = x + width;
        int maxy = y + height;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (maxx > bounds.width) {
            maxx = bounds.width;
        }
        if (maxy > bounds.height) {
            maxy = bounds.height;
        }
        width = maxx - x;
        int i = y;
        int index = y * bounds.width + x;
        while (i < maxy) {
            for (int j = 0; j < width; ++j) {
                if (z > this.zbuffer[index + j]) continue;
                this.pixel[index + j] = col;
                this.zbuffer[index + j] = z;
            }
            ++i;
            index += bounds.width;
        }
    }

    public void drawLine(Point p1, Point p2, Color color) {
        if (this.gr != null) {
            this.gr.setColor(color);
            this.gr.drawLine(p1.x, p1.y, p2.x, p2.y);
            return;
        }
        Rectangle bounds = this.getBounds();
        int col = color.getRGB();
        int x1 = p1.x;
        int y1 = p1.y;
        int x2 = p2.x;
        int y2 = p2.y;
        if (x1 < 0 && x2 < 0) {
            return;
        }
        if (y1 < 0 && y2 < 0) {
            return;
        }
        if (x1 >= bounds.width && x2 >= bounds.width) {
            return;
        }
        if (y1 >= bounds.height && y2 >= bounds.height) {
            return;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx == 0 && dy == 0) {
            return;
        }
        if (Math.abs(dx) > Math.abs(dy)) {
            int end;
            int y;
            int x;
            if (dx > 0) {
                x = x1;
                y = y1 << 32784;
                dy = (dy << 16) / dx;
                end = x2 < bounds.width ? x2 : bounds.width;
            } else {
                x = x2;
                y = y2 << 32784;
                dy = (dy << 16) / dx;
                int n = end = x1 < bounds.width ? x1 : bounds.width;
            }
            if (x < 0) {
                y -= dy * x;
                x = 0;
            }
            int edge = bounds.height << 16;
            while (x < end) {
                if (y >= 0 && y < edge) {
                    int index = bounds.width * (y >> 16) + x;
                    this.pixel[index] = col;
                }
                ++x;
                y += dy;
            }
        } else {
            int end;
            int y;
            int x;
            if (dy > 0) {
                x = x1 << 32784;
                y = y1;
                dx = (dx << 16) / dy;
                end = y2 < bounds.height ? y2 : bounds.height;
            } else {
                x = x2 << 32784;
                y = y2;
                dx = (dx << 16) / dy;
                int n = end = y1 < bounds.height ? y1 : bounds.height;
            }
            if (y < 0) {
                x -= dx * y;
                y = 0;
            }
            int edge = bounds.width << 16;
            while (y < end) {
                if (x >= 0 && x < edge) {
                    int index = y * bounds.width + (x >> 16);
                    this.pixel[index] = col;
                }
                x += dx;
                ++y;
            }
        }
    }

    public void renderLine(Vec3 p1, Vec3 p2, Camera cam, Color color) {
        if (cam.isPerspective()) {
            double z1 = cam.getObjectToView().timesZ(p1);
            double z2 = cam.getObjectToView().timesZ(p2);
            double clip = cam.getClipDistance();
            if (z1 < clip) {
                if (z2 < clip) {
                    return;
                }
                double f = (clip - z1) / (z2 - z1);
                p1 = new Vec3(p1.x + f * (p2.x - p1.x), p1.y + f * (p2.y - p1.y), p1.z + f * (p2.z - p1.z));
            } else if (z2 < clip) {
                double f = (clip - z2) / (z1 - z2);
                p2 = new Vec3(p2.x + f * (p1.x - p2.x), p2.y + f * (p1.y - p2.y), p2.z + f * (p1.z - p2.z));
            }
        }
        this.renderLine(cam.getObjectToScreen().timesXY(p1), cam.getObjectToView().timesZ(p1), cam.getObjectToScreen().timesXY(p2), cam.getObjectToView().timesZ(p2), cam, color);
    }

    public void renderLine(Vec2 p1, double zf1, Vec2 p2, double zf2, Camera cam, Color color) {
        int clip = (int)(cam.isPerspective() ? cam.getClipDistance() * 65535.0 : -2.147483648E9);
        int rgb = color.getRGB();
        Rectangle bounds = this.getBounds();
        int x1 = (int)p1.x;
        int y1 = (int)p1.y;
        int z1 = (int)(zf1 * 65535.0);
        int x2 = (int)p2.x;
        int y2 = (int)p2.y;
        int z2 = (int)(zf2 * 65535.0);
        if (x1 < 0 && x2 < 0) {
            return;
        }
        if (y1 < 0 && y2 < 0) {
            return;
        }
        if (x1 >= bounds.width && x2 >= bounds.width) {
            return;
        }
        if (y1 >= bounds.height && y2 >= bounds.height) {
            return;
        }
        if (z1 < clip && z2 < clip) {
            return;
        }
        if (this.renderMode == 0) {
            this.drawLine(new Point(x1, y1), new Point(x2, y2), color);
            return;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        if (dx == 0 && dy == 0) {
            return;
        }
        if (Math.abs(dx) > Math.abs(dy)) {
            int end;
            int z;
            int y;
            int x;
            if (dx > 0) {
                x = x1;
                y = y1 << 32784;
                z = z1;
                dy = (dy << 16) / dx;
                dz /= dx;
                end = x2 < bounds.width ? x2 : bounds.width;
            } else {
                x = x2;
                y = y2 << 32784;
                z = z2;
                dy = (dy << 16) / dx;
                dz /= dx;
                int n = end = x1 < bounds.width ? x1 : bounds.width;
            }
            if (x < 0) {
                y -= dy * x;
                z -= dz * x;
                x = 0;
            }
            int edge = bounds.height << 16;
            while (x < end) {
                int index;
                if (y >= 0 && y < edge && z > clip && z <= this.zbuffer[index = bounds.width * (y >> 16) + x]) {
                    this.pixel[index] = rgb;
                    this.zbuffer[index] = z;
                }
                ++x;
                y += dy;
                z += dz;
            }
        } else {
            int end;
            int z;
            int y;
            int x;
            if (dy > 0) {
                x = x1 << 32784;
                y = y1;
                z = z1;
                dx = (dx << 16) / dy;
                dz /= dy;
                end = y2 < bounds.height ? y2 : bounds.height;
            } else {
                x = x2 << 32784;
                y = y2;
                z = z2;
                dx = (dx << 16) / dy;
                dz /= dy;
                int n = end = y1 < bounds.height ? y1 : bounds.height;
            }
            if (y < 0) {
                x -= dx * y;
                z -= dz * y;
                y = 0;
            }
            int edge = bounds.width << 16;
            while (y < end) {
                int index;
                if (x >= 0 && x < edge && z > clip && z <= this.zbuffer[index = y * bounds.width + (x >> 16)]) {
                    this.pixel[index] = rgb;
                    this.zbuffer[index] = z;
                }
                x += dx;
                ++y;
                z += dz;
            }
        }
    }

    public void renderWireframe(WireframeMesh mesh, Camera cam) {
        Vec3[] vert = mesh.vert;
        int[] from = mesh.from;
        int[] to = mesh.to;
        for (int i = 0; i < from.length; ++i) {
            this.renderLine(vert[from[i]], vert[to[i]], cam, Color.black);
        }
    }

    private Vec2[] clipTriangle(Vec3 v1, Vec3 v2, Vec3 v3, double z1, double z2, double z3, Camera cam, double[] newz) {
        Vec3 u4;
        Vec3 u3;
        Vec3 u2;
        Vec3 u1;
        double clip = cam.getClipDistance();
        Mat4 toScreen = cam.getObjectToScreen();
        boolean c1 = z1 < clip;
        boolean c2 = z2 < clip;
        boolean c3 = z3 < clip;
        int clipCount = 0;
        if (c1) {
            ++clipCount;
        }
        if (c2) {
            ++clipCount;
        }
        if (c3) {
            ++clipCount;
        }
        if (clipCount == 2) {
            Vec3 u32;
            Vec3 u22;
            Vec3 u12;
            if (!c1) {
                u12 = v1;
                newz[0] = z1;
                double f2 = (z1 - clip) / (z1 - z2);
                double f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
                newz[1] = f1 * z1 + f2 * z2;
                f2 = (z1 - clip) / (z1 - z3);
                f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
                newz[2] = f1 * z1 + f2 * z3;
            } else if (!c2) {
                u22 = v2;
                newz[1] = z2;
                double f2 = (z2 - clip) / (z2 - z3);
                double f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
                newz[2] = f1 * z2 + f2 * z3;
                f2 = (z2 - clip) / (z2 - z1);
                f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
                newz[0] = f1 * z2 + f2 * z1;
            } else {
                u32 = v3;
                newz[2] = z3;
                double f2 = (z3 - clip) / (z3 - z1);
                double f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
                newz[0] = f1 * z3 + f2 * z1;
                f2 = (z3 - clip) / (z3 - z2);
                f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
                newz[1] = f1 * z3 + f2 * z2;
            }
            return new Vec2[]{toScreen.timesXY(u12), toScreen.timesXY(u22), toScreen.timesXY(u32)};
        }
        if (c1) {
            u1 = v2;
            newz[0] = z2;
            u2 = v3;
            newz[1] = z3;
            double f1 = (z2 - clip) / (z2 - z1);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
            newz[2] = f1 * z1 + f2 * z2;
            f1 = (z3 - clip) / (z3 - z1);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
            newz[3] = f1 * z1 + f2 * z3;
        } else if (c2) {
            u1 = v3;
            newz[0] = z3;
            u2 = v1;
            newz[1] = z1;
            double f1 = (z3 - clip) / (z3 - z2);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
            newz[2] = f1 * z2 + f2 * z3;
            f1 = (z1 - clip) / (z1 - z2);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
            newz[3] = f1 * z2 + f2 * z1;
        } else {
            u1 = v1;
            newz[0] = z1;
            u2 = v2;
            newz[1] = z2;
            double f1 = (z1 - clip) / (z1 - z3);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
            newz[2] = f1 * z3 + f2 * z1;
            f1 = (z2 - clip) / (z2 - z3);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
            newz[3] = f1 * z3 + f2 * z2;
        }
        return new Vec2[]{toScreen.timesXY(u1), toScreen.timesXY(u2), toScreen.timesXY(u3), toScreen.timesXY(u4)};
    }

    public void renderMeshTransparent(RenderingMesh mesh, Camera cam, Vec3 viewDir, RGBColor color, boolean[] hideFace) {
        int i;
        Vec3[] vert = mesh.vert;
        Vec2[] pos = new Vec2[vert.length];
        double[] z = new double[vert.length];
        double clip = cam.isPerspective() ? cam.getClipDistance() : -1.7976931348623157E308;
        double[] clipz = new double[4];
        Mat4 toView = cam.getObjectToView();
        Mat4 toScreen = cam.getObjectToScreen();
        Rectangle bounds = this.getBounds();
        RGBColor faceColor = new RGBColor(0.0f, 0.0f, 0.0f);
        int numToReuse = Math.min(vert.length, reuseVec2.length);
        for (i = 0; i < numToReuse; ++i) {
            pos[i] = toScreen.timesXY(vert[i], reuseVec2[i]);
            z[i] = toView.timesZ(vert[i]);
        }
        for (i = numToReuse; i < vert.length; ++i) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = toView.timesZ(vert[i]);
        }
        for (i = 0; i < mesh.triangle.length; ++i) {
            if (hideFace != null && hideFace[i]) continue;
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            if (z[v1] < clip && z[v2] < clip && z[v3] < clip) continue;
            float dot = (float)viewDir.dot(mesh.faceNorm[i]);
            faceColor.setRGB(1.0f - color.getRed(), 1.0f - color.getGreen(), 1.0f - color.getBlue());
            faceColor.scale(1.0f - 0.8f * Math.abs(dot));
            if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                int j;
                Vec2[] clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], cam, clipz);
                boolean inside = true;
                for (j = 0; j < clipPos.length; ++j) {
                    if (!(clipPos[j].x < -32767.0 || clipPos[j].x > 32767.0 || clipPos[j].y < -32767.0) && !(clipPos[j].y > 32767.0)) continue;
                    inside = false;
                }
                if (!inside) continue;
                for (j = 0; j < clipPos.length - 2; ++j) {
                    this.renderFlatTriangle(clipPos[j], clipz[j], clipPos[j + 1], clipz[j + 1], clipPos[j + 2], clipz[j + 2], bounds.width, bounds.height, clip, true, faceColor);
                }
                continue;
            }
            this.renderFlatTriangle(pos[v1], z[v1], pos[v2], z[v2], pos[v3], z[v3], bounds.width, bounds.height, clip, true, faceColor);
        }
    }

    public void renderMesh(RenderingMesh mesh, VertexShader shader, Camera cam, boolean closed, boolean[] hideFace) {
        int i;
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        Vec2[] pos = new Vec2[vert.length];
        double[] z = new double[vert.length];
        double clip = cam.isPerspective() ? cam.getClipDistance() : -1.7976931348623157E308;
        double[] clipz = new double[4];
        Mat4 toView = cam.getObjectToView();
        Mat4 toScreen = cam.getObjectToScreen();
        Rectangle bounds = this.getBounds();
        RGBColor color1 = new RGBColor();
        RGBColor color2 = new RGBColor();
        RGBColor color3 = new RGBColor();
        RGBColor color4 = new RGBColor();
        RGBColor color5 = new RGBColor();
        RGBColor color6 = new RGBColor();
        RGBColor color7 = new RGBColor();
        if (hideFace != null) {
            closed = false;
        }
        int numToReuse = Math.min(vert.length, reuseVec2.length);
        for (i = 0; i < numToReuse; ++i) {
            pos[i] = toScreen.timesXY(vert[i], reuseVec2[i]);
            z[i] = toView.timesZ(vert[i]);
        }
        for (i = numToReuse; i < vert.length; ++i) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = toView.timesZ(vert[i]);
        }
        for (i = 0; i < mesh.triangle.length; ++i) {
            int j;
            boolean inside;
            Vec2[] clipPos;
            boolean needClipping;
            if (hideFace != null && hideFace[i]) continue;
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            if (z[v1] < clip && z[v2] < clip && z[v3] < clip) continue;
            boolean backface = closed && this.hideBackfaces && (pos[v2].x - pos[v1].x) * (pos[v3].y - pos[v1].y) - (pos[v2].y - pos[v1].y) * (pos[v3].x - pos[v1].x) > 0.0;
            boolean bl = needClipping = z[v1] < clip || z[v2] < clip || z[v3] < clip;
            if (backface && !needClipping) continue;
            shader.getColor(i, 0, color1);
            if (shader.isUniformFace(i)) {
                if (needClipping) {
                    clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], cam, clipz);
                    inside = true;
                    for (j = 0; j < clipPos.length; ++j) {
                        if (!(clipPos[j].x < -32767.0 || clipPos[j].x > 32767.0 || clipPos[j].y < -32767.0) && !(clipPos[j].y > 32767.0)) continue;
                        inside = false;
                    }
                    if (!inside) continue;
                    for (j = 0; j < clipPos.length - 2; ++j) {
                        this.renderFlatTriangle(clipPos[j], clipz[j], clipPos[j + 1], clipz[j + 1], clipPos[j + 2], clipz[j + 2], bounds.width, bounds.height, clip, false, color1);
                    }
                    continue;
                }
                this.renderFlatTriangle(pos[v1], z[v1], pos[v2], z[v2], pos[v3], z[v3], bounds.width, bounds.height, clip, false, color1);
                continue;
            }
            shader.getColor(i, 1, color2);
            shader.getColor(i, 2, color3);
            if (needClipping) {
                clipPos = this.clipSmoothTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], cam, color1, color2, color3, color4, color5, color6, color7, clipz);
                inside = true;
                for (j = 0; j < clipPos.length; ++j) {
                    if (!(clipPos[j].x < -32767.0 || clipPos[j].x > 32767.0 || clipPos[j].y < -32767.0) && !(clipPos[j].y > 32767.0)) continue;
                    inside = false;
                }
                if (!inside) continue;
                this.renderSmoothTriangle(clipPos[0], clipz[0], clipPos[1], clipz[1], clipPos[2], clipz[2], bounds.width, bounds.height, clip, color4, color5, color6);
                if (clipPos.length != 4) continue;
                this.renderSmoothTriangle(clipPos[1], clipz[1], clipPos[2], clipz[2], clipPos[3], clipz[3], bounds.width, bounds.height, clip, color5, color6, color7);
                continue;
            }
            this.renderSmoothTriangle(pos[v1], z[v1], pos[v2], z[v2], pos[v3], z[v3], bounds.width, bounds.height, clip, color1, color2, color3);
        }
    }

    private Vec2[] clipSmoothTriangle(Vec3 v1, Vec3 v2, Vec3 v3, double z1, double z2, double z3, Camera cam, RGBColor col1, RGBColor col2, RGBColor col3, RGBColor newc1, RGBColor newc2, RGBColor newc3, RGBColor newc4, double[] newz) {
        Vec3 u4;
        Vec3 u3;
        Vec3 u2;
        Vec3 u1;
        double clip = cam.getClipDistance();
        Mat4 toScreen = cam.getObjectToScreen();
        boolean c1 = z1 < clip;
        boolean c2 = z2 < clip;
        boolean c3 = z3 < clip;
        int clipCount = 0;
        if (c1) {
            ++clipCount;
        }
        if (c2) {
            ++clipCount;
        }
        if (c3) {
            ++clipCount;
        }
        if (clipCount == 2) {
            Vec3 u32;
            Vec3 u22;
            Vec3 u12;
            if (!c1) {
                u12 = v1;
                newz[0] = z1;
                newc1.copy(col1);
                double f2 = (z1 - clip) / (z1 - z2);
                double f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
                newc2.setRGB(f1 * (double)col1.getRed() + f2 * (double)col2.getRed(), f1 * (double)col1.getGreen() + f2 * (double)col2.getGreen(), f1 * (double)col1.getBlue() + f2 * (double)col2.getBlue());
                newz[1] = f1 * z1 + f2 * z2;
                f2 = (z1 - clip) / (z1 - z3);
                f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
                newc3.setRGB(f1 * (double)col1.getRed() + f2 * (double)col3.getRed(), f1 * (double)col1.getGreen() + f2 * (double)col3.getGreen(), f1 * (double)col1.getBlue() + f2 * (double)col3.getBlue());
                newz[2] = f1 * z1 + f2 * z3;
            } else if (!c2) {
                u22 = v2;
                newz[1] = z2;
                newc2.copy(col2);
                double f2 = (z2 - clip) / (z2 - z3);
                double f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
                newc3.setRGB(f1 * (double)col2.getRed() + f2 * (double)col3.getRed(), f1 * (double)col2.getGreen() + f2 * (double)col3.getGreen(), f1 * (double)col2.getBlue() + f2 * (double)col3.getBlue());
                newz[2] = f1 * z2 + f2 * z3;
                f2 = (z2 - clip) / (z2 - z1);
                f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
                newc1.setRGB(f1 * (double)col2.getRed() + f2 * (double)col3.getRed(), f1 * (double)col2.getGreen() + f2 * (double)col3.getGreen(), f1 * (double)col2.getBlue() + f2 * (double)col3.getBlue());
                newz[0] = f1 * z2 + f2 * z1;
            } else {
                u32 = v3;
                newz[2] = z3;
                newc3.copy(col3);
                double f2 = (z3 - clip) / (z3 - z1);
                double f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
                newc1.setRGB(f1 * (double)col3.getRed() + f2 * (double)col1.getRed(), f1 * (double)col3.getGreen() + f2 * (double)col1.getGreen(), f1 * (double)col3.getBlue() + f2 * (double)col1.getBlue());
                newz[0] = f1 * z3 + f2 * z1;
                f2 = (z3 - clip) / (z3 - z2);
                f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
                newc2.setRGB(f1 * (double)col3.getRed() + f2 * (double)col2.getRed(), f1 * (double)col3.getGreen() + f2 * (double)col2.getGreen(), f1 * (double)col3.getBlue() + f2 * (double)col2.getBlue());
                newz[1] = f1 * z3 + f2 * z2;
            }
            return new Vec2[]{toScreen.timesXY(u12), toScreen.timesXY(u22), toScreen.timesXY(u32)};
        }
        if (c1) {
            u1 = v2;
            newz[0] = z2;
            newc1.copy(col2);
            u2 = v3;
            newz[1] = z3;
            newc2.copy(col3);
            double f1 = (z2 - clip) / (z2 - z1);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
            newc3.setRGB(f1 * (double)col1.getRed() + f2 * (double)col2.getRed(), f1 * (double)col1.getGreen() + f2 * (double)col2.getGreen(), f1 * (double)col1.getBlue() + f2 * (double)col2.getBlue());
            newz[2] = f1 * z1 + f2 * z2;
            f1 = (z3 - clip) / (z3 - z1);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
            newc4.setRGB(f1 * (double)col1.getRed() + f2 * (double)col3.getRed(), f1 * (double)col1.getGreen() + f2 * (double)col3.getGreen(), f1 * (double)col1.getBlue() + f2 * (double)col3.getBlue());
            newz[3] = f1 * z1 + f2 * z3;
        } else if (c2) {
            u1 = v3;
            newz[0] = z3;
            newc1.copy(col3);
            u2 = v1;
            newz[1] = z1;
            newc2.copy(col1);
            double f1 = (z3 - clip) / (z3 - z2);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
            newc3.setRGB(f1 * (double)col2.getRed() + f2 * (double)col3.getRed(), f1 * (double)col2.getGreen() + f2 * (double)col3.getGreen(), f1 * (double)col2.getBlue() + f2 * (double)col3.getBlue());
            newz[2] = f1 * z2 + f2 * z3;
            f1 = (z1 - clip) / (z1 - z2);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
            newc4.setRGB(f1 * (double)col2.getRed() + f2 * (double)col1.getRed(), f1 * (double)col2.getGreen() + f2 * (double)col1.getGreen(), f1 * (double)col2.getBlue() + f2 * (double)col1.getBlue());
            newz[3] = f1 * z2 + f2 * z1;
        } else {
            u1 = v1;
            newz[0] = z1;
            newc1.copy(col1);
            u2 = v2;
            newz[1] = z2;
            newc2.copy(col2);
            double f1 = (z1 - clip) / (z1 - z3);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
            newc3.setRGB(f1 * (double)col3.getRed() + f2 * (double)col1.getRed(), f1 * (double)col3.getGreen() + f2 * (double)col1.getGreen(), f1 * (double)col3.getBlue() + f2 * (double)col1.getBlue());
            newz[2] = f1 * z3 + f2 * z1;
            f1 = (z2 - clip) / (z2 - z3);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
            newc4.setRGB(f1 * (double)col3.getRed() + f2 * (double)col2.getRed(), f1 * (double)col3.getGreen() + f2 * (double)col2.getGreen(), f1 * (double)col3.getBlue() + f2 * (double)col2.getBlue());
            newz[3] = f1 * z3 + f2 * z2;
        }
        return new Vec2[]{toScreen.timesXY(u1), toScreen.timesXY(u2), toScreen.timesXY(u3), toScreen.timesXY(u4)};
    }

    public void renderFlatTriangle(Vec2 pos1, double zf1, Vec2 pos2, double zf2, Vec2 pos3, double zf3, int width, int height, double clip, boolean transparent, RGBColor color) {
        int b;
        int g;
        int r;
        int i;
        int dz;
        int z;
        int right;
        int left;
        int index;
        int yend;
        int mz2;
        int mx2;
        int zend;
        int xend;
        int z3;
        int y3;
        int x3;
        int z2;
        int y2;
        int x2;
        int z1;
        int y1;
        int x1;
        int blue;
        int green;
        int red;
        int col;
        int clipDist = (int)(clip * 65535.0);
        if (transparent) {
            col = 0;
            red = (int)(color.getRed() * 255.0f);
            green = (int)(color.getGreen() * 255.0f);
            blue = (int)(color.getBlue() * 255.0f);
        } else {
            col = color.getARGB();
            blue = 0;
            green = 0;
            red = 0;
        }
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = (int)pos1.x << 16;
            y1 = (int)pos1.y;
            z1 = (int)(zf1 * 65535.0);
            if (pos2.y < pos3.y) {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65535.0);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65535.0);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65535.0);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65535.0);
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = (int)pos2.x << 16;
            y1 = (int)pos2.y;
            z1 = (int)(zf2 * 65535.0);
            if (pos1.y < pos3.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65535.0);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65535.0);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65535.0);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65535.0);
            }
        } else {
            x1 = (int)pos3.x << 16;
            y1 = (int)pos3.y;
            z1 = (int)(zf3 * 65535.0);
            if (pos1.y < pos2.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65535.0);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65535.0);
            } else {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65535.0);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65535.0);
            }
        }
        int dx1 = x3 - x1;
        int dy1 = y3 - y1;
        int dz1 = z3 - z1;
        if (dy1 == 0) {
            return;
        }
        int dx2 = x2 - x1;
        int dy2 = y2 - y1;
        int dz2 = z2 - z1;
        int mx1 = dx1 / dy1;
        int mz1 = dz1 / dy1;
        int xstart = xend = x1;
        int zstart = zend = z1;
        int y = y1;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            if (y2 < 0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart += mz1 * dy2;
                zend += mz2 * dy2;
                y = y2;
            } else if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                y = 0;
            }
            yend = y2 < height ? y2 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                }
                if (left != right) {
                    dz /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    if (transparent) {
                        for (i = left; i < right; ++i) {
                            if (z > clipDist) {
                                r = ((this.pixel[index + i] & 0xFF0000) >> 16) - red;
                                g = ((this.pixel[index + i] & 0xFF00) >> 8) - green;
                                b = (this.pixel[index + i] & 0xFF) - blue;
                                if (r < 0) {
                                    r = 0;
                                }
                                if (g < 0) {
                                    g = 0;
                                }
                                if (b < 0) {
                                    b = 0;
                                }
                                this.pixel[index + i] = -16777216 + (r << 16) + (g << 8) + b;
                            }
                            z += dz;
                        }
                    } else {
                        for (i = left; i < right; ++i) {
                            if (z < this.zbuffer[index + i] && z > clipDist) {
                                this.pixel[index + i] = col;
                                this.zbuffer[index + i] = z;
                            }
                            z += dz;
                        }
                    }
                }
                xstart += mx1;
                zstart += mz1;
                xend += mx2;
                zend += mz2;
                index += width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            xend = x2;
            zend = z2;
            if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                y = 0;
            }
            yend = y3 < height ? y3 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                }
                if (left != right) {
                    dz /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    if (transparent) {
                        for (i = left; i < right; ++i) {
                            if (z > clipDist) {
                                r = ((this.pixel[index + i] & 0xFF0000) >> 16) - red;
                                g = ((this.pixel[index + i] & 0xFF00) >> 8) - green;
                                b = (this.pixel[index + i] & 0xFF) - blue;
                                if (r < 0) {
                                    r = 0;
                                }
                                if (g < 0) {
                                    g = 0;
                                }
                                if (b < 0) {
                                    b = 0;
                                }
                                this.pixel[index + i] = -16777216 + (r << 16) + (g << 8) + b;
                            }
                            z += dz;
                        }
                    } else {
                        for (i = left; i < right; ++i) {
                            if (z < this.zbuffer[index + i] && z > clipDist) {
                                this.pixel[index + i] = col;
                                this.zbuffer[index + i] = z;
                            }
                            z += dz;
                        }
                    }
                }
                xstart += mx1;
                zstart += mz1;
                xend += mx2;
                zend += mz2;
                index += width;
                ++y;
            }
        }
    }

    public void renderSmoothTriangle(Vec2 pos1, double zf1, Vec2 pos2, double zf2, Vec2 pos3, double zf3, int width, int height, double clip, RGBColor color1, RGBColor color2, RGBColor color3) {
        int i;
        int dblue;
        int blue;
        int dgreen;
        int green;
        int dred;
        int red;
        int dz;
        int z;
        int right;
        int left;
        int index;
        int yend;
        int mblue2;
        int mgreen2;
        int mred2;
        int mz2;
        int mx2;
        int blueend;
        int greenend;
        int redend;
        int zend;
        int xend;
        int blue3;
        int green3;
        int red3;
        int z3;
        int y3;
        int x3;
        int blue2;
        int green2;
        int red2;
        int z2;
        int y2;
        int x2;
        int blue1;
        int green1;
        int red1;
        int z1;
        int y1;
        int x1;
        int clipDist = (int)(clip * 65535.0);
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = (int)pos1.x << 16;
            y1 = (int)pos1.y;
            z1 = (int)(zf1 * 65535.0);
            red1 = (int)(color1.getRed() * 65535.0f);
            green1 = (int)(color1.getGreen() * 65535.0f);
            blue1 = (int)(color1.getBlue() * 65535.0f);
            if (pos2.y < pos3.y) {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65535.0);
                red2 = (int)(color2.getRed() * 65535.0f);
                green2 = (int)(color2.getGreen() * 65535.0f);
                blue2 = (int)(color2.getBlue() * 65535.0f);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65535.0);
                red3 = (int)(color3.getRed() * 65535.0f);
                green3 = (int)(color3.getGreen() * 65535.0f);
                blue3 = (int)(color3.getBlue() * 65535.0f);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65535.0);
                red2 = (int)(color3.getRed() * 65535.0f);
                green2 = (int)(color3.getGreen() * 65535.0f);
                blue2 = (int)(color3.getBlue() * 65535.0f);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65535.0);
                red3 = (int)(color2.getRed() * 65535.0f);
                green3 = (int)(color2.getGreen() * 65535.0f);
                blue3 = (int)(color2.getBlue() * 65535.0f);
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = (int)pos2.x << 16;
            y1 = (int)pos2.y;
            z1 = (int)(zf2 * 65535.0);
            red1 = (int)(color2.getRed() * 65535.0f);
            green1 = (int)(color2.getGreen() * 65535.0f);
            blue1 = (int)(color2.getBlue() * 65535.0f);
            if (pos1.y < pos3.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65535.0);
                red2 = (int)(color1.getRed() * 65535.0f);
                green2 = (int)(color1.getGreen() * 65535.0f);
                blue2 = (int)(color1.getBlue() * 65535.0f);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65535.0);
                red3 = (int)(color3.getRed() * 65535.0f);
                green3 = (int)(color3.getGreen() * 65535.0f);
                blue3 = (int)(color3.getBlue() * 65535.0f);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65535.0);
                red2 = (int)(color3.getRed() * 65535.0f);
                green2 = (int)(color3.getGreen() * 65535.0f);
                blue2 = (int)(color3.getBlue() * 65535.0f);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65535.0);
                red3 = (int)(color1.getRed() * 65535.0f);
                green3 = (int)(color1.getGreen() * 65535.0f);
                blue3 = (int)(color1.getBlue() * 65535.0f);
            }
        } else {
            x1 = (int)pos3.x << 16;
            y1 = (int)pos3.y;
            z1 = (int)(zf3 * 65535.0);
            red1 = (int)(color3.getRed() * 65535.0f);
            green1 = (int)(color3.getGreen() * 65535.0f);
            blue1 = (int)(color3.getBlue() * 65535.0f);
            if (pos1.y < pos2.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65535.0);
                red2 = (int)(color1.getRed() * 65535.0f);
                green2 = (int)(color1.getGreen() * 65535.0f);
                blue2 = (int)(color1.getBlue() * 65535.0f);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65535.0);
                red3 = (int)(color2.getRed() * 65535.0f);
                green3 = (int)(color2.getGreen() * 65535.0f);
                blue3 = (int)(color2.getBlue() * 65535.0f);
            } else {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65535.0);
                red2 = (int)(color2.getRed() * 65535.0f);
                green2 = (int)(color2.getGreen() * 65535.0f);
                blue2 = (int)(color2.getBlue() * 65535.0f);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65535.0);
                red3 = (int)(color1.getRed() * 65535.0f);
                green3 = (int)(color1.getGreen() * 65535.0f);
                blue3 = (int)(color1.getBlue() * 65535.0f);
            }
        }
        int dx1 = x3 - x1;
        int dy1 = y3 - y1;
        int dz1 = z3 - z1;
        if (dy1 == 0) {
            return;
        }
        int dred1 = red3 - red1;
        int dgreen1 = green3 - green1;
        int dblue1 = blue3 - blue1;
        int dx2 = x2 - x1;
        int dy2 = y2 - y1;
        int dz2 = z2 - z1;
        int dred2 = red2 - red1;
        int dgreen2 = green2 - green1;
        int dblue2 = blue2 - blue1;
        int mx1 = dx1 / dy1;
        int mz1 = dz1 / dy1;
        int mred1 = dred1 / dy1;
        int mgreen1 = dgreen1 / dy1;
        int mblue1 = dblue1 / dy1;
        int xstart = xend = x1;
        int zstart = zend = z1;
        int redstart = redend = red1;
        int greenstart = greenend = green1;
        int bluestart = blueend = blue1;
        int y = y1;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            mred2 = dred2 / dy2;
            mgreen2 = dgreen2 / dy2;
            mblue2 = dblue2 / dy2;
            if (y2 < 0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart += mz1 * dy2;
                zend += mz2 * dy2;
                redstart += mred1 * dy2;
                redend += mred2 * dy2;
                greenstart += mgreen1 * dy2;
                greenend += mgreen2 * dy2;
                bluestart += mblue1 * dy2;
                blueend += mblue2 * dy2;
                y = y2;
            } else if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                redstart -= mred1 * y;
                redend -= mred2 * y;
                greenstart -= mgreen1 * y;
                greenend -= mgreen2 * y;
                bluestart -= mblue1 * y;
                blueend -= mblue2 * y;
                y = 0;
            }
            yend = y2 < height ? y2 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                    red = redstart;
                    dred = redend - redstart;
                    green = greenstart;
                    dgreen = greenend - greenstart;
                    blue = bluestart;
                    dblue = blueend - bluestart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                    red = redend;
                    dred = redstart - redend;
                    green = greenend;
                    dgreen = greenstart - greenend;
                    blue = blueend;
                    dblue = bluestart - blueend;
                }
                if (left != right) {
                    dz /= right - left;
                    dred /= right - left;
                    dgreen /= right - left;
                    dblue /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        red -= left * dred;
                        green -= left * dgreen;
                        blue -= left * dblue;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    for (i = left; i < right; ++i) {
                        if (z < this.zbuffer[index + i] && z > clipDist) {
                            this.pixel[index + i] = -16777216 + ((red & 0xFF00) << 8) + (green & 0xFF00) + (blue >> 8);
                            this.zbuffer[index + i] = z;
                        }
                        z += dz;
                        red += dred;
                        green += dgreen;
                        blue += dblue;
                    }
                }
                xstart += mx1;
                zstart += mz1;
                redstart += mred1;
                greenstart += mgreen1;
                bluestart += mblue1;
                xend += mx2;
                zend += mz2;
                redend += mred2;
                greenend += mgreen2;
                blueend += mblue2;
                index += width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        dred2 = red3 - red2;
        dgreen2 = green3 - green2;
        dblue2 = blue3 - blue2;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            mred2 = dred2 / dy2;
            mgreen2 = dgreen2 / dy2;
            mblue2 = dblue2 / dy2;
            xend = x2;
            zend = z2;
            redend = red2;
            greenend = green2;
            blueend = blue2;
            if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                redstart -= mred1 * y;
                redend -= mred2 * y;
                greenstart -= mgreen1 * y;
                greenend -= mgreen2 * y;
                bluestart -= mblue1 * y;
                blueend -= mblue2 * y;
                y = 0;
            }
            yend = y3 < height ? y3 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                    red = redstart;
                    dred = redend - redstart;
                    green = greenstart;
                    dgreen = greenend - greenstart;
                    blue = bluestart;
                    dblue = blueend - bluestart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                    red = redend;
                    dred = redstart - redend;
                    green = greenend;
                    dgreen = greenstart - greenend;
                    blue = blueend;
                    dblue = bluestart - blueend;
                }
                if (left != right) {
                    dz /= right - left;
                    dred /= right - left;
                    dgreen /= right - left;
                    dblue /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        red -= left * dred;
                        green -= left * dgreen;
                        blue -= left * dblue;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    for (i = left; i < right; ++i) {
                        if (z < this.zbuffer[index + i] && z > clipDist) {
                            this.pixel[index + i] = -16777216 + ((red & 0xFF00) << 8) + (green & 0xFF00) + (blue >> 8);
                            this.zbuffer[index + i] = z;
                        }
                        z += dz;
                        red += dred;
                        green += dgreen;
                        blue += dblue;
                    }
                }
                xstart += mx1;
                zstart += mz1;
                redstart += mred1;
                greenstart += mgreen1;
                bluestart += mblue1;
                xend += mx2;
                zend += mz2;
                redend += mred2;
                greenend += mgreen2;
                blueend += mblue2;
                index += width;
                ++y;
            }
        }
    }
}

