/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CurveViewer;
import artofillusion.RenderingMesh;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Tube;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.TexturedVertexShader;
import artofillusion.view.VertexShader;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Graphics;

public class TubeViewer
extends CurveViewer {
    public TubeViewer(ObjectInfo obj, RowContainer p) {
        super(obj, p);
    }

    protected void drawObject(Graphics g) {
        boolean[] selected = this.getSelection();
        if (this.showSurface) {
            if (this.renderMode == 0) {
                g.setColor(surfaceColor);
                Object3D.draw(g, this.theCamera, this.objInfo.getWireframePreview(), this.objInfo.getBounds());
            } else if (this.renderMode == 4) {
                this.renderMeshTransparent(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), surfaceRGB, null);
            } else {
                RenderingMesh mesh = this.objInfo.getPreviewMesh();
                Vec3 viewDir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
                VertexShader shader = this.renderMode == 1 ? new FlatVertexShader(mesh, surfaceRGB, viewDir) : (this.renderMode == 2 ? new SmoothVertexShader(mesh, surfaceRGB, viewDir) : new TexturedVertexShader(mesh, this.objInfo.object, 0.0, viewDir).optimize());
                this.renderMesh(mesh, shader, this.theCamera, this.objInfo.object.isClosed(), null);
            }
        }
        if (this.showMesh) {
            Color color;
            int i;
            MeshVertex[] v = ((Mesh)((Object)this.theObject)).getVertices();
            Vec2[] pos = new Vec2[v.length];
            for (i = 0; i < v.length; ++i) {
                pos[i] = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            }
            if (this.renderMode == 0) {
                g.setColor(Color.black);
                for (i = 0; i < v.length - 1; ++i) {
                    g.drawLine((int)pos[i].x, (int)pos[i].y, (int)pos[i + 1].x, (int)pos[i + 1].y);
                }
                if (((Tube)this.theObject).getEndsStyle() == 1) {
                    g.drawLine((int)pos[v.length - 1].x, (int)pos[v.length - 1].y, (int)pos[0].x, (int)pos[0].y);
                }
            } else {
                for (i = 0; i < v.length - 1; ++i) {
                    this.renderLine(v[i].r, v[i + 1].r, this.theCamera, Color.black);
                }
                if (((Tube)this.theObject).getEndsStyle() == 1) {
                    this.renderLine(v[v.length - 1].r, v[0].r, this.theCamera, Color.black);
                }
            }
            for (i = 0; i < v.length; ++i) {
                if (selected[i] || !(this.theCamera.getObjectToView().timesZ(v[i].r) > this.theCamera.getClipDistance())) continue;
                if (this.renderMode == 0) {
                    g.fillRect((int)pos[i].x - 2, (int)pos[i].y - 2, 5, 5);
                    continue;
                }
                double z = this.theCamera.getObjectToView().timesZ(v[i].r);
                this.renderBox((int)pos[i].x - 2, (int)pos[i].y - 2, 5, 5, z, Color.black);
            }
            Color color2 = color = this.currentTool.hilightSelection() ? Color.magenta : Color.black;
            if (g != null) {
                g.setColor(color);
            }
            for (int i2 = 0; i2 < v.length; ++i2) {
                if (!selected[i2] || !(this.theCamera.getObjectToView().timesZ(v[i2].r) > this.theCamera.getClipDistance())) continue;
                if (this.renderMode == 0) {
                    g.fillRect((int)pos[i2].x - 2, (int)pos[i2].y - 2, 5, 5);
                    continue;
                }
                double z = this.theCamera.getObjectToView().timesZ(v[i2].r);
                this.renderBox((int)pos[i2].x - 2, (int)pos[i2].y - 2, 5, 5, z, color);
            }
        }
    }
}

