/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CurveEditorWindow;
import artofillusion.CurveViewer;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.TaperMeshTool;
import artofillusion.TubeViewer;
import artofillusion.UndoRecord;
import artofillusion.Utilities;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.object.Tube;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MenuStructure;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.CommandEvent;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BMenuItem;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.MenuWidget;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class TubeEditorWindow
extends CurveEditorWindow {
    BCheckBoxMenuItem[] endsItem;

    public TubeEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Runnable onClose) {
        super(parent, title, obj, onClose, 1);
        MenuStructure ms = new MenuStructure();
        ms.loadStructure("Tube", false);
        this.menubar = ms.createMenuBar(this);
        this.setMenuBar(this.menubar);
        this.menuitemsCache = null;
        UIUtilities.recursivelyAddKeyPressedListeners(this);
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 3 / 4, d1.height * 3 / 4);
        this.setBounds(new Rectangle((d1.width - d2.width) / 2, (d1.height - d2.height) / 2, d2.width, d2.height));
        this.updateMenus();
    }

    protected void updateMenuItem(MenuWidget item) {
        String itemname = ((Widget)((Object)item)).getName();
        BCheckBoxMenuItem cbitem = null;
        BMenuItem mnitem = null;
        if (item instanceof BCheckBoxMenuItem) {
            cbitem = (BCheckBoxMenuItem)item;
        } else if (item instanceof BMenuItem) {
            mnitem = (BMenuItem)item;
        }
        Tube obj = (Tube)this.getCurrentView().getObject().object;
        if ("parameters".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("thickness".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("centerTube".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("smoothness".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("openEnds".equals(itemname)) {
            cbitem.setState(obj.getEndsStyle() == 0);
        } else if ("closedEnds".equals(itemname)) {
            cbitem.setState(obj.getEndsStyle() == 1);
        } else if ("flatEnds".equals(itemname)) {
            cbitem.setState(obj.getEndsStyle() == 2);
        } else {
            super.updateMenuItem(item);
        }
    }

    public void itemStateChanged(CommandEvent e) {
        Object[] ENDSSTYLES;
        int i;
        Object source = e.getSource();
        BCheckBoxMenuItem sourceitem = null;
        String itemname = "";
        if (source instanceof BCheckBoxMenuItem) {
            sourceitem = (BCheckBoxMenuItem)source;
            itemname = sourceitem.getName();
        }
        if ((i = Utilities.findIndexEqual(ENDSSTYLES = new String[]{"openEnds", "closedEnds", "flatEnds"}, itemname)) > -1) {
            ((Tube)this.getCurrentView().getObject().object).setEndsStyle(i);
            this.updateMenus();
            this.object3DChangedDuringEditor();
            return;
        }
        super.itemStateChanged(e);
    }

    public void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.handleMenuAction(command)) {
            if (command.equals("deletePoints")) {
                this.deleteCommand();
            } else if (command.equals("editPoints")) {
                this.setPointsCommand();
            } else if (command.equals("parameters")) {
                this.setParametersCommand();
            } else if (command.equals("thickness")) {
                this.setThicknessCommand();
            } else if (command.equals("centerTube")) {
                this.centerCommand();
            } else if (command.equals("smoothness")) {
                this.setSmoothnessCommand();
            } else if (command.equals("curveTension")) {
                this.setTensionCommand();
            } else if (command.equals("closedEnds")) {
                this.toggleClosedCommand();
            } else if (command.equals("renderPreview")) {
                this.getCurrentView().previewObject();
            } else if (command.equals("grid")) {
                this.setGridCommand();
            } else if (command.equals("fourViews")) {
                this.toggleViewsCommand();
            } else if (command.equals("showTemplate")) {
                boolean wasShown = this.getCurrentView().getTemplateShown();
                for (int i = 0; i < this.theView.length; ++i) {
                    this.theView[i].setShowTemplate(!wasShown);
                }
                this.updateMenus();
                this.updateImage();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    protected MeshEditorWindow createNewViewNewSelection() {
        TubeEditorWindow w = new TubeEditorWindow(this.parentWindow, this.getTitle(), this.objInConstructor, this.onClose);
        return w;
    }

    public MeshViewer createMeshViewer(ObjectInfo obj, RowContainer p) {
        return new TubeViewer(obj, p);
    }

    public BorderContainer createToolbarPanel() {
        BorderContainer p4 = new BorderContainer();
        this.tools = new ToolPalette(1, 7);
        p4.add(this.tools, BorderContainer.NORTH);
        this.defaultTool = new ReshapeMeshTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this));
        this.tools.addTool(new RotateMeshTool(this, false));
        this.tools.addTool(new SkewMeshTool(this));
        this.tools.addTool(new TaperMeshTool(this));
        this.tools.addTool(this.getMetaTool());
        this.tools.addTool(this.getAltTool());
        this.tools.selectTool(this.defaultTool);
        return p4;
    }

    public void deleteCommand() {
        int i;
        int num = 0;
        Tube theTube = (Tube)this.getCurrentView().getObject().object;
        boolean[] selected = ((TubeViewer)this.getCurrentView()).getSelection();
        MeshVertex[] vt = theTube.getVertices();
        double[] t = theTube.getThickness();
        float[] s = theTube.getSmoothness();
        for (i = 0; i < selected.length; ++i) {
            if (!selected[i]) continue;
            ++num;
        }
        if (num == 0) {
            return;
        }
        if (theTube.getEndsStyle() != 1 && selected.length - num < 2) {
            new BStandardDialog("", Translate.text("tubeNeeds2Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        if (theTube.getEndsStyle() == 1 && selected.length - num < 3) {
            new BStandardDialog("", Translate.text("tubeNeeds3Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theTube, theTube.duplicate()}));
        MeshVertex[] newv = new MeshVertex[vt.length - num];
        double[] newt = new double[vt.length - num];
        float[] news = new float[vt.length - num];
        boolean[] newsel = new boolean[vt.length - num];
        int j = 0;
        for (i = 0; i < vt.length; ++i) {
            if (selected[i]) continue;
            newsel[j] = selected[i];
            newt[j] = t[i];
            news[j] = s[i];
            newv[j++] = vt[i];
        }
        theTube.setShape(newv, news, newt);
        this.object3DChangedDuringEditor();
        ((TubeViewer)this.getCurrentView()).setSelection(newsel);
        ((CurveViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
    }

    public void subdivideCommand() {
        int j;
        int i;
        Tube theTube = (Tube)this.getCurrentView().getObject().object;
        MeshVertex[] vt = theTube.getVertices();
        float[] s = theTube.getSmoothness();
        double[] t = theTube.getThickness();
        int numParam = theTube.getParameters() == null ? 0 : theTube.getParameters().length;
        double[] paramTemp = new double[numParam];
        boolean[] selected = ((TubeViewer)this.getCurrentView()).getSelection();
        int splitcount = 0;
        int method = theTube.getSmoothingMethod();
        double[][] param = new double[vt.length][numParam];
        ParameterValue[] paramValue = theTube.getParameterValues();
        for (i = 0; i < numParam; ++i) {
            if (!(paramValue[i] instanceof VertexParameterValue)) continue;
            double[] val = ((VertexParameterValue)paramValue[i]).getValue();
            for (j = 0; j < val.length; ++j) {
                param[j][i] = val[j];
            }
        }
        boolean[] split = theTube.getEndsStyle() == 1 ? new boolean[vt.length] : new boolean[vt.length - 1];
        for (i = 0; i < split.length; ++i) {
            if (!selected[i] || !selected[(i + 1) % selected.length]) continue;
            split[i] = true;
            ++splitcount;
        }
        MeshVertex[] newpos = new MeshVertex[vt.length + splitcount];
        float[] news = new float[vt.length + splitcount];
        double[] newt = new double[vt.length + splitcount];
        double[][] newparam = new double[vt.length + splitcount][numParam];
        boolean[] newsel = new boolean[vt.length + splitcount];
        j = 0;
        for (i = 0; i < split.length; ++i) {
            int k;
            newsel[j] = selected[i];
            int p1 = i - 1;
            if (p1 < 0) {
                p1 = theTube.getEndsStyle() == 1 ? vt.length - 1 : 0;
            }
            int p3 = i < vt.length - 1 ? i + 1 : (theTube.getEndsStyle() == 1 ? 0 : vt.length - 1);
            if (selected[i] && method == 3) {
                newpos[j] = SplineMesh.calcApproxPoint(vt, s, param, paramTemp, p1, i, p3);
                newt[j] = Tube.calcApproxThickness(t, s, p1, i, p3);
                for (k = 0; k < numParam; ++k) {
                    newparam[j][k] = paramTemp[k];
                }
            } else {
                newpos[j] = vt[i];
                newt[j] = t[i];
                newparam[j] = param[i];
            }
            news[j] = selected[i] ? Math.min(s[i] * 2.0f, 1.0f) : s[i];
            if (!split[i]) {
                ++j;
                continue;
            }
            if (method == 0) {
                newpos[j + 1] = MeshVertex.blend(vt[i], vt[p3], 0.5, 0.5);
                for (k = 0; k < numParam; ++k) {
                    newparam[j + 1][k] = 0.5 * (param[i][k] + param[p3][k]);
                }
            } else if (method == 2) {
                int p4 = i < vt.length - 2 ? i + 2 : (theTube.getEndsStyle() == 1 ? (i + 2) % vt.length : vt.length - 1);
                newpos[j + 1] = SplineMesh.calcInterpPoint(vt, s, param, paramTemp, p1, i, p3, p4);
                newt[j + 1] = Tube.calcInterpThickness(t, s, p1, i, p3, p4);
                for (k = 0; k < numParam; ++k) {
                    newparam[j + 1][k] = paramTemp[k];
                }
            } else {
                newpos[j + 1] = MeshVertex.blend(vt[i], vt[p3], 0.5, 0.5);
                newt[j + 1] = 0.5 * (t[i] + t[p3]);
                for (k = 0; k < numParam; ++k) {
                    newparam[j + 1][k] = 0.5 * (param[i][k] + param[p3][k]);
                }
            }
            news[j + 1] = 1.0f;
            newsel[j + 1] = true;
            j += 2;
        }
        if (theTube.getEndsStyle() != 1) {
            newpos[0] = vt[0];
            newpos[j] = vt[i];
            newt[0] = t[0];
            newt[j] = t[i];
            news[j] = s[i];
            newparam[0] = param[0];
            newparam[j] = param[i];
            newsel[j] = selected[i];
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theTube, theTube.duplicate()}));
        theTube.setShape(newpos, news, newt);
        for (i = 0; i < numParam; ++i) {
            if (!(paramValue[i] instanceof VertexParameterValue)) continue;
            double[] val = new double[newpos.length];
            for (j = 0; j < val.length; ++j) {
                val[j] = newparam[j][i];
            }
            paramValue[i] = new VertexParameterValue(val);
        }
        theTube.setParameterValues(paramValue);
        ((TubeViewer)this.getCurrentView()).setSelection(newsel);
        ((CurveViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
        this.object3DChangedDuringEditor();
    }

    public void setThicknessCommand() {
        Tube theTube = (Tube)this.getCurrentView().getObject().object;
        double[] thickness = theTube.getThickness();
        double initial = -1.0;
        int[] selected = this.getCurrentView().getSelectionDistance();
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] != 0) continue;
            if (initial == -1.0) {
                initial = thickness[i];
                continue;
            }
            if (initial == thickness[i]) continue;
            initial = Double.NaN;
        }
        if (initial == -1.0) {
            return;
        }
        ValueField thicknessField = new ValueField(initial, 1, 5);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("setThicknessTitle"), new Widget[]{thicknessField}, new String[]{Translate.text("Thickness")});
        if (!dlg.clickedOk() || Double.isNaN(thicknessField.getValue())) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theTube, theTube.duplicate()}));
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] != 0) continue;
            thickness[i] = thicknessField.getValue();
        }
        theTube.setThickness(thickness);
        this.object3DChangedDuringEditor();
    }
}

