/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshViewer;
import artofillusion.ModelEvent;
import artofillusion.RenderingMesh;
import artofillusion.TextureParameter;
import artofillusion.TriMeshEditorWindow;
import artofillusion.Utilities;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.ParameterValue;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.TexturedVertexShader;
import artofillusion.view.VertexShader;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Arrays;
import java.util.Vector;

public class TriMeshViewer
extends MeshViewer {
    private boolean[] visible;
    private boolean[] hideVert;
    private boolean[] hideEdge;
    private boolean[] hideFace;
    private boolean draggingSelectionBox;
    private boolean dragging;
    private boolean tolerant;
    private boolean showQuads;
    private Point[] screenVert;
    private double[] screenZ;
    private int[][] boundary;
    private TextureParameter hideFaceParam;
    public static final int POINT_MODE = 0;
    public static final int EDGE_MODE = 1;
    public static final int FACE_MODE = 2;

    public TriMeshViewer(ObjectInfo obj, RowContainer p) {
        super(obj, p);
        TriangleMesh mesh = (TriangleMesh)obj.object;
        this.visible = new boolean[mesh.getVertices().length];
        this.hideVert = new boolean[mesh.getVertices().length];
        this.findQuads();
        ((TriangleMesh)obj.getObject3D()).getSkeleton().getModelEvent().addListener(this);
    }

    public void dispose() {
        if (this.theObject != null) {
            ((TriangleMesh)this.theObject).getSkeleton().getModelEvent().removeListener(this);
        }
        super.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleModelEvent(ModelEvent event) {
        if (super.handleModelEvent(event)) return true;
        if (event.getSource() != ((TriangleMesh)this.theObject).getSkeleton()) return false;
        if (!event.hasKey("skeleton changed")) return false;
        if (!this.getSkeletonDetached() || !this.draggingAutosync) return true;
        this.updateInternalState();
        if (!this.isVisible()) return true;
        this.updateImage();
        this.repaint();
        return true;
    }

    protected void drawObject(Graphics g) {
        Color selectedColor;
        Color meshColor;
        MeshVertex[] v = ((Mesh)((Object)this.theObject)).getVertices();
        int selectMode = this.getSelectionMode();
        this.screenVert = new Point[v.length];
        this.screenZ = new double[v.length];
        if (this.visible.length != v.length) {
            this.visible = new boolean[v.length];
        }
        Vec2[] p = new Vec2[v.length];
        double clipDist = this.theCamera.isPerspective() ? this.theCamera.getClipDistance() : -1.7976931348623157E308;
        for (int i = 0; i < v.length; ++i) {
            p[i] = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            this.screenVert[i] = new Point((int)p[i].x, (int)p[i].y);
            this.screenZ[i] = this.theCamera.getObjectToView().timesZ(v[i].r);
            this.visible[i] = !this.hideVert[i] && this.screenZ[i] > clipDist;
        }
        this.drawSurface(g);
        if (this.currentTool instanceof SkeletonTool) {
            meshColor = Color.gray;
            selectedColor = new Color(255, 127, 255);
        } else {
            meshColor = Color.black;
            selectedColor = Color.magenta;
            if (this.showSkeleton && this.theObject.getSkeleton() != null) {
                this.theObject.getSkeleton().draw(this, false);
            }
        }
        if (selectMode == 0) {
            this.drawEdges(g, p, Color.gray, Color.gray);
            this.drawVertices(g, meshColor, this.currentTool.hilightSelection() ? selectedColor : meshColor);
        } else {
            this.drawEdges(g, p, meshColor, this.currentTool.hilightSelection() ? selectedColor : meshColor);
        }
        if (this.currentTool instanceof SkeletonTool && this.showSkeleton && this.theObject.getSkeleton() != null) {
            this.theObject.getSkeleton().draw(this, true);
        }
    }

    private void drawSurface(Graphics g) {
        RenderingMesh mesh;
        if (!this.showSurface) {
            return;
        }
        boolean[] hide = null;
        if (this.hideFaceParam != null) {
            mesh = this.objInfo.getPreviewMesh();
            double[] param = ((FaceParameterValue)mesh.param[mesh.param.length - 1]).getValue();
            hide = new boolean[param.length];
            for (int i = 0; i < hide.length; ++i) {
                hide[i] = param[i] == 1.0;
            }
        }
        if (this.renderMode == 0) {
            g.setColor(surfaceColor);
            Object3D.draw(g, this.theCamera, this.objInfo.getWireframePreview(), this.objInfo.getBounds());
        } else if (this.renderMode == 4) {
            this.renderMeshTransparent(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), surfaceRGB, hide);
        } else {
            mesh = this.objInfo.getPreviewMesh();
            Vec3 viewDir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
            VertexShader shader = this.renderMode == 1 ? new FlatVertexShader(mesh, surfaceRGB, viewDir) : (this.renderMode == 2 ? new SmoothVertexShader(mesh, surfaceRGB, viewDir) : new TexturedVertexShader(mesh, this.objInfo.object, 0.0, viewDir).optimize());
            this.renderMesh(mesh, shader, this.theCamera, this.objInfo.object.isClosed(), hide);
        }
    }

    private void drawVertices(Graphics g, Color unselectedColor, Color selectedColor) {
        int i;
        if (!this.showMesh) {
            return;
        }
        MeshVertex[] v = ((Mesh)((Object)this.theObject)).getVertices();
        boolean[] selected = this.getSelection();
        if (this.renderMode == 0 || this.renderMode == 4) {
            for (i = 0; i < v.length; ++i) {
                if (selected[i] || !this.visible[i]) continue;
                this.drawBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, unselectedColor);
            }
        } else {
            for (i = 0; i < v.length; ++i) {
                if (selected[i] || !this.visible[i]) continue;
                this.renderBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, this.screenZ[i] - 0.01, unselectedColor);
            }
        }
        if (this.renderMode == 0 || this.renderMode == 4) {
            for (i = 0; i < v.length; ++i) {
                if (!selected[i] || !this.visible[i]) continue;
                this.drawBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, selectedColor);
            }
        } else {
            for (i = 0; i < v.length; ++i) {
                if (!selected[i] || !this.visible[i]) continue;
                this.renderBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, this.screenZ[i] - 0.01, selectedColor);
            }
        }
    }

    private void drawEdges(Graphics g, Vec2[] p, Color unselectedColor, Color selectedColor) {
        block26: {
            int i;
            boolean[] selected;
            int selectMode;
            TriangleMesh.Edge[] e;
            block24: {
                block25: {
                    if (!this.showMesh) {
                        return;
                    }
                    e = ((TriangleMesh)this.theObject).getEdges();
                    selectMode = this.getSelectionMode();
                    selected = this.getSelection();
                    if (this.renderMode == 0 || this.renderMode == 4) {
                        if (selectMode == 0) {
                            for (i = 0; i < e.length; ++i) {
                                if (this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2]) continue;
                                this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], unselectedColor);
                            }
                        } else if (selectMode == 1) {
                            for (i = 0; i < e.length; ++i) {
                                if (selected[i] || this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2]) continue;
                                this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], unselectedColor);
                            }
                        } else {
                            for (i = 0; i < e.length; ++i) {
                                if (this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2] || selected[e[i].f1] || e[i].f2 != -1 && selected[e[i].f2]) continue;
                                this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], unselectedColor);
                            }
                        }
                    } else if (selectMode == 0) {
                        for (i = 0; i < e.length; ++i) {
                            if (this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2]) continue;
                            this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, unselectedColor);
                        }
                    } else if (selectMode == 1) {
                        for (i = 0; i < e.length; ++i) {
                            if (selected[i] || this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2]) continue;
                            this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, unselectedColor);
                        }
                    } else {
                        for (i = 0; i < e.length; ++i) {
                            this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, unselectedColor);
                        }
                    }
                    if (this.renderMode != 0 && this.renderMode != 4) break block24;
                    if (selectMode != 1) break block25;
                    for (i = 0; i < e.length; ++i) {
                        if (!selected[i] || this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2]) continue;
                        this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], selectedColor);
                    }
                    break block26;
                }
                if (selectMode != 2) break block26;
                for (i = 0; i < e.length; ++i) {
                    if (this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2] || !selected[e[i].f1] && (e[i].f2 == -1 || !selected[e[i].f2])) continue;
                    this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], selectedColor);
                }
                break block26;
            }
            if (selectMode == 1) {
                for (i = 0; i < e.length; ++i) {
                    if (!selected[i] || this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2]) continue;
                    this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, selectedColor);
                }
            } else if (selectMode == 2) {
                for (i = 0; i < e.length; ++i) {
                    if (this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2] || !selected[e[i].f1] && (e[i].f2 == -1 || !selected[e[i].f2])) continue;
                    this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, selectedColor);
                }
            }
        }
    }

    private void addExtraParameter() {
        if (this.hideFaceParam != null) {
            return;
        }
        this.hideFaceParam = new TextureParameter(this, "Hide Face", 0.0, 1.0, 0.0);
        TextureParameter[] params = this.theObject.getParameters();
        TextureParameter[] newparams = new TextureParameter[params.length + 1];
        ParameterValue[] values = this.theObject.getParameterValues();
        ParameterValue[] newvalues = new ParameterValue[values.length + 1];
        for (int i = 0; i < params.length; ++i) {
            newparams[i] = params[i];
            newvalues[i] = values[i];
        }
        newparams[params.length] = this.hideFaceParam;
        newvalues[values.length] = new FaceParameterValue((TriangleMesh)this.theObject, this.hideFaceParam);
        this.theObject.setParameters(newparams);
        this.theObject.setParameterValues(newvalues);
        this.objInfo.clearCachedMeshes();
    }

    public void removeExtraParameter() {
        if (this.hideFaceParam == null) {
            return;
        }
        this.hideFaceParam = null;
        TextureParameter[] params = this.theObject.getParameters();
        TextureParameter[] newparams = new TextureParameter[params.length - 1];
        ParameterValue[] values = this.theObject.getParameterValues();
        ParameterValue[] newvalues = new ParameterValue[values.length - 1];
        for (int i = 0; i < newparams.length; ++i) {
            newparams[i] = params[i];
            newvalues[i] = values[i];
        }
        this.theObject.setParameters(newparams);
        this.theObject.setParameterValues(newvalues);
        this.objInfo.clearCachedMeshes();
    }

    public TextureParameter getExtraParameter() {
        return this.hideFaceParam;
    }

    public void drawDraggedSelection(Graphics g, Camera cam, Vec3[] v, boolean broadcast) {
        int i;
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] edge = ((TriangleMesh)this.theObject).getEdges();
        int selectMode = this.getSelectionMode();
        if (selectMode == 0) {
            for (i = 0; i < vert.length; ++i) {
                if (vert[i].r == v[i]) continue;
                Vec2 p = cam.getObjectToScreen().timesXY(v[i]);
                g.fillRect((int)p.x - 2, (int)p.y - 2, 5, 5);
            }
        }
        for (i = 0; i < edge.length; ++i) {
            if (this.hideEdge[i] || vert[edge[i].v1].r == v[edge[i].v1] && vert[edge[i].v2].r == v[edge[i].v2]) continue;
            cam.drawClippedLine(g, v[edge[i].v1], v[edge[i].v2]);
        }
        this.broadcastDraggedSelection(v, broadcast);
    }

    public void setSelectionMode(int mode) {
        boolean[] newSel;
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] e = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        if (mode == selectMode) {
            return;
        }
        if (mode == 0) {
            newSel = new boolean[v.length];
            if (selectMode == 1) {
                for (int i = 0; i < e.length; ++i) {
                    if (!selected[i]) continue;
                    newSel[e[i].v2] = true;
                    newSel[e[i].v1] = true;
                }
            } else {
                for (int i = 0; i < f.length; ++i) {
                    if (!selected[i]) continue;
                    newSel[f[i].v3] = true;
                    newSel[f[i].v2] = true;
                    newSel[f[i].v1] = true;
                }
            }
        } else if (mode == 1) {
            newSel = new boolean[e.length];
            if (selectMode == 0) {
                if (this.tolerant) {
                    for (int i = 0; i < e.length; ++i) {
                        newSel[i] = !this.hideEdge[i] && (selected[e[i].v1] || selected[e[i].v2]);
                    }
                } else {
                    for (int i = 0; i < e.length; ++i) {
                        newSel[i] = !this.hideEdge[i] && selected[e[i].v1] && selected[e[i].v2];
                    }
                }
            } else {
                for (int i = 0; i < f.length; ++i) {
                    if (!selected[i]) continue;
                    newSel[f[i].e3] = true;
                    newSel[f[i].e2] = true;
                    newSel[f[i].e1] = true;
                }
            }
        } else {
            newSel = new boolean[f.length];
            if (selectMode == 0) {
                if (this.tolerant) {
                    for (int i = 0; i < f.length; ++i) {
                        newSel[i] = selected[f[i].v1] || selected[f[i].v2] || selected[f[i].v3];
                    }
                } else {
                    for (int i = 0; i < f.length; ++i) {
                        newSel[i] = selected[f[i].v1] && selected[f[i].v2] && selected[f[i].v3];
                    }
                }
            } else {
                for (int i = 0; i < f.length; ++i) {
                    newSel[i] = selected[f[i].e1] && selected[f[i].e2] && selected[f[i].e3];
                }
            }
        }
        this.getSelectionHolder().setSelectionMode(mode);
        this.getSelectionHolder().setSelection(newSel);
    }

    public boolean[] getVisible() {
        return this.visible;
    }

    public Point[] getScreenVert() {
        return this.screenVert;
    }

    public boolean isTolerant() {
        return this.tolerant;
    }

    public void setTolerant(boolean tol) {
        this.tolerant = tol;
    }

    public boolean isQuadMode() {
        return this.showQuads;
    }

    public void setQuadMode(boolean quads) {
        this.showQuads = quads;
        this.findQuads();
        this.findSelectionDistance();
    }

    public boolean isEdgeHidden(int which) {
        return this.hideEdge[which];
    }

    public boolean[] getHiddenFaces() {
        return this.hideFace;
    }

    public void setHiddenFaces(boolean[] hidden) {
        this.hideFace = hidden;
        TriangleMesh obj = (TriangleMesh)this.theObject;
        this.hideVert = new boolean[obj.getVertices().length];
        if (this.hideFace != null) {
            for (int i = 0; i < this.hideVert.length; ++i) {
                this.hideVert[i] = true;
            }
            TriangleMesh.Face[] face = obj.getFaces();
            for (int i = 0; i < face.length; ++i) {
                if (this.hideFace[i]) continue;
                this.hideVert[face[i].v3] = false;
                this.hideVert[face[i].v2] = false;
                this.hideVert[face[i].v1] = false;
            }
            this.addExtraParameter();
            FaceParameterValue val = (FaceParameterValue)this.theObject.getParameterValue(this.hideFaceParam);
            double[] param = val.getValue();
            for (int i = 0; i < this.hideFace.length; ++i) {
                param[i] = this.hideFace[i] ? 1.0 : 0.0;
            }
            val.setValue(param);
            this.theObject.setParameterValue(this.hideFaceParam, val);
            this.objInfo.clearCachedMeshes();
        } else {
            this.removeExtraParameter();
            for (int i = 0; i < this.hideVert.length; ++i) {
                this.hideVert[i] = false;
            }
        }
        this.findQuads();
        this.updateImage();
        this.repaint();
    }

    public void setSelection(boolean[] sel) {
        this.getSelectionHolder().setSelection(sel);
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }

    protected void findSelectionDistance() {
        int i;
        int[] dist = new int[((TriangleMesh)this.theObject).getVertices().length];
        TriangleMesh.Edge[] e = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        this.maxDistance = TriMeshEditorWindow.getTensionDistance();
        if (selectMode == 0) {
            for (i = 0; i < dist.length; ++i) {
                dist[i] = selected[i] ? 0 : -1;
            }
        } else if (selectMode == 1) {
            for (i = 0; i < dist.length; ++i) {
                dist[i] = -1;
            }
            for (i = 0; i < selected.length; ++i) {
                if (!selected[i]) continue;
                dist[e[i].v2] = 0;
                dist[e[i].v1] = 0;
            }
        } else {
            for (i = 0; i < dist.length; ++i) {
                dist[i] = -1;
            }
            for (i = 0; i < selected.length; ++i) {
                if (!selected[i]) continue;
                dist[f[i].v3] = 0;
                dist[f[i].v2] = 0;
                dist[f[i].v1] = 0;
            }
        }
        for (i = 0; i < this.maxDistance; ++i) {
            for (int j = 0; j < e.length; ++j) {
                if (this.hideEdge[j]) continue;
                if (dist[e[j].v1] == -1 && dist[e[j].v2] == i) {
                    dist[e[j].v1] = i + 1;
                    continue;
                }
                if (dist[e[j].v2] != -1 || dist[e[j].v1] != i) continue;
                dist[e[j].v2] = i + 1;
            }
        }
        this.selectionDistance = dist;
    }

    public void extendDistance(int[] dist, int maxDistance) {
        TriangleMesh.Edge[] e = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        for (int i = 0; maxDistance == -1 || i < maxDistance; ++i) {
            boolean canStop = true;
            for (int j = 0; j < e.length; ++j) {
                if (this.hideEdge[j]) continue;
                if (dist[e[j].v1] == -1 && dist[e[j].v2] == i) {
                    dist[e[j].v1] = i + 1;
                    canStop = false;
                    continue;
                }
                if (dist[e[j].v2] != -1 || dist[e[j].v1] != i) continue;
                dist[e[j].v2] = i + 1;
                canStop = false;
            }
            if (canStop) break;
        }
    }

    public void setMesh(Mesh mesh) {
        TriangleMesh obj = (TriangleMesh)mesh;
        this.setObject(obj);
        int selectMode = this.getSelectionMode();
        int newsellength = -1;
        if (selectMode == 0) {
            newsellength = obj.getVertices().length;
        } else if (selectMode == 1) {
            newsellength = obj.getEdges().length;
        } else if (selectMode == 2) {
            newsellength = obj.getFaces().length;
        }
        this.getSelectionHolder().setSelection(Utilities.arrayEnsureLength(this.getSelection(), newsellength));
        this.visible = Utilities.arrayEnsureLength(this.visible, newsellength);
        this.hideVert = new boolean[obj.getVertices().length];
        if (this.hideFaceParam != null) {
            FaceParameterValue val = (FaceParameterValue)this.theObject.getParameterValue(this.hideFaceParam);
            double[] param = val.getValue();
            this.hideFace = new boolean[param.length];
            for (int i = 0; i < param.length; ++i) {
                this.hideFace[i] = param[i] == 1.0;
            }
        }
        this.findQuads();
        this.findSelectionDistance();
        this.boundary = null;
        this.currentTool.getWindow().updateMenus();
    }

    public int[][] findSelectedBoundaries() {
        if (this.getSelectionMode() != 1) {
            return new int[0][0];
        }
        if (this.boundary == null) {
            this.boundary = ((TriangleMesh)this.theObject).findBoundaryEdges();
        }
        Vector<int[]> all = new Vector<int[]>();
        for (int i = 0; i < this.boundary.length; ++i) {
            int start;
            for (start = this.boundary[i].length - 1; start > 0 && this.getSelection()[this.boundary[i][start]]; --start) {
            }
            Vector<Integer> current = null;
            int j = start;
            do {
                boolean isSelected;
                if (isSelected = this.getSelection()[this.boundary[i][j]]) {
                    if (current == null) {
                        current = new Vector<Integer>();
                    }
                    current.addElement(new Integer(this.boundary[i][j]));
                }
                if (++j == this.boundary[i].length) {
                    j = 0;
                }
                if (isSelected && j != start || current == null) continue;
                int[] edgeList = new int[current.size()];
                for (int k = 0; k < edgeList.length; ++k) {
                    edgeList[k] = (Integer)current.elementAt(k);
                }
                all.addElement(edgeList);
                current = null;
            } while (j != start);
        }
        int[][] index = new int[all.size()][];
        all.copyInto((Object[])index);
        return index;
    }

    public void objectChanged() {
        super.objectChanged();
        this.findQuads();
    }

    protected void mousePressed(WidgetMouseEvent e) {
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] ed = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        this.requestFocus();
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if (this.activeTool.whichClicks() == 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            return;
        }
        int i = this.findClickTarget(e.getPoint(), null);
        if (i == -1) {
            this.draggingSelectionBox = true;
            this.beginDraggingSelection(e.getPoint(), false);
            this.sentClick = false;
            return;
        }
        int j = selectMode == 1 ? (this.visible[ed[i].v1] ? ed[i].v1 : ed[i].v2) : (selectMode == 2 ? (this.visible[f[i].v1] ? f[i].v1 : (this.visible[f[i].v2] ? f[i].v2 : f[i].v3)) : i);
        if (selected[i]) {
            if (e.isShiftDown()) {
                this.deselect = i;
            }
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
            return;
        }
        if (!e.isShiftDown()) {
            for (int k = 0; k < selected.length; ++k) {
                selected[k] = false;
            }
        }
        selected[i] = true;
        if (selectMode == 2) {
            if (this.hideEdge[f[i].e1]) {
                selected[ed[f[i].e1].f2] = true;
                selected[ed[f[i].e1].f1] = true;
            }
            if (this.hideEdge[f[i].e2]) {
                selected[ed[f[i].e2].f2] = true;
                selected[ed[f[i].e2].f1] = true;
            }
            if (this.hideEdge[f[i].e3]) {
                selected[ed[f[i].e3].f2] = true;
                selected[ed[f[i].e3].f1] = true;
            }
        }
        this.getSelectionHolder().informChanged(this, "object editor");
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        if (e.isShiftDown()) {
            this.sentClick = false;
            this.updateImage();
            this.repaint();
        } else {
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
        }
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        int i;
        TriangleMesh.Edge[] ed = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] fc = ((TriangleMesh)this.theObject).getFaces();
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        this.moveToGrid(e);
        this.endDraggingSelection();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            for (i = 0; i < selected.length; ++i) {
                selected[i] = false;
            }
        }
        if (this.selectBounds != null) {
            boolean newsel;
            boolean bl = newsel = !e.isControlDown();
            if (selectMode == 0) {
                for (i = 0; i < selected.length; ++i) {
                    if (this.hideVert[i] || !this.selectionRegionContains(this.screenVert[i])) continue;
                    selected[i] = newsel;
                }
            } else if (selectMode == 1) {
                if (this.tolerant) {
                    for (i = 0; i < selected.length; ++i) {
                        if (this.hideEdge[i] || !this.selectionRegionContains(this.screenVert[ed[i].v1]) && !this.selectionRegionContains(this.screenVert[ed[i].v2])) continue;
                        selected[i] = newsel;
                    }
                } else {
                    for (i = 0; i < selected.length; ++i) {
                        if (this.hideEdge[i] || !this.selectionRegionContains(this.screenVert[ed[i].v1]) || !this.selectionRegionContains(this.screenVert[ed[i].v2])) continue;
                        selected[i] = newsel;
                    }
                }
            } else if (this.tolerant) {
                for (i = 0; i < selected.length; ++i) {
                    if (this.hideFace != null && this.hideFace[i] || !this.selectionRegionContains(this.screenVert[fc[i].v1]) && !this.selectionRegionContains(this.screenVert[fc[i].v2]) && !this.selectionRegionContains(this.screenVert[fc[i].v3])) continue;
                    selected[i] = newsel;
                }
            } else {
                for (i = 0; i < selected.length; ++i) {
                    if (this.hideFace != null && this.hideFace[i] || !this.selectionRegionContains(this.screenVert[fc[i].v1]) || !this.selectionRegionContains(this.screenVert[fc[i].v2]) || !this.selectionRegionContains(this.screenVert[fc[i].v3])) continue;
                    selected[i] = newsel;
                }
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            selected[this.deselect] = false;
            if (selectMode == 2) {
                TriangleMesh.Face f = fc[this.deselect];
                if (this.hideEdge[f.e1]) {
                    selected[ed[f.e1].f2] = false;
                    selected[ed[f.e1].f1] = false;
                }
                if (this.hideEdge[f.e2]) {
                    selected[ed[f.e2].f2] = false;
                    selected[ed[f.e2].f1] = false;
                }
                if (this.hideEdge[f.e3]) {
                    selected[ed[f.e3].f2] = false;
                    selected[ed[f.e3].f1] = false;
                }
            }
        }
        this.getSelectionHolder().informChanged(this, "object editor");
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
    }

    public int findClickTarget(Point pos, Vec3 uvw) {
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] ed = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] fc = ((TriangleMesh)this.theObject).getFaces();
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        double closestz = Double.MAX_VALUE;
        boolean sel = false;
        int which = -1;
        if (selectMode == 0) {
            for (int i = 0; i < vt.length; ++i) {
                if (!this.visible[i] || sel && !selected[i]) continue;
                Point v1 = this.screenVert[i];
                if (pos.x < v1.x - 2 || pos.x > v1.x + 2 || pos.y < v1.y - 2 || pos.y > v1.y + 2) continue;
                double z = this.theCamera.getObjectToView().timesZ(vt[i].r);
                if ((sel || !selected[i]) && !(z < closestz)) continue;
                which = i;
                closestz = z;
                sel = selected[i];
            }
        } else if (selectMode == 1) {
            for (int i = 0; i < ed.length; ++i) {
                double w;
                double u;
                double v;
                if (!this.visible[ed[i].v1] || !this.visible[ed[i].v2] || this.hideEdge[i] || sel && !selected[i]) continue;
                Point v1 = this.screenVert[ed[i].v1];
                Point v2 = this.screenVert[ed[i].v2];
                if (pos.x < v1.x - 2 && pos.x < v2.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2) continue;
                if (Math.abs(v1.x - v2.x) > Math.abs(v1.y - v2.y)) {
                    if (v2.x > v1.x) {
                        v = ((double)pos.x - (double)v1.x) / (double)(v2.x - v1.x);
                        u = 1.0 - v;
                    } else {
                        u = ((double)pos.x - (double)v2.x) / (double)(v1.x - v2.x);
                        v = 1.0 - u;
                    }
                    w = u * (double)v1.y + v * (double)v2.y - (double)pos.y;
                } else {
                    if (v2.y > v1.y) {
                        v = ((double)pos.y - (double)v1.y) / (double)(v2.y - v1.y);
                        u = 1.0 - v;
                    } else {
                        u = ((double)pos.y - (double)v2.y) / (double)(v1.y - v2.y);
                        v = 1.0 - u;
                    }
                    w = u * (double)v1.x + v * (double)v2.x - (double)pos.x;
                }
                if (Math.abs(w) > 2.0) continue;
                double z = u * this.theCamera.getObjectToView().timesZ(vt[ed[i].v1].r) + v * this.theCamera.getObjectToView().timesZ(vt[ed[i].v2].r);
                if ((sel || !selected[i]) && !(z < closestz)) continue;
                which = i;
                closestz = z;
                sel = selected[i];
                if (uvw == null) continue;
                uvw.set(u, v, w);
            }
        } else {
            for (int i = 0; i < fc.length; ++i) {
                double u;
                double w;
                if (this.hideFace != null && this.hideFace[i] || !this.visible[fc[i].v1] || !this.visible[fc[i].v2] || !this.visible[fc[i].v3] || sel && !selected[i]) continue;
                Point v1 = this.screenVert[fc[i].v1];
                Point v2 = this.screenVert[fc[i].v2];
                Point v3 = this.screenVert[fc[i].v3];
                if (pos.x < v1.x - 2 && pos.x < v2.x - 2 && pos.x < v3.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 && pos.x > v3.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 && pos.y < v3.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2 && pos.y > v3.y + 2) continue;
                double e1x = v1.x - v2.x;
                double e1y = v1.y - v2.y;
                double e2x = v1.x - v3.x;
                double e2y = v1.y - v3.y;
                double denom = 1.0 / (e1x * e2y - e1y * e2x);
                double vy = pos.y - v1.y;
                double vx = pos.x - v1.x;
                double v = (e2x *= denom) * vy - (e2y *= denom) * vx;
                if (v < 0.0 || v > 1.0 || (w = vx * (e1y *= denom) - vy * (e1x *= denom)) < 0.0 || w > 1.0 || (u = 1.0 - v - w) < 0.0 || u > 1.0) continue;
                double z = u * this.theCamera.getObjectToView().timesZ(vt[fc[i].v1].r) + v * this.theCamera.getObjectToView().timesZ(vt[fc[i].v2].r) + w * this.theCamera.getObjectToView().timesZ(vt[fc[i].v3].r);
                if ((sel || !selected[i]) && !(z < closestz)) continue;
                which = i;
                closestz = z;
                sel = selected[i];
                if (uvw == null) continue;
                uvw.set(u, v, w);
            }
        }
        return which;
    }

    private void findQuads() {
        int i;
        int i2;
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] e = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        if (this.hideEdge == null || this.hideEdge.length != e.length) {
            this.hideEdge = new boolean[e.length];
        }
        if (this.hideFace == null) {
            for (i2 = 0; i2 < e.length; ++i2) {
                this.hideEdge[i2] = false;
            }
        } else {
            for (i2 = 0; i2 < e.length; ++i2) {
                this.hideEdge[i2] = this.hideFace[e[i2].f1] && (e[i2].f2 == -1 || this.hideFace[e[i2].f2]);
            }
        }
        if (!this.showQuads) {
            return;
        }
        boolean[] candidate = new boolean[e.length];
        Vec3[] norm = new Vec3[f.length];
        for (i = 0; i < f.length; ++i) {
            TriangleMesh.Face fc = f[i];
            norm[i] = v[fc.v2].r.minus(v[fc.v1].r).cross(v[fc.v3].r.minus(v[fc.v1].r));
            double length = norm[i].length();
            if (!(length > 0.0)) continue;
            norm[i].scale(1.0 / length);
        }
        for (i = 0; i < e.length; ++i) {
            candidate[i] = e[i].f2 != -1 && norm[e[i].f1].dot(norm[e[i].f2]) > 0.99;
        }
        class EdgeScore
        implements Comparable {
            public int edge;
            public double score;

            public EdgeScore(int edge, double score) {
                this.edge = edge;
                this.score = score;
            }

            public int compareTo(Object o) {
                double diff = this.score - ((EdgeScore)o).score;
                if (diff < 0.0) {
                    return -1;
                }
                if (diff > 0.0) {
                    return 1;
                }
                return 0;
            }
        }
        Vector<EdgeScore> scoreVec = new Vector<EdgeScore>(e.length);
        Vec3 temp0 = new Vec3();
        Vec3 temp1 = new Vec3();
        Vec3 temp2 = new Vec3();
        for (int i3 = 0; i3 < e.length; ++i3) {
            if (!candidate[i3]) continue;
            TriangleMesh.Edge ed = e[i3];
            int v1 = ed.v1;
            int v2 = ed.v2;
            TriangleMesh.Face fc = f[ed.f1];
            int v3 = fc.v1 != v1 && fc.v1 != v2 ? fc.v1 : (fc.v2 != v1 && fc.v2 != v2 ? fc.v2 : fc.v3);
            fc = f[ed.f2];
            int v4 = fc.v1 != v1 && fc.v1 != v2 ? fc.v1 : (fc.v2 != v1 && fc.v2 != v2 ? fc.v2 : fc.v3);
            temp0.set(v[v1].r.minus(v[v2].r));
            temp0.normalize();
            temp1.set(v[v1].r.minus(v[v3].r));
            temp1.normalize();
            temp2.set(v[v1].r.minus(v[v4].r));
            temp2.normalize();
            if (Math.acos(temp0.dot(temp1)) + Math.acos(temp0.dot(temp2)) > Math.PI) continue;
            double dot = temp1.dot(temp2);
            double score = dot > 0.0 ? dot : -dot;
            temp1.set(v[v2].r.minus(v[v3].r));
            temp1.normalize();
            temp2.set(v[v2].r.minus(v[v4].r));
            temp2.normalize();
            if (Math.acos(-temp0.dot(temp1)) + Math.acos(-temp0.dot(temp2)) > Math.PI) continue;
            dot = temp1.dot(temp2);
            scoreVec.addElement(new EdgeScore(i3, score += dot > 0.0 ? dot : -dot));
        }
        if (scoreVec.size() == 0) {
            return;
        }
        Object[] score = new EdgeScore[scoreVec.size()];
        scoreVec.copyInto(score);
        Arrays.sort(score);
        boolean[] hasHiddenEdge = new boolean[f.length];
        for (int i4 = 0; i4 < score.length; ++i4) {
            TriangleMesh.Edge ed = e[((EdgeScore)score[i4]).edge];
            if (hasHiddenEdge[ed.f1] || hasHiddenEdge[ed.f2]) continue;
            this.hideEdge[((EdgeScore)score[i4]).edge] = true;
            hasHiddenEdge[ed.f2] = true;
            hasHiddenEdge[ed.f1] = true;
        }
    }
}

