/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.BevelExtrudeTool;
import artofillusion.Copieable;
import artofillusion.CreateVertexTool;
import artofillusion.CreateVertexTool_ED;
import artofillusion.LayoutWindow;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshSelectionHolder;
import artofillusion.MeshViewer;
import artofillusion.ModellingApp;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.TaperMeshTool;
import artofillusion.TextureParameter;
import artofillusion.ThickenMeshTool;
import artofillusion.TriMeshBeveler;
import artofillusion.TriMeshSimplifier;
import artofillusion.TriMeshViewer;
import artofillusion.UndoRecord;
import artofillusion.Utilities;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.animation.SkeletonTool;
import artofillusion.datahandling.AppendDefaultItemListOp;
import artofillusion.datahandling.AppendItemsListOp;
import artofillusion.datahandling.DeleteMarkedItemsListOp;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.GenericTool;
import artofillusion.ui.MenuStructure;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BMenuItem;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.MenuWidget;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;

public class TriMeshEditorWindow
extends MeshEditorWindow {
    ToolPalette modes;
    boolean topology;
    private static final String[] MENUITEMS_ALLOWED_ON_TOPOLOGY = new String[]{"clear", "subdivideEdges", "simplify", "bevel", "optimize", "closeBoundary", "joinBoundaries", "invertNormals", "createFace"};
    private static final String[] MENUITEMS_CHECKBOXITEMS = new String[]{"tolerantSelection", "freehandSelection", "displayAsQuads", "none", "shading", "interpolating", "approximating", "detachSkeleton"};

    public TriMeshEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Runnable onClose, boolean allowTopology) {
        super(parent, title, obj, onClose);
        this.topology = allowTopology;
        this.tools = new ToolPalette(1, allowTopology ? 12 : 9);
        this.toolsPanel.add(this.tools, BorderContainer.NORTH);
        this.defaultTool = new ReshapeMeshTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this));
        this.tools.addTool(new RotateMeshTool(this, false));
        this.tools.addTool(new SkewMeshTool(this));
        this.tools.addTool(new TaperMeshTool(this));
        this.tools.addTool(new ThickenMeshTool(this));
        if (this.topology) {
            this.tools.addTool(new BevelExtrudeTool(this));
            this.tools.addTool(new CreateVertexTool(this));
            this.tools.addTool(new CreateVertexTool_ED(this));
        }
        this.tools.addTool(new SkeletonTool(this, true));
        this.tools.addTool(this.getMetaTool());
        this.tools.addTool(this.getAltTool());
        this.tools.selectTool(this.defaultTool);
        this.modes = new ToolPalette(1, 3);
        this.toolsPanel.add(this.modes, BorderContainer.SOUTH);
        this.modes.addTool(new GenericTool(this, "point.gif", "selected/point.gif"));
        this.modes.addTool(new GenericTool(this, "edge.gif", "selected/edge.gif"));
        this.modes.addTool(new GenericTool(this, "face.gif", "selected/face.gif"));
        MenuStructure ms = new MenuStructure();
        ms.loadStructure("TriMesh", false);
        this.menubar = ms.createMenuBar(this);
        this.setMenuBar(this.menubar);
        this.menuitemsCache = null;
        UIUtilities.recursivelyAddKeyPressedListeners(this);
        this.pack();
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 3 / 4, d1.height * 3 / 4);
        this.setBounds(new Rectangle((d1.width - d2.width) / 2, (d1.height - d2.height) / 2, d2.width, d2.height));
        this.tools.requestFocus();
        this.updateMenus();
    }

    public boolean isMenuItemAllowed(MenuWidget item) {
        String itemname = ((Widget)((Object)item)).getName();
        if (Utilities.findIndexEqual(MENUITEMS_ALLOWED_ON_TOPOLOGY, itemname) > -1) {
            return this.topology;
        }
        if ("renderPreview".equals(itemname)) {
            return ModellingApp.getPreferences().getObjectPreviewRenderer() != null;
        }
        return super.isMenuItemAllowed(item);
    }

    protected boolean isMenuItemNameCheckbox(String itemname) {
        if (Utilities.findIndexEqual(MENUITEMS_CHECKBOXITEMS, itemname) > -1) {
            return true;
        }
        return super.isMenuItemNameCheckbox(itemname);
    }

    public void setTool(EditingTool tool) {
        for (int i = 0; i < this.theView.length; ++i) {
            if (tool instanceof GenericTool) {
                ((TriMeshViewer)this.theView[i]).setSelectionMode(this.modes.getSelection());
                this.theView[i].getCurrentTool().activate();
                ((TriMeshViewer)this.theView[i]).informSelectionChanged(this, "object editor");
                this.updateMenus();
                continue;
            }
            this.theView[i].setTool(tool);
            this.currentTool = tool;
        }
    }

    public boolean isSomethingSelected() {
        int i;
        boolean[] selected = ((TriMeshViewer)this.getCurrentView()).getSelection();
        for (i = 0; i < selected.length && !selected[i]; ++i) {
        }
        return i < selected.length;
    }

    protected void updateMenuItem(MenuWidget item) {
        String itemname = ((Widget)((Object)item)).getName();
        BCheckBoxMenuItem cbitem = null;
        BMenuItem mnitem = null;
        if (item instanceof BCheckBoxMenuItem) {
            cbitem = (BCheckBoxMenuItem)item;
        } else if (item instanceof BMenuItem) {
            mnitem = (BMenuItem)item;
        }
        int selectionMode = ((TriMeshViewer)this.getCurrentView()).getSelectionMode();
        TriangleMesh obj = (TriangleMesh)this.getCurrentView().getObject().object;
        if ("clear".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("selectBoundary".equals(itemname)) {
            mnitem.setEnabled(selectionMode == 1 && !this.getCurrentView().getObject().object.isClosed());
        } else if ("extendSelection".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("hideSelection".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("subdivideEdges".equals(itemname)) {
            mnitem.setEnabled(true);
            if (!this.isSomethingSelected()) {
                mnitem.setEnabled(false);
            } else if (selectionMode == 1) {
                mnitem.setText(Translate.text("menu.subdivideEdges"));
            } else if (selectionMode == 2) {
                mnitem.setText(Translate.text("menu.subdivideFaces"));
            } else {
                mnitem.setEnabled(false);
            }
        } else if ("simplify".equals(itemname)) {
            mnitem.setEnabled(true);
            if (this.isSomethingSelected()) {
                mnitem.setText(Translate.text("menu.simplify"));
            } else {
                mnitem.setText(Translate.text("menu.simplifyMesh"));
            }
        } else if ("createFace".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected() && selectionMode == 0);
        } else if ("editPoints".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("transformPoints".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("randomize".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("bevel".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("parameters".equals(itemname)) {
            if (this.isSomethingSelected()) {
                if (selectionMode == 1) {
                    int[][] boundary = ((TriMeshViewer)this.getCurrentView()).findSelectedBoundaries();
                    mnitem.setEnabled(boundary.length > 0);
                } else {
                    mnitem.setEnabled(true);
                }
            } else {
                mnitem.setEnabled(false);
            }
        } else if ("closeBoundary".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected() && selectionMode == 1);
        } else if ("joinBoundaries".equals(itemname)) {
            if (this.isSomethingSelected() && selectionMode == 1) {
                int[][] boundary = ((TriMeshViewer)this.getCurrentView()).findSelectedBoundaries();
                mnitem.setEnabled(boundary.length == 2);
            } else {
                mnitem.setEnabled(false);
            }
        } else if ("extractCurve".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected() && selectionMode == 1);
        } else if ("smoothness".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected() && selectionMode != 2);
        } else if ("fourViews".equals(itemname)) {
            if (this.numViewsShown == 4) {
                mnitem.setText(Translate.text("menu.fourViews"));
            } else {
                mnitem.setText(Translate.text("menu.oneView"));
            }
        } else if ("none".equals(itemname)) {
            cbitem.setState(obj.getSmoothingMethod() == 0);
        } else if ("shading".equals(itemname)) {
            cbitem.setState(obj.getSmoothingMethod() == 1);
        } else if ("interpolating".equals(itemname)) {
            cbitem.setState(obj.getSmoothingMethod() == 2);
        } else if ("approximating".equals(itemname)) {
            cbitem.setState(obj.getSmoothingMethod() == 3);
        } else if ("editBone".equals(itemname)) {
            Skeleton s = obj.getSkeleton();
            Joint selJoint = s.getJoint(this.getCurrentView().getSelectedJoint());
            mnitem.setEnabled(selJoint != null);
        } else if ("deleteBone".equals(itemname)) {
            Skeleton s = obj.getSkeleton();
            Joint selJoint = s.getJoint(this.getCurrentView().getSelectedJoint());
            mnitem.setEnabled(selJoint != null && selJoint.children.length == 0);
        } else if ("bindSkeleton".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("setParentBone".equals(itemname)) {
            Skeleton s = obj.getSkeleton();
            Joint selJoint = s.getJoint(this.getCurrentView().getSelectedJoint());
            mnitem.setEnabled(selJoint != null);
        } else {
            super.updateMenuItem(item);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyPressed(KeyPressedEvent e) {
        if (e.getKeyCode() != 127) {
            if (e.getKeyCode() != 8) {
                super.keyPressed(e);
                return;
            }
        }
        if (this.getCurrentView().getCurrentTool() instanceof SkeletonTool) {
            this.deleteJointCommand();
            return;
        }
        this.deleteCommand();
    }

    public void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.handleMenuAction(command)) {
            if (command.equals("undo")) {
                this.undoCommand();
            } else if (command.equals("clear")) {
                this.deleteCommand();
            } else if (command.equals("subdivideEdges")) {
                this.subdivideCommand();
            } else if (command.equals("editPoints")) {
                this.setPointsCommand();
            } else if (command.equals("parameters")) {
                this.setParametersCommand();
            } else if (command.equals("centerMesh")) {
                this.centerCommand();
            } else if (command.equals("smoothness")) {
                this.setSmoothnessCommand();
            } else if (command.equals("invertNormals")) {
                this.reverseNormalsCommand();
            } else if (command.equals("meshTension")) {
                this.setTensionCommand();
            } else if (command.equals("renderPreview")) {
                this.getCurrentView().previewObject();
            } else if (command.equals("editBone")) {
                this.editJointCommand();
            } else if (command.equals("deleteBone")) {
                this.deleteJointCommand();
            } else if (command.equals("setParentBone")) {
                this.setJointParentCommand();
            } else if (command.equals("grid")) {
                this.setGridCommand();
            } else if (command.equals("fourViews")) {
                this.toggleViewsCommand();
            } else if (command.equals("showTemplate")) {
                boolean wasShown = this.getCurrentView().getTemplateShown();
                this.getCurrentView().setShowTemplate(!wasShown);
                this.updateMenus();
                this.updateImage();
            } else if (command.equals("setTemplate")) {
                this.setTemplateCommand();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemStateChanged(CommandEvent e) {
        Object source = e.getSource();
        BCheckBoxMenuItem sourceitem = null;
        String itemname = "";
        if (source instanceof BCheckBoxMenuItem) {
            sourceitem = (BCheckBoxMenuItem)source;
            itemname = sourceitem.getName();
        }
        if ("tolerantSelection".equals(itemname)) {
            for (int i = 0; i < this.theView.length; ++i) {
                ((TriMeshViewer)this.theView[i]).setTolerant(sourceitem.getState());
            }
            return;
        }
        if ("freehandSelection".equals(itemname)) {
            for (int i = 0; i < this.theView.length; ++i) {
                ((TriMeshViewer)this.theView[i]).setFreehandSelection(sourceitem.getState());
            }
            return;
        }
        if ("displayAsQuads".equals(itemname)) {
            for (int i = 0; i < this.theView.length; ++i) {
                ((TriMeshViewer)this.theView[i]).setQuadMode(sourceitem.getState());
            }
            this.updateImage();
            return;
        }
        if ("detachSkeleton".equals(itemname)) {
            for (int i = 0; i < this.theView.length; ++i) {
                ((TriMeshViewer)this.theView[i]).setSkeletonDetached(sourceitem.getState());
            }
            return;
        }
        Object[] SMOOTHMETHODS = new String[]{"none", "shading", "interpolating", "approximating"};
        int i = Utilities.findIndexEqual(SMOOTHMETHODS, itemname);
        if (i > -1) {
            this.setSmoothingMethod(i);
            return;
        }
        super.itemStateChanged(e);
    }

    protected MeshEditorWindow createNewViewNewSelection() {
        TriMeshEditorWindow w = new TriMeshEditorWindow(this.parentWindow, this.getTitle(), this.objInConstructor, this.onClose, this.topology);
        return w;
    }

    public MeshViewer createMeshViewer(ObjectInfo obj, RowContainer p) {
        return new TriMeshViewer(obj, p);
    }

    public void initBaseSelectionHolder(ObjectInfo obj) {
        this.baseSelHolder = new MeshSelectionHolder(obj);
        TriangleMesh mesh = (TriangleMesh)obj.object;
        this.baseSelHolder.setSelection(new boolean[mesh.getVertices().length]);
        this.baseSelHolder.setSelectionMode(0);
        this.baseSelHolder.decRefCount();
        for (int i = 0; i < this.theView.length; ++i) {
            ((TriMeshViewer)this.theView[i]).setSelectionHolder(this.baseSelHolder);
        }
    }

    public BorderContainer createToolbarPanel() {
        return new BorderContainer();
    }

    public void selectAllCommand() {
        int i;
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        boolean[] selected = tmv.getSelection();
        for (i = 0; i < selected.length; ++i) {
            selected[i] = true;
        }
        if (tmv.getSelectionMode() == 1) {
            for (i = 0; i < selected.length; ++i) {
                if (!tmv.isEdgeHidden(i)) continue;
                selected[i] = false;
            }
        }
        ((TriMeshViewer)this.getCurrentView()).setSelection(selected);
        ((TriMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
    }

    public void hideSelectionCommand() {
        int i;
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        TriangleMesh theMesh = (TriangleMesh)tmv.getObject().object;
        boolean[] sel = tmv.getSelection();
        boolean[] hide = new boolean[theMesh.getFaces().length];
        if (tmv.getSelectionMode() == 2) {
            System.arraycopy(sel, 0, hide, 0, sel.length);
        } else if (tmv.getSelectionMode() == 1) {
            TriangleMesh.Edge[] edge = theMesh.getEdges();
            for (i = 0; i < sel.length; ++i) {
                if (!sel[i]) continue;
                hide[edge[i].f2] = true;
                hide[edge[i].f1] = true;
            }
        } else {
            TriangleMesh.Face[] face = theMesh.getFaces();
            for (i = 0; i < face.length; ++i) {
                hide[i] = sel[face[i].v1] || sel[face[i].v2] || sel[face[i].v3];
            }
        }
        boolean[] wasHidden = tmv.getHiddenFaces();
        if (wasHidden != null) {
            for (i = 0; i < wasHidden.length; ++i) {
                if (!wasHidden[i]) continue;
                hide[i] = true;
            }
        }
        tmv.setHiddenFaces(hide);
        for (i = 0; i < sel.length; ++i) {
            sel[i] = false;
        }
        tmv.setSelection(sel);
    }

    public void showAllCommand() {
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        tmv.setHiddenFaces(null);
    }

    public void selectBoundaryCommand() {
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        boolean[] selected = ((TriMeshViewer)this.getCurrentView()).getSelection();
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = edge[i].f2 == -1;
        }
        ((TriMeshViewer)this.getCurrentView()).setSelection(selected);
        ((TriMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
    }

    public void extendSelectionCommand() {
        int i;
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        int[] dist = tmv.getSelectionDistance();
        boolean[] selectedVert = new boolean[dist.length];
        boolean[] selected = tmv.getSelection();
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        for (i = 0; i < edge.length; ++i) {
            if (dist[edge[i].v1] != 0 && dist[edge[i].v2] != 0 || tmv.isEdgeHidden(i)) continue;
            selectedVert[edge[i].v2] = true;
            selectedVert[edge[i].v1] = true;
        }
        if (tmv.getSelectionMode() == 0) {
            ((TriMeshViewer)this.getCurrentView()).setSelection(selected);
            ((TriMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
        } else if (tmv.getSelectionMode() == 1) {
            for (i = 0; i < edge.length; ++i) {
                selected[i] = selectedVert[edge[i].v1] && selectedVert[edge[i].v2];
            }
            ((TriMeshViewer)this.getCurrentView()).setSelection(selected);
            ((TriMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
        } else {
            TriangleMesh.Face[] face = theMesh.getFaces();
            for (int i2 = 0; i2 < face.length; ++i2) {
                selected[i2] = selectedVert[face[i2].v1] && selectedVert[face[i2].v2] && selectedVert[face[i2].v3];
            }
            ((TriMeshViewer)this.getCurrentView()).setSelection(selected);
            ((TriMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
        }
    }

    public void deleteCommand() {
        BStandardDialog dlg;
        int i;
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        Object[] vert = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        Object[] face = theMesh.getFaces();
        boolean[] selected = tmv.getSelection();
        boolean[] deleteVert = new boolean[vert.length];
        boolean[] deleteEdge = new boolean[edge.length];
        boolean[] deleteFace = new boolean[face.length];
        if (tmv.getSelectionMode() == 0) {
            for (i = 0; i < deleteVert.length; ++i) {
                deleteVert[i] = selected[i];
            }
            for (i = 0; i < deleteEdge.length; ++i) {
                deleteEdge[i] = deleteVert[edge[i].v1] || deleteVert[edge[i].v2];
            }
            for (i = 0; i < deleteFace.length; ++i) {
                deleteFace[i] = deleteVert[face[i].v1] || deleteVert[face[i].v2] || deleteVert[face[i].v3];
            }
        } else if (tmv.getSelectionMode() == 1) {
            for (i = 0; i < deleteFace.length; ++i) {
                deleteFace[i] = selected[face[i].e1] || selected[face[i].e2] || selected[face[i].e3];
            }
            for (i = 0; i < deleteEdge.length; ++i) {
                deleteEdge[i] = deleteFace[edge[i].f1] && (edge[i].f2 == -1 || deleteFace[edge[i].f2]);
            }
            for (i = 0; i < deleteVert.length; ++i) {
                deleteVert[i] = vert[i].edges > 0;
            }
            for (i = 0; i < deleteFace.length; ++i) {
                if (deleteFace[i]) continue;
                deleteVert[face[i].v3] = false;
                deleteVert[face[i].v2] = false;
                deleteVert[face[i].v1] = false;
            }
        } else {
            for (i = 0; i < deleteFace.length; ++i) {
                deleteFace[i] = selected[i];
            }
            for (i = 0; i < deleteEdge.length; ++i) {
                deleteEdge[i] = deleteFace[edge[i].f1] && (edge[i].f2 == -1 || deleteFace[edge[i].f2]);
            }
            for (i = 0; i < deleteVert.length; ++i) {
                deleteVert[i] = vert[i].edges > 0;
            }
            for (i = 0; i < deleteFace.length; ++i) {
                if (deleteFace[i]) continue;
                deleteVert[face[i].v3] = false;
                deleteVert[face[i].v2] = false;
                deleteVert[face[i].v1] = false;
            }
        }
        int breaks = 0;
        for (int i2 = 0; i2 < vert.length; ++i2) {
            int[] e = theMesh.getEdgesForVertex(vert[i2]);
            if (e.length == 0) continue;
            int fprev = edge[e[0]].f1;
            breaks = 0;
            for (int j = 1; j < e.length; ++j) {
                int f;
                int n = f = edge[e[j]].f1 == fprev ? edge[e[j]].f2 : edge[e[j]].f1;
                if (f == -1) break;
                if (!deleteFace[fprev] && deleteFace[f]) {
                    ++breaks;
                }
                fprev = f;
            }
            if (!deleteFace[fprev] && (edge[e[0]].f2 == -1 || deleteFace[edge[e[0]].f1])) {
                ++breaks;
            }
            if (breaks > 1) break;
        }
        if (breaks > 1 && (dlg = new BStandardDialog("Illegal surface", new String[]{"Deleting the selection will", "result in an illegal surface."}, BStandardDialog.QUESTION)).showOptionDialog(this, new String[]{Translate.text("button.ok"), Translate.text("button.cancel")}, Translate.text("button.cancel")) == 1) {
            return;
        }
        DeleteMarkedItemsListOp vertDeleteOp = new DeleteMarkedItemsListOp(deleteVert);
        DeleteMarkedItemsListOp faceDeleteOp = new DeleteMarkedItemsListOp(deleteFace);
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])vertDeleteOp.apply(vert);
        TriangleMesh.Face[] f = (TriangleMesh.Face[])Utilities.deepArrayCopy((Copieable[])faceDeleteOp.apply(face));
        int[] newVertIndex = vertDeleteOp.getMappingOldToNew();
        for (int i3 = 0; i3 < f.length; ++i3) {
            f[i3].v1 = newVertIndex[f[i3].v1];
            f[i3].v2 = newVertIndex[f[i3].v2];
            f[i3].v3 = newVertIndex[f[i3].v3];
        }
        ParameterValue[] oldParamVal = theMesh.getParameterValues();
        ParameterValue[] newParamVal = new ParameterValue[oldParamVal.length];
        for (int i4 = 0; i4 < oldParamVal.length; ++i4) {
            Object oldval;
            if (oldParamVal[i4] instanceof VertexParameterValue) {
                oldval = ((VertexParameterValue)oldParamVal[i4]).getValue();
                newParamVal[i4] = new VertexParameterValue(vertDeleteOp.apply((double[])oldval));
                continue;
            }
            if (oldParamVal[i4] instanceof FaceParameterValue) {
                oldval = ((FaceParameterValue)oldParamVal[i4]).getValue();
                newParamVal[i4] = new FaceParameterValue(faceDeleteOp.apply((double[])oldval));
                continue;
            }
            if (oldParamVal[i4] instanceof FaceVertexParameterValue) {
                oldval = ((FaceVertexParameterValue)oldParamVal[i4]).getValue();
                double[][] newval = new double[3][];
                for (int j = 0; j < 3; ++j) {
                    newval[j] = faceDeleteOp.apply((double[])oldval[j]);
                }
                newParamVal[i4] = new FaceVertexParameterValue(newval);
                continue;
            }
            newParamVal[i4] = oldParamVal[i4].duplicate();
        }
        TriangleMesh newmesh = new TriangleMesh(v, f);
        TriangleMesh.Vertex[] newvert = (TriangleMesh.Vertex[])newmesh.getVertices();
        TriangleMesh.Edge[] newedge = newmesh.getEdges();
        newmesh.getSkeleton().copy(theMesh.getSkeleton());
        newmesh.copyTextureAndMaterial(theMesh);
        newmesh.setSmoothingMethod(theMesh.getSmoothingMethod());
        newmesh.setParameterValues(newParamVal);
        for (int i5 = 0; i5 < edge.length; ++i5) {
            int j = newmesh.findEdgeByVertexSet(newVertIndex[edge[i5].v1], newVertIndex[edge[i5].v2]);
            if (j < 0) continue;
            newedge[j].smoothness = edge[i5].smoothness;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.copyObject(newmesh);
        this.object3DChangedDuringEditor();
    }

    public void subdivideCommand() {
        int i;
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        TriangleMesh theMesh = (TriangleMesh)tmv.getObject().object;
        boolean[] selected = tmv.getSelection();
        if (tmv.getSelectionMode() != 1 && tmv.getSelectionMode() != 2) {
            return;
        }
        for (i = 0; !selected[i] && i < selected.length; ++i) {
        }
        if (i == selected.length) {
            return;
        }
        if (tmv.getSelectionMode() == 1) {
            i = theMesh.getVertices().length;
            TriangleMesh newmesh = TriangleMesh.subdivideEdges(theMesh, selected, Double.MAX_VALUE);
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
            theMesh.copyObject(newmesh);
            this.object3DChangedDuringEditor();
            TriangleMesh.Edge[] edges = newmesh.getEdges();
            boolean[] newselection = new boolean[edges.length];
            for (int j = 0; j < edges.length; ++j) {
                newselection[j] = edges[j].v1 >= i || edges[j].v2 >= i;
            }
            ((TriMeshViewer)this.getCurrentView()).setSelection(newselection);
            ((TriMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
        } else {
            i = theMesh.getVertices().length;
            TriangleMesh newmesh = TriangleMesh.subdivideFaces(theMesh, selected);
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
            theMesh.copyObject(newmesh);
            this.object3DChangedDuringEditor();
            TriangleMesh.Face[] faces = newmesh.getFaces();
            boolean[] newselection = new boolean[faces.length];
            for (int j = 0; j < faces.length; ++j) {
                newselection[j] = faces[j].v1 >= i || faces[j].v2 >= i || faces[j].v3 >= i;
            }
            ((TriMeshViewer)this.getCurrentView()).setSelection(newselection);
            ((TriMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
        }
    }

    public void simplifyCommand() {
        int i;
        boolean[] newSel;
        TriangleMesh.Edge[] e;
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        TriangleMesh theMesh = (TriangleMesh)tmv.getObject().object;
        boolean[] selection = tmv.getSelection();
        int selectionMode = tmv.getSelectionMode();
        ValueField errorField = new ValueField(0.01, 1);
        ComponentsDialog dlg = new ComponentsDialog(this, "Specify tolerance for simplified mesh:", new Widget[]{errorField}, new String[]{"Max Surface Error"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        if (selectionMode == 0) {
            e = theMesh.getEdges();
            newSel = new boolean[e.length];
            for (i = 0; i < e.length; ++i) {
                newSel[i] = selection[e[i].v1] && selection[e[i].v2];
            }
            selection = newSel;
        }
        if (selectionMode == 2) {
            e = theMesh.getEdges();
            newSel = new boolean[e.length];
            for (i = 0; i < e.length; ++i) {
                newSel[i] = selection[e[i].f1] || selection[e[i].f2];
            }
            selection = newSel;
        }
        for (i = 0; i < selection.length && !selection[i]; ++i) {
        }
        if (i == selection.length) {
            selection = new boolean[selection.length];
            for (i = 0; i < selection.length; ++i) {
                selection[i] = true;
            }
        }
        new TriMeshSimplifier(theMesh, selection, errorField.getValue(), this);
        this.object3DChangedDuringEditor();
    }

    public void optimizeCommand() {
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        MessageDialog dlg = new MessageDialog((WindowWidget)this, "Optimize mesh connectivity?  This will rearrange the mesh edges to produce a smoother surface.", new String[]{Translate.text("button.ok"), Translate.text("button.cancel")});
        if (dlg.getChoice() == 1) {
            return;
        }
        TriangleMesh theMesh = (TriangleMesh)tmv.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.copyObject(TriangleMesh.optimizeMesh(theMesh));
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setMesh(theMesh);
        }
        boolean[] selection = ((TriMeshViewer)this.getCurrentView()).getSelection();
        for (int i = 0; i < selection.length; ++i) {
            selection[i] = false;
        }
        ((TriMeshViewer)this.getCurrentView()).setSelection(selection);
        ((TriMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
        this.object3DChangedDuringEditor();
    }

    public void createFaceCommand() {
        boolean[] selection = ((TriMeshViewer)this.getCurrentView()).getSelection();
        int[] sel = Utilities.createIndexList(selection);
        if (sel.length != 3) {
            return;
        }
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        if (theMesh.addNewFace(sel[0], sel[1], sel[2]) == -1) {
            MessageDialog dlg = new MessageDialog((WindowWidget)this, new String[]{"An edge can't be adjacent to more than", "two faces. New face not created."}, new String[]{Translate.text("button.ok")});
            return;
        }
        this.object3DChangedDuringEditor();
    }

    public void repairGeometryCommand() {
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.repairGeometry();
        this.object3DChangedDuringEditor();
    }

    void bevelCommand() {
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        final TriangleMesh theMesh = (TriangleMesh)tmv.getObject().object;
        TriangleMesh.Face[] face = theMesh.getFaces();
        final boolean[] selection = tmv.getSelection();
        final ValueField heightField = new ValueField(0.0, 0);
        final ValueField widthField = new ValueField(0.0, 0);
        final ObjectPreviewCanvas preview = new ObjectPreviewCanvas(new ObjectInfo(theMesh, new CoordinateSystem(), ""));
        int selectionMode = tmv.getSelectionMode();
        final int[] bevelMode = selectionMode == 2 ? new int[]{1, 0} : (selectionMode == 0 ? new int[]{3, 3} : new int[]{2, 2});
        final BComboBox applyChoice = new BComboBox(new String[]{Translate.text("selectionAsWhole"), Translate.text("individualFaces")});
        applyChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                TriMeshBeveler beveler = new TriMeshBeveler(theMesh, selection, bevelMode[applyChoice.getSelectedIndex()]);
                double height = heightField.getValue();
                double width = widthField.getValue();
                preview.setObject(beveler.bevelMesh(height, width));
                preview.updateImage();
                preview.repaint();
            }
        });
        Object listener = new Object(){

            void processEvent() {
                TriMeshBeveler beveler = new TriMeshBeveler(theMesh, selection, bevelMode[applyChoice.getSelectedIndex()]);
                double height = heightField.getValue();
                double width = widthField.getValue();
                preview.setObject(beveler.bevelMesh(height, width));
                preview.updateImage();
                preview.repaint();
            }
        };
        heightField.addEventLink(ValueChangedEvent.class, listener);
        widthField.addEventLink(ValueChangedEvent.class, listener);
        preview.setPreferredSize(new Dimension(200, 200));
        ComponentsDialog dlg = selectionMode == 2 ? new ComponentsDialog(this, Translate.text("bevelFacesTitle"), new Widget[]{heightField, widthField, applyChoice, preview}, new String[]{Translate.text("extrudeHeight"), Translate.text("bevelWidth"), Translate.text("applyTo"), ""}) : (selectionMode == 0 ? new ComponentsDialog(this, Translate.text("bevelPointsTitle"), new Widget[]{heightField, widthField, preview}, new String[]{Translate.text("extrudeHeight"), Translate.text("bevelWidth"), ""}) : new ComponentsDialog(this, Translate.text("bevelEdgesTitle"), new Widget[]{heightField, widthField, preview}, new String[]{Translate.text("extrudeHeight"), Translate.text("bevelWidth"), ""}));
        if (!dlg.clickedOk()) {
            return;
        }
        double height = heightField.getValue();
        double width = widthField.getValue();
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        TriMeshBeveler beveler = new TriMeshBeveler(theMesh, selection, bevelMode[applyChoice.getSelectedIndex()]);
        theMesh.copyObject(beveler.bevelMesh(height, width));
        this.object3DChangedDuringEditor();
        tmv.setSelection(beveler.getNewSelection());
        tmv.informSelectionChanged(this, "object editor");
    }

    private boolean isBoundaryClosed(int[] edges) {
        if (edges.length < 3) {
            return false;
        }
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        TriangleMesh.Edge first = ed[edges[0]];
        TriangleMesh.Edge last = ed[edges[edges.length - 1]];
        return first.v1 == last.v1 || first.v1 == last.v2 || first.v2 == last.v1 || first.v2 == last.v2;
    }

    public void closeBoundaryCommand() {
        int i;
        int j;
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        Object[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        Object[] fc = theMesh.getFaces();
        int[][] boundary = ((TriMeshViewer)this.getCurrentView()).findSelectedBoundaries();
        AppendItemsListOp vertAppendOp = new AppendItemsListOp(boundary.length);
        AppendItemsListOp faceAppendOp = new AppendItemsListOp();
        for (int i2 = 0; i2 < boundary.length; ++i2) {
            TriangleMesh.Edge e;
            int k;
            if (boundary[i2].length < 2) continue;
            TriangleMesh.Edge ed0 = ed[boundary[i2][0]];
            TriangleMesh.Edge ed1 = ed[boundary[i2][1]];
            int j2 = ed0.v1 == ed1.v1 || ed0.v1 == ed1.v2 ? ed0.v2 : ed0.v1;
            Vec3 center = new Vec3();
            for (k = 0; k < boundary[i2].length; ++k) {
                center.add(((TriangleMesh.Vertex)vt[j2]).r);
                e = ed[boundary[i2][k]];
                j2 = e.v1 == j2 ? e.v2 : e.v1;
            }
            if (this.isBoundaryClosed(boundary[i2])) {
                center.scale(1.0 / (double)boundary[i2].length);
            } else {
                center.add(((TriangleMesh.Vertex)vt[j2]).r);
                center.scale(1.0 / (double)(boundary[i2].length + 1));
            }
            vertAppendOp.add(new TriangleMesh.Vertex(center));
            for (k = 0; k < boundary[i2].length; ++k) {
                e = ed[boundary[i2][k]];
                Object f = fc[e.f1];
                if (((TriangleMesh.Face)f).v1 == e.v1 && ((TriangleMesh.Face)f).v2 == e.v2 || ((TriangleMesh.Face)f).v2 == e.v1 && ((TriangleMesh.Face)f).v3 == e.v2 || ((TriangleMesh.Face)f).v3 == e.v1 && ((TriangleMesh.Face)f).v1 == e.v2) {
                    faceAppendOp.add(new TriangleMesh.Face(e.v2, e.v1, vt.length + i2));
                    continue;
                }
                faceAppendOp.add(new TriangleMesh.Face(e.v2, e.v1, vt.length + i2));
            }
        }
        TextureParameter[] param = theMesh.getParameters();
        ParameterValue[] oldParamVal = theMesh.getParameterValues();
        ParameterValue[] newParamVal = new ParameterValue[oldParamVal.length];
        for (int i3 = 0; i3 < oldParamVal.length; ++i3) {
            AppendDefaultItemListOp addop;
            Object oldval;
            double defvalue = param[i3].defaultVal;
            if (oldParamVal[i3] instanceof VertexParameterValue) {
                oldval = ((VertexParameterValue)oldParamVal[i3]).getValue();
                addop = new AppendDefaultItemListOp(defvalue, vertAppendOp.getAddSize());
                newParamVal[i3] = new VertexParameterValue(addop.apply((double[])oldval));
                continue;
            }
            if (oldParamVal[i3] instanceof FaceParameterValue) {
                oldval = ((FaceParameterValue)oldParamVal[i3]).getValue();
                addop = new AppendDefaultItemListOp(defvalue, faceAppendOp.getAddSize());
                newParamVal[i3] = new FaceParameterValue(addop.apply((double[])oldval));
                continue;
            }
            if (oldParamVal[i3] instanceof FaceVertexParameterValue) {
                oldval = ((FaceVertexParameterValue)oldParamVal[i3]).getValue();
                double[][] newval = new double[3][];
                AppendDefaultItemListOp addop2 = new AppendDefaultItemListOp(defvalue, faceAppendOp.getAddSize());
                for (j = 0; j < 3; ++j) {
                    newval[j] = addop2.apply((double[])oldval[j]);
                }
                newParamVal[i3] = new FaceVertexParameterValue(newval);
                continue;
            }
            newParamVal[i3] = oldParamVal[i3].duplicate();
        }
        TriangleMesh.Vertex[] newvert = (TriangleMesh.Vertex[])vertAppendOp.apply(vt);
        TriangleMesh.Face[] newface = (TriangleMesh.Face[])faceAppendOp.apply(fc);
        TriangleMesh newmesh = new TriangleMesh(newvert, newface);
        TriangleMesh.Vertex[] newvt = (TriangleMesh.Vertex[])newmesh.getVertices();
        TriangleMesh.Edge[] newed = newmesh.getEdges();
        newmesh.copyTextureAndMaterial(theMesh);
        newmesh.setSmoothingMethod(theMesh.getSmoothingMethod());
        newmesh.setParameterValues(newParamVal);
        for (i = 0; i < vt.length; ++i) {
            newvt[i].smoothness = ((TriangleMesh.Vertex)vt[i]).smoothness;
        }
        for (i = 0; i < newed.length; ++i) {
            if (newed[i].v1 >= vt.length || newed[i].v2 >= vt.length) continue;
            for (j = 0; j < ed.length; ++j) {
                if ((newed[i].v1 != ed[j].v1 || newed[i].v2 != ed[j].v2) && (newed[i].v1 != ed[j].v2 || newed[i].v2 != ed[j].v1)) continue;
                newed[i].smoothness = ed[j].smoothness;
            }
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.copyObject(newmesh);
        this.object3DChangedDuringEditor();
    }

    void joinBoundariesCommand() {
        int maxsteps;
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        final int[][] boundary = tmv.findSelectedBoundaries();
        if (boundary.length != 2) {
            return;
        }
        final int[][] boundaryVert = new int[2][];
        TriangleMesh theMesh = (TriangleMesh)tmv.getObject().object;
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        boolean closed = this.isBoundaryClosed(boundary[0]);
        if (closed != this.isBoundaryClosed(boundary[1])) {
            new BStandardDialog("", Translate.text("cannotJoinOpenAndClosed"), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        for (int j = 0; j < 2; ++j) {
            boundaryVert[j] = new int[boundary[j].length + (closed ? 0 : 1)];
            boundaryVert[j][0] = boundary[j].length == 1 || ed[boundary[j][0]].v1 == ed[boundary[j][1]].v1 || ed[boundary[j][0]].v1 == ed[boundary[j][1]].v2 ? ed[boundary[j][0]].v2 : ed[boundary[j][0]].v1;
            for (int i = 0; i < boundaryVert[j].length - 1; ++i) {
                TriangleMesh.Edge e = ed[boundary[j][i]];
                boundaryVert[j][i + 1] = e.v1 == boundaryVert[j][i] ? e.v2 : e.v1;
            }
        }
        double offset = 0.0;
        boolean reverse = false;
        int n = maxsteps = boundary[0].length > boundary[1].length ? boundary[0].length : boundary[1].length;
        if (closed) {
            double step0 = (double)boundary[0].length / (double)maxsteps;
            double step1 = (reverse ? -1.0 : 1.0) * (double)boundary[1].length / (double)maxsteps;
            double mindist = Double.MAX_VALUE;
            for (int i = 0; i < maxsteps - 1; ++i) {
                int i1;
                int i0;
                double p1;
                double p0;
                int j;
                double dist = 0.0;
                for (j = 0; j < maxsteps; ++j) {
                    p0 = (double)j * step0;
                    p1 = (double)(i + j) * step1;
                    i0 = ((int)Math.round(p0) + boundary[0].length) % boundary[0].length;
                    i1 = ((int)Math.round(p1) + boundary[1].length) % boundary[1].length;
                    dist += vt[boundaryVert[0][i0]].r.distance2(vt[boundaryVert[1][i1]].r);
                }
                if (dist < mindist) {
                    mindist = dist;
                    offset = (double)i * step1;
                    reverse = false;
                }
                dist = 0.0;
                for (j = 0; j < maxsteps; ++j) {
                    p0 = (double)j * step0;
                    p1 = (double)(i - j) * step1;
                    i0 = ((int)Math.round(p0) + boundary[0].length) % boundary[0].length;
                    i1 = ((int)Math.round(p1) + boundary[1].length) % boundary[1].length;
                    dist += vt[boundaryVert[0][i0]].r.distance2(vt[boundaryVert[1][i1]].r);
                }
                if (!(dist < mindist)) continue;
                mindist = dist;
                offset = (double)i * step1;
                reverse = true;
            }
        } else {
            double fdist = 0.0;
            double rdist = 0.0;
            double step0 = (double)boundary[0].length / (double)maxsteps;
            double step1 = (double)boundary[1].length / (double)maxsteps;
            int revStart = boundaryVert[1].length - 1;
            for (int i = 0; i < maxsteps; ++i) {
                int i0 = (int)Math.round((double)i * step0);
                int i1 = (int)Math.round((double)i * step1);
                fdist += vt[boundaryVert[0][i0]].r.distance2(vt[boundaryVert[1][i1]].r);
                rdist += vt[boundaryVert[0][i0]].r.distance2(vt[boundaryVert[1][revStart - i1]].r);
            }
            reverse = fdist > rdist;
        }
        final ValueSlider offsetSlider = new ValueSlider(-0.5 * (double)boundary[1].length, 0.5 * (double)boundary[1].length, 2 * maxsteps, 0.0);
        final BCheckBox reverseBox = new BCheckBox(Translate.text("reverseDirection"), false);
        final ObjectPreviewCanvas preview = new ObjectPreviewCanvas(new ObjectInfo(this.doJoinBoundaries(boundary, boundaryVert, offset, reverse), new CoordinateSystem(), ""));
        final double baseOffset = offset;
        final boolean baseReverse = reverse;
        FormContainer content = new FormContainer(new double[]{1.0}, new double[]{0.0, 0.0, 1.0});
        if (closed) {
            RowContainer row = new RowContainer();
            row.add(new BLabel(Translate.text("Offset") + ":"));
            row.add(offsetSlider);
            content.add(row, 0, 0);
        }
        content.add(reverseBox, 0, 1);
        content.add(preview, 0, 2, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        preview.setPreferredSize(new Dimension(200, 200));
        preview.setRenderMode(1);
        Object listener = new Object(){

            void processEvent() {
                preview.setObject(TriMeshEditorWindow.this.doJoinBoundaries(boundary, boundaryVert, baseOffset + offsetSlider.getValue(), baseReverse ^ reverseBox.getState()));
                preview.updateImage();
                preview.repaint();
            }
        };
        offsetSlider.addEventLink(ValueChangedEvent.class, listener);
        reverseBox.addEventLink(ValueChangedEvent.class, listener);
        PanelDialog dlg = new PanelDialog((WindowWidget)this, Translate.text("joinBoundardiesTitle"), content);
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.copyObject(preview.getObject().object);
        this.object3DChangedDuringEditor();
        tmv.updateImage();
    }

    TriangleMesh doJoinBoundaries(int[][] boundary, int[][] boundaryVert, double offset, boolean reverse) {
        int i;
        int i1prev;
        int i0prev;
        double p1;
        double p0;
        int maxsteps = boundary[0].length > boundary[1].length ? boundary[0].length : boundary[1].length;
        double step0 = (double)boundary[0].length / (double)maxsteps;
        double step1 = (reverse ? -1.0 : 1.0) * (double)boundary[1].length / (double)maxsteps;
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        Object[] fc = theMesh.getFaces();
        AppendItemsListOp faceAppendOp = new AppendItemsListOp(boundary[0].length + boundary[1].length);
        if (this.isBoundaryClosed(boundary[0])) {
            p0 = 0.0;
            p1 = offset;
            i0prev = 0;
            i1prev = ((int)Math.round(p1) + boundary[1].length) % boundary[1].length;
            for (int i2 = 1; i2 <= maxsteps; ++i2) {
                int v2;
                int v1;
                Object f;
                TriangleMesh.Edge e;
                p0 += step0;
                p1 += step1;
                while (p1 < 0.0) {
                    p1 += (double)boundary[1].length;
                }
                int i0 = (int)Math.round(p0) % boundary[0].length;
                int i1 = (int)Math.round(p1) % boundary[1].length;
                if (i0 != i0prev) {
                    e = ed[boundary[0][step0 > 0.0 ? i0prev : i0]];
                    f = fc[e.f1];
                    v1 = boundaryVert[0][i0prev];
                    v2 = boundaryVert[0][i0];
                    if (((TriangleMesh.Face)f).v1 == v1 && ((TriangleMesh.Face)f).v2 == v2 || ((TriangleMesh.Face)f).v2 == v1 && ((TriangleMesh.Face)f).v3 == v2 || ((TriangleMesh.Face)f).v3 == v1 && ((TriangleMesh.Face)f).v1 == v2) {
                        faceAppendOp.add(new TriangleMesh.Face(v2, v1, boundaryVert[1][i1prev]));
                    } else {
                        faceAppendOp.add(new TriangleMesh.Face(v1, v2, boundaryVert[1][i1prev]));
                    }
                }
                if (i1 != i1prev) {
                    e = ed[boundary[1][step1 > 0.0 ? i1prev : i1]];
                    f = fc[e.f1];
                    v1 = boundaryVert[1][i1prev];
                    v2 = boundaryVert[1][i1];
                    if (((TriangleMesh.Face)f).v1 == v1 && ((TriangleMesh.Face)f).v2 == v2 || ((TriangleMesh.Face)f).v2 == v1 && ((TriangleMesh.Face)f).v3 == v2 || ((TriangleMesh.Face)f).v3 == v1 && ((TriangleMesh.Face)f).v1 == v2) {
                        faceAppendOp.add(new TriangleMesh.Face(v2, v1, boundaryVert[0][i0]));
                    } else {
                        faceAppendOp.add(new TriangleMesh.Face(v1, v2, boundaryVert[0][i0]));
                    }
                }
                i0prev = i0;
                i1prev = i1;
            }
        } else {
            p0 = 0.0;
            p1 = reverse ? (double)boundary[1].length : 0.0;
            i0prev = 0;
            i1prev = (int)Math.round(p1);
            while (faceAppendOp.getAddSize() < fc.length + boundary[0].length + boundary[1].length) {
                int v2;
                int v1;
                Object f;
                TriangleMesh.Edge e;
                int i0 = (int)Math.round(p0 += step0);
                int i1 = (int)Math.round(p1 += step1);
                if (i0 < 0) {
                    i0 = 0;
                }
                if (i1 < 0) {
                    i1 = 0;
                }
                if (i0 > boundary[0].length) {
                    i0 = boundary[0].length;
                }
                if (i1 > boundary[1].length) {
                    i1 = boundary[1].length;
                }
                if (i0 != i0prev) {
                    e = ed[boundary[0][i0prev < i0 ? i0prev : i0]];
                    f = fc[e.f1];
                    v1 = boundaryVert[0][i0prev];
                    v2 = boundaryVert[0][i0];
                    if (((TriangleMesh.Face)f).v1 == v1 && ((TriangleMesh.Face)f).v2 == v2 || ((TriangleMesh.Face)f).v2 == v1 && ((TriangleMesh.Face)f).v3 == v2 || ((TriangleMesh.Face)f).v3 == v1 && ((TriangleMesh.Face)f).v1 == v2) {
                        faceAppendOp.add(new TriangleMesh.Face(v2, v1, boundaryVert[1][i1prev]));
                    } else {
                        faceAppendOp.add(new TriangleMesh.Face(v1, v2, boundaryVert[1][i1prev]));
                    }
                }
                if (i1 != i1prev) {
                    e = ed[boundary[1][i1prev < i1 ? i1prev : i1]];
                    f = fc[e.f1];
                    v1 = boundaryVert[1][i1prev];
                    v2 = boundaryVert[1][i1];
                    if (((TriangleMesh.Face)f).v1 == v1 && ((TriangleMesh.Face)f).v2 == v2 || ((TriangleMesh.Face)f).v2 == v1 && ((TriangleMesh.Face)f).v3 == v2 || ((TriangleMesh.Face)f).v3 == v1 && ((TriangleMesh.Face)f).v1 == v2) {
                        faceAppendOp.add(new TriangleMesh.Face(v2, v1, boundaryVert[0][i0]));
                    } else {
                        faceAppendOp.add(new TriangleMesh.Face(v1, v2, boundaryVert[0][i0]));
                    }
                }
                i0prev = i0;
                i1prev = i1;
            }
        }
        TextureParameter[] param = theMesh.getParameters();
        ParameterValue[] oldParamVal = theMesh.getParameterValues();
        ParameterValue[] newParamVal = new ParameterValue[oldParamVal.length];
        for (int i3 = 0; i3 < oldParamVal.length; ++i3) {
            double defvalue = param[i3].defaultVal;
            if (oldParamVal[i3] instanceof FaceParameterValue) {
                double[] oldval = ((FaceParameterValue)oldParamVal[i3]).getValue();
                AppendDefaultItemListOp addop = new AppendDefaultItemListOp(defvalue, faceAppendOp.getAddSize());
                newParamVal[i3] = new FaceParameterValue(addop.apply(oldval));
                continue;
            }
            if (oldParamVal[i3] instanceof FaceVertexParameterValue) {
                double[][] oldval = ((FaceVertexParameterValue)oldParamVal[i3]).getValue();
                double[][] newval = new double[3][];
                AppendDefaultItemListOp addop = new AppendDefaultItemListOp(defvalue, faceAppendOp.getAddSize());
                for (int j = 0; j < 3; ++j) {
                    newval[j] = addop.apply(oldval[j]);
                }
                newParamVal[i3] = new FaceVertexParameterValue(newval);
                continue;
            }
            newParamVal[i3] = oldParamVal[i3].duplicate();
        }
        TriangleMesh.Face[] newface = (TriangleMesh.Face[])faceAppendOp.apply(fc);
        TriangleMesh newmesh = new TriangleMesh(vt, newface);
        TriangleMesh.Vertex[] newvt = (TriangleMesh.Vertex[])newmesh.getVertices();
        TriangleMesh.Edge[] newed = newmesh.getEdges();
        newmesh.copyTextureAndMaterial(theMesh);
        newmesh.setSmoothingMethod(theMesh.getSmoothingMethod());
        newmesh.setParameterValues(newParamVal);
        for (i = 0; i < vt.length; ++i) {
            newvt[i].smoothness = vt[i].smoothness;
        }
        for (i = 0; i < newed.length; ++i) {
            if (newed[i].v1 >= vt.length || newed[i].v2 >= vt.length) continue;
            for (int j = 0; j < ed.length; ++j) {
                if ((newed[i].v1 != ed[j].v1 || newed[i].v2 != ed[j].v2) && (newed[i].v1 != ed[j].v2 || newed[i].v2 != ed[j].v1)) continue;
                newed[i].smoothness = ed[j].smoothness;
            }
        }
        return newmesh;
    }

    public void extractCurveCommand() {
        Widget parent;
        int smoothingMethod;
        TriangleMesh.Edge first;
        int i;
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        boolean[] selected = ((TriMeshViewer)this.getCurrentView()).getSelection();
        Vector<TriangleMesh.Edge> edges = new Vector<TriangleMesh.Edge>();
        if (((TriMeshViewer)this.getCurrentView()).getSelectionMode() != 1) {
            return;
        }
        for (i = 0; i < selected.length; ++i) {
            if (!selected[i]) continue;
            edges.addElement(ed[i]);
        }
        if (edges.size() == 0) {
            return;
        }
        TriangleMesh.Edge last = first = (TriangleMesh.Edge)edges.elementAt(0);
        Vector<TriangleMesh.Edge> ordered = new Vector<TriangleMesh.Edge>();
        ordered.addElement(first);
        edges.removeElementAt(0);
        while (edges.size() > 0) {
            for (i = 0; i < edges.size(); ++i) {
                TriangleMesh.Edge e = (TriangleMesh.Edge)edges.elementAt(i);
                if (e.v1 == first.v1 || e.v2 == first.v1 || e.v1 == first.v2 || e.v2 == first.v2) {
                    ordered.insertElementAt(e, 0);
                    first = e;
                    break;
                }
                if (e.v1 != last.v1 && e.v2 != last.v1 && e.v1 != last.v2 && e.v2 != last.v2) continue;
                ordered.addElement(e);
                last = e;
                break;
            }
            if (i == edges.size()) {
                new BStandardDialog("", Translate.text("edgesNotContinuous"), BStandardDialog.ERROR).showMessageDialog(this);
                return;
            }
            edges.removeElementAt(i);
        }
        boolean closed = ordered.size() > 2 && (last.v1 == first.v1 || last.v2 == first.v1 || last.v1 == first.v2 || last.v2 == first.v2);
        Vec3[] v = new Vec3[closed ? ordered.size() : ordered.size() + 1];
        float[] smoothness = new float[v.length];
        TriangleMesh.Edge second = ordered.size() == 1 ? first : (TriangleMesh.Edge)ordered.elementAt(1);
        int prev = first.v1 == second.v1 || first.v1 == second.v2 ? first.v2 : first.v1;
        for (i = 0; i < ordered.size(); ++i) {
            TriangleMesh.Edge e = (TriangleMesh.Edge)ordered.elementAt(i);
            v[i] = new Vec3(vt[prev].r);
            smoothness[i] = vt[prev].smoothness;
            prev = e.v1 == prev ? e.v2 : e.v1;
        }
        if (!closed) {
            v[i] = new Vec3(vt[prev].r);
            smoothness[i] = vt[prev].smoothness;
        }
        if ((smoothingMethod = theMesh.getSmoothingMethod()) == 1) {
            smoothingMethod = 0;
        }
        Curve cv = new Curve(v, smoothness, smoothingMethod, closed);
        for (parent = (Widget)((Object)this.parentWindow); parent != null && !(parent instanceof LayoutWindow); parent = parent.getParent()) {
        }
        if (parent != null) {
            ((LayoutWindow)parent).addObject(cv, this.getCurrentView().thisObjectInScene.coords.duplicate(), "Extracted Curve", null);
            ((LayoutWindow)parent).updateImage();
        }
    }

    public void setSmoothnessCommand() {
        int i;
        final TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        TriangleMesh oldMesh = (TriangleMesh)theMesh.duplicate();
        final TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        final TriangleMesh.Edge[] ed = theMesh.getEdges();
        final boolean[] selected = ((TriMeshViewer)this.getCurrentView()).getSelection();
        final boolean pointmode = ((TriMeshViewer)this.getCurrentView()).getSelectionMode() == 0;
        final ActionProcessor processor = new ActionProcessor();
        for (i = 0; i < selected.length && !selected[i]; ++i) {
        }
        if (i == selected.length) {
            return;
        }
        float value = pointmode ? vt[i].smoothness : ed[i].smoothness;
        value = 0.001f * (float)Math.round(value * 1000.0f);
        final ValueSlider smoothness = new ValueSlider(0.0, 1.0, 100, value);
        smoothness.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                processor.addEvent(new Runnable(){

                    public void run() {
                        float s = (float)smoothness.getValue();
                        for (int i = 0; i < selected.length; ++i) {
                            if (!selected[i]) continue;
                            if (pointmode) {
                                (this).vt[i].smoothness = s;
                                continue;
                            }
                            (this).ed[i].smoothness = s;
                        }
                        theMesh.setSmoothingMethod(theMesh.getSmoothingMethod());
                        (this).TriMeshEditorWindow.this.getCurrentView().getObject().object.informChanged(this, "object editor drag");
                        TriMeshEditorWindow.this.getCurrentView().objectChanged();
                        TriMeshEditorWindow.this.getCurrentView().updateImage();
                        TriMeshEditorWindow.this.getCurrentView().repaint();
                    }
                });
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text(pointmode ? "setPointSmoothness" : "setEdgeSmoothness"), new Widget[]{smoothness}, new String[]{Translate.text("Smoothness")});
        processor.stopProcessing();
        if (dlg.clickedOk()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, oldMesh}));
            this.object3DChangedDuringEditor();
        } else {
            theMesh.copyObject(oldMesh);
            this.object3DChangedDuringEditor();
            for (i = 0; i < this.theView.length; ++i) {
                this.theView[i].updateImage();
                this.theView[i].repaint();
            }
        }
    }

    public void reverseNormalsCommand() {
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.reverseNormals();
        this.object3DChangedDuringEditor();
    }

    void setSmoothingMethod(int method) {
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        this.updateMenus();
        theMesh.setSmoothingMethod(method);
        this.object3DChangedDuringEditor();
    }

    public void adjustDeltas(Vec3[] delta) {
        int i;
        int[] dist = this.getCurrentView().getSelectionDistance();
        int[] count = new int[delta.length];
        TriangleMesh theMesh = (TriangleMesh)this.getCurrentView().getObject().object;
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        int maxDistance = TriMeshEditorWindow.getTensionDistance();
        double tension = TriMeshEditorWindow.getMeshTension();
        double[] scale = new double[maxDistance + 1];
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] == 0) continue;
            delta[i].set(0.0, 0.0, 0.0);
        }
        for (i = 0; i < maxDistance; ++i) {
            int j;
            for (j = 0; j < count.length; ++j) {
                count[j] = 0;
            }
            for (j = 0; j < edge.length; ++j) {
                if (dist[edge[j].v1] == i && dist[edge[j].v2] == i + 1) {
                    int n = edge[j].v2;
                    count[n] = count[n] + 1;
                    delta[edge[j].v2].add(delta[edge[j].v1]);
                    continue;
                }
                if (dist[edge[j].v2] != i || dist[edge[j].v1] != i + 1) continue;
                int n = edge[j].v1;
                count[n] = count[n] + 1;
                delta[edge[j].v1].add(delta[edge[j].v2]);
            }
            for (j = 0; j < count.length; ++j) {
                if (count[j] <= 1) continue;
                delta[j].scale(1.0 / (double)count[j]);
            }
        }
        for (i = 0; i < scale.length; ++i) {
            scale[i] = Math.pow(((double)(maxDistance - i) + 1.0) / ((double)maxDistance + 1.0), tension);
        }
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] <= 0) continue;
            delta[i].scale(scale[dist[i]]);
        }
    }

    public void setParametersCommand() {
        PanelDialog dlg;
        FormContainer content;
        int k;
        int i;
        int j;
        TriMeshViewer tmv = (TriMeshViewer)this.getCurrentView();
        int selectionMode = tmv.getSelectionMode();
        if (selectionMode == 1) {
            return;
        }
        if (selectionMode == 0) {
            super.setParametersCommand();
            return;
        }
        TriangleMesh theMesh = (TriangleMesh)tmv.getObject().object;
        MeshVertex[] vert = theMesh.getVertices();
        ObjectInfo info = tmv.getObject();
        TextureParameter[] param = info.object.getParameters();
        ParameterValue[] paramValue = info.object.getParameterValues();
        int[] paramIndex = null;
        boolean[] selected = tmv.getSelection();
        for (j = 0; j < selected.length && !selected[j]; ++j) {
        }
        if (j == selected.length) {
            return;
        }
        if (param != null) {
            int num = 0;
            for (i = 0; i < param.length; ++i) {
                if (!(paramValue[i] instanceof FaceParameterValue) && !(paramValue[i] instanceof FaceVertexParameterValue) || param[i] == tmv.getExtraParameter()) continue;
                ++num;
            }
            paramIndex = new int[num];
            i = 0;
            for (k = 0; k < param.length; ++k) {
                if (!(paramValue[k] instanceof FaceParameterValue) && !(paramValue[k] instanceof FaceVertexParameterValue) || param[i] == tmv.getExtraParameter()) continue;
                paramIndex[i++] = k;
            }
        }
        if (paramIndex == null || paramIndex.length == 0) {
            new BStandardDialog("", Translate.text("noPerFaceParams"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        double[][] value = new double[paramIndex.length][];
        for (i = 0; i < paramIndex.length; ++i) {
            Object currentVal;
            if (paramValue[paramIndex[i]] instanceof FaceParameterValue) {
                currentVal = ((FaceParameterValue)paramValue[paramIndex[i]]).getValue();
                double commonVal = currentVal[j];
                for (k = j; k < selected.length; ++k) {
                    if (!selected[k] || currentVal[k] == commonVal) continue;
                    commonVal = Double.NaN;
                }
                value[i] = new double[]{commonVal};
                continue;
            }
            currentVal = ((FaceVertexParameterValue)paramValue[paramIndex[i]]).getValue();
            double[] commonVal = new double[]{currentVal[0][j], currentVal[1][j], currentVal[2][j]};
            for (k = j; k < selected.length; ++k) {
                if (!selected[k]) continue;
                if (currentVal[0][k] != commonVal[0]) {
                    commonVal[0] = Double.NaN;
                }
                if (currentVal[1][k] != commonVal[1]) {
                    commonVal[1] = Double.NaN;
                }
                if (currentVal[2][k] == commonVal[2]) continue;
                commonVal[2] = Double.NaN;
            }
            value[i] = commonVal;
        }
        Widget[][] editWidget = new Widget[paramIndex.length][3];
        LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 10, 0, 5), null);
        if (info.object.getTexture() instanceof LayeredTexture) {
            LayeredMapping map = (LayeredMapping)info.object.getTextureMapping();
            Texture[] layer = map.getLayers();
            content = new FormContainer(2, paramIndex.length + layer.length * 3);
            content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
            int line = 0;
            for (k = 0; k < layer.length; ++k) {
                content.add(new BLabel(Translate.text("layerLabel", Integer.toString(k + 1), layer[k].getName())), 0, line++, 2, 1);
                TextureParameter[] layerParam = map.getLayerParameters(k);
                boolean any = false;
                for (i = 0; i < paramIndex.length; ++i) {
                    int m;
                    TextureParameter pm = param[paramIndex[i]];
                    for (m = 0; m < layerParam.length && !layerParam[m].equals(pm); ++m) {
                    }
                    if (m == layerParam.length) continue;
                    any = true;
                    for (m = 0; m < value[i].length; ++m) {
                        editWidget[i][m] = pm.getEditingWidget(value[i][m]);
                        content.add(new BLabel(m == 0 ? pm.name : ""), 0, line, leftLayout);
                        content.add(editWidget[i][m], 1, line++);
                    }
                }
                if (any) continue;
                content.add(Translate.label("noLayerPerFaceParams"), 0, line++, 2, 1, new LayoutInfo());
            }
        } else {
            content = new FormContainer(2, paramIndex.length + 1);
            content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
            content.add(new BLabel(Translate.text("Texture") + ": " + info.object.getTexture().getName()), 0, 0);
            for (i = 0; i < paramIndex.length; ++i) {
                TextureParameter pm = param[paramIndex[i]];
                editWidget[i][0] = pm.getEditingWidget(value[i][0]);
                content.add(new BLabel(pm.name), 0, i + 1, leftLayout);
                content.add(editWidget[i][0], 1, i + 1);
            }
        }
        if (!(dlg = new PanelDialog((WindowWidget)this, Translate.text("texParamsForSelectedFaces"), content)).clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        for (j = 0; j < editWidget.length; ++j) {
            if (paramValue[paramIndex[j]] instanceof FaceParameterValue) {
                double d = editWidget[j][0] instanceof ValueField ? ((ValueField)editWidget[j][0]).getValue() : ((ValueSlider)editWidget[j][0]).getValue();
                if (Double.isNaN(d)) continue;
                double[] val = ((FaceParameterValue)paramValue[paramIndex[j]]).getValue();
                for (i = 0; i < selected.length; ++i) {
                    if (!selected[i]) continue;
                    val[i] = d;
                }
                ((FaceParameterValue)paramValue[paramIndex[j]]).setValue(val);
                continue;
            }
            double[] d = editWidget[j][0] instanceof ValueField ? new double[]{((ValueField)editWidget[j][0]).getValue(), ((ValueField)editWidget[j][1]).getValue(), ((ValueField)editWidget[j][2]).getValue()} : new double[]{((ValueSlider)editWidget[j][0]).getValue(), ((ValueSlider)editWidget[j][1]).getValue(), ((ValueSlider)editWidget[j][2]).getValue()};
            double[][] val = ((FaceVertexParameterValue)paramValue[paramIndex[j]]).getValue();
            for (i = 0; i < selected.length; ++i) {
                if (!selected[i]) continue;
                for (int m = 0; m < 3; ++m) {
                    if (Double.isNaN(d[m])) continue;
                    val[m][i] = d[m];
                }
            }
            ((FaceVertexParameterValue)paramValue[paramIndex[j]]).setValue(val);
        }
    }
}

