/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.KeyPressedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Insets;
import java.util.Iterator;

public class TransformPointsDialog
extends BDialog {
    private double[] finalValues;
    private ValueField[] fields = new ValueField[9];
    private BComboBox centerChoice;

    public TransformPointsDialog(BFrame parent) {
        super(parent, Translate.text("transformPoints"), true);
        this.layoutDialog();
        this.pack();
        this.setResizable(false);
        UIUtilities.centerWindow(this);
        this.fields[0].requestFocus();
        this.setVisible(true);
    }

    public double[] getValues() {
        return this.finalValues;
    }

    public boolean useSelectionCenter() {
        return this.centerChoice.getSelectedIndex() == 0;
    }

    private void layoutDialog() {
        FormContainer content = new FormContainer(4, 6);
        this.setContent(content);
        LayoutInfo eastLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        content.add(Translate.label("Move"), 0, 1, eastLayout);
        content.add(Translate.label("Rotate"), 0, 2, eastLayout);
        content.add(Translate.label("Scale"), 0, 3, eastLayout);
        content.add(new BLabel("X"), 1, 0);
        content.add(new BLabel("Y"), 2, 0);
        content.add(new BLabel("Z"), 3, 0);
        for (int i = 0; i < 9; ++i) {
            this.fields[i] = new ValueField(Double.NaN, 0);
            content.add(this.fields[i], i % 3 + 1, i / 3 + 1);
        }
        RowContainer row = new RowContainer();
        content.add(row, 0, 4, 4, 1);
        row.add(Translate.label("transformAround"));
        this.centerChoice = new BComboBox(new String[]{Translate.text("centerOfSelection"), Translate.text("objectOrigin")});
        row.add(this.centerChoice);
        RowContainer buttons = new RowContainer();
        content.add(buttons, 0, 5, 4, 1);
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "dispose"));
        this.addEventLink(WindowClosingEvent.class, (Object)this, "dispose");
        this.addAsListener(this);
    }

    private void doOk() {
        this.finalValues = new double[9];
        for (int i = 0; i < this.finalValues.length; ++i) {
            this.finalValues[i] = this.fields[i].getValue();
            if (!Double.isNaN(this.finalValues[i])) continue;
            this.finalValues[i] = i < 6 ? 0.0 : 1.0;
        }
        this.dispose();
    }

    private void keyPressed(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        if (code == 10) {
            this.doOk();
        }
        if (code == 27) {
            this.dispose();
        }
    }

    private void addAsListener(Widget w) {
        w.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        if (w instanceof WidgetContainer) {
            Iterator iter = ((WidgetContainer)w).getChildren();
            while (iter.hasNext()) {
                this.addAsListener((Widget)iter.next());
            }
        }
    }
}

