/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Image;
import java.awt.Point;
import java.text.NumberFormat;

public class ThickenMeshTool
extends EditingTool {
    private Point clickPoint;
    private Vec3[] norm;
    private Vec3[] baseVertPos;
    private UndoRecord undo;
    private static Image icon;
    private static Image selectedIcon;

    public ThickenMeshTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("outsetPoints.gif");
        selectedIcon = this.loadImage("selected/outsetPoints.gif");
    }

    public void activate() {
        super.activate();
        MeshViewer view = ((MeshEditorWindow)this.theFrame).getCurrentView();
        int[] selected = view.getSelectionDistance();
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] != 0) continue;
            this.theWindow.setHelpText(Translate.text("thickenMeshTool.helpText"));
            return;
        }
        this.theWindow.setHelpText(Translate.text("thickenMeshTool.errorText"));
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("thickenMeshTool.tipText");
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        this.clickPoint = e.getPoint();
        this.norm = mesh.getNormals();
        this.baseVertPos = mesh.getVertexPositions();
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int size = 5;
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        double distance = 0.01 * (double)(this.clickPoint.y - dragPoint.y);
        Vec3[] v = this.findNewPositions(mesh, this.baseVertPos, (MeshViewer)view, distance);
        mesh.setVertexPositions(v);
        ((ObjectViewer)view).objectChanged();
        this.theWindow.updateImage();
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        if (distance < 0.0) {
            this.theWindow.setHelpText(Translate.text("thickenMeshTool.dragText.inward", format.format(-distance)));
        } else {
            this.theWindow.setHelpText(Translate.text("thickenMeshTool.dragText.outward", format.format(distance)));
        }
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Object3D meshobj = ((MeshViewer)view).getObject().object;
        Mesh mesh = (Mesh)((Object)meshobj);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
            double distance = 0.01 * (double)(this.clickPoint.y - dragPoint.y);
            Vec3[] v = this.findNewPositions(mesh, this.baseVertPos, (MeshViewer)view, distance);
            mesh.setVertexPositions(v);
        }
        meshobj.informChanged(this, "object editor");
        this.theWindow.setHelpText(Translate.text("thickenMeshTool.helpText"));
        this.norm = null;
        this.undo = null;
        this.baseVertPos = null;
    }

    Vec3[] findNewPositions(Mesh mesh, Vec3[] vert, MeshViewer view, double distance) {
        int i;
        Vec3[] v = new Vec3[vert.length];
        int[] selected = view.getSelectionDistance();
        for (i = 0; i < v.length; ++i) {
            v[i] = selected[i] == 0 ? this.norm[i].times(distance) : new Vec3();
        }
        ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        for (i = 0; i < vert.length; ++i) {
            v[i].add(vert[i]);
        }
        return v;
    }
}

