/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayoutWindow;
import artofillusion.ListChangeListener;
import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.texture.Texture;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.CommandEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.WidgetEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BList;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.BorderContainer;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Method;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class TexturesDialog
extends BDialog
implements ListChangeListener {
    private Scene theScene;
    private BFrame parent;
    private BList texList;
    private BButton[] b;

    public TexturesDialog(BFrame fr, Scene sc) {
        super(fr, Translate.text("texturesTitle"), false);
        this.parent = fr;
        this.theScene = sc;
        BorderContainer content = new BorderContainer();
        this.setContent(BOutline.createEmptyBorder(content, ModellingApp.standardDialogInsets));
        ColumnContainer buttons = new ColumnContainer();
        buttons.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, null, null));
        content.add(buttons, BorderContainer.WEST);
        this.b = new BButton[6];
        this.b[0] = Translate.button("new", "...", this, "doNew");
        buttons.add(this.b[0]);
        this.b[1] = Translate.button("copy", "...", this, "doCopy");
        buttons.add(this.b[1]);
        this.b[2] = Translate.button("delete", "...", this, "doDelete");
        buttons.add(this.b[2]);
        this.b[3] = Translate.button("import", "...", this, "doImport");
        buttons.add(this.b[3]);
        this.b[4] = Translate.button("edit", "...", this, "doEdit");
        buttons.add(this.b[4]);
        this.b[5] = Translate.button("close", this, "dispose");
        buttons.add(this.b[5]);
        this.texList = new BList();
        this.texList.setMultipleSelectionEnabled(false);
        content.add(UIUtilities.createScrollingList(this.texList), BorderContainer.CENTER);
        for (int i = 0; i < this.theScene.getNumTextures(); ++i) {
            this.texList.add(this.theScene.getTexture(i).getName());
        }
        this.texList.addEventLink(SelectionChangedEvent.class, (Object)this, "hilightButtons");
        this.texList.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        sc.addTextureListener(this);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "dispose");
        this.hilightButtons();
        this.pack();
        UIUtilities.centerWindow(this);
    }

    public void dispose() {
        this.theScene.removeTextureListener(this);
        super.dispose();
    }

    private void hilightButtons() {
        boolean selection = this.texList.getSelectedIndex() != -1;
        this.b[1].setEnabled(selection);
        this.b[2].setEnabled(selection);
        this.b[4].setEnabled(selection);
    }

    private void mouseClicked(MouseClickedEvent ev) {
        if (ev.getClickCount() == 2 && this.texList.getSelectedIndex() != -1) {
            this.doEdit();
        }
    }

    private void doNew() {
        TexturesDialog.showNewTextureWindow(this, this.theScene);
    }

    private void doCopy() {
        String name = new BStandardDialog("", Translate.text("newTexName"), BStandardDialog.PLAIN).showInputDialog(this, null, "");
        if (name == null) {
            return;
        }
        Texture tex = this.theScene.getTexture(this.texList.getSelectedIndex()).duplicate();
        tex.setName(name);
        this.theScene.addTexture(tex);
    }

    private void doDelete() {
        int selected = this.texList.getSelectedIndex();
        Texture tex = this.theScene.getTexture(selected);
        String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
        int choice = new BStandardDialog("", Translate.text("deleteTexture", tex.getName()), BStandardDialog.PLAIN).showOptionDialog(this, options, options[1]);
        if (choice == 0) {
            this.theScene.removeTexture(selected);
        }
    }

    private void doEdit() {
        int selected = this.texList.getSelectedIndex();
        this.setCursor(Cursor.getPredefinedCursor(3));
        Texture tex = this.theScene.getTexture(selected);
        tex.edit(this.parent, this.theScene);
        tex.assignNewID();
        this.theScene.changeTexture(selected);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemAdded(int index, Object obj) {
        Texture tex = (Texture)obj;
        this.texList.add(index, tex.getName());
        this.texList.setSelected(this.texList.getSelectedIndex(), false);
        this.texList.setSelected(index, true);
        this.hilightButtons();
        if (this.parent instanceof LayoutWindow) {
            ((LayoutWindow)this.parent).setModified();
            ((LayoutWindow)this.parent).updateImage();
        }
    }

    public void itemRemoved(int index, Object obj) {
        this.texList.removeAll();
        for (int j = 0; j < this.theScene.getNumTextures(); ++j) {
            this.texList.add(this.theScene.getTexture(j).getName());
        }
        this.hilightButtons();
        if (this.parent instanceof LayoutWindow) {
            ((LayoutWindow)this.parent).setModified();
            ((LayoutWindow)this.parent).updateImage();
        }
    }

    public void itemChanged(int index, Object obj) {
        Texture tex = (Texture)obj;
        this.texList.replace(index, tex.getName());
        this.texList.setSelected(index, true);
        if (this.parent instanceof LayoutWindow) {
            ((LayoutWindow)this.parent).setModified();
            ((LayoutWindow)this.parent).updateImage();
        }
    }

    public static void showNewTextureWindow(BDialog parent, Scene theScene) {
        int j;
        parent.setCursor(Cursor.getPredefinedCursor(3));
        BTextField nameField = new BTextField();
        BComboBox typeChoice = new BComboBox();
        Class[] types = ModellingApp.getTextureTypes();
        for (j = 0; j < types.length; ++j) {
            try {
                Method mtd = types[j].getMethod("getTypeName", null);
                typeChoice.add((String)mtd.invoke(null, null));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        j = 0;
        int k = -1;
        String name = "";
        while (theScene.getTexture(name = "Untitled " + ++j) != null) {
        }
        nameField.setText(name);
        nameField.setSelectionStart(0);
        nameField.setSelectionEnd(name.length());
        ComponentsDialog dlg = new ComponentsDialog(parent, Translate.text("newTexNameAndType"), new Widget[]{nameField, typeChoice}, new String[]{Translate.text("Name"), Translate.text("Type")});
        if (dlg.clickedOk()) {
            WidgetContainer frame = parent;
            while (!(frame instanceof BFrame)) {
                frame = frame.getParent();
            }
            try {
                Texture tex = (Texture)types[typeChoice.getSelectedIndex()].newInstance();
                tex.setName(nameField.getText());
                theScene.addTexture(tex);
                tex.edit((BFrame)frame, theScene);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        parent.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doImport() {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("importTextures"));
        if (!fc.showDialog(this)) {
            return;
        }
        File f = fc.getSelectedFile();
        FilterInputStream in = null;
        Scene sc = null;
        in = new DataInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
        sc = new Scene((DataInputStream)in, false);
        try {
            in.close();
        }
        catch (Exception ex) {
            new BStandardDialog("", new String[]{Translate.text("errorLoadingFile"), ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        catch (InvalidObjectException ex) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("errorLoadingWholeScene")), BStandardDialog.ERROR).showMessageDialog(this);
            try {
                in.close();
            }
            catch (Exception ex2) {
                new BStandardDialog("", new String[]{Translate.text("errorLoadingFile"), ex2.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
                return;
            }
            return;
        }
        catch (IOException ex2) {
            new BStandardDialog("", new String[]{Translate.text("errorLoadingFile"), ex2.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
            {
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (Exception ex3) {
                        new BStandardDialog("", new String[]{Translate.text("errorLoadingFile"), ex3.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
                        return;
                    }
                    throw throwable;
                }
            }
            try {
                in.close();
            }
            catch (Exception ex4) {
                new BStandardDialog("", new String[]{Translate.text("errorLoadingFile"), ex4.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
                return;
            }
            return;
        }
        if (sc.getNumTextures() == 0) {
            new BStandardDialog("", Translate.text("noTexturesError"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        FormContainer mainPanel = new FormContainer(4, 1);
        mainPanel.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        final BList baseList = new BList();
        final BList importList = new BList();
        final BButton addButton = new BButton(Translate.text("Add") + " >>");
        final BButton removeButton = new BButton("<< " + Translate.text("Remove"));
        final Vector<Texture> baseVec = new Vector<Texture>();
        final Vector importVec = new Vector();
        final MaterialPreviewer preview = new MaterialPreviewer(sc.getTexture(0), null, 160, 160);
        baseList.setMultipleSelectionEnabled(false);
        importList.setMultipleSelectionEnabled(false);
        for (int i = 0; i < sc.getNumTextures(); ++i) {
            baseVec.addElement(sc.getTexture(i));
            baseList.add(sc.getTexture(i).getName());
        }
        Object listListener = new Object(){

            private void processEvent(WidgetEvent ev) {
                if (ev.getWidget() == baseList && baseList.getSelectedIndex() > -1) {
                    if (importList.getSelectedIndex() > -1) {
                        importList.setSelected(importList.getSelectedIndex(), false);
                    }
                    addButton.setEnabled(true);
                    removeButton.setEnabled(false);
                    Texture tex = (Texture)baseVec.elementAt(baseList.getSelectedIndex());
                    preview.setTexture(tex, tex.getDefaultMapping());
                    preview.render();
                } else if (importList.getSelectedIndex() > -1) {
                    if (baseList.getSelectedIndex() > -1) {
                        baseList.setSelected(baseList.getSelectedIndex(), false);
                    }
                    addButton.setEnabled(false);
                    removeButton.setEnabled(true);
                    Texture tex = (Texture)importVec.elementAt(importList.getSelectedIndex());
                    preview.setTexture(tex, tex.getDefaultMapping());
                    preview.render();
                }
            }
        };
        baseList.addEventLink(SelectionChangedEvent.class, listListener);
        importList.addEventLink(SelectionChangedEvent.class, listListener);
        baseList.setSelected(0, true);
        addButton.addEventLink(CommandEvent.class, new Object(){

            void processEvent() {
                int which = baseList.getSelectedIndex();
                if (which < 0) {
                    return;
                }
                Texture tex = (Texture)baseVec.elementAt(which);
                baseVec.removeElementAt(which);
                baseList.remove(which);
                importVec.addElement(tex);
                importList.add(tex.getName());
                addButton.setEnabled(false);
            }
        });
        removeButton.addEventLink(CommandEvent.class, new Object(){

            void processEvent() {
                int which = importList.getSelectedIndex();
                if (which < 0) {
                    return;
                }
                Texture tex = (Texture)importVec.elementAt(which);
                importVec.removeElementAt(which);
                importList.remove(which);
                baseVec.addElement(tex);
                baseList.add(tex.getName());
                removeButton.setEnabled(false);
            }
        });
        removeButton.setEnabled(false);
        ColumnContainer buttons = new ColumnContainer();
        buttons.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        buttons.add(addButton);
        buttons.add(removeButton);
        mainPanel.add(UIUtilities.createScrollingList(baseList), 0, 0);
        mainPanel.add(buttons, 1, 0, new LayoutInfo());
        mainPanel.add(UIUtilities.createScrollingList(importList), 2, 0);
        mainPanel.add(preview, 3, 0);
        ((BScrollPane)baseList.getParent()).setPreferredViewSize(new Dimension(150, 200));
        ((BScrollPane)importList.getParent()).setPreferredViewSize(new Dimension(150, 200));
        PanelDialog dlg = new PanelDialog((WindowWidget)this, Translate.text("selectTexturesToImport"), mainPanel);
        if (!dlg.clickedOk()) {
            return;
        }
        boolean[] imageUsed = new boolean[sc.getNumImages()];
        for (int i = 0; i < importVec.size(); ++i) {
            Texture tex = (Texture)importVec.elementAt(i);
            for (int j = 0; j < imageUsed.length; ++j) {
                if (imageUsed[j] || !tex.usesImage(sc.getImage(j))) continue;
                this.theScene.addImage(sc.getImage(j));
                imageUsed[j] = true;
            }
            this.theScene.addTexture(tex);
        }
    }
}

