/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.TextureParameter;
import artofillusion.math.Vec2;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectWrapper;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UVMapping;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

public class TextureMappingDialog
extends BDialog {
    private BFrame fr;
    private FormContainer content;
    private Object3D origObj;
    private Object3D editObj;
    private Vector mappings;
    private BComboBox mapChoice;
    private MaterialPreviewer preview;
    private TextureMapping map;
    private TextureMapping oldMapping;
    private Widget editingPanel;
    private boolean layered;
    private int layer;
    static /* synthetic */ Class class$artofillusion$object$Object3D;

    public TextureMappingDialog(BFrame parent, Object3D obj, int layer) {
        super(parent, "Texture Mapping", true);
        this.fr = parent;
        this.editObj = obj.duplicate();
        this.origObj = obj;
        this.layer = layer;
        this.map = this.editObj.getTextureMapping();
        this.layered = this.map instanceof LayeredMapping;
        if (this.layered) {
            this.map = ((LayeredMapping)this.map).getLayerMapping(layer);
        }
        this.oldMapping = this.map.duplicate();
        this.mappings = new Vector();
        Class[] allMappings = ModellingApp.getTextureMappings();
        for (int i = 0; i < allMappings.length; ++i) {
            try {
                Method mtd = allMappings[i].getMethod("legalMapping", class$artofillusion$object$Object3D == null ? TextureMappingDialog.class$("artofillusion.object.Object3D") : class$artofillusion$object$Object3D, class$artofillusion$texture$Texture == null ? TextureMappingDialog.class$("artofillusion.texture.Texture") : class$artofillusion$texture$Texture);
                Texture tex = this.layered ? ((LayeredMapping)this.editObj.getTextureMapping()).getLayer(layer) : this.editObj.getTexture();
                Boolean result = (Boolean)mtd.invoke(null, this.editObj, tex);
                if (!result.booleanValue()) continue;
                this.mappings.addElement(allMappings[i]);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.content = new FormContainer(new double[]{1.0}, new double[]{1.0, 0.0, 0.0, 0.0});
        this.setContent(BOutline.createEmptyBorder(this.content, ModellingApp.standardDialogInsets));
        Object3D previewObj = this.editObj;
        while (previewObj instanceof ObjectWrapper) {
            previewObj = ((ObjectWrapper)previewObj).getWrappedObject();
        }
        previewObj = previewObj.duplicate();
        this.preview = new MaterialPreviewer(obj.getTexture(), obj.getMaterial(), obj.duplicate(), 160, 160);
        this.content.add(this.preview, 0, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(0, 50, 0, 50), null));
        this.setPreviewMapping(this.map);
        RowContainer choiceRow = new RowContainer();
        this.content.add(choiceRow, 0, 1);
        choiceRow.add(new BLabel(Translate.text("Mapping") + ":"));
        this.mapChoice = new BComboBox();
        choiceRow.add(this.mapChoice);
        for (int i = 0; i < this.mappings.size(); ++i) {
            try {
                Method mtd = ((Class)this.mappings.elementAt(i)).getMethod("getName", null);
                this.mapChoice.add((String)mtd.invoke(null, null));
                if (this.mappings.elementAt(i) != this.map.getClass()) continue;
                this.mapChoice.setSelectedIndex(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.mapChoice.addEventLink(ValueChangedEvent.class, (Object)this, "mappingChanged");
        this.editingPanel = this.map.getEditingPanel(this.editObj, this.preview);
        this.content.add(this.editingPanel, 0, 2);
        RowContainer row = new RowContainer();
        this.content.add(row, 0, 3);
        row.add(Translate.button("ok", this, "doOk"));
        row.add(Translate.button("cancel", this, "dispose"));
        this.pack();
        UIUtilities.centerWindow(this);
        this.setVisible(true);
    }

    private void doOk() {
        this.editObj.setTexture(this.editObj.getTexture(), this.editObj.getTextureMapping());
        this.origObj.copyTextureAndMaterial(this.editObj);
        this.dispose();
    }

    private void mappingChanged() {
        try {
            Class cls = (Class)this.mappings.elementAt(this.mapChoice.getSelectedIndex());
            if (cls == this.map.getClass()) {
                return;
            }
            Constructor con = cls.getConstructor(Texture.class);
            Texture tex = this.layered ? ((LayeredMapping)this.editObj.getTextureMapping()).getLayer(this.layer) : this.editObj.getTexture();
            this.setMapping((TextureMapping)con.newInstance(tex));
            this.content.remove(this.editingPanel);
            this.editingPanel = this.map.getEditingPanel(this.editObj, this.preview);
            this.content.add(this.editingPanel, 0, 2);
            this.pack();
            this.preview.render();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setMapping(TextureMapping newmap) {
        this.map = newmap;
        Vec2[] uv = null;
        Vec2[][] uvf = null;
        if (newmap instanceof UVMapping) {
            Mapping2D oldmap = this.layered ? (Mapping2D)((LayeredMapping)this.editObj.getTextureMapping()).getLayerMapping(this.layer) : (Mapping2D)this.editObj.getTextureMapping();
            Object3D innerObj = this.editObj;
            while (innerObj instanceof ObjectWrapper) {
                innerObj = ((ObjectWrapper)innerObj).getWrappedObject();
            }
            Mesh m = (Mesh)((Object)innerObj);
            if (m instanceof TriangleMesh && oldmap instanceof UVMapping && ((UVMapping)oldmap).isPerFaceVertex((TriangleMesh)m)) {
                uvf = ((UVMapping)oldmap).findFaceTextureCoordinates((TriangleMesh)m);
            } else {
                uv = oldmap.findTextureCoordinates(m);
            }
        }
        if (this.layered) {
            LayeredMapping lm = (LayeredMapping)this.editObj.getTextureMapping();
            lm.setLayerMapping(this.layer, newmap);
            this.editObj.setTexture(lm.getTexture(), lm);
        } else {
            this.editObj.setTexture(this.editObj.getTexture(), newmap);
            this.setPreviewMapping(newmap);
        }
        if (uv != null) {
            ((UVMapping)newmap).setTextureCoordinates(this.editObj, uv);
            this.setPreviewMapping(newmap);
        }
        if (uvf != null) {
            ((UVMapping)newmap).setFaceTextureCoordinates(this.editObj, uvf);
            this.setPreviewMapping(newmap);
        }
        this.preview.render();
    }

    public void setPreviewMapping(TextureMapping newmap) {
        this.preview.setTexture(this.editObj.getTexture(), newmap);
        Object3D mesh = this.editObj;
        while (mesh instanceof ObjectWrapper) {
            mesh = ((ObjectWrapper)mesh).getWrappedObject();
        }
        if (!(mesh instanceof Mesh)) {
            return;
        }
        TextureParameter[] param = mesh.getParameters();
        ParameterValue[] val = mesh.getParameterValues();
        Object3D previewObj = this.preview.getObject().object;
        for (int i = 0; i < param.length; ++i) {
            previewObj.setParameterValue(param[i], val[i]);
        }
        this.preview.render();
    }
}

