/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class TaperMeshTool
extends EditingTool {
    private boolean noSelection;
    private boolean taperAll;
    private boolean towardCenter;
    private Point clickPoint;
    private int whichHandle;
    private BoundingBox bounds;
    private double boundsHeight;
    private double boundsWidth;
    private Vec3[] baseVertPos;
    private UndoRecord undo;
    public static final int HANDLE_SIZE = 5;
    private static Image icon;
    private static Image selectedIcon;

    public TaperMeshTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("taperPoints.gif");
        selectedIcon = this.loadImage("selected/taperPoints.gif");
    }

    public void activate() {
        super.activate();
        MeshViewer view = (MeshViewer)this.theWindow.getView();
        int[] selected = view.getSelectionDistance();
        this.noSelection = false;
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] != 0) continue;
            this.theWindow.setHelpText(Translate.text("taperMeshTool.helpText"));
            return;
        }
        this.theWindow.setHelpText(Translate.text("taperMeshTool.errorText"));
        this.noSelection = true;
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("taperMeshTool.tipText");
    }

    public void drawOverlay(Graphics g, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        g.setColor(Color.red);
        Rectangle b = this.findScreenBounds(this.findSelectionBounds(v, cam, (MeshViewer)view), cam, (MeshViewer)view);
        if (b != null) {
            g.fillRect(b.x, b.y, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y, 5, 5);
            g.fillRect(b.x, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y + b.height - 5 + 1, 5, 5);
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        this.clickPoint = e.getPoint();
        this.bounds = this.findSelectionBounds(v, cam, (MeshViewer)view);
        Rectangle b = this.findScreenBounds(this.bounds, cam, (MeshViewer)view);
        if (!b.contains(this.clickPoint)) {
            this.whichHandle = -1;
            return;
        }
        int j = this.clickPoint.x <= b.x + 5 ? 0 : (this.clickPoint.x >= b.x + b.width - 5 ? 1 : -1);
        int k = this.clickPoint.y <= b.y + 5 ? 0 : (this.clickPoint.y >= b.y + b.height - 5 ? 1 : -1);
        if (j == -1 || k == -1) {
            this.whichHandle = -1;
            return;
        }
        if (j == 0 && k == 0) {
            this.whichHandle = 0;
        } else if (j == 1 && k == 0) {
            this.whichHandle = 1;
        } else if (j == 0 && k == 1) {
            this.whichHandle = 2;
        } else if (j == 1 && k == 1) {
            this.whichHandle = 3;
        }
        this.taperAll = e.isShiftDown();
        this.towardCenter = e.isControlDown();
        this.boundsHeight = b.height;
        this.boundsWidth = b.width;
        this.baseVertPos = mesh.getVertexPositions();
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int vertSize = 5;
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        if (this.noSelection || this.whichHandle == -1) {
            return;
        }
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        Vec3[] v = this.findTaperedPositions(this.baseVertPos, dragPoint, (MeshViewer)view);
        mesh.setVertexPositions(v);
        ((ObjectViewer)view).objectChanged();
        this.theWindow.updateImage();
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Object3D meshobj = ((MeshViewer)view).getObject().object;
        Mesh mesh = (Mesh)((Object)meshobj);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.noSelection || this.whichHandle == -1) {
            return;
        }
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        Vec3[] v = this.findTaperedPositions(this.baseVertPos, e.getPoint(), (MeshViewer)view);
        mesh.setVertexPositions(v);
        this.theWindow.setHelpText(Translate.text("taperMeshTool.helpText"));
        this.undo = null;
        this.baseVertPos = null;
        meshobj.informChanged(this, "object editor");
    }

    BoundingBox findSelectionBounds(MeshVertex[] vert, Camera cam, MeshViewer view) {
        int[] selected = view.getSelectionDistance();
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        for (int i = 0; i < vert.length; ++i) {
            if (selected[i] != 0) continue;
            Vec3 v = cam.getObjectToView().times(vert[i].r);
            if (v.x < minx) {
                minx = v.x;
            }
            if (v.x > maxx) {
                maxx = v.x;
            }
            if (v.y < miny) {
                miny = v.y;
            }
            if (v.y > maxy) {
                maxy = v.y;
            }
            if (v.z < minz) {
                minz = v.z;
            }
            if (!(v.z > maxz)) continue;
            maxz = v.z;
        }
        return new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    Rectangle findScreenBounds(BoundingBox b, Camera cam, MeshViewer view) {
        CoordinateSystem coords = view.getObject().coords;
        Mat4 m = cam.getObjectToWorld();
        cam.setObjectTransform(cam.getViewToWorld());
        Rectangle r = cam.findScreenBounds(b);
        cam.setObjectTransform(m);
        if (r != null) {
            r.setBounds(r.x - 10, r.y - 10, r.width + 20, r.height + 20);
        }
        return r;
    }

    Vec3[] findTaperedPositions(Vec3[] vert, Point pos, MeshViewer view) {
        int i;
        double taper;
        Vec3[] v = new Vec3[vert.length];
        int[] selected = view.getSelectionDistance();
        Camera cam = view.getCamera();
        double clickX = this.clickPoint.x;
        double clickY = this.clickPoint.y;
        double posX = pos.x;
        double posY = pos.y;
        boolean direction = !(Math.abs(posX - clickX) > Math.abs(posY - clickY));
        Vec3 center = new Vec3(0.0, 0.0, (this.bounds.minz + this.bounds.maxz) / 2.0);
        if (this.bounds.minx == this.bounds.maxx || this.bounds.miny == this.bounds.maxy) {
            taper = 0.0;
        } else if (!direction) {
            center.x = this.towardCenter ? (this.bounds.minx + this.bounds.maxx) / 2.0 : (this.whichHandle == 0 || this.whichHandle == 2 ? this.bounds.minx : this.bounds.maxx);
            center.y = this.whichHandle == 0 || this.whichHandle == 1 ? this.bounds.miny : this.bounds.maxy;
            taper = this.whichHandle == 0 || this.whichHandle == 2 ? (posX - clickX) / this.boundsWidth : (clickX - posX) / this.boundsWidth;
            if (taper > 1.0) {
                taper = 1.0;
            }
            if (this.whichHandle == 2 || this.whichHandle == 3) {
                taper *= -1.0;
            }
        } else {
            center.y = this.towardCenter ? (this.bounds.miny + this.bounds.maxy) / 2.0 : (this.whichHandle == 0 || this.whichHandle == 1 ? this.bounds.miny : this.bounds.maxy);
            center.x = this.whichHandle == 0 || this.whichHandle == 2 ? this.bounds.minx : this.bounds.maxx;
            taper = this.whichHandle == 0 || this.whichHandle == 1 ? (posY - clickY) / this.boundsWidth : (clickY - posY) / this.boundsWidth;
            if (taper > 1.0) {
                taper = 1.0;
            }
            if (this.whichHandle == 1 || this.whichHandle == 3) {
                taper *= -1.0;
            }
        }
        if (taper == 0.0) {
            for (int i2 = 0; i2 < vert.length; ++i2) {
                v[i2] = new Vec3(vert[i2]);
            }
            return v;
        }
        Mat4 m1 = cam.getObjectToView();
        m1 = Mat4.translation(-center.x, -center.y, -center.z).times(m1);
        Mat4 m2 = Mat4.translation(center.x, center.y, center.z);
        m2 = cam.getViewToWorld().times(m2);
        m2 = view.getDisplayCoordinates().toLocal().times(m2);
        for (i = 0; i < vert.length; ++i) {
            if (selected[i] == 0) {
                v[i] = m1.times(vert[i]);
                if (!direction) {
                    v[i].x *= 1.0 - taper * v[i].y / (this.bounds.maxy - this.bounds.miny);
                    if (this.taperAll) {
                        v[i].z *= 1.0 - taper * v[i].y / (this.bounds.maxy - this.bounds.miny);
                    }
                } else {
                    v[i].y *= 1.0 - taper * v[i].x / (this.bounds.maxx - this.bounds.minx);
                    if (this.taperAll) {
                        v[i].z *= 1.0 - taper * v[i].x / (this.bounds.maxx - this.bounds.minx);
                    }
                }
                v[i] = m2.times(v[i]).minus(vert[i]);
                continue;
            }
            v[i] = new Vec3();
        }
        if (this.theFrame instanceof MeshEditorWindow) {
            ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        }
        for (i = 0; i < vert.length; ++i) {
            v[i].add(vert[i]);
        }
        return v;
    }
}

