/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ModelEvent;
import artofillusion.RenderingMesh;
import artofillusion.Utilities;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.TexturedVertexShader;
import artofillusion.view.VertexShader;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class SplineMeshViewer
extends MeshViewer {
    boolean[] visible;
    boolean draggingSelectionBox;
    boolean dragging;
    Point[] screenVert;
    double[] screenZ;
    public static final int POINT_MODE = 0;
    public static final int CURVE_MODE = 1;
    static final RGBColor surfaceRGB = new RGBColor(0.8f, 0.8f, 1.0f);
    static final Color surfaceColor = new Color(0.8f, 0.8f, 1.0f);

    public SplineMeshViewer(ObjectInfo obj, RowContainer p) {
        super(obj, p);
        SplineMesh mesh = (SplineMesh)obj.object;
        this.visible = new boolean[mesh.getVertices().length];
        ((SplineMesh)obj.getObject3D()).getSkeleton().getModelEvent().addListener(this);
    }

    public void dispose() {
        if (this.theObject != null) {
            ((SplineMesh)this.theObject).getSkeleton().getModelEvent().removeListener(this);
        }
        super.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleModelEvent(ModelEvent event) {
        if (super.handleModelEvent(event)) return true;
        if (event.getSource() != ((SplineMesh)this.theObject).getSkeleton()) return false;
        if (!event.hasKey("skeleton changed")) return false;
        if (!this.getSkeletonDetached() || !this.draggingAutosync) return true;
        this.updateInternalState();
        if (!this.isVisible()) return true;
        this.updateImage();
        this.repaint();
        return true;
    }

    protected void drawObject(Graphics g) {
        Color selectedColor;
        Color meshColor;
        MeshVertex[] v = ((Mesh)((Object)this.theObject)).getVertices();
        this.screenVert = new Point[v.length];
        this.screenZ = new double[v.length];
        Vec2[] p = new Vec2[v.length];
        double clipDist = this.theCamera.isPerspective() ? this.theCamera.getClipDistance() : -1.7976931348623157E308;
        for (int i = 0; i < v.length; ++i) {
            p[i] = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            this.screenVert[i] = new Point((int)p[i].x, (int)p[i].y);
            this.screenZ[i] = this.theCamera.getObjectToView().timesZ(v[i].r);
            this.visible[i] = this.screenZ[i] > clipDist;
        }
        this.drawSurface(g);
        Vec3 displace = new Vec3(0.0, 0.0, -0.01);
        this.theCamera.getViewToWorld().transformDirection(displace);
        this.getDisplayCoordinates().toLocal().transformDirection(displace);
        Mat4 oldTransform = this.theCamera.getObjectToWorld();
        this.theCamera.setObjectTransform(oldTransform.times(Mat4.translation(displace.x, displace.y, displace.z)));
        if (this.currentTool instanceof SkeletonTool) {
            meshColor = Color.gray;
            selectedColor = new Color(255, 127, 255);
        } else {
            meshColor = Color.black;
            selectedColor = Color.magenta;
            if (this.showSkeleton && this.theObject.getSkeleton() != null) {
                this.theObject.getSkeleton().draw(this, false);
            }
        }
        if (this.getSelectionMode() == 0) {
            this.drawEdges(g, p, Color.gray, Color.gray);
            this.drawVertices(g, meshColor, this.currentTool.hilightSelection() ? selectedColor : meshColor);
        } else {
            this.drawEdges(g, p, meshColor, this.currentTool.hilightSelection() ? selectedColor : meshColor);
        }
        if (this.currentTool instanceof SkeletonTool && this.showSkeleton && this.theObject.getSkeleton() != null) {
            this.theObject.getSkeleton().draw(this, true);
        }
    }

    private void drawSurface(Graphics g) {
        if (!this.showSurface) {
            return;
        }
        if (this.renderMode == 0) {
            g.setColor(surfaceColor);
            Object3D.draw(g, this.theCamera, this.objInfo.getWireframePreview(), this.objInfo.getBounds());
        } else if (this.renderMode == 4) {
            this.renderMeshTransparent(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), surfaceRGB, null);
        } else {
            RenderingMesh mesh = this.objInfo.getPreviewMesh();
            Vec3 viewDir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
            VertexShader shader = this.renderMode == 1 ? new FlatVertexShader(mesh, surfaceRGB, viewDir) : (this.renderMode == 2 ? new SmoothVertexShader(mesh, surfaceRGB, viewDir) : new TexturedVertexShader(mesh, this.objInfo.object, 0.0, viewDir).optimize());
            this.renderMesh(mesh, shader, this.theCamera, this.objInfo.object.isClosed(), null);
        }
    }

    private void drawVertices(Graphics g, Color unselectedColor, Color selectedColor) {
        int i;
        if (!this.showMesh) {
            return;
        }
        MeshVertex[] v = ((Mesh)((Object)this.theObject)).getVertices();
        boolean[] selected = this.getSelection();
        if (this.renderMode == 0 || this.renderMode == 4) {
            for (i = 0; i < v.length; ++i) {
                if (selected[i] || !this.visible[i]) continue;
                this.drawBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, unselectedColor);
            }
        } else {
            for (i = 0; i < v.length; ++i) {
                if (selected[i] || !this.visible[i]) continue;
                this.renderBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, this.screenZ[i] - 0.01, unselectedColor);
            }
        }
        if (this.renderMode == 0 || this.renderMode == 4) {
            for (i = 0; i < v.length; ++i) {
                if (!selected[i] || !this.visible[i]) continue;
                this.drawBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, selectedColor);
            }
        } else {
            for (i = 0; i < v.length; ++i) {
                if (!selected[i] || !this.visible[i]) continue;
                this.renderBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, this.screenZ[i] - 0.01, selectedColor);
            }
        }
    }

    private void drawEdges(Graphics g, Vec2[] p, Color unselectedColor, Color selectedColor) {
        int j;
        int i;
        if (!this.showMesh) {
            return;
        }
        MeshVertex[] v = ((Mesh)((Object)this.theObject)).getVertices();
        int usize = ((SplineMesh)this.theObject).getUSize();
        int vsize = ((SplineMesh)this.theObject).getVSize();
        boolean uclosed = ((SplineMesh)this.theObject).isUClosed();
        boolean vclosed = ((SplineMesh)this.theObject).isVClosed();
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        if (this.renderMode == 0 || this.renderMode == 4) {
            if (selectMode == 0) {
                for (i = 0; i < usize; ++i) {
                    for (j = 0; j < vsize - 1; ++j) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + (j + 1) * usize], unselectedColor);
                    }
                    if (!vclosed) continue;
                    this.drawLine(this.screenVert[i + j * usize], this.screenVert[i], unselectedColor);
                }
                for (j = 0; j < vsize; ++j) {
                    for (i = 0; i < usize - 1; ++i) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + 1 + j * usize], unselectedColor);
                    }
                    if (!uclosed) continue;
                    this.drawLine(this.screenVert[i + j * usize], this.screenVert[j * usize], unselectedColor);
                }
            } else {
                for (i = 0; i < usize; ++i) {
                    if (selected[i]) continue;
                    for (j = 0; j < vsize - 1; ++j) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + (j + 1) * usize], unselectedColor);
                    }
                    if (!vclosed) continue;
                    this.drawLine(this.screenVert[i + j * usize], this.screenVert[i], unselectedColor);
                }
                for (j = 0; j < vsize; ++j) {
                    if (selected[j + usize]) continue;
                    for (i = 0; i < usize - 1; ++i) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + 1 + j * usize], unselectedColor);
                    }
                    if (!uclosed) continue;
                    this.drawLine(this.screenVert[i + j * usize], this.screenVert[j * usize], unselectedColor);
                }
            }
        } else if (selectMode == 0) {
            for (i = 0; i < usize; ++i) {
                for (j = 0; j < vsize - 1; ++j) {
                    this.renderLine(v[i + j * usize].r, v[i + (j + 1) * usize].r, this.theCamera, unselectedColor);
                }
                if (!vclosed) continue;
                this.renderLine(v[i + j * usize].r, v[i].r, this.theCamera, unselectedColor);
            }
            for (j = 0; j < vsize; ++j) {
                for (i = 0; i < usize - 1; ++i) {
                    this.renderLine(v[i + j * usize].r, v[i + 1 + j * usize].r, this.theCamera, unselectedColor);
                }
                if (!uclosed) continue;
                this.renderLine(v[i + j * usize].r, v[j * usize].r, this.theCamera, unselectedColor);
            }
        } else {
            for (i = 0; i < usize; ++i) {
                if (selected[i]) continue;
                for (j = 0; j < vsize - 1; ++j) {
                    this.renderLine(v[i + j * usize].r, v[i + (j + 1) * usize].r, this.theCamera, unselectedColor);
                }
                if (!vclosed) continue;
                this.renderLine(v[i + j * usize].r, v[i].r, this.theCamera, unselectedColor);
            }
            for (j = 0; j < vsize; ++j) {
                if (selected[j + usize]) continue;
                for (i = 0; i < usize - 1; ++i) {
                    this.renderLine(v[i + j * usize].r, v[i + 1 + j * usize].r, this.theCamera, unselectedColor);
                }
                if (!uclosed) continue;
                this.renderLine(v[i + j * usize].r, v[j * usize].r, this.theCamera, unselectedColor);
            }
        }
        if (selectMode == 0) {
            return;
        }
        if (this.renderMode == 0 || this.renderMode == 4) {
            for (i = 0; i < usize; ++i) {
                if (!selected[i]) continue;
                for (j = 0; j < vsize - 1; ++j) {
                    this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + (j + 1) * usize], selectedColor);
                }
                if (!vclosed) continue;
                this.drawLine(this.screenVert[i + j * usize], this.screenVert[i], selectedColor);
            }
            for (j = 0; j < vsize; ++j) {
                if (!selected[j + usize]) continue;
                for (i = 0; i < usize - 1; ++i) {
                    this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + 1 + j * usize], selectedColor);
                }
                if (!uclosed) continue;
                this.drawLine(this.screenVert[i + j * usize], this.screenVert[j * usize], selectedColor);
            }
        } else {
            for (i = 0; i < usize; ++i) {
                if (!selected[i]) continue;
                for (j = 0; j < vsize - 1; ++j) {
                    this.renderLine(v[i + j * usize].r, v[i + (j + 1) * usize].r, this.theCamera, selectedColor);
                }
                if (!vclosed) continue;
                this.renderLine(v[i + j * usize].r, v[i].r, this.theCamera, selectedColor);
            }
            for (j = 0; j < vsize; ++j) {
                if (!selected[j + usize]) continue;
                for (i = 0; i < usize - 1; ++i) {
                    this.renderLine(v[i + j * usize].r, v[i + 1 + j * usize].r, this.theCamera, selectedColor);
                }
                if (!uclosed) continue;
                this.renderLine(v[i + j * usize].r, v[j * usize].r, this.theCamera, selectedColor);
            }
        }
    }

    public void drawDraggedSelection(Graphics g, Camera cam, Vec3[] v, boolean broadcast) {
        int j;
        int i;
        MeshVertex[] vert = ((SplineMesh)this.theObject).getVertices();
        int usize = ((SplineMesh)this.theObject).getUSize();
        int vsize = ((SplineMesh)this.theObject).getVSize();
        boolean uclosed = ((SplineMesh)this.theObject).isUClosed();
        boolean vclosed = ((SplineMesh)this.theObject).isVClosed();
        if (this.getSelectionMode() == 0) {
            for (i = 0; i < vert.length; ++i) {
                if (vert[i].r == v[i]) continue;
                Vec2 p = cam.getObjectToScreen().timesXY(v[i]);
                g.fillRect((int)p.x - 2, (int)p.y - 2, 5, 5);
            }
        }
        for (i = 0; i < usize; ++i) {
            for (j = 0; j < vsize - 1; ++j) {
                if (vert[i + j * usize].r == v[i + j * usize] && vert[i + (j + 1) * usize].r == v[i + (j + 1) * usize]) continue;
                cam.drawClippedLine(g, v[i + j * usize], v[i + (j + 1) * usize]);
            }
            if (!vclosed || vert[i + j * usize].r == v[i + j * usize] && vert[i].r == v[i]) continue;
            cam.drawClippedLine(g, v[i + j * usize], v[i]);
        }
        for (j = 0; j < vsize; ++j) {
            for (i = 0; i < usize - 1; ++i) {
                if (vert[i + j * usize].r == v[i + j * usize] && vert[i + 1 + j * usize].r == v[i + 1 + j * usize]) continue;
                cam.drawClippedLine(g, v[i + j * usize], v[i + 1 + j * usize]);
            }
            if (!uclosed || vert[i + j * usize].r == v[i + j * usize] && vert[j * usize].r == v[j * usize]) continue;
            cam.drawClippedLine(g, v[i + j * usize], v[j * usize]);
        }
        this.broadcastDraggedSelection(v, broadcast);
    }

    public void setSelectionMode(int mode) {
        boolean[] newSel;
        MeshVertex[] vert = ((SplineMesh)this.theObject).getVertices();
        int usize = ((SplineMesh)this.theObject).getUSize();
        int vsize = ((SplineMesh)this.theObject).getVSize();
        boolean uclosed = ((SplineMesh)this.theObject).isUClosed();
        boolean vclosed = ((SplineMesh)this.theObject).isVClosed();
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        if (mode == selectMode) {
            return;
        }
        if (mode == 0) {
            int j;
            int i;
            newSel = new boolean[vert.length];
            for (i = 0; i < usize; ++i) {
                if (!selected[i]) continue;
                for (j = 0; j < vsize; ++j) {
                    newSel[i + j * usize] = true;
                }
            }
            for (i = 0; i < vsize; ++i) {
                if (!selected[i + usize]) continue;
                for (j = 0; j < usize; ++j) {
                    newSel[j + i * usize] = true;
                }
            }
        } else {
            newSel = new boolean[usize + vsize];
            int i = 0;
            while (i < newSel.length) {
                newSel[i++] = true;
            }
            for (i = 0; i < usize; ++i) {
                for (int j = 0; j < vsize; ++j) {
                    if (selected[i + j * usize]) continue;
                    newSel[j + usize] = false;
                    newSel[i] = false;
                }
            }
        }
        this.getSelectionHolder().setSelectionMode(mode);
        this.getSelectionHolder().setSelection(newSel);
    }

    public void setSelection(boolean[] sel) {
        this.getSelectionHolder().setSelection(sel);
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }

    protected void findSelectionDistance() {
        int j;
        int i;
        int usize = ((SplineMesh)this.theObject).getUSize();
        int vsize = ((SplineMesh)this.theObject).getVSize();
        boolean uclosed = ((SplineMesh)this.theObject).isUClosed();
        boolean vclosed = ((SplineMesh)this.theObject).isVClosed();
        int[] dist = new int[((SplineMesh)this.theObject).getVertices().length];
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        this.maxDistance = MeshEditorWindow.getTensionDistance();
        if (selectMode == 0) {
            for (i = 0; i < dist.length; ++i) {
                dist[i] = selected[i] ? 0 : -1;
            }
        } else {
            for (i = 0; i < usize; ++i) {
                for (j = 0; j < vsize; ++j) {
                    dist[i + j * usize] = selected[i] || selected[j + usize] ? 0 : -1;
                }
            }
        }
        for (i = 0; i < this.maxDistance; ++i) {
            for (j = 0; j < usize; ++j) {
                for (int k = 0; k < vsize; ++k) {
                    if (dist[j + k * usize] != -1) continue;
                    if (j == 0) {
                        if (uclosed && dist[usize - 1 + k * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                    } else if (dist[j - 1 + k * usize] == i) {
                        dist[j + k * usize] = i + 1;
                    }
                    if (j == usize - 1) {
                        if (uclosed && dist[k * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                    } else if (dist[j + 1 + k * usize] == i) {
                        dist[j + k * usize] = i + 1;
                    }
                    if (k == 0) {
                        if (vclosed && dist[j + (vsize - 1) * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                    } else if (dist[j + (k - 1) * usize] == i) {
                        dist[j + k * usize] = i + 1;
                    }
                    if (k == vsize - 1) {
                        if (!vclosed || dist[j] != i) continue;
                        dist[j + k * usize] = i + 1;
                        continue;
                    }
                    if (dist[j + (k + 1) * usize] != i) continue;
                    dist[j + k * usize] = i + 1;
                }
            }
        }
        this.selectionDistance = dist;
    }

    public void extendDistance(int[] dist, int maxDistance) {
        int usize = ((SplineMesh)this.theObject).getUSize();
        int vsize = ((SplineMesh)this.theObject).getVSize();
        boolean uclosed = ((SplineMesh)this.theObject).isUClosed();
        boolean vclosed = ((SplineMesh)this.theObject).isVClosed();
        for (int i = 0; maxDistance == 0 || i < maxDistance; ++i) {
            for (i = 0; i < maxDistance; ++i) {
                for (int j = 0; j < usize; ++j) {
                    for (int k = 0; k < vsize; ++k) {
                        if (dist[j + k * usize] != -1) continue;
                        if (j == 0) {
                            if (uclosed && dist[usize - 1 + k * usize] == i) {
                                dist[j + k * usize] = i + 1;
                            }
                        } else if (dist[j - 1 + k * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                        if (j == usize - 1) {
                            if (uclosed && dist[k * usize] == i) {
                                dist[j + k * usize] = i + 1;
                            }
                        } else if (dist[j + 1 + k * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                        if (k == 0) {
                            if (vclosed && dist[j + (vsize - 1) * usize] == i) {
                                dist[j + k * usize] = i + 1;
                            }
                        } else if (dist[j + (k - 1) * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                        if (k == vsize - 1) {
                            if (!vclosed || dist[j] != i) continue;
                            dist[j + k * usize] = i + 1;
                            continue;
                        }
                        if (dist[j + (k + 1) * usize] != i) continue;
                        dist[j + k * usize] = i + 1;
                    }
                }
            }
        }
        this.selectionDistance = dist;
    }

    public void setMesh(Mesh mesh) {
        SplineMesh obj = (SplineMesh)mesh;
        this.setObject(obj);
        int selectMode = this.getSelectionMode();
        int newsellength = -1;
        if (selectMode == 0) {
            newsellength = obj.getVertices().length;
        } else if (selectMode == 1) {
            newsellength = obj.getUSize() + obj.getVSize();
        }
        this.getSelectionHolder().setSelection(Utilities.arrayEnsureLength(this.getSelection(), newsellength));
        this.visible = Utilities.arrayEnsureLength(this.visible, obj.getVertices().length);
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
    }

    protected void mousePressed(WidgetMouseEvent e) {
        int k;
        int j;
        MeshVertex[] v = ((SplineMesh)this.theObject).getVertices();
        int usize = ((SplineMesh)this.theObject).getUSize();
        int vsize = ((SplineMesh)this.theObject).getVSize();
        Point pos = e.getPoint();
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        this.requestFocus();
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if (this.activeTool.whichClicks() == 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            return;
        }
        int i = this.findClickTarget(e.getPoint());
        if (i == -1) {
            this.draggingSelectionBox = true;
            this.beginDraggingSelection(pos, false);
            this.sentClick = false;
            return;
        }
        if (selectMode == 1) {
            int dist;
            j = 0;
            int closest = Integer.MAX_VALUE;
            if (i < usize) {
                for (k = 0; k < vsize; ++k) {
                    dist = Math.abs(pos.x - this.screenVert[i + usize * k].x) + Math.abs(pos.y - this.screenVert[i + usize * k].y);
                    if (dist >= closest) continue;
                    j = i + usize * k;
                }
            } else {
                for (k = 0; k < usize; ++k) {
                    dist = Math.abs(pos.x - this.screenVert[k + usize * (i - usize)].x) + Math.abs(pos.y - this.screenVert[k + usize * (i - usize)].y);
                    if (dist >= closest) continue;
                    j = k + usize * (i - usize);
                }
            }
        } else {
            j = i;
        }
        if (selected[i]) {
            if (e.isShiftDown()) {
                this.deselect = i;
            }
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
            return;
        }
        if (!e.isShiftDown()) {
            for (k = 0; k < selected.length; ++k) {
                selected[k] = false;
            }
        }
        selected[i] = true;
        this.getSelectionHolder().informChanged(this, "object editor");
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        if (e.isShiftDown()) {
            this.sentClick = false;
            this.updateImage();
            this.repaint();
        } else {
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
        }
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        int i;
        int usize = ((SplineMesh)this.theObject).getUSize();
        int vsize = ((SplineMesh)this.theObject).getVSize();
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        this.moveToGrid(e);
        this.endDraggingSelection();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            for (i = 0; i < selected.length; ++i) {
                selected[i] = false;
            }
        }
        if (this.selectBounds != null) {
            boolean newsel;
            boolean bl = newsel = !e.isControlDown();
            if (selectMode == 0) {
                for (i = 0; i < selected.length; ++i) {
                    if (!this.selectionRegionContains(this.screenVert[i])) continue;
                    selected[i] = newsel;
                }
            } else {
                int j;
                for (i = 0; i < usize; ++i) {
                    for (j = 0; j < vsize && this.selectionRegionContains(this.screenVert[i + j * usize]); ++j) {
                    }
                    if (j != vsize) continue;
                    selected[i] = newsel;
                }
                for (i = 0; i < vsize; ++i) {
                    for (j = 0; j < usize && this.selectionRegionContains(this.screenVert[j + i * usize]); ++j) {
                    }
                    if (j != usize) continue;
                    selected[i + usize] = newsel;
                }
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            selected[this.deselect] = false;
        }
        this.getSelectionHolder().informChanged(this, "object editor");
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
    }

    int findClickTarget(Point pos) {
        MeshVertex[] vt = ((SplineMesh)this.theObject).getVertices();
        int selectMode = this.getSelectionMode();
        boolean[] selected = this.getSelection();
        double closestz = Double.MAX_VALUE;
        boolean sel = false;
        int which = -1;
        boolean uclosed = ((SplineMesh)this.theObject).isUClosed();
        boolean vclosed = ((SplineMesh)this.theObject).isVClosed();
        int usize = ((SplineMesh)this.theObject).getUSize();
        int vsize = ((SplineMesh)this.theObject).getVSize();
        if (selectMode == 0) {
            for (int i = 0; i < vt.length; ++i) {
                if (!this.visible[i] || sel && !selected[i]) continue;
                Point v1 = this.screenVert[i];
                if (pos.x < v1.x - 2 || pos.x > v1.x + 2 || pos.y < v1.y - 2 || pos.y > v1.y + 2) continue;
                double z = this.theCamera.getObjectToView().timesZ(vt[i].r);
                if ((sel || !selected[i]) && !(z < closestz)) continue;
                which = i;
                closestz = z;
                sel = selected[i];
            }
        } else {
            double z;
            int j;
            int i;
            for (i = 0; i < usize; ++i) {
                if (sel && !selected[i]) continue;
                for (j = 1; j < vsize; ++j) {
                    z = this.lineClickDepth(pos, vt, i + (j - 1) * usize, i + j * usize);
                    if (z == Double.MAX_VALUE || (sel || !selected[i]) && !(z < closestz)) continue;
                    which = i;
                    closestz = z;
                    sel = selected[i];
                }
                if (!vclosed || (z = this.lineClickDepth(pos, vt, i + (j - 1) * usize, i)) == Double.MAX_VALUE || (sel || !selected[i]) && !(z < closestz)) continue;
                which = i;
                closestz = z;
                sel = selected[i];
            }
            for (i = 0; i < vsize; ++i) {
                if (sel && !selected[i + usize]) continue;
                for (j = 1; j < usize; ++j) {
                    z = this.lineClickDepth(pos, vt, j - 1 + i * usize, j + i * usize);
                    if (z == Double.MAX_VALUE || (sel || !selected[i + usize]) && !(z < closestz)) continue;
                    which = i + usize;
                    closestz = z;
                    sel = selected[i + usize];
                }
                if (!vclosed || (z = this.lineClickDepth(pos, vt, j - 1 + i * usize, i * usize)) == Double.MAX_VALUE || (sel || !selected[i + usize]) && !(z < closestz)) continue;
                which = i + usize;
                closestz = z;
                sel = selected[i + usize];
            }
        }
        return which;
    }

    private double lineClickDepth(Point pos, MeshVertex[] vt, int p1, int p2) {
        double w;
        double u;
        double v;
        if (!this.visible[p1] || !this.visible[p2]) {
            return Double.MAX_VALUE;
        }
        Point v1 = this.screenVert[p1];
        Point v2 = this.screenVert[p2];
        if (pos.x < v1.x - 2 && pos.x < v2.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2) {
            return Double.MAX_VALUE;
        }
        if (Math.abs(v1.x - v2.x) > Math.abs(v1.y - v2.y)) {
            if (v2.x > v1.x) {
                v = ((double)pos.x - (double)v1.x) / (double)(v2.x - v1.x);
                u = 1.0 - v;
            } else {
                u = ((double)pos.x - (double)v2.x) / (double)(v1.x - v2.x);
                v = 1.0 - u;
            }
            w = u * (double)v1.y + v * (double)v2.y - (double)pos.y;
        } else {
            if (v2.y > v1.y) {
                v = ((double)pos.y - (double)v1.y) / (double)(v2.y - v1.y);
                u = 1.0 - v;
            } else {
                u = ((double)pos.y - (double)v2.y) / (double)(v1.y - v2.y);
                v = 1.0 - u;
            }
            w = u * (double)v1.x + v * (double)v2.x - (double)pos.x;
        }
        if (Math.abs(w) > 2.0) {
            return Double.MAX_VALUE;
        }
        return u * this.theCamera.getObjectToView().timesZ(vt[p1].r) + v * this.theCamera.getObjectToView().timesZ(vt[p2].r);
    }
}

