/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayoutWindow;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshSelectionHolder;
import artofillusion.MeshViewer;
import artofillusion.ModellingApp;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.SplineMeshViewer;
import artofillusion.TaperMeshTool;
import artofillusion.ThickenMeshTool;
import artofillusion.UndoRecord;
import artofillusion.Utilities;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.GenericTool;
import artofillusion.ui.MenuStructure;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueSlider;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BMenuItem;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.MenuWidget;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class SplineMeshEditorWindow
extends MeshEditorWindow {
    ToolPalette modes;
    boolean topology;
    BMenuItem item;
    final String[] MENUITEMS_ALLOWED_ON_TOPOLOGY = new String[]{"clear", "subdivideEdges", "simplify", "bevel", "optimize", "closeBoundary", "joinBoundaries", "invertNormals", "createFace"};
    final String[] MENUITEMS_CHECKBOXITEMS = new String[]{"freehandSelection", "interpolating", "approximating", "udirection", "vdirection", "both", "neither", "detachSkeleton"};

    public SplineMeshEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Runnable onClose, boolean allowTopology) {
        super(parent, title, obj, onClose);
        this.topology = allowTopology;
        MenuStructure ms = new MenuStructure();
        ms.loadStructure("SplineMesh", false);
        this.menubar = ms.createMenuBar(this);
        this.setMenuBar(this.menubar);
        this.menuitemsCache = null;
        UIUtilities.recursivelyAddKeyPressedListeners(this);
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 3 / 4, d1.height * 3 / 4);
        this.setBounds(new Rectangle((d1.width - d2.width) / 2, (d1.height - d2.height) / 2, d2.width, d2.height));
        this.updateMenus();
    }

    public boolean isMenuItemAllowed(MenuWidget item) {
        String itemname = ((Widget)((Object)item)).getName();
        if (Utilities.findIndexEqual(this.MENUITEMS_ALLOWED_ON_TOPOLOGY, itemname) > -1) {
            return this.topology;
        }
        if ("renderPreview".equals(itemname)) {
            return ModellingApp.getPreferences().getObjectPreviewRenderer() != null;
        }
        return super.isMenuItemAllowed(item);
    }

    protected boolean isMenuItemNameCheckbox(String itemname) {
        if (Utilities.findIndexEqual(this.MENUITEMS_CHECKBOXITEMS, itemname) > -1) {
            return true;
        }
        return super.isMenuItemNameCheckbox(itemname);
    }

    public void setTool(EditingTool tool) {
        for (int i = 0; i < this.theView.length; ++i) {
            if (tool instanceof GenericTool) {
                ((SplineMeshViewer)this.theView[i]).setSelectionMode(this.modes.getSelection());
                this.theView[i].getCurrentTool().activate();
                ((SplineMeshViewer)this.theView[i]).informSelectionChanged(this, "object editor");
                this.updateMenus();
                continue;
            }
            this.theView[i].setTool(tool);
            this.currentTool = tool;
        }
    }

    public boolean isSomethingSelected() {
        int i;
        boolean[] selected = ((SplineMeshViewer)this.getCurrentView()).getSelection();
        for (i = 0; i < selected.length && !selected[i]; ++i) {
        }
        return i < selected.length;
    }

    protected void updateMenuItem(MenuWidget item) {
        String itemname = ((Widget)((Object)item)).getName();
        BCheckBoxMenuItem cbitem = null;
        BMenuItem mnitem = null;
        if (item instanceof BCheckBoxMenuItem) {
            cbitem = (BCheckBoxMenuItem)item;
        } else if (item instanceof BMenuItem) {
            mnitem = (BMenuItem)item;
        } else {
            return;
        }
        boolean curvemode = ((SplineMeshViewer)this.getCurrentView()).getSelectionMode() == 1;
        SplineMesh obj = (SplineMesh)this.getCurrentView().getObject().object;
        if ("clear".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("extendSelection".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("deleteCurves".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected() && curvemode);
        } else if ("subdivide".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected() && curvemode);
        } else if ("editPoints".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("transformPoints".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("randomize".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("parameters".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("extractCurve".equals(itemname)) {
            int count = 0;
            boolean[] selected = ((SplineMeshViewer)this.getCurrentView()).getSelection();
            for (int i = 0; i < selected.length; ++i) {
                if (!selected[i]) continue;
                ++count;
            }
            mnitem.setEnabled(curvemode && count == 1);
        } else if ("smoothness".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected() && curvemode);
        } else if ("interpolating".equals(itemname)) {
            cbitem.setState(obj.getSmoothingMethod() == 2);
        } else if ("approximating".equals(itemname)) {
            cbitem.setState(obj.getSmoothingMethod() == 3);
        } else if ("udirection".equals(itemname)) {
            cbitem.setState(obj.isUClosed() && !obj.isVClosed());
        } else if ("vdirection".equals(itemname)) {
            cbitem.setState(!obj.isUClosed() && obj.isVClosed());
        } else if ("both".equals(itemname)) {
            cbitem.setState(obj.isUClosed() && obj.isVClosed());
        } else if ("neither".equals(itemname)) {
            cbitem.setState(!obj.isUClosed() && !obj.isVClosed());
        } else if ("editBone".equals(itemname)) {
            Skeleton s = obj.getSkeleton();
            Joint selJoint = s.getJoint(this.getCurrentView().getSelectedJoint());
            mnitem.setEnabled(selJoint != null);
        } else if ("deleteBone".equals(itemname)) {
            Skeleton s = obj.getSkeleton();
            Joint selJoint = s.getJoint(this.getCurrentView().getSelectedJoint());
            mnitem.setEnabled(selJoint != null && selJoint.children.length == 0);
        } else if ("bindSkeleton".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("setParentBone".equals(itemname)) {
            Skeleton s = obj.getSkeleton();
            Joint selJoint = s.getJoint(this.getCurrentView().getSelectedJoint());
            mnitem.setEnabled(selJoint != null);
        } else {
            super.updateMenuItem(item);
        }
    }

    protected void keyPressed(KeyPressedEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            if (this.getCurrentView().getCurrentTool() instanceof SkeletonTool) {
                this.deleteJointCommand();
            } else {
                this.deleteCommand();
            }
        } else {
            super.keyPressed(e);
        }
    }

    public void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.handleMenuAction(command)) {
            if (command.equals("clear")) {
                this.deleteCommand();
            } else if (command.equals("editPoints")) {
                this.setPointsCommand();
            } else if (command.equals("parameters")) {
                this.setParametersCommand();
            } else if (command.equals("centerMesh")) {
                this.centerCommand();
            } else if (command.equals("smoothness")) {
                this.setSmoothnessCommand();
            } else if (command.equals("invertNormals")) {
                this.reverseNormalsCommand();
            } else if (command.equals("meshTension")) {
                this.setTensionCommand();
            } else if (command.equals("renderPreview")) {
                this.getCurrentView().previewObject();
            } else if (command.equals("editBone")) {
                this.editJointCommand();
            } else if (command.equals("deleteBone")) {
                this.deleteJointCommand();
            } else if (command.equals("setParentBone")) {
                this.setJointParentCommand();
            } else if (command.equals("grid")) {
                this.setGridCommand();
            } else if (command.equals("fourViews")) {
                this.toggleViewsCommand();
            } else if (command.equals("showTemplate")) {
                boolean wasShown = this.getCurrentView().getTemplateShown();
                for (int i = 0; i < this.theView.length; ++i) {
                    this.theView[i].setShowTemplate(!wasShown);
                }
                this.updateMenus();
                this.updateImage();
            } else if (command.equals("setTemplate")) {
                this.setTemplateCommand();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemStateChanged(CommandEvent e) {
        Object source = e.getSource();
        BCheckBoxMenuItem sourceitem = null;
        String itemname = "";
        if (source instanceof BCheckBoxMenuItem) {
            sourceitem = (BCheckBoxMenuItem)source;
            itemname = sourceitem.getName();
        }
        if ("freehandSelection".equals(itemname)) {
            ((SplineMeshViewer)this.getCurrentView()).setFreehandSelection(sourceitem.getState());
            return;
        }
        if ("detachSkeleton".equals(itemname)) {
            ((SplineMeshViewer)this.getCurrentView()).setSkeletonDetached(sourceitem.getState());
            return;
        }
        Object[] SMOOTHMETHODS = new String[]{"interpolating", "approximating"};
        Object[] CLOSEDTYPES = new String[]{"udirection", "vdirection", "both", "neither"};
        int i = Utilities.findIndexEqual(SMOOTHMETHODS, itemname);
        if (i > -1) {
            this.setSmoothingMethod(i + 2);
            return;
        }
        i = Utilities.findIndexEqual(CLOSEDTYPES, itemname);
        if (i > -1) {
            this.setClosed(i);
            return;
        }
        super.itemStateChanged(e);
    }

    protected MeshEditorWindow createNewViewNewSelection() {
        SplineMeshEditorWindow w = new SplineMeshEditorWindow(this.parentWindow, this.getTitle(), this.objInConstructor, this.onClose, this.topology);
        return w;
    }

    public MeshViewer createMeshViewer(ObjectInfo obj, RowContainer p) {
        return new SplineMeshViewer(obj, p);
    }

    public void initBaseSelectionHolder(ObjectInfo obj) {
        this.baseSelHolder = new MeshSelectionHolder(obj);
        SplineMesh mesh = (SplineMesh)obj.object;
        this.baseSelHolder.setSelection(new boolean[mesh.getVertices().length]);
        this.baseSelHolder.setSelectionMode(0);
        this.baseSelHolder.decRefCount();
        for (int i = 0; i < this.theView.length; ++i) {
            ((SplineMeshViewer)this.theView[i]).setSelectionHolder(this.baseSelHolder);
        }
    }

    public BorderContainer createToolbarPanel() {
        BorderContainer p4 = new BorderContainer();
        this.tools = new ToolPalette(1, 9);
        p4.add(this.tools, BorderContainer.NORTH);
        this.defaultTool = new ReshapeMeshTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this));
        this.tools.addTool(new RotateMeshTool(this, false));
        this.tools.addTool(new SkewMeshTool(this));
        this.tools.addTool(new TaperMeshTool(this));
        this.tools.addTool(new ThickenMeshTool(this));
        this.tools.addTool(new SkeletonTool(this, true));
        this.tools.addTool(this.getMetaTool());
        this.tools.addTool(this.getAltTool());
        this.tools.selectTool(this.defaultTool);
        this.modes = new ToolPalette(1, 2);
        p4.add(this.modes, BorderContainer.SOUTH);
        this.modes.addTool(new GenericTool(this, "point.gif", "selected/point.gif"));
        this.modes.addTool(new GenericTool(this, "curve.gif", "selected/curve.gif"));
        return p4;
    }

    public void selectAllCommand() {
        boolean[] selected = ((SplineMeshViewer)this.getCurrentView()).getSelection();
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = true;
        }
        ((SplineMeshViewer)this.getCurrentView()).setSelection(selected);
        ((SplineMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
    }

    public void extendSelectionCommand() {
        SplineMesh theMesh = (SplineMesh)this.getCurrentView().getObject().object;
        if (((SplineMeshViewer)this.getCurrentView()).getSelectionMode() == 0) {
            int oldDist = tensionDistance;
            tensionDistance = 1;
            int[] dist = ((SplineMeshViewer)this.getCurrentView()).getSelectionDistance();
            boolean[] selected = new boolean[dist.length];
            tensionDistance = oldDist;
            for (int i = 0; i < dist.length; ++i) {
                selected[i] = dist[i] == 0 || dist[i] == 1;
            }
            ((SplineMeshViewer)this.getCurrentView()).setSelection(selected);
            ((SplineMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
        } else {
            int i;
            boolean[] oldSelection = ((SplineMeshViewer)this.getCurrentView()).getSelection();
            boolean[] selected = new boolean[oldSelection.length];
            int usize = theMesh.getUSize();
            int vsize = theMesh.getVSize();
            for (i = 0; i < usize - 1; ++i) {
                if (!oldSelection[i] && !oldSelection[i + 1]) continue;
                selected[i + 1] = true;
                selected[i] = true;
            }
            if (theMesh.isUClosed() && (oldSelection[0] || oldSelection[usize - 1])) {
                selected[usize - 1] = true;
                selected[0] = true;
            }
            for (i = 0; i < vsize - 1; ++i) {
                if (!oldSelection[usize + i] && !oldSelection[usize + i + 1]) continue;
                selected[usize + i + 1] = true;
                selected[usize + i] = true;
            }
            if (theMesh.isVClosed() && (oldSelection[usize] || oldSelection[usize + vsize - 1])) {
                selected[usize + vsize - 1] = true;
                selected[usize] = true;
            }
            ((SplineMeshViewer)this.getCurrentView()).setSelection(selected);
            ((SplineMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
        }
    }

    public void deleteCommand() {
        int i;
        int unum = 0;
        int vnum = 0;
        SplineMesh theMesh = (SplineMesh)this.getCurrentView().getObject().object;
        float[] us = theMesh.getUSmoothness();
        float[] vs = theMesh.getVSmoothness();
        boolean[] selected = ((SplineMeshViewer)this.getCurrentView()).getSelection();
        MeshVertex[] vt = theMesh.getVertices();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        if (((SplineMeshViewer)this.getCurrentView()).getSelectionMode() != 1) {
            return;
        }
        for (i = 0; i < usize; ++i) {
            if (!selected[i]) continue;
            ++unum;
        }
        for (i = 0; i < vsize; ++i) {
            if (!selected[i + usize]) continue;
            ++vnum;
        }
        if (unum == 0 && vnum == 0) {
            return;
        }
        if (usize - unum < 2 || vsize - vnum < 2) {
            new BStandardDialog("", Translate.text("curveNeeds2Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        if (theMesh.isUClosed() && usize - unum < 3 || theMesh.isVClosed() && vsize - vnum < 3) {
            new BStandardDialog("", Translate.text("curveNeeds3Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        MeshVertex[][] v = new MeshVertex[usize - unum][vsize - vnum];
        float[] newus = new float[usize - unum];
        float[] newvs = new float[vsize - vnum];
        int j = 0;
        for (i = 0; i < usize; ++i) {
            if (selected[i]) continue;
            int m = 0;
            for (int k = 0; k < vsize; ++k) {
                if (selected[k + usize]) continue;
                newvs[m] = vs[k];
                v[j][m++] = vt[i + k * usize];
            }
            newus[j++] = us[i];
        }
        theMesh.setShape(v, newus, newvs);
        this.object3DChangedDuringEditor();
    }

    public void subdivideCommand() {
        double[] val;
        int k;
        int j;
        int i;
        int numParam;
        SplineMesh theMesh = (SplineMesh)this.getCurrentView().getObject().object;
        MeshVertex[] vt = theMesh.getVertices();
        float[] us = theMesh.getUSmoothness();
        float[] vs = theMesh.getVSmoothness();
        boolean[] selected = ((SplineMeshViewer)this.getCurrentView()).getSelection();
        int usplitcount = 0;
        int vsplitcount = 0;
        int method = theMesh.getSmoothingMethod();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        int n = numParam = theMesh.getParameters() == null ? 0 : theMesh.getParameters().length;
        if (((SplineMeshViewer)this.getCurrentView()).getSelectionMode() != 1) {
            return;
        }
        for (i = 0; !selected[i] && i < selected.length; ++i) {
        }
        if (i == selected.length) {
            return;
        }
        boolean[] splitu = theMesh.isUClosed() ? new boolean[usize] : new boolean[usize - 1];
        for (i = 0; i < splitu.length; ++i) {
            if (!selected[i] || !selected[(i + 1) % usize]) continue;
            splitu[i] = true;
            ++usplitcount;
        }
        boolean[] splitv = theMesh.isVClosed() ? new boolean[vsize] : new boolean[vsize - 1];
        for (i = 0; i < splitv.length; ++i) {
            if (!selected[i + usize] || !selected[(i + 1) % vsize + usize]) continue;
            splitv[i] = true;
            ++vsplitcount;
        }
        float[] newus = new float[usize + usplitcount];
        float[] newvs = new float[vsize + vsplitcount];
        boolean[] newsel = new boolean[selected.length + usplitcount + vsplitcount];
        MeshVertex[][] v = new MeshVertex[vsize][usize];
        for (i = 0; i < usize; ++i) {
            for (j = 0; j < vsize; ++j) {
                v[j][i] = vt[i + j * usize];
            }
        }
        MeshVertex[][] newv = new MeshVertex[vsize][usize + usplitcount];
        double[][][] param = new double[vsize][usize][numParam];
        for (k = 0; k < numParam; ++k) {
            if (!(theMesh.getParameterValues()[k] instanceof VertexParameterValue)) continue;
            val = ((VertexParameterValue)theMesh.getParameterValues()[k]).getValue();
            for (i = 0; i < usize; ++i) {
                for (j = 0; j < vsize; ++j) {
                    param[j][i][k] = val[i + usize * j];
                }
            }
        }
        double[][][] newparam = new double[vsize][usize + usplitcount][numParam];
        this.splitOneAxis(v, newv, us, newus, splitu, param, newparam, theMesh.isUClosed());
        v = new MeshVertex[usize + usplitcount][vsize];
        for (i = 0; i < v.length; ++i) {
            for (j = 0; j < v[i].length; ++j) {
                v[i][j] = newv[j][i];
            }
        }
        newv = new MeshVertex[usize + usplitcount][vsize + vsplitcount];
        param = new double[usize + usplitcount][vsize][numParam];
        for (i = 0; i < param.length; ++i) {
            for (j = 0; j < param[i].length; ++j) {
                for (k = 0; k < param[i][j].length; ++k) {
                    param[i][j][k] = newparam[j][i][k];
                }
            }
        }
        newparam = new double[usize + usplitcount][vsize + vsplitcount][numParam];
        this.splitOneAxis(v, newv, vs, newvs, splitv, param, newparam, theMesh.isVClosed());
        j = 0;
        for (i = 0; i < usize; ++i) {
            if (selected[i]) {
                newsel[j] = true;
            }
            if (i < splitu.length && splitu[i]) {
                newsel[++j] = true;
            }
            ++j;
        }
        j = 0;
        for (i = 0; i < vsize; ++i) {
            if (selected[i + usize]) {
                newsel[j + usize + usplitcount] = true;
            }
            if (i < splitv.length && splitv[i]) {
                newsel[++j + usize + usplitcount] = true;
            }
            ++j;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.setShape(newv, newus, newvs);
        for (k = 0; k < numParam; ++k) {
            if (!(theMesh.getParameterValues()[k] instanceof VertexParameterValue)) continue;
            val = new double[newus.length * newvs.length];
            for (i = 0; i < newus.length; ++i) {
                for (j = 0; j < newvs.length; ++j) {
                    val[i + newus.length * j] = newparam[i][j][k];
                }
            }
            theMesh.setParameterValue(theMesh.getParameters()[k], new VertexParameterValue(val));
        }
        this.object3DChangedDuringEditor();
        ((SplineMeshViewer)this.getCurrentView()).setSelection(newsel);
        ((SplineMeshViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
    }

    private void splitOneAxis(MeshVertex[][] v, MeshVertex[][] newv, float[] s, float[] news, boolean[] split, double[][][] param, double[][][] newparam, boolean closed) {
        int m;
        int k;
        int i;
        SplineMesh theMesh = (SplineMesh)this.getCurrentView().getObject().object;
        int method = theMesh.getSmoothingMethod();
        int numParam = param[0][0].length;
        double[] paramTemp = new double[numParam];
        int j = 0;
        for (i = 0; i < split.length; ++i) {
            int p1 = i - 1;
            if (p1 < 0) {
                p1 = closed ? v[0].length - 1 : 0;
            }
            int p3 = i < v[0].length - 1 ? i + 1 : (closed ? 0 : v[0].length - 1);
            if ((split[i] || split[p1]) && method == 3) {
                for (k = 0; k < v.length; ++k) {
                    newv[k][j] = SplineMesh.calcApproxPoint(v[k], s, param[k], paramTemp, p1, i, p3);
                    for (m = 0; m < numParam; ++m) {
                        newparam[k][j][m] = paramTemp[m];
                    }
                }
            } else {
                for (k = 0; k < v.length; ++k) {
                    newv[k][j] = v[k][i];
                    for (m = 0; m < numParam; ++m) {
                        newparam[k][j][m] = param[k][i][m];
                    }
                }
            }
            news[j] = split[i] || split[p1] ? Math.min(s[i] * 2.0f, 1.0f) : s[i];
            if (!split[i]) {
                ++j;
                continue;
            }
            if (method == 0) {
                for (k = 0; k < v.length; ++k) {
                    newv[k][j + 1] = MeshVertex.blend(v[k][i], v[k][p3], 0.5, 0.5);
                    for (m = 0; m < numParam; ++m) {
                        newparam[k][j + 1][m] = 0.5 * (param[k][i][m] + param[k][p3][m]);
                    }
                }
            } else if (method == 2) {
                int p4 = i < v[0].length - 2 ? i + 2 : (closed ? (i + 2) % v[0].length : v[0].length - 1);
                for (k = 0; k < v.length; ++k) {
                    newv[k][j + 1] = SplineMesh.calcInterpPoint(v[k], s, param[k], paramTemp, p1, i, p3, p4);
                    for (m = 0; m < numParam; ++m) {
                        newparam[k][j + 1][m] = paramTemp[m];
                    }
                }
            } else {
                for (k = 0; k < v.length; ++k) {
                    newv[k][j + 1] = MeshVertex.blend(v[k][i], v[k][p3], 0.5, 0.5);
                    for (m = 0; m < numParam; ++m) {
                        newparam[k][j + 1][m] = 0.5 * (param[k][i][m] + param[k][p3][m]);
                    }
                }
            }
            news[j + 1] = 1.0f;
            j += 2;
        }
        if (!closed) {
            for (k = 0; k < v.length; ++k) {
                newv[k][0] = v[k][0];
                newv[k][j] = v[k][i];
                for (m = 0; m < numParam; ++m) {
                    newparam[k][0][m] = param[k][0][m];
                    newparam[k][j][m] = param[k][i][m];
                }
            }
            news[j] = s[i];
        }
    }

    public void extractCurveCommand() {
        WidgetContainer parent;
        Vec3[] v;
        boolean closed;
        int which;
        SplineMesh theMesh = (SplineMesh)this.getCurrentView().getObject().object;
        MeshVertex[] vt = theMesh.getVertices();
        boolean[] selected = ((SplineMeshViewer)this.getCurrentView()).getSelection();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        if (((SplineMeshViewer)this.getCurrentView()).getSelectionMode() != 1) {
            return;
        }
        for (which = 0; which < selected.length && !selected[which]; ++which) {
        }
        if (which == selected.length) {
            return;
        }
        if (which < usize) {
            closed = theMesh.isVClosed();
            v = new Vec3[vsize];
        } else {
            closed = theMesh.isUClosed();
            v = new Vec3[usize];
        }
        float[] smoothness = new float[v.length];
        float[] usmoothness = theMesh.getUSmoothness();
        float[] vsmoothness = theMesh.getVSmoothness();
        for (int i = 0; i < v.length; ++i) {
            if (which < usize) {
                v[i] = vt[which + i * usize].r;
                smoothness[i] = vsmoothness[i];
                continue;
            }
            v[i] = vt[(which - usize) * usize + i].r;
            smoothness[i] = usmoothness[i];
        }
        Curve cv = new Curve(v, smoothness, theMesh.getSmoothingMethod(), closed);
        for (parent = this.parentWindow.getFrame(); parent != null && !(parent instanceof LayoutWindow); parent = parent.getParent()) {
        }
        if (parent != null) {
            ((LayoutWindow)parent).addObject(cv, this.getCurrentView().thisObjectInScene.coords.duplicate(), "Extracted Curve", null);
            ((LayoutWindow)parent).updateImage();
        }
    }

    public void setSmoothnessCommand() {
        int i;
        final SplineMesh theMesh = (SplineMesh)this.getCurrentView().getObject().object;
        SplineMesh oldMesh = (SplineMesh)theMesh.duplicate();
        MeshVertex[] vt = theMesh.getVertices();
        final boolean[] selected = ((SplineMeshViewer)this.getCurrentView()).getSelection();
        final float[] usmoothness = theMesh.getUSmoothness();
        final float[] vsmoothness = theMesh.getVSmoothness();
        if (((SplineMeshViewer)this.getCurrentView()).getSelectionMode() != 1) {
            return;
        }
        for (i = 0; i < selected.length && !selected[i]; ++i) {
        }
        if (i == selected.length) {
            return;
        }
        float value = i < theMesh.getUSize() ? usmoothness[i] : vsmoothness[i - theMesh.getUSize()];
        value = 0.001f * (float)Math.round(value * 1000.0f);
        final ValueSlider smoothness = new ValueSlider(0.0, 1.0, 100, value);
        smoothness.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                float s = (float)smoothness.getValue();
                for (int i = 0; i < selected.length; ++i) {
                    if (!selected[i]) continue;
                    if (i < theMesh.getUSize()) {
                        usmoothness[i] = s;
                        continue;
                    }
                    vsmoothness[i - theMesh.getUSize()] = s;
                }
                theMesh.setSmoothness(usmoothness, vsmoothness);
                SplineMeshEditorWindow.this.getCurrentView().objectChanged();
                SplineMeshEditorWindow.this.getCurrentView().updateImage();
                SplineMeshEditorWindow.this.getCurrentView().repaint();
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("setCurveSmoothness"), new Widget[]{smoothness}, new String[]{Translate.text("Smoothness")});
        if (dlg.clickedOk()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, oldMesh}));
            this.object3DChangedDuringEditor();
        } else {
            theMesh.copyObject(oldMesh);
            this.getCurrentView().objectChanged();
            this.getCurrentView().updateImage();
            this.getCurrentView().repaint();
        }
    }

    public void reverseNormalsCommand() {
        SplineMesh theMesh = (SplineMesh)this.getCurrentView().getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.reverseOrientation();
        this.object3DChangedDuringEditor();
    }

    void setSmoothingMethod(int method) {
        SplineMesh theMesh = (SplineMesh)this.getCurrentView().getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        this.updateMenus();
        theMesh.setSmoothingMethod(method);
        this.object3DChangedDuringEditor();
    }

    void setClosed(int item) {
        SplineMesh theMesh = (SplineMesh)this.getCurrentView().getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        this.updateMenus();
        theMesh.setClosed(item == 0 || item == 2, item == 1 || item == 2);
        this.object3DChangedDuringEditor();
    }

    public void adjustDeltas(Vec3[] delta) {
        int i;
        int[] dist = this.getCurrentView().getSelectionDistance();
        int[] count = new int[delta.length];
        SplineMesh theMesh = (SplineMesh)this.getCurrentView().getObject().object;
        int maxDistance = SplineMeshEditorWindow.getTensionDistance();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        double tension = SplineMeshEditorWindow.getMeshTension();
        double[] scale = new double[maxDistance + 1];
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] == 0) continue;
            delta[i].set(0.0, 0.0, 0.0);
        }
        for (i = 0; i < maxDistance; ++i) {
            int j;
            for (j = 0; j < count.length; ++j) {
                count[j] = 0;
            }
            for (j = 0; j < usize; ++j) {
                for (int k = 0; k < vsize; ++k) {
                    if (dist[j + k * usize] != i) continue;
                    if (j == 0) {
                        if (theMesh.isUClosed() && dist[usize - 1 + k * usize] == i + 1) {
                            int n = usize - 1 + k * usize;
                            count[n] = count[n] + 1;
                            delta[usize - 1 + k * usize].add(delta[j + k * usize]);
                        }
                    } else if (dist[j - 1 + k * usize] == i + 1) {
                        int n = j - 1 + k * usize;
                        count[n] = count[n] + 1;
                        delta[j - 1 + k * usize].add(delta[j + k * usize]);
                    }
                    if (j == usize - 1) {
                        if (theMesh.isUClosed() && dist[k * usize] == i + 1) {
                            int n = k * usize;
                            count[n] = count[n] + 1;
                            delta[k * usize].add(delta[j + k * usize]);
                        }
                    } else if (dist[j + 1 + k * usize] == i + 1) {
                        int n = j + 1 + k * usize;
                        count[n] = count[n] + 1;
                        delta[j + 1 + k * usize].add(delta[j + k * usize]);
                    }
                    if (k == 0) {
                        if (theMesh.isVClosed() && dist[j + (vsize - 1) * usize] == i + 1) {
                            int n = j + (vsize - 1) * usize;
                            count[n] = count[n] + 1;
                            delta[j + (vsize - 1) * usize].add(delta[j + k * usize]);
                        }
                    } else if (dist[j + (k - 1) * usize] == i + 1) {
                        int n = j + (k - 1) * usize;
                        count[n] = count[n] + 1;
                        delta[j + (k - 1) * usize].add(delta[j + k * usize]);
                    }
                    if (k == vsize - 1) {
                        if (!theMesh.isVClosed() || dist[j] != i + 1) continue;
                        dist[j + k * usize] = i + 1;
                        int n = j;
                        count[n] = count[n] + 1;
                        delta[j].add(delta[j + k * usize]);
                        continue;
                    }
                    if (dist[j + (k + 1) * usize] != i + 1) continue;
                    int n = j + (k + 1) * usize;
                    count[n] = count[n] + 1;
                    delta[j + (k + 1) * usize].add(delta[j + k * usize]);
                }
            }
            for (j = 0; j < count.length; ++j) {
                if (count[j] <= 1) continue;
                delta[j].scale(1.0 / (double)count[j]);
            }
        }
        for (i = 0; i < scale.length; ++i) {
            scale[i] = Math.pow(((double)(maxDistance - i) + 1.0) / ((double)maxDistance + 1.0), tension);
        }
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] <= 0) continue;
            delta[i].scale(scale[dist[i]]);
        }
    }
}

