/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModelEvent;
import artofillusion.animation.Skeleton;
import artofillusion.object.ObjectInfo;
import java.util.Vector;

public class SkeletonControlHolder {
    protected transient ModelEvent modelevent;
    protected ObjectInfo objinfo;
    protected int selectedJoint;
    protected Vector lockedJoints;

    public SkeletonControlHolder(ObjectInfo objinfo) {
        this.objinfo = objinfo;
        this.selectedJoint = 0;
        this.lockedJoints = new Vector();
    }

    public ModelEvent getModelEvent() {
        if (this.modelevent == null) {
            this.modelevent = new ModelEvent();
        }
        return this.modelevent;
    }

    protected ModelEvent createChangedModelEvent(Object cause, String during) {
        return this.getModelEvent().createClone(this, cause).put("skeletoncontrol changed", null).put("happened during", during);
    }

    public void informChanged(Object cause, String during) {
        this.createChangedModelEvent(cause, during).processSend();
    }

    public int getSelectedJoint() {
        return this.selectedJoint;
    }

    public void setSelectedJointE(int id) {
        this.modelevent.send((Object)this, "joint deselected", new Integer(this.selectedJoint), null);
        this.selectedJoint = id;
        this.modelevent.send((Object)this, "joint selected", new Integer(id), null);
    }

    public boolean[] getLockedJoints(Skeleton s) {
        if (s == null) {
            return new boolean[0];
        }
        boolean[] b = new boolean[s.getNumJoints()];
        for (int i = 0; i < this.lockedJoints.size(); ++i) {
            int index = s.findJointIndex((Integer)this.lockedJoints.elementAt(i));
            if (index <= -1 || index >= b.length) continue;
            b[index] = true;
        }
        return b;
    }

    public boolean isJointLocked(int id) {
        for (int i = 0; i < this.lockedJoints.size(); ++i) {
            if ((Integer)this.lockedJoints.elementAt(i) != id) continue;
            return true;
        }
        return false;
    }

    public void lockJoint(int id) {
        Integer i = new Integer(id);
        if (this.lockedJoints.indexOf(i) == -1) {
            this.lockedJoints.addElement(i);
        }
    }

    public void unlockJoint(int id) {
        this.lockedJoints.removeElement(new Integer(id));
    }
}

