/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayoutWindow;
import artofillusion.ModelEvent;
import artofillusion.ModellingApp;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.SceneSubset;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.image.ComplexImage;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.EditingWindow;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.LiveRenderOptions;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.TexturedVertexShader;
import artofillusion.view.VertexShader;
import buoy.event.MouseClickedEvent;
import buoy.event.WidgetEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;
import java.util.Enumeration;
import java.util.Vector;

public class SceneViewer
extends ViewerCanvas {
    Scene theScene;
    EditingWindow parentFrame;
    Vector cameras;
    boolean draggingBox;
    boolean draggingSelectionBox;
    boolean squareBox;
    boolean sentClick;
    boolean dragging;
    Point clickPoint;
    Point dragPoint;
    ObjectInfo clickedObject;
    int deselect;
    Renderer liveRenderer;
    LiveRenderOptions liveRenderOptions;
    SceneSubset liveRenderSubset;

    public SceneViewer(Scene s, RowContainer p, EditingWindow fr) {
        this.theScene = s;
        this.theScene.getModelEvent().addListener(this);
        this.parentFrame = fr;
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        this.cameras = new Vector();
        this.buildChoices(p);
        this.rebuildCameraList();
        this.setRenderMode(ModellingApp.getPreferences().getDefaultDisplayMode());
        this.liveRenderer = null;
        this.liveRenderOptions = new LiveRenderOptions();
        this.liveRenderSubset = new SceneSubset(s);
    }

    public LiveRenderOptions getLiveRenderOptions() {
        return this.liveRenderOptions;
    }

    public void setLiveRendering(boolean active) {
        this.liveRenderer = active ? this.getLiveRenderOptions().createRenderer() : null;
    }

    public boolean isLiveRendering() {
        return this.liveRenderer != null;
    }

    public SceneSubset getLiveRenderSubset() {
        return this.liveRenderSubset;
    }

    public void dispose() {
        super.dispose();
        this.theScene.getModelEvent().removeListener(this);
    }

    public void rebuildCameraList() {
        int i = this.viewChoice.getItemCount() - 2;
        int selected = this.viewChoice.getSelectedIndex();
        while (i > 5) {
            this.viewChoice.remove(i--);
        }
        this.cameras.removeAllElements();
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo obj = this.theScene.getObject(i);
            if (!(obj.object instanceof SceneCamera)) continue;
            this.cameras.addElement(obj);
            this.viewChoice.add(this.viewChoice.getItemCount() - 1, obj.name);
            if (obj != this.boundCamera) continue;
            selected = this.viewChoice.getItemCount() - 2;
        }
        if (selected < this.viewChoice.getItemCount()) {
            this.viewChoice.setSelectedIndex(selected);
        } else {
            this.viewChoice.setSelectedIndex(this.viewChoice.getItemCount() - 1);
        }
        if (this.viewChoice.getParent() != null) {
            this.viewChoice.getParent().layoutChildren();
        }
    }

    public void selectOrientation(int which) {
        super.selectOrientation(which);
        if (which > 5 && which < this.viewChoice.getItemCount() - 1) {
            this.boundCamera = (ObjectInfo)this.cameras.elementAt(which - 6);
            CoordinateSystem coords = this.theCamera.getCameraCoordinates();
            coords.copyCoords(this.boundCamera.coords);
            this.theCamera.setCameraCoordinates(coords);
        } else {
            this.boundCamera = null;
        }
    }

    public int getOrientationChoice() {
        return this.viewChoice.getSelectedIndex();
    }

    public synchronized void updateImage() {
        this.updateWithLiveRenderImage(null);
        if (this.liveRenderer != null) {
            Renderer oldlr = this.liveRenderer;
            this.liveRenderer = oldlr.duplicate();
            oldlr.cancelRenderingAsync(this.getLiveRenderSubset());
            this.liveRenderer.renderScene(this.getLiveRenderSubset(), this.theCamera, new ViewRenderListener(), null);
        }
    }

    public synchronized void updateWithLiveRenderImage(Image liveRenderImage) {
        ObjectInfo obj;
        int i;
        Rectangle dim = this.getBounds();
        boolean render = this.renderMode != 0;
        this.adjustCamera(this.perspectiveChoice.getSelectedIndex() == 0);
        super.updateImage();
        if (this.theImage == null) {
            return;
        }
        try {
            if (liveRenderImage != null) {
                if (this.renderMode == 0) {
                    this.gr.drawImage(liveRenderImage, 0, 0, null);
                } else {
                    int width = liveRenderImage.getWidth(null);
                    int height = liveRenderImage.getHeight(null);
                    int maxi = height < dim.height ? height : dim.height;
                    int maxj = width < dim.width ? width : dim.width;
                    boolean frombase = false;
                    boolean tobase = false;
                    PixelGrabber pg = new PixelGrabber(liveRenderImage, 0, 0, -1, -1, true);
                    pg.grabPixels();
                    for (i = 0; i < maxi; ++i) {
                        System.arraycopy((int[])pg.getPixels(), width * i, this.pixel, dim.width * i, maxj);
                    }
                }
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (liveRenderImage == null) {
            if (!render) {
                this.gr.setColor(Color.black);
                for (i = 0; i < this.theScene.getNumObjects(); ++i) {
                    obj = this.theScene.getObject(i);
                    if (obj == this.boundCamera) continue;
                    this.theCamera.setObjectTransform(obj.coords.fromLocal());
                    this.drawObject(obj);
                }
            } else {
                Vec3 viewdir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
                for (i = 0; i < this.theScene.getNumObjects(); ++i) {
                    obj = this.theScene.getObject(i);
                    if (obj == this.boundCamera) continue;
                    this.theCamera.setObjectTransform(obj.coords.fromLocal());
                    this.renderObject(obj, viewdir);
                }
            }
        }
        if (this.currentTool.hilightSelection()) {
            for (i = 0; i < this.theScene.getNumObjects(); ++i) {
                Color col;
                int hsize;
                obj = this.theScene.getObject(i);
                if (obj.selected) {
                    hsize = 4;
                    col = Color.red;
                } else {
                    if (!obj.parentSelected) continue;
                    hsize = 2;
                    col = Color.magenta;
                }
                this.theCamera.setObjectTransform(obj.coords.fromLocal());
                Rectangle bounds = this.theCamera.findScreenBounds(obj.getBounds());
                if (bounds == null) continue;
                this.drawBox(bounds.x, bounds.y, hsize, hsize, Color.red);
                this.drawBox(bounds.x + bounds.width - hsize + 1, bounds.y, hsize, hsize, col);
                this.drawBox(bounds.x, bounds.y + bounds.height - hsize + 1, hsize, hsize, col);
                this.drawBox(bounds.x + bounds.width - hsize + 1, bounds.y + bounds.height - hsize + 1, hsize, hsize, col);
                this.drawBox(bounds.x + (bounds.width - hsize) / 2, bounds.y, hsize, hsize, col);
                this.drawBox(bounds.x, bounds.y + (bounds.height - hsize) / 2, hsize, hsize, col);
                this.drawBox(bounds.x + (bounds.width - hsize) / 2, bounds.y + bounds.height - hsize + 1, hsize, hsize, col);
                this.drawBox(bounds.x + bounds.width - hsize + 1, bounds.y + (bounds.height - hsize) / 2, hsize, hsize, col);
            }
        }
        this.drawBorder();
        if (this.showAxes) {
            this.drawCoordinateAxes();
        }
    }

    private void drawObject(ObjectInfo obj) {
        if (!obj.visible) {
            return;
        }
        if (obj.object instanceof ObjectCollection) {
            Mat4 m = this.theCamera.getObjectToWorld();
            Enumeration infoEnum = ((ObjectCollection)obj.object).getObjects(obj, true, this.theScene);
            while (infoEnum.hasMoreElements()) {
                ObjectInfo info = (ObjectInfo)infoEnum.nextElement();
                CoordinateSystem coords = info.coords.duplicate();
                coords.transformCoordinates(m);
                this.theCamera.setObjectTransform(coords.fromLocal());
                this.drawObject(info);
            }
            return;
        }
        Object3D.draw(this.gr, this.theCamera, obj.getWireframePreview(), obj.getBounds());
    }

    private void renderObject(ObjectInfo obj, Vec3 viewdir) {
        if (!obj.visible) {
            return;
        }
        if (this.theCamera.visibility(obj.getBounds()) == 0) {
            return;
        }
        if (obj.object instanceof ObjectCollection) {
            Mat4 m = this.theCamera.getObjectToWorld();
            Enumeration infoEnum = ((ObjectCollection)obj.object).getObjects(obj, true, this.theScene);
            while (infoEnum.hasMoreElements()) {
                ObjectInfo info = (ObjectInfo)infoEnum.nextElement();
                CoordinateSystem coords = info.coords.duplicate();
                coords.transformCoordinates(m);
                this.theCamera.setObjectTransform(coords.fromLocal());
                this.renderObject(info, info.coords.toLocal().timesDirection(viewdir));
            }
            return;
        }
        RenderingMesh mesh = obj.getPreviewMesh();
        if (mesh != null) {
            VertexShader shader = this.renderMode == 1 ? new FlatVertexShader(mesh, obj.object, this.theScene.getTime(), obj.coords.toLocal().timesDirection(viewdir)) : (this.renderMode == 2 ? new SmoothVertexShader(mesh, obj.object, this.theScene.getTime(), obj.coords.toLocal().timesDirection(viewdir)) : new TexturedVertexShader(mesh, obj.object, this.theScene.getTime(), obj.coords.toLocal().timesDirection(viewdir)).optimize());
            this.renderMesh(mesh, shader, this.theCamera, obj.object.isClosed(), null);
        } else {
            this.renderWireframe(obj.getWireframePreview(), this.theCamera);
        }
    }

    public void beginDraggingBox(Point p, boolean square) {
        this.draggingBox = true;
        this.clickPoint = p;
        this.squareBox = square;
        this.dragPoint = null;
    }

    protected void mousePressed(WidgetMouseEvent e) {
        ObjectInfo info;
        int i;
        Rectangle bounds = null;
        this.requestFocus();
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = true;
        this.clickPoint = e.getPoint();
        this.clickedObject = null;
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if (this.activeTool.whichClicks() == 0) {
            this.moveToGrid(e);
            this.activeTool.mousePressed(e, this);
            return;
        }
        Point p = e.getPoint();
        int[] sel = this.theScene.getSelection();
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            this.theCamera.setObjectTransform(info.coords.fromLocal());
            bounds = this.theCamera.findScreenBounds(info.getBounds());
            if (bounds == null || bounds.x > p.x || bounds.y > p.y || bounds.x + bounds.width < p.x || bounds.y + bounds.height < p.y) continue;
            this.clickedObject = info;
            break;
        }
        if (i < sel.length) {
            if (e.isShiftDown()) {
                this.deselect = sel[i];
            }
            if ((this.activeTool.whichClicks() & 2) != 0) {
                int j = p.x <= bounds.x + 4 ? 0 : (p.x >= bounds.x + (bounds.width - 4) / 2 && p.x <= bounds.x + (bounds.width - 4) / 2 + 4 ? 1 : (p.x >= bounds.x + bounds.width - 4 ? 2 : -1));
                int k = p.y <= bounds.y + 4 ? 0 : (p.y >= bounds.y + (bounds.height - 4) / 2 && p.y <= bounds.y + (bounds.height - 4) / 2 + 4 ? 1 : (p.y >= bounds.y + bounds.height - 4 ? 2 : -1));
                if (k == 0) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], j);
                    return;
                }
                if (j == 0 && k == 1) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], 3);
                    return;
                }
                if (j == 2 && k == 1) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], 4);
                    return;
                }
                if (k == 2) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], j + 5);
                    return;
                }
            }
            this.moveToGrid(e);
            this.dragging = false;
            if ((this.activeTool.whichClicks() & 1) != 0) {
                this.activeTool.mousePressedOnObject(e, this, sel[i]);
            } else {
                this.sentClick = false;
            }
            return;
        }
        int j = -1;
        int minarea = Integer.MAX_VALUE;
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            info = this.theScene.getObject(i);
            if (!info.visible) continue;
            this.theCamera.setObjectTransform(info.coords.fromLocal());
            bounds = this.theCamera.findScreenBounds(info.getBounds());
            if (bounds == null || !bounds.contains(p) || bounds.width * bounds.height >= minarea) continue;
            j = i;
            minarea = bounds.width * bounds.height;
        }
        if (j > -1) {
            info = this.theScene.getObject(j);
            if (!e.isShiftDown()) {
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).clearSelection();
                } else {
                    this.theScene.clearSelection();
                }
            }
            if (this.parentFrame instanceof LayoutWindow) {
                ((LayoutWindow)this.parentFrame).addToSelection(j);
            } else {
                this.theScene.addToSelection(j);
            }
            this.parentFrame.updateMenus();
            this.parentFrame.updateImage();
            this.moveToGrid(e);
            if ((this.activeTool.whichClicks() & 1) != 0 && !e.isShiftDown()) {
                this.activeTool.mousePressedOnObject(e, this, j);
            } else {
                this.sentClick = false;
            }
            this.clickedObject = info;
            return;
        }
        this.moveToGrid(e);
        this.draggingSelectionBox = true;
        this.beginDraggingBox(p, false);
        this.sentClick = false;
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        this.moveToGrid(e);
        if (!this.dragging) {
            Point p = e.getPoint();
            if (this.clickPoint == null) {
                this.clickPoint = p;
            }
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        Graphics g = this.getComponent().getGraphics();
        if (this.draggingBox) {
            g.setXORMode(Color.white);
            g.setColor(Color.black);
            if (this.dragPoint != null) {
                g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
            }
            this.dragPoint = e.getPoint();
            if (this.squareBox) {
                if (Math.abs(this.dragPoint.x - this.clickPoint.x) > Math.abs(this.dragPoint.y - this.clickPoint.y)) {
                    this.dragPoint.y = this.dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(this.dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(this.dragPoint.x - this.clickPoint.x);
                } else {
                    this.dragPoint.x = this.dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(this.dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(this.dragPoint.y - this.clickPoint.y);
                }
            }
            g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
        }
        g.dispose();
        if (this.sentClick) {
            this.activeTool.mouseDragged(e, this);
        }
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        ObjectInfo info;
        Graphics g = this.getComponent().getGraphics();
        int[] sel = this.theScene.getSelection();
        this.moveToGrid(e);
        if (this.draggingBox && this.dragPoint != null) {
            g.setXORMode(Color.white);
            g.setColor(Color.black);
            g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
        }
        if (this.draggingSelectionBox) {
            this.dragPoint = e.getPoint();
            Rectangle r = new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
            if (!e.isShiftDown()) {
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).clearSelection();
                } else {
                    this.theScene.clearSelection();
                }
                this.parentFrame.updateMenus();
            }
            for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
                int j;
                info = this.theScene.getObject(i);
                if (!info.visible) continue;
                this.theCamera.setObjectTransform(info.coords.fromLocal());
                Rectangle b = this.theCamera.findScreenBounds(info.getBounds());
                if (b == null || !b.intersects(r)) continue;
                if (!e.isShiftDown()) {
                    if (this.parentFrame instanceof LayoutWindow) {
                        ((LayoutWindow)this.parentFrame).addToSelection(i);
                    } else {
                        this.theScene.addToSelection(i);
                    }
                    this.parentFrame.updateMenus();
                    continue;
                }
                for (j = 0; j < sel.length && sel[j] != i; ++j) {
                }
                if (j != sel.length) continue;
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).addToSelection(i);
                } else {
                    this.theScene.addToSelection(i);
                }
                this.parentFrame.updateMenus();
            }
            if (this.currentTool.hilightSelection()) {
                this.parentFrame.updateImage();
            }
        }
        g.dispose();
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            info = this.theScene.getObject(this.deselect);
            if (this.parentFrame instanceof LayoutWindow) {
                ((LayoutWindow)this.parentFrame).removeFromSelection(this.deselect);
            } else {
                this.theScene.removeFromSelection(this.deselect);
            }
            this.parentFrame.updateMenus();
            this.parentFrame.updateImage();
        }
    }

    public void mouseClicked(MouseClickedEvent e) {
        if (e.getClickCount() == 2 && this.activeTool.whichClicks() != 0 && this.clickedObject != null && this.clickedObject.object.isEditable()) {
            final Object3D obj = this.clickedObject.object;
            this.parentFrame.setUndoRecord(new UndoRecord(this.parentFrame, false, 0, new Object[]{obj, obj.duplicate()}));
            obj.edit(this.parentFrame, this.clickedObject, new Runnable(){

                public void run() {
                    SceneViewer.this.theScene.objectModified(obj);
                    SceneViewer.this.parentFrame.updateImage();
                    SceneViewer.this.parentFrame.updateMenus();
                }
            });
        }
    }

    protected void choiceChanged(WidgetEvent ev) {
        if (this.snapToGrid) {
            this.theCamera.setGrid(this.gridSpacing / (double)this.gridSubdivisions);
        } else {
            this.theCamera.setGrid(0.0);
        }
        super.choiceChanged(ev);
    }

    protected boolean handleModelEvent(ModelEvent event) {
        if (!super.handleModelEvent(event)) {
            if (event.getSource() == this.theScene) {
                this.updateImage();
                this.repaint();
            } else {
                return false;
            }
        }
        return true;
    }

    public class ViewRenderListener
    implements RenderListener {
        public void imageUpdated(Image image) {
        }

        public void statusChanged(String status) {
        }

        public void imageComplete(ComplexImage image) {
            SceneViewer.this.updateWithLiveRenderImage(image.getImage());
            SceneViewer.this.repaint();
        }

        public void renderingCanceled() {
        }
    }
}

