/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class ScaleMeshTool
extends EditingTool {
    private boolean noSelection;
    private boolean notOnHandle;
    private boolean scaleX;
    private boolean scaleY;
    private boolean scaleAll;
    private Point clickPoint;
    private double clickX;
    private double clickY;
    private double centerX;
    private double centerY;
    private Vec3 scaleCenter;
    private Vec3[] baseVertPos;
    private BoundingBox bounds;
    private UndoRecord undo;
    private static Image icon;
    private static Image selectedIcon;
    public static final int HANDLE_SIZE = 5;

    public ScaleMeshTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("scalePoints.gif");
        selectedIcon = this.loadImage("selected/scalePoints.gif");
    }

    public void activate() {
        super.activate();
        MeshViewer view = (MeshViewer)this.theWindow.getView();
        int[] selected = view.getSelectionDistance();
        this.noSelection = false;
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] != 0) continue;
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.helpText"));
            return;
        }
        this.theWindow.setHelpText(Translate.text("scaleMeshTool.errorText"));
        this.noSelection = true;
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("scaleMeshTool.tipText");
    }

    public void drawOverlay(Graphics g, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        g.setColor(Color.red);
        Rectangle b = this.findScreenBounds(this.findSelectionBounds(v, cam, (MeshViewer)view), cam, (MeshViewer)view);
        if (b != null) {
            g.fillRect(b.x, b.y, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y, 5, 5);
            g.fillRect(b.x, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + (b.width - 5) / 2, b.y, 5, 5);
            g.fillRect(b.x, b.y + (b.height - 5) / 2, 5, 5);
            g.fillRect(b.x + (b.width - 5) / 2, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y + (b.height - 5) / 2, 5, 5);
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        this.clickPoint = e.getPoint();
        this.bounds = this.findSelectionBounds(v, cam, (MeshViewer)view);
        Rectangle b = this.findScreenBounds(this.bounds, cam, (MeshViewer)view);
        if (!b.contains(this.clickPoint)) {
            this.notOnHandle = true;
            return;
        }
        int j = this.clickPoint.x <= b.x + 5 ? 0 : (this.clickPoint.x >= b.x + (b.width - 5) / 2 && this.clickPoint.x <= b.x + (b.width - 5) / 2 + 5 ? 1 : (this.clickPoint.x >= b.x + b.width - 5 ? 2 : -1));
        int k = this.clickPoint.y <= b.y + 5 ? 0 : (this.clickPoint.y >= b.y + (b.height - 5) / 2 && this.clickPoint.y <= b.y + (b.height - 5) / 2 + 5 ? 1 : (this.clickPoint.y >= b.y + b.height - 5 ? 2 : -1));
        if (j == -1 || k == -1 || j == 1 && k == 1) {
            this.notOnHandle = true;
            return;
        }
        this.notOnHandle = false;
        this.clickX = this.clickPoint.x;
        this.clickY = this.clickPoint.y;
        this.scaleCenter = new Vec3(0.0, 0.0, (this.bounds.minz + this.bounds.maxz) / 2.0);
        if (j == 0) {
            this.scaleX = true;
            this.centerX = b.x + b.width;
            this.scaleCenter.x = this.bounds.minx;
        } else if (j == 2) {
            this.scaleX = true;
            this.centerX = b.x;
            this.scaleCenter.x = this.bounds.maxx;
        } else {
            this.scaleX = false;
            this.scaleCenter.x = this.bounds.minx + this.bounds.maxx;
        }
        if (k == 0) {
            this.scaleY = true;
            this.centerY = b.y + b.height;
            this.scaleCenter.y = this.bounds.miny;
        } else if (k == 2) {
            this.scaleY = true;
            this.centerY = b.y;
            this.scaleCenter.y = this.bounds.maxy;
        } else {
            this.scaleY = false;
            this.scaleCenter.y = this.bounds.miny + this.bounds.maxy;
        }
        if (e.isControlDown()) {
            this.centerX = b.x + b.width / 2;
            this.centerY = b.y + b.height / 2;
            this.scaleCenter.x = (this.bounds.minx + this.bounds.maxx) / 2.0;
            this.scaleCenter.y = (this.bounds.miny + this.bounds.maxy) / 2.0;
        }
        this.scaleAll = e.isShiftDown();
        this.baseVertPos = mesh.getVertexPositions();
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        double zscale;
        double size;
        double xscale;
        double yscale;
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int vertSize = 5;
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        if (this.noSelection || this.notOnHandle) {
            return;
        }
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        if (this.scaleAll) {
            yscale = 0.0;
            xscale = 0.0;
        } else {
            yscale = 1.0;
            xscale = 1.0;
        }
        if (this.scaleX && (xscale = (size = (double)dragPoint.x - this.centerX) / (this.clickX - this.centerX)) <= 0.0) {
            xscale = Math.abs(1.0 / (this.clickX - this.centerX));
        }
        if (this.scaleY && (yscale = (size = (double)dragPoint.y - this.centerY) / (this.clickY - this.centerY)) <= 0.0) {
            yscale = Math.abs(1.0 / (this.clickY - this.centerY));
        }
        if (this.scaleAll) {
            yscale = zscale = Math.max(xscale, yscale);
            xscale = zscale;
        } else {
            zscale = 1.0;
        }
        Vec3[] v = this.findScaledPositions(this.baseVertPos, xscale, yscale, zscale, (MeshViewer)view);
        mesh.setVertexPositions(v);
        ((ObjectViewer)view).objectChanged();
        this.theWindow.updateImage();
        if (this.scaleAll) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(xscale * 100000.0) / 100000.0)));
        } else if (this.scaleX && !this.scaleY) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(xscale * 100000.0) / 100000.0)));
        } else if (this.scaleY && !this.scaleX) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(yscale * 100000.0) / 100000.0)));
        } else {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", (double)Math.round(xscale * 100000.0) / 100000.0 + ", " + (double)Math.round(yscale * 100000.0) / 100000.0));
        }
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        double zscale;
        double size;
        double xscale;
        double yscale;
        Object3D meshobj = ((MeshViewer)view).getObject().object;
        Mesh mesh = (Mesh)((Object)meshobj);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.noSelection || this.notOnHandle) {
            return;
        }
        if (this.scaleAll) {
            yscale = 0.0;
            xscale = 0.0;
        } else {
            yscale = 1.0;
            xscale = 1.0;
        }
        if (this.scaleX && (xscale = (size = (double)dragPoint.x - this.centerX) / (this.clickX - this.centerX)) <= 0.0) {
            xscale = Math.abs(1.0 / (this.clickX - this.centerX));
        }
        if (this.scaleY && (yscale = (size = (double)dragPoint.y - this.centerY) / (this.clickY - this.centerY)) <= 0.0) {
            yscale = Math.abs(1.0 / (this.clickY - this.centerY));
        }
        if (this.scaleAll) {
            yscale = zscale = Math.max(xscale, yscale);
            xscale = zscale;
        } else {
            zscale = 1.0;
        }
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        Vec3[] v = this.findScaledPositions(this.baseVertPos, xscale, yscale, zscale, (MeshViewer)view);
        mesh.setVertexPositions(v);
        meshobj.informChanged(this, "object editor");
        this.theWindow.setHelpText(Translate.text("scaleMeshTool.helpText"));
        this.undo = null;
        this.baseVertPos = null;
    }

    BoundingBox findSelectionBounds(MeshVertex[] vert, Camera cam, MeshViewer view) {
        int[] selected = view.getSelectionDistance();
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        for (int i = 0; i < vert.length; ++i) {
            if (selected[i] != 0) continue;
            Vec3 v = cam.getObjectToView().times(vert[i].r);
            if (v.x < minx) {
                minx = v.x;
            }
            if (v.x > maxx) {
                maxx = v.x;
            }
            if (v.y < miny) {
                miny = v.y;
            }
            if (v.y > maxy) {
                maxy = v.y;
            }
            if (v.z < minz) {
                minz = v.z;
            }
            if (!(v.z > maxz)) continue;
            maxz = v.z;
        }
        return new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    Rectangle findScreenBounds(BoundingBox b, Camera cam, MeshViewer view) {
        CoordinateSystem coords = view.getObject().coords;
        Mat4 m = cam.getObjectToWorld();
        cam.setObjectTransform(cam.getViewToWorld());
        Rectangle r = cam.findScreenBounds(b);
        cam.setObjectTransform(m);
        if (r != null) {
            r.setBounds(r.x - 10, r.y - 10, r.width + 20, r.height + 20);
        }
        return r;
    }

    Vec3[] findScaledPositions(Vec3[] vert, double xscale, double yscale, double zscale, MeshViewer view) {
        int i;
        Vec3[] v = new Vec3[vert.length];
        int[] selected = view.getSelectionDistance();
        Camera cam = view.getCamera();
        Mat4 m = cam.getObjectToView();
        m = Mat4.translation(-this.scaleCenter.x, -this.scaleCenter.y, -this.scaleCenter.z).times(m);
        m = Mat4.scale(xscale, yscale, zscale).times(m);
        m = Mat4.translation(this.scaleCenter.x, this.scaleCenter.y, this.scaleCenter.z).times(m);
        m = cam.getViewToWorld().times(m);
        m = view.getDisplayCoordinates().toLocal().times(m);
        for (i = 0; i < vert.length; ++i) {
            v[i] = selected[i] == 0 ? m.times(vert[i]).minus(vert[i]) : new Vec3();
        }
        if (this.theFrame instanceof MeshEditorWindow) {
            ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        }
        for (i = 0; i < vert.length; ++i) {
            v[i].add(vert[i]);
        }
        return v;
    }
}

