/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.RotateViewTool;
import artofillusion.Scene;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import buoy.event.WidgetMouseEvent;
import java.awt.Graphics;
import java.awt.Point;

public class RotateSceneViewTool
extends RotateViewTool {
    boolean respectSelectionCenter;

    public RotateSceneViewTool(EditingWindow fr, boolean respectcenter) {
        super(fr);
        this.respectSelectionCenter = respectcenter;
    }

    public Vec3 findSelectionCenter() {
        if (!this.respectSelectionCenter) {
            return null;
        }
        Scene theScene = this.theWindow.getScene();
        Vec3 center = new Vec3();
        int numSelected = 0;
        int[] sel = theScene.getSelection();
        if (sel.length == 0) {
            return null;
        }
        for (int i = 0; i < sel.length; ++i) {
            ObjectInfo info = theScene.getObject(sel[i]);
            if (info.selected) {
                center.add(info.coords.getOrigin());
            }
            ++numSelected;
        }
        if (numSelected > 0) {
            center.scale(1.0 / (double)numSelected);
            return center;
        }
        return null;
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        double angle;
        Vec3 axis;
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        CoordinateSystem c = this.oldCoords.duplicate();
        Vec3 center = this.findSelectionCenter();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (this.controlDown) {
            axis = this.viewToWorld.timesDirection(Vec3.vz());
            angle = (double)dx * 0.01;
        } else if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                axis = this.viewToWorld.timesDirection(Vec3.vy());
                angle = (double)dx * 0.01;
            } else {
                axis = this.viewToWorld.timesDirection(Vec3.vx());
                angle = (double)(-dy) * 0.01;
            }
        } else {
            axis = new Vec3((double)(-dy) * 0.01, (double)dx * 0.01, 0.0);
            angle = axis.length();
            axis = axis.times(1.0 / angle);
            axis = this.viewToWorld.timesDirection(axis);
        }
        if (angle != 0.0) {
            Mat4 m = center == null ? Mat4.axisRotation(axis, -angle) : Mat4.axisRotation(axis, -angle, center);
            c.transformCoordinates(m);
            cam.setCameraCoordinates(c);
            view.updateImage();
        }
        Graphics g = view.getComponent().getGraphics();
        view.drawImage(g);
        g.dispose();
    }
}

