/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Image;
import java.awt.Point;
import java.util.Vector;

public class RotateObjectTool
extends EditingTool {
    static final int X_ONLY = 1;
    static final int Y_ONLY = 2;
    static final int Z_ONLY = 3;
    static final int ALL_AXES = 4;
    static final int OBJECT_CENTER = 0;
    static final int PARENT_CENTER = 1;
    static final int SELECTION_CENTER = 2;
    static final double DRAG_SCALE = Math.PI / 360;
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    Vector toMove;
    ObjectInfo clickedObject;
    int whichAxes;
    int rotateAround = 1;
    boolean dragged;
    boolean applyToChildren = true;
    Vec3 rotAxis;
    Vec3[] rotationCenter;
    CoordinateSystem[] objectCoords;

    public RotateObjectTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("rotate.gif");
        selectedIcon = this.loadImage("selected/rotate.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("rotateObjectTool.helpText"));
    }

    public int whichClicks() {
        return 3;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("rotateObjectTool.tipText");
    }

    public void mousePressedOnObject(WidgetMouseEvent e, ViewerCanvas view, int obj) {
        int i;
        Scene theScene = this.theWindow.getScene();
        int numSelected = 0;
        Vec3 center = new Vec3();
        this.toMove = new Vector();
        this.clickedObject = theScene.getObject(obj);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        for (i = 0; i < sel.length; ++i) {
            this.toMove.addElement(theScene.getObject(sel[i]));
        }
        this.objectCoords = new CoordinateSystem[this.toMove.size()];
        this.rotationCenter = new Vec3[this.toMove.size()];
        for (i = 0; i < this.objectCoords.length; ++i) {
            ObjectInfo info;
            ObjectInfo parent = info = (ObjectInfo)this.toMove.elementAt(i);
            this.objectCoords[i] = info.coords.duplicate();
            if (this.rotateAround == 2) {
                this.rotationCenter[i] = center;
                if (info.selected) {
                    center.add(info.coords.getOrigin());
                    ++numSelected;
                }
            } else {
                this.rotationCenter[i] = info.coords.getOrigin();
            }
            if (this.rotateAround != 1) continue;
            while (parent.parent != null) {
                parent = parent.parent;
                if (!parent.selected) continue;
                this.rotationCenter[i] = parent.coords.getOrigin();
            }
        }
        if (numSelected > 0) {
            center.scale(1.0 / (double)numSelected);
        }
        this.clickPoint = e.getPoint();
        this.dragged = false;
        this.whichAxes = 4;
    }

    public void mousePressedOnHandle(WidgetMouseEvent e, ViewerCanvas view, int obj, int handle) {
        this.mousePressedOnObject(e, view, obj);
        if (handle == 1 || handle == 6) {
            this.whichAxes = 1;
            this.rotAxis = new Vec3(1.0, 0.0, 0.0);
        } else if (handle == 3 || handle == 4) {
            this.whichAxes = 2;
            this.rotAxis = new Vec3(0.0, -1.0, 0.0);
        } else {
            this.whichAxes = 3;
            this.rotAxis = handle < 4 ? new Vec3(0.0, 0.0, 1.0) : new Vec3(0.0, 0.0, -1.0);
        }
        this.rotAxis = view.getCamera().getViewToWorld().timesDirection(this.rotAxis);
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        double angle;
        CoordinateSystem c;
        ObjectInfo info;
        int i;
        Scene theScene = this.theWindow.getScene();
        Point dragPoint = e.getPoint();
        if (!this.dragged) {
            UndoRecord undo = new UndoRecord(this.theWindow, false);
            this.theWindow.setUndoRecord(undo);
            for (i = 0; i < this.toMove.size(); ++i) {
                info = (ObjectInfo)this.toMove.elementAt(i);
                c = info.coords;
                undo.addCommand(1, new Object[]{c, c.duplicate()});
            }
            this.dragged = true;
        }
        if (this.whichAxes == 1) {
            angle = (double)(this.clickPoint.y - dragPoint.y) * (Math.PI / 360);
        } else if (this.whichAxes == 2) {
            angle = (double)(this.clickPoint.x - dragPoint.x) * (Math.PI / 360);
        } else if (this.whichAxes == 3) {
            angle = (double)(dragPoint.x - this.clickPoint.x) * (Math.PI / 360);
        } else {
            this.rotAxis = new Vec3((double)(this.clickPoint.y - dragPoint.y) * (Math.PI / 360), (double)(dragPoint.x - this.clickPoint.x) * (Math.PI / 360), 0.0);
            angle = this.rotAxis.length();
            this.rotAxis = this.rotAxis.times(1.0 / angle);
            this.rotAxis = view.getCamera().getViewToWorld().timesDirection(this.rotAxis);
        }
        if (angle != 0.0) {
            for (i = 0; i < this.toMove.size(); ++i) {
                info = (ObjectInfo)this.toMove.elementAt(i);
                c = info.coords;
                Vec3 origin = this.rotationCenter[i];
                Mat4 rotMatrix = Mat4.translation(origin.x, origin.y, origin.z).times(Mat4.axisRotation(this.rotAxis, angle)).times(Mat4.translation(-origin.x, -origin.y, -origin.z));
                c.copyCoords(this.objectCoords[i]);
                c.transformCoordinates(rotMatrix);
            }
        }
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("rotateMeshTool.dragText", Double.toString((double)Math.round(angle * 100000.0 * 180.0 / Math.PI) / 100000.0)));
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        for (int i = 0; i < this.toMove.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            info.object.sceneChanged(info, this.theWindow.getScene());
        }
        this.theWindow.setHelpText(Translate.text("rotateObjectTool.helpText"));
        this.toMove = null;
        this.objectCoords = null;
        this.rotationCenter = null;
        this.theWindow.updateImage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
        ObjectInfo info;
        int i;
        int i2;
        Scene theScene = this.theWindow.getScene();
        Vec3 center = new Vec3();
        int key = e.getKeyCode();
        int numSelected = 0;
        if (e.isControlDown()) {
            if (key == 38 || key == 39) {
                this.rotAxis = new Vec3(0.0, 0.0, 1.0);
            } else {
                if (key != 40 && key != 37) return;
                this.rotAxis = new Vec3(0.0, 0.0, -1.0);
            }
        } else if (key == 38) {
            this.rotAxis = new Vec3(1.0, 0.0, 0.0);
        } else if (key == 40) {
            this.rotAxis = new Vec3(-1.0, 0.0, 0.0);
        } else if (key == 37) {
            this.rotAxis = new Vec3(0.0, -1.0, 0.0);
        } else {
            if (key != 39) return;
            this.rotAxis = new Vec3(0.0, 1.0, 0.0);
        }
        this.rotAxis = view.getCamera().getViewToWorld().timesDirection(this.rotAxis);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        this.toMove = new Vector();
        for (i2 = 0; i2 < sel.length; ++i2) {
            this.toMove.addElement(theScene.getObject(sel[i2]));
        }
        this.rotationCenter = new Vec3[this.toMove.size()];
        for (i2 = 0; i2 < this.rotationCenter.length; ++i2) {
            ObjectInfo info2;
            ObjectInfo parent = info2 = (ObjectInfo)this.toMove.elementAt(i2);
            if (this.rotateAround == 2) {
                this.rotationCenter[i2] = center;
                if (info2.selected) {
                    center.add(info2.coords.getOrigin());
                    ++numSelected;
                }
            } else {
                this.rotationCenter[i2] = info2.coords.getOrigin();
            }
            if (this.rotateAround != 1) continue;
            while (parent.parent != null) {
                parent = parent.parent;
                if (!parent.selected) continue;
                this.rotationCenter[i2] = parent.coords.getOrigin();
            }
        }
        if (numSelected > 0) {
            center.scale(1.0 / (double)numSelected);
        }
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        this.theWindow.setUndoRecord(undo);
        double angle = Math.PI / 360;
        if (e.isAltDown()) {
            angle *= 10.0;
        }
        for (i = 0; i < this.toMove.size(); ++i) {
            info = (ObjectInfo)this.toMove.elementAt(i);
            CoordinateSystem c = info.coords;
            Vec3 origin = this.rotationCenter[i];
            Mat4 rotMatrix = Mat4.translation(origin.x, origin.y, origin.z).times(Mat4.axisRotation(this.rotAxis, angle)).times(Mat4.translation(-origin.x, -origin.y, -origin.z));
            undo.addCommand(1, new Object[]{c, c.duplicate()});
            c.transformCoordinates(rotMatrix);
        }
        for (i = 0; i < this.toMove.size(); ++i) {
            info = (ObjectInfo)this.toMove.elementAt(i);
            info.object.sceneChanged(info, this.theWindow.getScene());
        }
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("rotateObjectTool.helpText"));
        this.toMove = null;
        this.rotationCenter = null;
    }

    public void iconDoubleClicked() {
        BCheckBox childrenBox = new BCheckBox(Translate.text("applyToUnselectedChildren"), this.applyToChildren);
        BComboBox centerChoice = new BComboBox(new String[]{Translate.text("individualObjectCenters"), Translate.text("parentObject"), Translate.text("centerOfSelection")});
        centerChoice.setSelectedIndex(this.rotateAround);
        RowContainer row = new RowContainer();
        row.add(Translate.label("rotateAround"));
        row.add(centerChoice);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("rotateToolTitle"), new Widget[]{childrenBox, row}, new String[]{null, null});
        if (!dlg.clickedOk()) {
            return;
        }
        this.applyToChildren = childrenBox.getState();
        this.rotateAround = centerChoice.getSelectedIndex();
    }
}

