/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class RotateMeshTool
extends EditingTool {
    private boolean noSelection;
    private boolean notOnHandle;
    private boolean only2D;
    private Point clickPoint;
    private Point centerPoint;
    private Vec3 rotCenter;
    private Vec3[] baseVertPos;
    private int hdirection;
    private int vdirection;
    private int whichAxis;
    private BoundingBox bounds;
    private UndoRecord undo;
    public static final int HANDLE_SIZE = 5;
    private static Image icon;
    private static Image selectedIcon;
    private static final double DRAG_SCALE = Math.PI / 360;
    private static final int XAXIS = 0;
    private static final int YAXIS = 1;
    private static final int ZAXIS = 2;

    public RotateMeshTool(EditingWindow fr, boolean only2D) {
        super(fr);
        this.only2D = only2D;
        icon = this.loadImage("rotatePoints.gif");
        selectedIcon = this.loadImage("selected/rotatePoints.gif");
    }

    public void activate() {
        super.activate();
        MeshViewer view = (MeshViewer)this.theWindow.getView();
        Mesh mesh = (Mesh)((Object)view.getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        int[] selected = view.getSelectionDistance();
        this.noSelection = false;
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] != 0) continue;
            this.theWindow.setHelpText(Translate.text("rotateMeshTool.helpText"));
            this.bounds = this.findSelectionBounds(v, cam, view);
            this.rotCenter = new Vec3((this.bounds.minx + this.bounds.maxx) / 2.0, (this.bounds.miny + this.bounds.maxy) / 2.0, (this.bounds.minz + this.bounds.maxz) / 2.0);
            this.rotCenter = cam.getViewToWorld().times(this.rotCenter);
            return;
        }
        this.theWindow.setHelpText(Translate.text("rotateMeshTool.errorText"));
        this.noSelection = true;
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("rotateMeshTool.tipText");
    }

    public void drawOverlay(Graphics g, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        g.setColor(Color.red);
        Rectangle b = this.findScreenBounds(this.findSelectionBounds(v, cam, (MeshViewer)view), cam, (MeshViewer)view);
        Vec2 p = cam.getWorldToScreen().timesXY(this.rotCenter);
        if (b != null) {
            g.fillRect(b.x, b.y, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y, 5, 5);
            g.fillRect(b.x, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y + b.height - 5 + 1, 5, 5);
            if (!this.only2D) {
                g.fillRect(b.x + (b.width - 5) / 2, b.y, 5, 5);
                g.fillRect(b.x, b.y + (b.height - 5) / 2, 5, 5);
                g.fillRect(b.x + (b.width - 5) / 2, b.y + b.height - 5 + 1, 5, 5);
                g.fillRect(b.x + b.width - 5 + 1, b.y + (b.height - 5) / 2, 5, 5);
            }
            int px = (int)p.x;
            int py = (int)p.y;
            g.drawLine(px - 5, py - 5, px + 5, py + 5);
            g.drawLine(px - 5, py + 5, px + 5, py - 5);
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        this.clickPoint = e.getPoint();
        if (e.isControlDown()) {
            this.rotCenter = cam.convertScreenToWorld(this.clickPoint, this.rotCenter.z);
            view.repaint();
            this.notOnHandle = true;
            return;
        }
        this.bounds = this.findSelectionBounds(v, cam, (MeshViewer)view);
        Rectangle b = this.findScreenBounds(this.bounds, cam, (MeshViewer)view);
        this.notOnHandle = false;
        if (!b.contains(this.clickPoint)) {
            this.notOnHandle = true;
            return;
        }
        int j = this.clickPoint.x <= b.x + 5 ? 0 : (this.clickPoint.x >= b.x + (b.width - 5) / 2 && this.clickPoint.x <= b.x + (b.width - 5) / 2 + 5 ? 1 : (this.clickPoint.x >= b.x + b.width - 5 ? 2 : -1));
        int k = this.clickPoint.y <= b.y + 5 ? 0 : (this.clickPoint.y >= b.y + (b.height - 5) / 2 && this.clickPoint.y <= b.y + (b.height - 5) / 2 + 5 ? 1 : (this.clickPoint.y >= b.y + b.height - 5 ? 2 : -1));
        if (j == -1 || k == -1 || j == 1 && k == 1) {
            this.notOnHandle = true;
            return;
        }
        if (j == 1) {
            this.whichAxis = 0;
            this.hdirection = 0;
            this.vdirection = -1;
        } else if (k == 1) {
            this.whichAxis = 1;
            this.vdirection = 0;
            this.hdirection = 1;
        } else {
            this.whichAxis = 2;
            this.vdirection = j == 0 ? -1 : 1;
            this.hdirection = k == 0 ? 1 : -1;
        }
        this.notOnHandle = this.only2D && this.whichAxis != 2;
        this.baseVertPos = mesh.getVertexPositions();
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int vertSize = 5;
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        if (this.noSelection || this.notOnHandle) {
            return;
        }
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        double angle = Math.PI / 360 * (double)((dragPoint.x - this.clickPoint.x) * this.hdirection + (dragPoint.y - this.clickPoint.y) * this.vdirection);
        Vec3[] v = this.findRotatedPositions(this.baseVertPos, angle, (MeshViewer)view);
        mesh.setVertexPositions(v);
        ((ObjectViewer)view).objectChanged();
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("rotateMeshTool.dragText", Double.toString((double)Math.round(angle * 100000.0 * 180.0 / Math.PI) / 100000.0)));
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.noSelection || this.notOnHandle) {
            return;
        }
        double angle = Math.PI / 360 * (double)((dragPoint.x - this.clickPoint.x) * this.hdirection + (dragPoint.y - this.clickPoint.y) * this.vdirection);
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        Vec3[] v = this.findRotatedPositions(this.baseVertPos, angle, (MeshViewer)view);
        mesh.setVertexPositions(v);
        mesh.informChanged(this, "object editor");
        this.theWindow.setHelpText(Translate.text("rotateMeshTool.helpText"));
        this.undo = null;
        this.baseVertPos = null;
    }

    BoundingBox findSelectionBounds(MeshVertex[] vert, Camera cam, MeshViewer view) {
        int[] selected = view.getSelectionDistance();
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        for (int i = 0; i < vert.length; ++i) {
            if (selected[i] != 0) continue;
            Vec3 v = cam.getObjectToView().times(vert[i].r);
            if (v.x < minx) {
                minx = v.x;
            }
            if (v.x > maxx) {
                maxx = v.x;
            }
            if (v.y < miny) {
                miny = v.y;
            }
            if (v.y > maxy) {
                maxy = v.y;
            }
            if (v.z < minz) {
                minz = v.z;
            }
            if (!(v.z > maxz)) continue;
            maxz = v.z;
        }
        return new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    Rectangle findScreenBounds(BoundingBox b, Camera cam, MeshViewer view) {
        CoordinateSystem coords = view.getObject().coords;
        Mat4 m = cam.getObjectToWorld();
        cam.setObjectTransform(cam.getViewToWorld());
        Rectangle r = cam.findScreenBounds(b);
        cam.setObjectTransform(m);
        if (r != null) {
            r.setBounds(r.x - 10, r.y - 10, r.width + 20, r.height + 20);
        }
        return r;
    }

    Vec3[] findRotatedPositions(Vec3[] vert, double angle, MeshViewer view) {
        int i;
        Vec3[] v = new Vec3[vert.length];
        int[] selected = view.getSelectionDistance();
        Camera cam = view.getCamera();
        CoordinateSystem coords = view.getDisplayCoordinates();
        Vec3 xdir = cam.getWorldToView().timesDirection(Vec3.vx());
        Vec3 ydir = cam.getWorldToView().timesDirection(Vec3.vy());
        Vec3 zdir = cam.getWorldToView().timesDirection(Vec3.vz());
        if (xdir.cross(ydir).dot(zdir) < 0.0) {
            angle = -angle;
        }
        Mat4 m = coords.fromLocal();
        m = Mat4.translation(-this.rotCenter.x, -this.rotCenter.y, -this.rotCenter.z).times(m);
        Vec3 axis = this.whichAxis == 0 ? cam.getViewToWorld().timesDirection(Vec3.vx()) : (this.whichAxis == 1 ? cam.getViewToWorld().timesDirection(Vec3.vy()) : cam.getViewToWorld().timesDirection(Vec3.vz()));
        m = Mat4.axisRotation(axis, angle).times(m);
        m = Mat4.translation(this.rotCenter.x, this.rotCenter.y, this.rotCenter.z).times(m);
        m = coords.toLocal().times(m);
        for (i = 0; i < vert.length; ++i) {
            v[i] = selected[i] == 0 ? m.times(vert[i]).minus(vert[i]) : new Vec3();
        }
        if (this.theFrame instanceof MeshEditorWindow) {
            ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        }
        for (i = 0; i < vert.length; ++i) {
            v[i].add(vert[i]);
        }
        return v;
    }
}

