/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.TriMeshEditorWindow;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.event.WidgetMouseEvent;
import java.awt.Image;
import java.awt.Point;

public class ReshapeMeshTool
extends EditingTool {
    private Point clickPoint;
    private Vec3 clickPos;
    private Vec3[] baseVertPos;
    private UndoRecord undo;
    private static Image icon;
    private static Image selectedIcon;

    public ReshapeMeshTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("movePoints.gif");
        selectedIcon = this.loadImage("selected/movePoints.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.helpText"));
    }

    public int whichClicks() {
        return 2;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("reshapeMeshTool.tipText");
    }

    public void mousePressedOnHandle(WidgetMouseEvent e, ViewerCanvas view, int obj, int handle) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        this.clickPoint = e.getPoint();
        this.clickPos = v[handle].r;
        this.baseVertPos = mesh.getVertexPositions();
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        MeshViewer mv = (MeshViewer)view;
        Mesh mesh = (Mesh)((Object)mv.getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int size = 5;
        int[] selectDist = mv.getSelectionDistance();
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        Vec3[] v = ReshapeMeshTool.findDraggedPositions(this.clickPos, this.baseVertPos, dx, dy, mv, e.isControlDown(), mv.getSelectionDistance());
        mesh.setVertexPositions(v);
        ((ObjectViewer)view).objectChanged();
        this.theWindow.updateImage();
        Vec3 drag = e.isControlDown() ? view.getCamera().getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : view.getCamera().findDragVector(this.clickPos, dx, dy);
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.dragText", (double)Math.round(drag.x * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.y * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.z * 100000.0) / 100000.0));
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Object3D meshobj = ((MeshViewer)view).getObject().object;
        Mesh mesh = (Mesh)((Object)meshobj);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        if (dx != 0 || dy != 0) {
            if (this.undo != null) {
                this.theWindow.setUndoRecord(this.undo);
            }
            Vec3[] v = ReshapeMeshTool.findDraggedPositions(this.clickPos, this.baseVertPos, dx, dy, (MeshViewer)view, e.isControlDown(), ((MeshViewer)view).getSelectionDistance());
            mesh.setVertexPositions(v);
        }
        meshobj.informChanged(this, "object editor");
        System.out.println("ReshapeMeshTool.mouseReleased informChanged");
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.helpText"));
        this.undo = null;
        this.baseVertPos = null;
    }

    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
        int i;
        int dy;
        int dx;
        Object3D meshobj = ((MeshViewer)view).getObject().object;
        Mesh mesh = (Mesh)((Object)meshobj);
        Vec3[] vert = mesh.getVertexPositions();
        Camera cam = view.getCamera();
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        int key = e.getKeyCode();
        if (key == 38) {
            dx = 0;
            dy = -1;
        } else if (key == 40) {
            dx = 0;
            dy = 1;
        } else if (key == 37) {
            dx = -1;
            dy = 0;
        } else if (key == 39) {
            dx = 1;
            dy = 0;
        } else {
            return;
        }
        for (i = 0; i < vert.length && selectDist[i] != 0; ++i) {
        }
        if (i == vert.length) {
            return;
        }
        if (e.isAltDown()) {
            dx *= 10;
            dy *= 10;
        }
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 13, new Object[]{meshobj, vert}));
        Vec3[] v = ReshapeMeshTool.findDraggedPositions(vert[i], vert, dx, dy, (MeshViewer)view, e.isControlDown(), selectDist);
        mesh.setVertexPositions(v);
        meshobj.informChanged(this, "object editor");
    }

    public static Vec3[] findDraggedPositions(Vec3 pos, Vec3[] vert, int dx, int dy, MeshViewer view, boolean controlDown) {
        return ReshapeMeshTool.findDraggedPositions(pos, vert, dx, dy, view, controlDown, view.getSelectionDistance());
    }

    public static Vec3[] findDraggedPositions(Vec3 pos, Vec3[] vert, int dx, int dy, MeshViewer view, boolean controlDown, int[] selectDist) {
        int i;
        int maxDistance = TriMeshEditorWindow.getTensionDistance();
        double tension = TriMeshEditorWindow.getMeshTension();
        Vec3[] drag = new Vec3[maxDistance + 1];
        Vec3[] v = new Vec3[vert.length];
        drag[0] = controlDown ? view.getCamera().getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : view.getCamera().findDragVector(pos, dx, dy);
        for (i = 1; i <= maxDistance; ++i) {
            drag[i] = drag[0].times(Math.pow(((double)(maxDistance - i) + 1.0) / ((double)maxDistance + 1.0), tension));
        }
        if (view.getUseWorldCoords()) {
            Mat4 trans = view.getDisplayCoordinates().toLocal();
            for (int i2 = 0; i2 < drag.length; ++i2) {
                trans.transformDirection(drag[i2]);
            }
        }
        for (i = 0; i < vert.length; ++i) {
            v[i] = selectDist[i] > -1 ? vert[i].plus(drag[selectDist[i]]) : new Vec3(vert[i]);
        }
        return v;
    }
}

