/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.RenderingTriangle;
import artofillusion.material.MaterialMapping;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.TextureMapping;

public class RenderingMesh {
    public Vec3[] vert;
    public Vec3[] norm;
    public Vec3[] faceNorm;
    public ParameterValue[] param;
    public double[] paramTemp;
    public RenderingTriangle[] triangle;
    public TextureMapping mapping;
    public MaterialMapping matMapping;

    public RenderingMesh(Vec3[] vert, Vec3[] norm, RenderingTriangle[] triangle, TextureMapping mapping, MaterialMapping matMapping) {
        int i;
        this.vert = vert;
        this.norm = norm;
        this.triangle = triangle;
        this.mapping = mapping;
        this.matMapping = matMapping;
        this.faceNorm = new Vec3[triangle.length];
        for (i = 0; i < triangle.length; ++i) {
            this.faceNorm[i] = vert[triangle[i].v2].minus(vert[triangle[i].v1]).cross(vert[triangle[i].v3].minus(vert[triangle[i].v1]));
            double length = this.faceNorm[i].length();
            if (length > 0.0) {
                this.faceNorm[i].scale(1.0 / length);
            }
            triangle[i].setMesh(this, i);
        }
        int j = 0;
        for (i = 0; i < triangle.length; ++i) {
            if (norm[triangle[i].n1] != null && norm[triangle[i].n2] != null && norm[triangle[i].n3] != null) continue;
            ++j;
        }
        if (j == 0) {
            return;
        }
        Vec3[] newNorm = new Vec3[norm.length + j];
        for (i = 0; i < norm.length; ++i) {
            newNorm[i] = norm[i];
        }
        j = norm.length;
        for (i = 0; i < triangle.length; ++i) {
            if (norm[triangle[i].n1] != null && norm[triangle[i].n2] != null && norm[triangle[i].n3] != null) continue;
            newNorm[j] = this.faceNorm[i];
            if (norm[triangle[i].n1] == null) {
                triangle[i].n1 = j;
            }
            if (norm[triangle[i].n2] == null) {
                triangle[i].n2 = j;
            }
            if (norm[triangle[i].n3] == null) {
                triangle[i].n3 = j;
            }
            ++j;
        }
        this.norm = newNorm;
    }

    public void setParameters(ParameterValue[] param) {
        this.param = param;
        if (param == null) {
            this.paramTemp = new double[0];
            return;
        }
        this.paramTemp = new double[param.length];
        double[] val1 = new double[param.length];
        double[] val2 = new double[param.length];
        double[] val3 = new double[param.length];
        for (int i = 0; i < this.triangle.length; ++i) {
            RenderingTriangle tri = this.triangle[i];
            for (int j = param.length - 1; j >= 0; --j) {
                val1[j] = param[j].getValue(i, tri.v1, tri.v2, tri.v3, 1.0, 0.0, 0.0);
                val2[j] = param[j].getValue(i, tri.v1, tri.v2, tri.v3, 0.0, 1.0, 0.0);
                val3[j] = param[j].getValue(i, tri.v1, tri.v2, tri.v3, 0.0, 0.0, 1.0);
            }
            this.mapping.setParameters(tri, val1, val2, val3, this);
        }
    }

    public void transformMesh(Mat4 trans) {
        int i;
        for (i = 0; i < this.vert.length; ++i) {
            this.vert[i] = trans.times(this.vert[i]);
        }
        for (i = 0; i < this.norm.length; ++i) {
            if (this.norm[i] == null) continue;
            this.norm[i] = trans.timesDirection(this.norm[i]);
        }
        for (i = 0; i < this.faceNorm.length; ++i) {
            this.faceNorm[i] = trans.timesDirection(this.faceNorm[i]);
        }
    }
}

