/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.image.ImageAverager;
import artofillusion.image.ImageSaver;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.RepaintEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BScrollPane;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;

public class RenderingDialog
extends BDialog
implements RenderListener {
    private CustomWidget canvas;
    private Image previewImage;
    private ComplexImage theImage;
    private Renderer renderer;
    private Scene theScene;
    private ObjectInfo sceneCamera;
    private Camera theCamera;
    private double start;
    private double end;
    private double originalTime;
    private ImageSaver imgsaver;
    private ImageAverager imgaverager;
    private BButton closeButton;
    private BButton saveButton;
    private BLabel label1;
    private BLabel label2;
    private BFrame parent;
    private int w;
    private int h;
    private int fps;
    private int subimages;
    private int currentFrame;
    private int currentSubimage;
    private int totalFrames;
    private long startTime;
    private boolean done;

    public RenderingDialog(BFrame parent, Renderer rend, Scene sc, Camera cam, ObjectInfo sceneCamera) {
        super(parent, true);
        this.parent = parent;
        this.sceneCamera = sceneCamera;
        this.renderer = rend;
        this.theScene = sc;
        this.layoutDialog(parent, cam);
        this.startTime = System.currentTimeMillis();
        SceneCamera scm = (SceneCamera)sceneCamera.object;
        rend.renderScene(sc, cam, this, scm);
        this.setVisible(true);
    }

    public RenderingDialog(BFrame parent, Renderer rend, Scene sc, Camera cam, ObjectInfo sceneCamera, double start, double end, int fps, int subimages, ImageSaver imgsaver) {
        super(parent, true);
        this.parent = parent;
        this.renderer = rend;
        this.theScene = sc;
        this.theCamera = cam;
        this.sceneCamera = sceneCamera;
        this.start = start;
        this.end = end;
        this.fps = fps;
        this.subimages = subimages;
        this.imgsaver = imgsaver;
        this.originalTime = this.theScene.getTime();
        this.totalFrames = (int)Math.ceil((end - start) * (double)fps);
        if (this.totalFrames <= 0) {
            this.totalFrames = 1;
        }
        if (subimages > 1) {
            this.imgaverager = new ImageAverager(this.theCamera.getSize().width, this.theCamera.getSize().height);
        }
        this.layoutDialog(parent, cam);
        this.startTime = System.currentTimeMillis();
        sc.setTime(start);
        this.theCamera.setCameraCoordinates(sceneCamera.coords.duplicate());
        SceneCamera scm = (SceneCamera)sceneCamera.object;
        this.theCamera.setDistToScreen((double)this.h / 200.0 / Math.tan(scm.getFieldOfView() * Math.PI / 360.0));
        rend.renderScene(sc, this.theCamera, this, scm);
        this.setVisible(true);
    }

    private void layoutDialog(BFrame parent, Camera cam) {
        Dimension dim = cam.getSize();
        this.w = dim.width;
        this.h = dim.height;
        this.setFont(parent.getFont());
        FormContainer content = new FormContainer(new double[]{1.0, 0.0}, new double[]{0.0, 0.0, 1.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        this.label1 = new BLabel(Translate.text("Rendering", "..."));
        content.add(this.label1, 0, 0);
        this.label2 = new BLabel(Translate.text("elapsedTime", "0:00"));
        content.add(this.label2, 0, 1);
        this.closeButton = Translate.button("cancel", this, "doCancel");
        content.add(this.closeButton, 1, 0);
        this.saveButton = Translate.button("save", this, "doSave");
        content.add(this.saveButton, 1, 1);
        this.saveButton.setVisible(false);
        this.canvas = new CustomWidget();
        this.canvas.setPreferredSize(new Dimension(this.w, this.h));
        this.canvas.addEventLink(RepaintEvent.class, (Object)this, "paintCanvas");
        BScrollPane sp = new BScrollPane(this.canvas);
        content.add(sp, 0, 2, 2, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.pack();
        UIUtilities.centerWindow(this);
    }

    private void doCancel() {
        this.done = true;
        this.renderer.cancelRendering(this.theScene);
        if (this.imgsaver != null) {
            this.theScene.setTime(this.originalTime);
            this.imgsaver.lastMovieImage();
        }
        this.dispose();
    }

    private void doSave() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ImageSaver saver = new ImageSaver(this.parent);
        if (saver.clickedOk()) {
            saver.saveImage(this.theImage);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void paintCanvas(RepaintEvent ev) {
        if (this.previewImage != null) {
            ev.getGraphics().drawImage(this.previewImage, 0, 0, null);
        }
    }

    private void updateTimeLabel() {
        int sec = (int)((System.currentTimeMillis() - this.startTime) / 1000L);
        int hour = sec / 3600;
        int min = (sec -= 3600 * hour) / 60;
        sec -= 60 * min;
        if (hour == 0) {
            this.label2.setText(Translate.text("elapsedTime", min + ":" + (sec < 10 ? "0" : "") + sec));
        } else {
            this.label2.setText(Translate.text("elapsedTime", hour + ":" + (min < 10 ? "0" : "") + min + ":" + (sec < 10 ? "0" : "") + sec));
        }
    }

    public void imageUpdated(Image image) {
        this.previewImage = image;
        this.canvas.repaint();
        this.updateTimeLabel();
    }

    public void statusChanged(String status) {
        if (this.imgsaver != null) {
            String current = Integer.toString(this.currentFrame + 1);
            String total = Integer.toString(this.totalFrames);
            if (this.subimages > 1) {
                this.label1.setText(Translate.text("renderSubimageLabel", new String[]{current, total, Integer.toString(this.currentSubimage + 1), status}));
            } else {
                this.label1.setText(Translate.text("renderFrameLabel", new String[]{current, total, status}));
            }
        } else {
            this.label1.setText(status + "...");
        }
        this.updateTimeLabel();
    }

    public void imageComplete(ComplexImage image) {
        SceneCamera sc = (SceneCamera)this.sceneCamera.object;
        if (sc.getImageFilters().length > 0) {
            this.statusChanged(Translate.text("applyingFilters"));
            sc.applyImageFilters(image, this.theScene, this.sceneCamera.coords);
        }
        this.theImage = image;
        this.previewImage = this.theImage.getImage();
        this.canvas.repaint();
        if (this.imgsaver != null) {
            this.nextFrame();
        }
        if (this.currentFrame == this.totalFrames) {
            this.done = true;
            if (this.imgsaver != null) {
                this.imgsaver.lastMovieImage();
            }
            this.label1.setText(Translate.text("doneRendering"));
            this.closeButton.setText(Translate.text("button.close"));
            this.saveButton.setVisible(this.imgsaver == null);
        }
        this.pack();
        this.updateTimeLabel();
    }

    public void renderingCanceled() {
        this.dispose();
    }

    private void nextFrame() {
        if (this.done) {
            return;
        }
        this.statusChanged(Translate.text("Saving"));
        if (this.imgaverager != null) {
            this.imgaverager.addImage(this.theImage);
            ++this.currentSubimage;
            if (this.currentSubimage == this.subimages) {
                this.imgsaver.saveImage(this.imgaverager.getAverageImage());
                this.imgaverager.clear();
                this.currentSubimage = 0;
                ++this.currentFrame;
                if (this.currentFrame == this.totalFrames) {
                    return;
                }
            }
        } else {
            this.imgsaver.saveImage(this.theImage);
            ++this.currentFrame;
        }
        this.theScene.setTime(this.start + (double)(this.currentFrame * this.subimages + this.currentSubimage) / (double)(this.fps * this.subimages));
        this.theCamera.setCameraCoordinates(this.sceneCamera.coords.duplicate());
        SceneCamera scm = (SceneCamera)this.sceneCamera.object;
        this.theCamera.setDistToScreen((double)this.h / 200.0 / Math.tan(scm.getFieldOfView() * Math.PI / 360.0));
        this.renderer.renderScene(this.theScene, this.theCamera, this, scm);
        this.statusChanged(Translate.text("Rendering"));
    }
}

