/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.Renderer;
import artofillusion.RenderingDialog;
import artofillusion.Scene;
import artofillusion.image.ImageSaver;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BRadioButton;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RadioButtonGroup;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Panel;
import java.util.Vector;

public class RenderSetupDialog {
    private BFrame parent;
    private Renderer[] renderers;
    private ObjectInfo[] cameras;
    private Scene theScene;
    private BComboBox rendChoice;
    private BComboBox camChoice;
    private BRadioButton singleBox;
    private BRadioButton movieBox;
    private RadioButtonGroup movieGroup;
    private ValueField widthField;
    private ValueField heightField;
    private ValueField startField;
    private ValueField endField;
    private ValueField fpsField;
    private ValueField subimagesField;
    private Widget configPanel;
    private BorderContainer content;
    static Renderer currentRenderer;
    static int currentCamera;
    static int width;
    static int height;
    static int fps;
    static int subimages;
    static double startTime;
    static double endTime;
    static boolean movie;

    public RenderSetupDialog(BFrame parent, Scene theScene) {
        this(parent, theScene, false);
    }

    public RenderSetupDialog(BFrame parent, Scene theScene, boolean immediate) {
        ObjectInfo obj;
        int i;
        this.parent = parent;
        this.theScene = theScene;
        this.renderers = ModellingApp.getRenderers();
        int count = 0;
        for (i = 0; i < theScene.getNumObjects(); ++i) {
            obj = theScene.getObject(i);
            if (!(obj.object instanceof SceneCamera)) continue;
            ++count;
        }
        if (count == 0) {
            new BStandardDialog("", Translate.text("noCameraError"), BStandardDialog.ERROR).showMessageDialog(parent);
            return;
        }
        if (count <= currentCamera) {
            currentCamera = 0;
        }
        this.cameras = new ObjectInfo[count];
        count = 0;
        for (i = 0; i < theScene.getNumObjects(); ++i) {
            obj = theScene.getObject(i);
            if (!(obj.object instanceof SceneCamera)) continue;
            this.cameras[count++] = obj;
        }
        if (currentRenderer == null) {
            currentRenderer = ModellingApp.getPreferences().getDefaultRenderer();
        }
        this.showDialog();
        if (immediate && currentRenderer != null) {
            this.startRendering();
            return;
        }
    }

    private void showDialog() {
        int i;
        this.content = new BorderContainer();
        Panel p = new Panel();
        GridBagConstraints c = new GridBagConstraints();
        FormContainer top = new FormContainer(4, 5);
        top.setDefaultLayout(new LayoutInfo(LayoutInfo.EAST, LayoutInfo.HORIZONTAL, new Insets(0, 0, 0, 5), null));
        top.add(new BLabel(Translate.text("Width") + ":"), 0, 0);
        top.add(new BLabel(Translate.text("Height") + ":"), 0, 1);
        top.add(new BLabel(Translate.text("Render") + ":"), 0, 2);
        top.add(new BLabel(Translate.text("StartTime") + ":"), 0, 3);
        top.add(new BLabel(Translate.text("EndTime") + ":"), 0, 4);
        this.widthField = new ValueField((double)width, 7);
        top.add(this.widthField, 1, 0);
        this.heightField = new ValueField((double)height, 7);
        top.add(this.heightField, 1, 1);
        this.movieGroup = new RadioButtonGroup();
        this.movieGroup.addEventLink(SelectionChangedEvent.class, (Object)this, "enableMovieComponents");
        this.singleBox = new BRadioButton("Single Image", !movie, this.movieGroup);
        top.add(this.singleBox, 1, 2);
        this.startField = new ValueField(startTime, 0);
        top.add(this.startField, 1, 3);
        this.endField = new ValueField(endTime, 0);
        top.add(this.endField, 1, 4);
        top.add(new BLabel(Translate.text("Renderer") + ":"), 2, 0);
        top.add(new BLabel(Translate.text("Camera") + ":"), 2, 1);
        this.movieBox = new BRadioButton("Movie", movie, this.movieGroup);
        top.add(this.movieBox, 2, 2);
        top.add(new BLabel(Translate.text("FramesPerSec") + ":"), 2, 3);
        top.add(new BLabel(Translate.text("ImagesPerFrame") + ":"), 2, 4);
        this.rendChoice = new BComboBox();
        top.add(this.rendChoice, 3, 0);
        for (i = 0; i < this.renderers.length; ++i) {
            this.rendChoice.add(this.renderers[i].getName());
        }
        this.rendChoice.setSelectedValue(currentRenderer.getName());
        this.rendChoice.addEventLink(ValueChangedEvent.class, (Object)this, "rendererChanged");
        this.camChoice = new BComboBox();
        top.add(this.camChoice, 3, 1);
        for (i = 0; i < this.cameras.length; ++i) {
            this.camChoice.add(this.cameras[i].name);
        }
        this.camChoice.setSelectedIndex(currentCamera);
        this.fpsField = new ValueField(fps, 7);
        top.add(this.fpsField, 3, 3);
        this.subimagesField = new ValueField(subimages, 7);
        top.add(this.subimagesField, 3, 4);
        this.enableMovieComponents();
        this.content.add(top, BorderContainer.NORTH);
        this.content.add(currentRenderer.getConfigPanel(), BorderContainer.CENTER, new LayoutInfo());
        this.enableMovieComponents();
        PanelDialog dlg = new PanelDialog((WindowWidget)this.parent, Translate.text("renderTitle"), this.content);
        this.content.remove(BorderContainer.CENTER);
        if (dlg.clickedOk()) {
            this.doRender();
        }
    }

    private void doRender() {
        width = (int)this.widthField.getValue();
        height = (int)this.heightField.getValue();
        movie = this.movieBox.getState();
        startTime = this.startField.getValue();
        endTime = this.endField.getValue();
        fps = (int)this.fpsField.getValue();
        subimages = (int)this.subimagesField.getValue();
        currentCamera = this.camChoice.getSelectedIndex();
        if (currentRenderer.recordConfiguration()) {
            Camera cam = new Camera();
            SceneCamera sc = (SceneCamera)this.cameras[RenderSetupDialog.currentCamera].object;
            cam.setCameraCoordinates(this.cameras[RenderSetupDialog.currentCamera].coords.duplicate());
            cam.setSize(width, height);
            cam.setDistToScreen((double)height / 200.0 / Math.tan(sc.getFieldOfView() * Math.PI / 360.0));
            if (movie) {
                ImageSaver saver = new ImageSaver(this.parent, width, height, fps);
                if (!saver.clickedOk()) {
                    return;
                }
                new RenderingDialog(this.parent, currentRenderer, this.theScene, cam, this.cameras[currentCamera], startTime, endTime, fps, subimages, saver);
            } else {
                new RenderingDialog(this.parent, currentRenderer, this.theScene, cam, this.cameras[currentCamera]);
            }
        }
    }

    public void startRendering() {
        Camera cam = new Camera();
        System.out.println("cameras " + this.cameras);
        System.out.println("cameras[currentCamera] " + this.cameras[currentCamera]);
        SceneCamera sc = (SceneCamera)this.cameras[RenderSetupDialog.currentCamera].object;
        cam.setCameraCoordinates(this.cameras[RenderSetupDialog.currentCamera].coords.duplicate());
        cam.setSize(width, height);
        cam.setDistToScreen((double)height / 200.0 / Math.tan(sc.getFieldOfView() * Math.PI / 360.0));
        if (movie) {
            ImageSaver saver = new ImageSaver(this.parent, width, height, fps);
            if (!saver.clickedOk()) {
                return;
            }
            new RenderingDialog(this.parent, currentRenderer, this.theScene, cam, this.cameras[currentCamera], startTime, endTime, fps, subimages, saver);
        } else {
            new RenderingDialog(this.parent, currentRenderer, this.theScene, cam, this.cameras[currentCamera]);
        }
    }

    public static void renderImmediately(BFrame parent, Scene theScene) {
        Vector<ObjectInfo> cameras = new Vector<ObjectInfo>();
        for (int i = 0; i < theScene.getNumObjects(); ++i) {
            if (!(theScene.getObject((int)i).object instanceof SceneCamera)) continue;
            cameras.addElement(theScene.getObject(i));
        }
        if (cameras.size() == 0) {
            new BStandardDialog("", Translate.text("noCameraError"), BStandardDialog.ERROR).showMessageDialog(parent);
            return;
        }
        if (cameras.size() <= currentCamera) {
            currentCamera = 0;
        }
        if (currentRenderer == null) {
            currentRenderer = ModellingApp.getPreferences().getDefaultRenderer();
        }
        currentRenderer.getConfigPanel();
        currentRenderer.recordConfiguration();
        Camera cam = new Camera();
        ObjectInfo cameraInfo = (ObjectInfo)cameras.elementAt(currentCamera);
        SceneCamera sc = (SceneCamera)cameraInfo.object;
        cam.setCameraCoordinates(cameraInfo.coords.duplicate());
        cam.setSize(width, height);
        cam.setDistToScreen((double)height / 200.0 / Math.tan(sc.getFieldOfView() * Math.PI / 360.0));
        new RenderingDialog(parent, currentRenderer, theScene, cam, cameraInfo);
    }

    private void rendererChanged() {
        this.content.remove(BorderContainer.CENTER);
        currentRenderer = this.renderers[this.rendChoice.getSelectedIndex()];
        this.content.add(currentRenderer.getConfigPanel(), BorderContainer.CENTER, new LayoutInfo());
        UIUtilities.findWindow(this.content).pack();
    }

    private void enableMovieComponents() {
        boolean enable = this.movieBox.getState();
        this.startField.setEnabled(enable);
        this.endField.setEnabled(enable);
        this.fpsField.setEnabled(enable);
        this.subimagesField.setEnabled(enable);
    }

    static {
        currentCamera = 0;
        width = 400;
        height = 300;
        fps = 30;
        subimages = 1;
        startTime = 0.0;
        endTime = 1.0;
    }
}

