/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ApplicationPreferences;
import artofillusion.ModellingApp;
import artofillusion.Renderer;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import java.util.Locale;

public class PreferencesWindow {
    public PreferencesWindow(BFrame parent) {
        ApplicationPreferences prefs = ModellingApp.getPreferences();
        BComboBox defaultRendChoice = this.getRendererChoice(prefs.getDefaultRenderer());
        BComboBox objectRendChoice = this.getRendererChoice(prefs.getObjectPreviewRenderer());
        BComboBox texRendChoice = this.getRendererChoice(prefs.getTexturePreviewRenderer());
        BComboBox liveRendChoice = this.getRendererChoice(prefs.getLiveRenderer());
        ValueField interactiveTolField = new ValueField(prefs.getInteractiveSurfaceError(), 3);
        ValueField undoField = new ValueField(prefs.getUndoLevels(), 7);
        BCheckBox objectSceneAutosyncCheckbox = new BCheckBox("", prefs.getObjectSceneAutosync());
        BComboBox displayChoice = new BComboBox(new String[]{Translate.text("menu.wireframeDisplay"), Translate.text("menu.shadedDisplay"), Translate.text("menu.smoothDisplay"), Translate.text("menu.texturedDisplay")});
        displayChoice.setSelectedIndex(prefs.getDefaultDisplayMode());
        BComboBox localeChoice = new BComboBox();
        Locale[] languages = Translate.getAvailableLocales();
        for (int i = 0; i < languages.length; ++i) {
            localeChoice.add(languages[i].getDisplayName(prefs.getLocale()));
            if (!prefs.getLocale().equals(languages[i])) continue;
            localeChoice.setSelectedIndex(i);
        }
        boolean done = false;
        while (!done) {
            ComponentsDialog dlg = new ComponentsDialog(parent, Translate.text("prefsTitle"), new Widget[]{defaultRendChoice, objectRendChoice, texRendChoice, liveRendChoice, displayChoice, interactiveTolField, undoField, localeChoice, objectSceneAutosyncCheckbox}, new String[]{Translate.text("defaultRenderer"), Translate.text("objPreviewRenderer"), Translate.text("texPreviewRenderer"), Translate.text("liveRenderer"), Translate.text("defaultDisplayMode"), Translate.text("interactiveSurfError"), Translate.text("maxUndoLevels"), Translate.text("language"), "Sync object editors with scene"});
            if (!dlg.clickedOk()) {
                return;
            }
            done = true;
            if (!(interactiveTolField.getValue() < 0.01)) continue;
            String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
            int choice = new BStandardDialog("", Translate.text("lowSurfErrorWarning"), BStandardDialog.WARNING).showOptionDialog(parent, options, options[0]);
            if (choice != 1) continue;
            done = false;
        }
        Renderer[] renderers = ModellingApp.getRenderers();
        if (renderers.length > 0) {
            prefs.setDefaultRenderer(renderers[defaultRendChoice.getSelectedIndex()]);
            prefs.setObjectPreviewRenderer(renderers[objectRendChoice.getSelectedIndex()]);
            prefs.setTexturePreviewRenderer(renderers[texRendChoice.getSelectedIndex()]);
            prefs.setLiveRenderer(renderers[liveRendChoice.getSelectedIndex()]);
        }
        prefs.setDefaultDisplayMode(displayChoice.getSelectedIndex());
        prefs.setInteractiveSurfaceError(interactiveTolField.getValue());
        prefs.setUndoLevels((int)undoField.getValue());
        if (!prefs.getLocale().equals(languages[localeChoice.getSelectedIndex()])) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("languageChangedWarning")), BStandardDialog.INFORMATION).showMessageDialog(parent);
        }
        prefs.setLocale(languages[localeChoice.getSelectedIndex()]);
        prefs.setObjectSceneAutosync(objectSceneAutosyncCheckbox.getState());
        prefs.savePreferences();
    }

    private BComboBox getRendererChoice(Renderer selected) {
        Renderer[] renderers = ModellingApp.getRenderers();
        BComboBox c = new BComboBox();
        for (int i = 0; i < renderers.length; ++i) {
            c.add(renderers[i].getName());
        }
        if (selected != null) {
            c.setSelectedValue(selected.getName());
        }
        return c;
    }
}

