/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayoutWindow;
import artofillusion.ListChangeListener;
import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.TextureMappingDialog;
import artofillusion.TextureParameter;
import artofillusion.TexturesDialog;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.MouseClickedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Insets;

public class ObjectTextureDialog
extends BDialog
implements ListChangeListener {
    private BFrame fr;
    private Scene sc;
    private ObjectInfo[] obj;
    private ObjectInfo editObj;
    private BList texList;
    private BList layerList;
    private BButton mapButton;
    private BButton addLayerButton;
    private BButton deleteLayerButton;
    private BButton moveUpButton;
    private BButton moveDownButton;
    private BButton newTextureButton;
    private BButton editTexturesButton;
    private BorderContainer content;
    private FormContainer listPanel;
    private FormContainer layerPanel;
    private FormContainer paramsPanel;
    private MaterialPreviewer preview;
    private BComboBox typeChoice;
    private BComboBox blendChoice;
    private BComboBox[] paramTypeChoice;
    private Widget[] paramValueWidget;
    private int[] fieldParamIndex;
    private BScrollPane paramsScroller;
    private BLabel paramsLabel;
    private Runnable callback;
    private Texture oldTexture;
    private TextureMapping oldMapping;
    private LayeredTexture layeredTex;
    private LayeredMapping layeredMap;
    private ActionProcessor renderProcessor;
    private static final int CONSTANT_PARAM = 0;
    private static final int VERTEX_PARAM = 1;
    private static final int FACE_PARAM = 2;
    private static final int FACE_VERTEX_PARAM = 3;
    private static final String[] PARAM_TYPE_NAME = new String[]{Translate.text("Object"), Translate.text("Vertex"), Translate.text("Face"), Translate.text("Face-Vertex")};

    public ObjectTextureDialog(BFrame parent, Scene theScene, ObjectInfo[] objects) {
        super(parent, Translate.text("objectTextureTitle"), false);
        this.fr = parent;
        this.sc = theScene;
        this.obj = objects;
        this.renderProcessor = new ActionProcessor();
        this.editObj = this.obj[0].duplicate();
        this.editObj.object = this.editObj.object.duplicate();
        this.oldTexture = this.editObj.object.getTexture();
        this.oldMapping = this.editObj.object.getTextureMapping();
        if (this.oldTexture instanceof LayeredTexture) {
            this.layeredMap = (LayeredMapping)this.oldMapping;
            this.layeredTex = (LayeredTexture)this.oldTexture;
        } else {
            this.layeredTex = new LayeredTexture();
            this.layeredMap = (LayeredMapping)this.layeredTex.getDefaultMapping();
        }
        this.content = new BorderContainer();
        this.setContent(BOutline.createEmptyBorder(this.content, ModellingApp.standardDialogInsets));
        FormContainer northPanel = new FormContainer(1, 2);
        String title = this.obj.length == 1 ? Translate.text("chooseTextureForSingle", this.obj[0].name) : Translate.text("chooseTextureForMultiple");
        northPanel.add(new BLabel(title), 0, 0);
        RowContainer typeRow = new RowContainer();
        typeRow.add(Translate.label("Type"));
        this.typeChoice = new BComboBox(new String[]{Translate.text("simpleTexture"), Translate.text("layeredTexture")});
        typeRow.add(this.typeChoice);
        this.typeChoice.setSelectedIndex(this.oldTexture instanceof LayeredTexture ? 1 : 0);
        this.typeChoice.addEventLink(ValueChangedEvent.class, (Object)this, "typeChanged");
        if (this.obj.length == 1) {
            northPanel.add(typeRow, 0, 1);
        }
        this.content.add(northPanel, BorderContainer.NORTH);
        this.texList = new BList();
        this.texList.setMultipleSelectionEnabled(false);
        this.buildList();
        this.texList.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        this.texList.addEventLink(MouseClickedEvent.class, (Object)this, "textureClicked");
        this.listPanel = new FormContainer(new double[]{1.0}, new double[]{1.0, 0.0});
        this.listPanel.add(UIUtilities.createScrollingList(this.texList), 0, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        RowContainer texButtonRow = new RowContainer();
        this.newTextureButton = Translate.button("newTexture", this, "doNewTexture");
        texButtonRow.add(this.newTextureButton);
        this.editTexturesButton = Translate.button("textures", this, "doEditTextures");
        texButtonRow.add(this.editTexturesButton);
        this.listPanel.add(texButtonRow, 0, 1);
        this.layerPanel = new FormContainer(new double[]{1.0, 1.0, 1.0}, new double[]{0.0, 0.0, 0.0, 0.0, 1.0});
        this.layerPanel.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        this.addLayerButton = Translate.button("add", " >>", this, "doAddLayer");
        this.layerPanel.add(this.addLayerButton, 0, 0);
        this.deleteLayerButton = Translate.button("delete", this, "doDeleteLayer");
        this.layerPanel.add(this.deleteLayerButton, 0, 1);
        this.moveUpButton = Translate.button("moveUp", this, "doMoveLayerUp");
        this.layerPanel.add(this.moveUpButton, 0, 2);
        this.moveDownButton = Translate.button("moveDown", this, "doMoveLayerDown");
        this.layerPanel.add(this.moveDownButton, 0, 3);
        this.layerList = new BList(){

            public Dimension getPreferredSize() {
                return ObjectTextureDialog.this.texList.getPreferredSize();
            }
        };
        this.layerList.setMultipleSelectionEnabled(false);
        this.layerList.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        for (int i = 0; i < this.layeredMap.getLayers().length; ++i) {
            this.layerList.add(this.layeredMap.getLayers()[i].getName());
        }
        this.layerPanel.add(UIUtilities.createScrollingList(this.layerList), 1, 0, 1, 4, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.layerPanel.add(Translate.label("blendingMode"), 2, 0);
        this.blendChoice = new BComboBox(new String[]{Translate.text("blend"), Translate.text("overlay"), Translate.text("overlayBumpsAdd")});
        this.blendChoice.addEventLink(ValueChangedEvent.class, (Object)this, "blendTypeChanged");
        this.layerPanel.add(this.blendChoice, 2, 1);
        if (this.oldTexture instanceof LayeredTexture) {
            this.preview = new MaterialPreviewer(this.layeredTex, this.editObj.object.getMaterial(), 160, 160);
            this.preview.setTexture(this.layeredTex, this.layeredMap);
        } else {
            this.preview = new MaterialPreviewer(this.oldTexture, this.editObj.object.getMaterial(), 160, 160);
            this.preview.setTexture(this.oldTexture, this.oldMapping);
        }
        this.preview.setMaterial(this.editObj.object.getMaterial(), this.editObj.object.getMaterialMapping());
        double[] paramAvgVal = this.editObj.object.getAverageParameterValues();
        ParameterValue[] paramValue = new ParameterValue[paramAvgVal.length];
        for (int i = 0; i < paramValue.length; ++i) {
            paramValue[i] = new ConstantParameterValue(paramAvgVal[i]);
        }
        this.preview.getObject().object.setParameterValues(paramValue);
        RowContainer buttons = new RowContainer();
        this.content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
        this.mapButton = Translate.button("editMapping", this, "doEditMapping");
        buttons.add(this.mapButton);
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "doCancel"));
        this.paramsPanel = new FormContainer(1, 2);
        this.paramsPanel.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.paramsPanel.add(Translate.label("textureParameters"), 0, 0);
        this.paramsScroller = new BScrollPane();
        this.paramsPanel.add(BOutline.createBevelBorder(this.paramsScroller, false), 0, 1);
        this.paramsScroller.setPreferredViewSize(new Dimension(300, 80));
        this.buildParamList();
        if (this.oldTexture instanceof LayeredTexture) {
            this.layoutLayered();
        } else {
            this.layoutSimple();
        }
        this.pack();
        this.setResizable(false);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "dispose");
        UIUtilities.centerWindow(this);
        this.updateComponents();
        this.sc.addTextureListener(this);
        this.setVisible(true);
    }

    public void dispose() {
        this.sc.removeTextureListener(this);
        this.renderProcessor.stopProcessing();
        super.dispose();
    }

    public void setCallback(Runnable cb) {
        this.callback = cb;
    }

    private void layoutSimple() {
        this.content.remove(BorderContainer.CENTER);
        FormContainer center = new FormContainer(2, 2);
        center.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        center.add(this.listPanel, 0, 0);
        center.add(this.preview, 1, 0, new LayoutInfo());
        center.add(this.paramsPanel, 0, 1, 2, 1);
        this.content.add(center, BorderContainer.CENTER);
    }

    private void layoutLayered() {
        this.content.remove(BorderContainer.CENTER);
        FormContainer center = new FormContainer(new double[]{1.0, 1.0, 0.0}, new double[]{1.0, 1.0});
        center.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        center.add(this.listPanel, 0, 0);
        center.add(this.layerPanel, 1, 0, 2, 1);
        center.add(this.paramsPanel, 0, 1, 2, 1);
        center.add(this.preview, 2, 1, new LayoutInfo());
        this.content.add(center, BorderContainer.CENTER);
    }

    private void buildList() {
        this.texList.removeAll();
        for (int i = 0; i < this.sc.getNumTextures(); ++i) {
            this.texList.add(this.sc.getTexture(i).getName());
            if (this.editObj.object.getTexture() != this.sc.getTexture(i)) continue;
            this.texList.setSelected(i, true);
        }
    }

    private void buildParamList() {
        int index;
        TextureParameter[] params = this.editObj.object.getTexture() instanceof LayeredTexture ? ((index = this.layerList.getSelectedIndex()) == -1 ? new TextureParameter[]{} : ((LayeredMapping)this.editObj.object.getTextureMapping()).getLayerParameters(index)) : this.editObj.object.getParameters();
        this.paramTypeChoice = new BComboBox[params.length];
        this.paramValueWidget = new Widget[params.length];
        this.fieldParamIndex = new int[params.length];
        FormContainer paramsContainer = new FormContainer(3, params.length);
        paramsContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
        final TextureParameter[] texParam = this.editObj.object.getParameters();
        final ParameterValue[] paramValue = this.editObj.object.getParameterValues();
        for (int i = 0; i < params.length; ++i) {
            int j;
            if (params[i].type != 0) continue;
            boolean perObject = true;
            double val = params[i].defaultVal;
            for (j = 0; j < texParam.length; ++j) {
                if (!params[i].equals(texParam[j])) continue;
                val = paramValue[j].getAverageValue();
                perObject = paramValue[j] instanceof ConstantParameterValue;
                break;
            }
            final int whichParam = j;
            final int whichField = i;
            this.fieldParamIndex[i] = j;
            paramsContainer.add(new BLabel(params[i].name), 0, i);
            this.paramTypeChoice[i] = new BComboBox();
            paramsContainer.add(this.paramTypeChoice[i], 1, i);
            this.paramTypeChoice[i].add(PARAM_TYPE_NAME[0]);
            if (this.editObj.object.supportsParameterType(class$artofillusion$texture$VertexParameterValue == null ? ObjectTextureDialog.class$("artofillusion.texture.VertexParameterValue") : class$artofillusion$texture$VertexParameterValue)) {
                this.paramTypeChoice[i].add(PARAM_TYPE_NAME[1]);
            }
            if (this.editObj.object.supportsParameterType(class$artofillusion$texture$FaceParameterValue == null ? ObjectTextureDialog.class$("artofillusion.texture.FaceParameterValue") : class$artofillusion$texture$FaceParameterValue)) {
                this.paramTypeChoice[i].add(PARAM_TYPE_NAME[2]);
            }
            if (this.editObj.object.supportsParameterType(class$artofillusion$texture$FaceVertexParameterValue == null ? ObjectTextureDialog.class$("artofillusion.texture.FaceVertexParameterValue") : class$artofillusion$texture$FaceVertexParameterValue)) {
                this.paramTypeChoice[i].add(PARAM_TYPE_NAME[3]);
            }
            if (whichParam < paramValue.length) {
                this.paramTypeChoice[i].setSelectedValue(PARAM_TYPE_NAME[this.parameterTypeCode(paramValue[whichParam].getClass())]);
            }
            this.paramTypeChoice[i].addEventLink(class$buoy$event$ValueChangedEvent == null ? ObjectTextureDialog.class$("buoy.event.ValueChangedEvent") : class$buoy$event$ValueChangedEvent, (Object)this, "paramTypeChanged");
            this.paramValueWidget[i] = params[i].getEditingWidget(val);
            paramsContainer.add(this.paramValueWidget[i], 2, i);
            this.paramValueWidget[i].setEnabled(perObject);
            this.paramValueWidget[i].addEventLink(class$buoy$event$ValueChangedEvent == null ? ObjectTextureDialog.class$("buoy.event.ValueChangedEvent") : class$buoy$event$ValueChangedEvent, new Object(){

                void processEvent(ValueChangedEvent ev) {
                    if (whichParam >= paramValue.length) {
                        return;
                    }
                    double value = ObjectTextureDialog.this.paramValueWidget[whichField] instanceof ValueField ? ((ValueField)ObjectTextureDialog.this.paramValueWidget[whichField]).getValue() : ((ValueSlider)ObjectTextureDialog.this.paramValueWidget[whichField]).getValue();
                    ConstantParameterValue val = new ConstantParameterValue(value);
                    ((ObjectTextureDialog)ObjectTextureDialog.this).editObj.object.setParameterValue(texParam[whichParam], val);
                    ((ObjectTextureDialog)ObjectTextureDialog.this).preview.getObject().object.setParameterValue(texParam[whichParam], val);
                    ObjectTextureDialog.this.renderPreview();
                    ((ObjectTextureDialog)ObjectTextureDialog.this).editObj.object.setParameterValue(texParam[whichParam], val);
                    ((ObjectTextureDialog)ObjectTextureDialog.this).preview.getObject().object.setParameterValue(texParam[whichParam], val);
                }
            });
        }
        this.paramsScroller.setContent(paramsContainer);
        UIUtilities.applyBackground(paramsContainer, null);
        this.paramsScroller.layoutChildren();
    }

    private int parameterTypeCode(Class type) {
        if (type == VertexParameterValue.class) {
            return 1;
        }
        if (type == FaceParameterValue.class) {
            return 2;
        }
        if (type == FaceVertexParameterValue.class) {
            return 3;
        }
        return 0;
    }

    private void textureClicked(MouseClickedEvent ev) {
        if (ev.getClickCount() == 2) {
            int which = this.texList.getSelectedIndex();
            Texture tex = this.sc.getTexture(which);
            tex.edit(this.fr, this.sc);
            this.sc.changeTexture(which);
            this.renderPreview();
        }
    }

    private void doEditMapping() {
        int index = this.layerList.getSelectedIndex();
        new TextureMappingDialog(this.fr, this.editObj.object, index);
        this.editObj.setTexture(this.editObj.object.getTexture(), this.editObj.object.getTextureMapping());
        this.preview.setTexture(this.editObj.object.getTexture(), this.editObj.object.getTextureMapping());
        this.renderPreview();
    }

    private void doNewTexture() {
        TexturesDialog.showNewTextureWindow(this, this.sc);
    }

    private void doEditTextures() {
        this.sc.showTexturesDialog(this.fr);
        this.buildList();
        this.renderPreview();
    }

    private void doAddLayer() {
        this.preview.cancelRendering();
        Texture tex = this.sc.getTexture(this.texList.getSelectedIndex());
        this.layeredMap.addLayer(tex);
        this.layerList.add(0, tex.getName());
        this.layerList.setSelected(0, true);
        this.resetParameters();
        this.updateComponents();
    }

    private void doDeleteLayer() {
        int index = this.layerList.getSelectedIndex();
        this.preview.cancelRendering();
        this.layeredMap.deleteLayer(index);
        this.layerList.remove(index);
        this.resetParameters();
        this.updateComponents();
    }

    private void doMoveLayerUp() {
        int index = this.layerList.getSelectedIndex();
        this.preview.cancelRendering();
        String label = (String)this.layerList.getItem(index);
        this.layeredMap.moveLayer(index, index - 1);
        this.layerList.remove(index);
        this.layerList.add(index - 1, label);
        this.layerList.setSelected(index - 1, true);
        this.resetParameters();
        this.updateComponents();
    }

    private void doMoveLayerDown() {
        int index = this.layerList.getSelectedIndex();
        this.preview.cancelRendering();
        String label = (String)this.layerList.getItem(index);
        this.layeredMap.moveLayer(index, index + 1);
        this.layerList.remove(index);
        this.layerList.add(index + 1, label);
        this.layerList.setSelected(index + 1, true);
        this.resetParameters();
        this.updateComponents();
    }

    private void doOk() {
        TextureParameter[] param = this.editObj.object.getParameters();
        ParameterValue[] paramValue = this.editObj.object.getParameterValues();
        for (int i = 0; i < this.obj.length; ++i) {
            if (this.editObj.object.getTexture() instanceof LayeredTexture) {
                LayeredMapping m = (LayeredMapping)this.editObj.object.getTextureMapping().duplicate();
                this.obj[i].setTexture(new LayeredTexture(m), m);
            } else {
                this.obj[i].setTexture(this.editObj.object.getTexture(), this.editObj.object.getTextureMapping().duplicate());
            }
            for (int j = 0; j < param.length; ++j) {
                this.obj[i].object.setParameterValue(param[j], paramValue[j].duplicate());
            }
        }
        this.obj[0].object.copyObject(this.editObj.object);
        if (this.fr instanceof LayoutWindow) {
            ((LayoutWindow)this.fr).updateImage();
            ((LayoutWindow)this.fr).getScore().tracksModified(false);
        }
        if (this.callback != null) {
            this.callback.run();
        }
        this.dispose();
    }

    private void doCancel() {
        this.dispose();
        if (this.callback != null) {
            this.callback.run();
        }
    }

    private void paramTypeChanged(ValueChangedEvent ev) {
        Widget src = ev.getWidget();
        for (int i = 0; i < this.paramTypeChoice.length; ++i) {
            if (src != this.paramTypeChoice[i]) continue;
            String type = (String)this.paramTypeChoice[i].getSelectedValue();
            int index = this.fieldParamIndex[i];
            if (this.paramValueWidget[i] != null) {
                this.paramValueWidget[i].setEnabled(type == PARAM_TYPE_NAME[0]);
            }
            TextureParameter param = this.editObj.object.getParameters()[index];
            Object3D realObject = this.editObj.object;
            while (realObject instanceof ObjectWrapper) {
                realObject = ((ObjectWrapper)realObject).getWrappedObject();
            }
            if (type == PARAM_TYPE_NAME[0]) {
                this.editObj.object.setParameterValue(param, new ConstantParameterValue(this.editObj.object.getParameterValues()[index].getAverageValue()));
            } else if (type == PARAM_TYPE_NAME[1]) {
                this.editObj.object.setParameterValue(param, new VertexParameterValue((Mesh)((Object)realObject), param));
            } else if (type == PARAM_TYPE_NAME[2]) {
                this.editObj.object.setParameterValue(param, new FaceParameterValue((TriangleMesh)realObject, param));
            } else if (type == PARAM_TYPE_NAME[3]) {
                this.editObj.object.setParameterValue(param, new FaceVertexParameterValue((TriangleMesh)realObject, param));
            }
            this.renderPreview();
            this.editObj.object.setParameterValue(param, new FaceVertexParameterValue((TriangleMesh)realObject, param));
            return;
        }
    }

    private void typeChanged() {
        boolean layered;
        boolean bl = layered = this.typeChoice.getSelectedIndex() == 1;
        if (layered) {
            this.preview.cancelRendering();
            this.editObj.setTexture(this.layeredTex, this.layeredMap);
            this.preview.setTexture(this.layeredTex, this.layeredMap);
            this.updateComponents();
            this.layoutLayered();
            this.pack();
            UIUtilities.centerWindow(this);
            this.resetParameters();
            return;
        }
        this.texList.setSelected(0, true);
        Texture tex = this.sc.getDefaultTexture();
        this.editObj.setTexture(tex, tex.getDefaultMapping());
        this.updateComponents();
        this.layoutSimple();
        this.pack();
        UIUtilities.centerWindow(this);
        this.resetParameters();
    }

    private void blendTypeChanged() {
        this.layeredMap.setLayerMode(this.layerList.getSelectedIndex(), this.blendChoice.getSelectedIndex());
        this.renderPreview();
    }

    private void selectionChanged() {
        boolean anyselection;
        boolean layered;
        boolean bl = layered = this.typeChoice.getSelectedIndex() == 1;
        if (layered) {
            anyselection = this.layerList.getSelectedIndex() > -1;
        } else {
            boolean bl2 = anyselection = this.texList.getSelectedIndex() > -1;
        }
        if (!anyselection) {
            this.updateComponents();
            return;
        }
        Texture tex = layered ? this.layeredMap.getLayer(this.layerList.getSelectedIndex()) : this.sc.getTexture(this.texList.getSelectedIndex());
        if (!layered) {
            if (tex == this.oldTexture) {
                this.editObj.setTexture(tex, this.oldMapping.duplicate());
            } else {
                this.editObj.setTexture(tex, tex.getDefaultMapping());
            }
            this.preview.setTexture(tex, this.editObj.object.getTextureMapping());
        }
        this.renderPreview();
        this.updateComponents();
    }

    private void resetParameters() {
        this.preview.cancelRendering();
        this.editObj.setTexture(this.editObj.object.getTexture(), this.editObj.object.getTextureMapping());
        this.preview.getObject().setTexture(this.preview.getObject().object.getTexture(), this.preview.getObject().object.getTextureMapping());
        this.renderPreview();
    }

    private void updateComponents() {
        boolean layered = this.typeChoice.getSelectedIndex() == 1;
        boolean anyselection = this.texList.getSelectedIndex() > -1;
        this.buildParamList();
        if (layered) {
            this.addLayerButton.setEnabled(anyselection);
            int index = this.layerList.getSelectedIndex();
            if (index == -1) {
                this.mapButton.setEnabled(false);
                this.deleteLayerButton.setEnabled(false);
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
                this.blendChoice.setEnabled(false);
                return;
            }
            Texture tex = this.layeredMap.getLayer(index);
            this.mapButton.setEnabled(true);
            this.deleteLayerButton.setEnabled(true);
            this.moveUpButton.setEnabled(index > 0);
            this.moveDownButton.setEnabled(index < this.layeredMap.getLayers().length - 1);
            this.blendChoice.setEnabled(true);
            this.blendChoice.setSelectedIndex(this.layeredMap.getLayerMode(index));
        } else if (anyselection) {
            this.mapButton.setEnabled(true);
            Texture tex = this.sc.getTexture(this.texList.getSelectedIndex());
        } else {
            this.mapButton.setEnabled(false);
        }
    }

    public void itemAdded(int index, Object obj) {
        Texture tex = (Texture)obj;
        this.texList.add(index, tex.getName());
    }

    public void itemRemoved(int index, Object obj) {
        Texture tex = (Texture)obj;
        this.texList.remove(index);
        if (this.editObj.object.getTextureMapping() instanceof LayeredMapping) {
            Texture[] layers = this.layeredMap.getLayers();
            for (int i = layers.length - 1; i >= 0; --i) {
                if (layers[i] != tex) continue;
                this.layeredMap.deleteLayer(i);
                this.layerList.remove(i);
            }
            this.renderPreview();
            this.updateComponents();
        } else if (this.editObj.object.getTexture() == tex) {
            this.editObj.setTexture(this.sc.getDefaultTexture(), this.sc.getDefaultTexture().getDefaultMapping());
            this.preview.setTexture(this.editObj.object.getTexture(), this.editObj.object.getTextureMapping());
            this.renderPreview();
            this.updateComponents();
        }
    }

    public void itemChanged(int index, Object obj) {
        Texture tex = (Texture)obj;
        this.texList.replace(index, tex.getName());
    }

    private void renderPreview() {
        this.renderProcessor.addEvent(new Runnable(){

            public void run() {
                ObjectTextureDialog.this.preview.render();
            }
        });
    }
}

