/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MoveViewTool;
import artofillusion.ObjectViewer;
import artofillusion.RenderingMesh;
import artofillusion.RotateViewTool;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.TexturedVertexShader;
import artofillusion.view.VertexShader;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class ObjectPreviewCanvas
extends ObjectViewer {
    private boolean sizeSet;
    static final RGBColor surfaceRGB = new RGBColor(0.8f, 0.8f, 1.0f);
    static final Color surfaceColor = new Color(0.8f, 0.8f, 1.0f);

    public ObjectPreviewCanvas(ObjectInfo obj) {
        this(obj, new RowContainer());
    }

    public ObjectPreviewCanvas(ObjectInfo obj, RowContainer p) {
        super(obj, p);
        this.setTool(new RotateViewTool(null));
        this.setMetaTool(new MoveViewTool(null));
        int mode = lastRenderMode;
        this.setRenderMode(2);
        lastRenderMode = mode;
        this.hideBackfaces = false;
    }

    protected void drawObject(Graphics g) {
        if (this.theObject == null) {
            return;
        }
        if (!this.sizeSet) {
            Rectangle dim = this.getBounds();
            Vec3 objSize = this.theObject.getBounds().getSize();
            double scale = 0.8 * (double)Math.min(dim.width, dim.height) / Math.max(Math.max(objSize.x, objSize.y), objSize.z);
            this.setScale(scale);
            this.theCamera.setScreenParams(0.0, scale, dim.width, dim.height);
            this.sizeSet = true;
        }
        if (this.renderMode == 0) {
            g.setColor(surfaceColor);
            Object3D.draw(g, this.theCamera, this.objInfo.getWireframePreview(), this.objInfo.getBounds());
        } else if (this.renderMode == 4) {
            RenderingMesh mesh = this.objInfo.getPreviewMesh();
            if (mesh != null) {
                this.renderMeshTransparent(mesh, this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), surfaceRGB, null);
            }
        } else {
            RenderingMesh mesh = this.objInfo.getPreviewMesh();
            Vec3 viewDir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
            VertexShader shader = this.renderMode == 1 ? new FlatVertexShader(mesh, surfaceRGB, viewDir) : (this.renderMode == 2 ? new SmoothVertexShader(mesh, surfaceRGB, viewDir) : new TexturedVertexShader(mesh, this.theObject, 0.0, viewDir).optimize());
            this.renderMesh(mesh, shader, this.theCamera, this.theObject.isClosed(), null);
        }
    }

    protected void mousePressed(WidgetMouseEvent e) {
        this.requestFocus();
        this.sentClick = true;
        this.activeTool = this.currentTool;
        if (this.metaTool != null && e.isMetaDown()) {
            this.activeTool = this.metaTool;
        }
        this.activeTool.mousePressed(e, this);
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        if (this.sentClick) {
            this.activeTool.mouseReleased(e, this);
        }
    }
}

