/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ListChangeListener;
import artofillusion.MaterialMappingDialog;
import artofillusion.MaterialPreviewer;
import artofillusion.MaterialsDialog;
import artofillusion.Scene;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.material.UniformMaterial;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.MouseClickedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Insets;

public class ObjectMaterialDialog
extends BDialog
implements ListChangeListener {
    BFrame fr;
    Scene sc;
    ObjectInfo[] obj;
    Object3D firstObj;
    BList matList;
    BButton mapButton;
    MaterialPreviewer preview;
    Material oldMaterial;
    MaterialMapping oldMapping;

    public ObjectMaterialDialog(BFrame parent, Scene theScene, ObjectInfo[] objects) {
        super(parent, Translate.text("objectMaterialTitle"), false);
        this.fr = parent;
        this.sc = theScene;
        this.obj = objects;
        this.firstObj = this.obj[0].object;
        this.oldMaterial = this.firstObj.getMaterial();
        this.oldMapping = this.oldMaterial == null ? null : this.firstObj.getMaterialMapping().duplicate();
        FormContainer content = new FormContainer(3, 4);
        this.setContent(content);
        String title = this.obj.length == 1 ? Translate.text("chooseMaterialForSingle", this.obj[0].name) : Translate.text("chooseMaterialForMultiple");
        content.add(new BLabel(title), 0, 0, 3, 1);
        this.matList = new BList();
        this.matList.setMultipleSelectionEnabled(false);
        this.buildList();
        this.matList.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        this.matList.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        content.add(UIUtilities.createScrollingList(this.matList), 0, 1, 2, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        LayoutInfo buttonLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null);
        content.add(Translate.button("newMaterial", this, "doNewMaterial"), 0, 2, buttonLayout);
        content.add(Translate.button("materials", this, "doEditMaterials"), 1, 2, buttonLayout);
        this.preview = new MaterialPreviewer(this.firstObj.getTexture(), this.oldMaterial, 160, 160);
        content.add(this.preview, 2, 1, 1, 2);
        this.preview.setTexture(this.firstObj.getTexture(), this.firstObj.getTextureMapping());
        this.preview.setMaterial(this.oldMaterial, this.oldMapping);
        this.preview.render();
        RowContainer buttons = new RowContainer();
        content.add(buttons, 0, 3, 3, 1);
        this.mapButton = Translate.button("editMapping", this, "doEditMapping");
        buttons.add(this.mapButton);
        this.mapButton.setEnabled(!(this.oldMaterial instanceof UniformMaterial) && this.oldMaterial != null);
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "doCancel"));
        this.pack();
        this.setResizable(false);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "dispose");
        UIUtilities.centerWindow(this);
        this.sc.addMaterialListener(this);
        this.setVisible(true);
    }

    public void dispose() {
        this.sc.removeMaterialListener(this);
        super.dispose();
    }

    private void buildList() {
        this.matList.removeAll();
        this.matList.add("None");
        this.matList.setSelected(0, true);
        for (int i = 0; i < this.sc.getNumMaterials(); ++i) {
            this.matList.add(this.sc.getMaterial(i).getName());
            if (this.firstObj.getMaterial() != this.sc.getMaterial(i)) continue;
            this.matList.setSelected(i + 1, true);
        }
    }

    private void mouseClicked(MouseClickedEvent ev) {
        int which;
        if (ev.getClickCount() == 2 && (which = this.matList.getSelectedIndex() - 1) > -1) {
            Material mat = this.sc.getMaterial(which);
            mat.edit(this.fr, this.sc);
            this.sc.changeMaterial(which);
            this.preview.render();
        }
    }

    private void doOk() {
        if (this.firstObj.getMaterial() == null) {
            for (int i = 1; i < this.obj.length; ++i) {
                this.obj[i].object.setMaterial(null, null);
            }
        } else {
            for (int i = 1; i < this.obj.length; ++i) {
                this.obj[i].object.setMaterial(this.firstObj.getMaterial(), this.firstObj.getMaterialMapping().duplicate());
            }
        }
        this.dispose();
    }

    private void doCancel() {
        this.firstObj.setMaterial(this.oldMaterial, this.oldMapping);
        this.dispose();
    }

    private void doNewMaterial() {
        MaterialsDialog.showNewMaterialWindow(this, this.sc);
    }

    private void doEditMaterials() {
        this.sc.showMaterialsDialog(this.fr);
        this.buildList();
        this.preview.render();
    }

    private void doEditMapping() {
        new MaterialMappingDialog(this.fr, this.firstObj);
        this.preview.setMaterial(this.firstObj.getMaterial(), this.firstObj.getMaterialMapping());
        this.preview.render();
    }

    private void selectionChanged() {
        if (this.matList.getSelectedIndex() < 0) {
            this.matList.setSelected(0, true);
        }
        if (this.matList.getSelectedIndex() == 0) {
            this.mapButton.setEnabled(false);
            this.firstObj.setMaterial(null, null);
            this.preview.setMaterial(null, null);
            this.preview.render();
            return;
        }
        Material mat = this.sc.getMaterial(this.matList.getSelectedIndex() - 1);
        if (mat == this.oldMaterial) {
            this.firstObj.setMaterial(mat, this.oldMapping.duplicate());
        } else {
            this.firstObj.setMaterial(mat, mat.getDefaultMapping());
        }
        this.mapButton.setEnabled(!(mat instanceof UniformMaterial));
        this.preview.setMaterial(mat, this.firstObj.getMaterialMapping());
        this.preview.render();
    }

    public void itemAdded(int index, Object obj) {
        Material mat = (Material)obj;
        this.matList.add(index + 1, mat.getName());
    }

    public void itemRemoved(int index, Object obj) {
        Material mat = (Material)obj;
        this.matList.remove(index + 1);
        if (this.firstObj.getMaterial() == mat) {
            this.firstObj.setMaterial(null, null);
            this.preview.setMaterial(this.firstObj.getMaterial(), this.firstObj.getMaterialMapping());
            this.preview.render();
            this.mapButton.setEnabled(false);
        }
    }

    public void itemChanged(int index, Object obj) {
        Material mat = (Material)obj;
        this.matList.replace(index + 1, mat.getName());
    }
}

