/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BCheckBox;
import buoy.widget.Widget;
import java.awt.Image;
import java.awt.Point;
import java.util.Vector;

public class MoveObjectTool
extends EditingTool {
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    Vec3[] objectPos;
    Vector toMove;
    ObjectInfo clickedObject;
    boolean dragged;
    boolean applyToChildren = true;

    public MoveObjectTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("move.gif");
        selectedIcon = this.loadImage("selected/move.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("moveObjectTool.helpText"));
    }

    public int whichClicks() {
        return 1;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("moveObjectTool.tipText");
    }

    public void mousePressedOnObject(WidgetMouseEvent e, ViewerCanvas view, int obj) {
        int i;
        Scene theScene = this.theWindow.getScene();
        this.toMove = new Vector();
        this.clickedObject = theScene.getObject(obj);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        for (i = 0; i < sel.length; ++i) {
            this.toMove.addElement(theScene.getObject(sel[i]));
        }
        this.objectPos = new Vec3[this.toMove.size()];
        for (i = 0; i < this.objectPos.length; ++i) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            this.objectPos[i] = info.coords.getOrigin();
        }
        this.clickPoint = e.getPoint();
        this.dragged = false;
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        CoordinateSystem c;
        int i;
        System.out.println("Move mouseDragged");
        Scene theScene = this.theWindow.getScene();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (!this.dragged) {
            UndoRecord undo = new UndoRecord(this.theWindow, false);
            this.theWindow.setUndoRecord(undo);
            for (i = 0; i < this.toMove.size(); ++i) {
                ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
                c = info.coords;
                undo.addCommand(1, new Object[]{c, c.duplicate()});
            }
            this.dragged = true;
        }
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown() && !e.isControlDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        Vec3 v = e.isControlDown() ? cam.getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : cam.findDragVector(this.clickedObject.coords.getOrigin(), dx, dy);
        for (i = 0; i < this.toMove.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            c = info.coords;
            c.setOrigin(this.objectPos[i].plus(v));
        }
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("moveObjectTool.dragText", (double)Math.round(v.x * 100000.0) / 100000.0 + ", " + (double)Math.round(v.y * 100000.0) / 100000.0 + ", " + (double)Math.round(v.z * 100000.0) / 100000.0));
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        System.out.println("Move mouseReleased");
        for (int i = 0; i < this.toMove.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            info.object.sceneChanged(info, this.theWindow.getScene());
        }
        this.theWindow.setHelpText(Translate.text("moveObjectTool.helpText"));
        this.toMove = null;
        this.objectPos = null;
        this.theWindow.updateImage();
    }

    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
        int i;
        int dy;
        int dx;
        Scene theScene = this.theWindow.getScene();
        Camera cam = view.getCamera();
        int key = e.getKeyCode();
        if (key == 38) {
            dx = 0;
            dy = -1;
        } else if (key == 40) {
            dx = 0;
            dy = 1;
        } else if (key == 37) {
            dx = -1;
            dy = 0;
        } else if (key == 39) {
            dx = 1;
            dy = 0;
        } else {
            return;
        }
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        if (sel.length == 0) {
            return;
        }
        if (e.isAltDown()) {
            dx *= 10;
            dy *= 10;
        }
        Vec3 v = e.isControlDown() ? cam.getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : cam.findDragVector(theScene.getObject((int)sel[0]).coords.getOrigin(), dx, dy);
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        this.theWindow.setUndoRecord(undo);
        this.toMove = new Vector();
        for (i = 0; i < sel.length; ++i) {
            this.toMove.addElement(theScene.getObject(sel[i]));
        }
        for (i = 0; i < this.toMove.size(); ++i) {
            CoordinateSystem c = ((ObjectInfo)this.toMove.elementAt((int)i)).coords;
            undo.addCommand(1, new Object[]{c, c.duplicate()});
            c.setOrigin(c.getOrigin().plus(v));
        }
        for (i = 0; i < this.toMove.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            info.object.sceneChanged(info, this.theWindow.getScene());
        }
        this.theWindow.updateImage();
    }

    public void iconDoubleClicked() {
        BCheckBox childrenBox = new BCheckBox(Translate.text("applyToUnselectedChildren"), this.applyToChildren);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("moveToolTitle"), new Widget[]{childrenBox}, new String[]{null});
        if (!dlg.clickedOk()) {
            return;
        }
        this.applyToChildren = childrenBox.getState();
    }
}

