/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ApplicationPreferences;
import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.Plugin;
import artofillusion.RecentFiles;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.TitleWindow;
import artofillusion.Translator;
import artofillusion.UndoRecord;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.image.ImageMap;
import artofillusion.image.filter.ImageFilter;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.procedural.Module;
import artofillusion.script.ScriptRunner;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ModellingApp {
    public static final String MAJOR_VERSION = "1.9_ED20041129";
    public static final String VERSION = "1.9_ED20041129";
    public static final double DIST_TO_SCREEN = 20.0;
    public static final Color APP_BACKGROUND_COLOR = new Color(228, 228, 243);
    public static final String APP_DIRECTORY;
    public static final String PLUGIN_DIRECTORY;
    public static final String TOOL_SCRIPT_DIRECTORY;
    public static final String OBJECT_SCRIPT_DIRECTORY;
    public static final String STARTUP_SCRIPT_DIRECTORY;
    public static final Image APP_ICON;
    public static Font defaultFont;
    public static String currentDirectory;
    public static int standardDialogInsets;
    private static ApplicationPreferences preferences;
    private static ObjectInfo[] clipboardObject;
    private static Texture[] clipboardTexture;
    private static Material[] clipboardMaterial;
    private static ImageMap[] clipboardImage;
    private static Vector windows;
    private static URLClassLoader[] pluginLoader;
    private static Vector renderers;
    private static Vector translators;
    private static Vector modellingTools;
    private static Vector textures;
    private static Vector materials;
    private static Vector textureMappings;
    private static Vector materialMappings;
    private static Vector plugins;
    private static Vector filters;
    private static Vector modules;
    private static Hashtable classTranslations;

    public static void main(String[] args) {
        int i;
        System.setErr(System.out);
        Translate.setLocale(Locale.getDefault());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        TitleWindow title = new TitleWindow();
        try {
            textures.addElement(Class.forName("artofillusion.texture.UniformTexture"));
            textures.addElement(Class.forName("artofillusion.texture.ImageMapTexture"));
            textures.addElement(Class.forName("artofillusion.texture.ProceduralTexture2D"));
            textures.addElement(Class.forName("artofillusion.texture.ProceduralTexture3D"));
            materials.addElement(Class.forName("artofillusion.material.UniformMaterial"));
            materials.addElement(Class.forName("artofillusion.material.ProceduralMaterial3D"));
            textureMappings.addElement(Class.forName("artofillusion.texture.UniformMapping"));
            textureMappings.addElement(Class.forName("artofillusion.texture.ProjectionMapping"));
            textureMappings.addElement(Class.forName("artofillusion.texture.CylindricalMapping"));
            textureMappings.addElement(Class.forName("artofillusion.texture.SphericalMapping"));
            textureMappings.addElement(Class.forName("artofillusion.texture.UVMapping"));
            textureMappings.addElement(Class.forName("artofillusion.texture.LinearMapping3D"));
            materialMappings.addElement(Class.forName("artofillusion.material.LinearMaterialMapping"));
            filters.addElement(Class.forName("artofillusion.image.filter.BrightnessFilter"));
            filters.addElement(Class.forName("artofillusion.image.filter.SaturationFilter"));
            filters.addElement(Class.forName("artofillusion.image.filter.TintFilter"));
            filters.addElement(Class.forName("artofillusion.image.filter.BlurFilter"));
            filters.addElement(Class.forName("artofillusion.image.filter.GlowFilter"));
            filters.addElement(Class.forName("artofillusion.image.filter.OutlineFilter"));
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (pluginLoader == null) {
            ModellingApp.scanPlugins();
        }
        preferences = new ApplicationPreferences();
        for (i = 0; i < plugins.size(); ++i) {
            ((Plugin)plugins.elementAt(i)).processMessage(0, new Object[0]);
        }
        for (i = 0; i < args.length; ++i) {
            try {
                ModellingApp.newWindow(new Scene(new File(args[i]), true));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ModellingApp.runStartupScripts();
        boolean alreadyHasWindow = false;
        for (int i2 = 0; i2 < windows.size(); ++i2) {
            if (!(windows.elementAt(i2) instanceof LayoutWindow)) continue;
            alreadyHasWindow = true;
        }
        if (!alreadyHasWindow) {
            ModellingApp.newWindow();
        }
        title.dispose();
    }

    public static ApplicationPreferences getPreferences() {
        return preferences;
    }

    public static Renderer[] getRenderers() {
        Object[] r = new Renderer[renderers.size()];
        renderers.copyInto(r);
        return r;
    }

    public static Plugin[] getPlugins() {
        Object[] p = new Plugin[plugins.size()];
        plugins.copyInto(p);
        return p;
    }

    public static Translator[] getTranslators() {
        Object[] t = new Translator[translators.size()];
        translators.copyInto(t);
        return t;
    }

    public static ModellingTool[] getModellingTools() {
        Object[] t = new ModellingTool[modellingTools.size()];
        modellingTools.copyInto(t);
        return t;
    }

    public static Class[] getTextureTypes() {
        Object[] t = new Class[textures.size()];
        textures.copyInto(t);
        return t;
    }

    public static Class[] getMaterialTypes() {
        Object[] m = new Class[materials.size()];
        materials.copyInto(m);
        return m;
    }

    public static Class[] getTextureMappings() {
        Object[] t = new Class[textureMappings.size()];
        textureMappings.copyInto(t);
        return t;
    }

    public static Class[] getMaterialMappings() {
        Object[] m = new Class[materialMappings.size()];
        materialMappings.copyInto(m);
        return m;
    }

    public static Class[] getImageFilters() {
        Object[] f = new Class[filters.size()];
        filters.copyInto(f);
        return f;
    }

    public static Class[] getModules() {
        Object[] m = new Class[modules.size()];
        modules.copyInto(m);
        return m;
    }

    public static void registerRenderer(Renderer o) {
        renderers.addElement(o);
    }

    public static void registerTranslator(Translator o) {
        translators.addElement(o);
    }

    public static void registerModellingTool(ModellingTool o) {
        modellingTools.addElement(o);
    }

    public static void registerTexture(Texture o) {
        textures.addElement(o.getClass());
    }

    public static void registerMaterial(Material o) {
        materials.addElement(o.getClass());
    }

    public static void registerTextureMapping(TextureMapping o) {
        textureMappings.addElement(o.getClass());
    }

    public static void registerMaterialMapping(MaterialMapping o) {
        materialMappings.addElement(o.getClass());
    }

    public static void registerPlugin(Plugin o) {
        plugins.addElement(o);
    }

    public static void registerImageFilter(ImageFilter o) {
        filters.addElement(o.getClass());
    }

    public static void registerModule(Module o) {
        modules.addElement(o.getClass());
    }

    public static void newWindow() {
        Scene theScene = new Scene();
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        ObjectInfo info = new ObjectInfo(new SceneCamera(), coords, "Camera 1");
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        theScene.addObject(info, null);
        info = new ObjectInfo(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords.duplicate(), "Light 1");
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        theScene.addObject(info, null);
        ModellingApp.newWindow(theScene);
    }

    public static void newWindow(final Scene theScene) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i;
                LayoutWindow fr = new LayoutWindow(theScene);
                windows.addElement(fr);
                for (i = 0; i < plugins.size(); ++i) {
                    ((Plugin)plugins.elementAt(i)).processMessage(2, new Object[]{fr});
                }
                fr.setVisible(true);
                for (i = windows.size() - 2; i >= 0; --i) {
                    LayoutWindow win;
                    if (!(windows.elementAt(i) instanceof LayoutWindow) || (win = (LayoutWindow)windows.elementAt(i)).getScene().getName() != null || win.modified) continue;
                    ModellingApp.closeWindow(win);
                }
            }
        });
    }

    public static void addWindow(EditingWindow win) {
        windows.addElement(win);
    }

    public static void closeWindow(EditingWindow win) {
        if (win.confirmClose()) {
            windows.removeElement(win);
            if (win instanceof LayoutWindow) {
                for (int i = 0; i < plugins.size(); ++i) {
                    ((Plugin)plugins.elementAt(i)).processMessage(3, new Object[]{win});
                }
            }
        }
        if (windows.size() == 0) {
            ModellingApp.quit();
        }
    }

    public static EditingWindow[] getWindows() {
        Object[] w = new EditingWindow[windows.size()];
        windows.copyInto(w);
        return w;
    }

    public static void quit() {
        int i;
        for (i = windows.size() - 1; i >= 0; --i) {
            EditingWindow win = (EditingWindow)windows.elementAt(i);
            ModellingApp.closeWindow(win);
            if (!windows.contains(win)) continue;
            return;
        }
        for (i = 0; i < plugins.size(); ++i) {
            ((Plugin)plugins.elementAt(i)).processMessage(1, new Object[0]);
        }
        System.exit(0);
    }

    private static void scanPlugins() {
        int i;
        File dir2 = new File(PLUGIN_DIRECTORY);
        ZipFile zf = null;
        if (!dir2.exists()) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("cannotLocatePlugins")), BStandardDialog.ERROR).showMessageDialog(null);
            pluginLoader = new URLClassLoader[0];
            return;
        }
        String[] files = dir2.list();
        pluginLoader = new URLClassLoader[files.length];
        int j = 0;
        for (i = 0; i < files.length; ++i) {
            File f = new File(PLUGIN_DIRECTORY, files[i]);
            try {
                zf = new ZipFile(f);
            }
            catch (IOException ex) {
                continue;
            }
            try {
                ModellingApp.pluginLoader[j++] = new URLClassLoader(new URL[]{f.toURL()});
                ZipEntry ze = zf.getEntry("plugins");
                if (ze == null) continue;
                BufferedReader in = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                String name = in.readLine();
                while (name != null) {
                    try {
                        Object instance = pluginLoader[j - 1].loadClass(name).newInstance();
                        if (instance instanceof Plugin) {
                            plugins.addElement(instance);
                        }
                        if (instance instanceof Renderer) {
                            renderers.addElement(instance);
                        }
                        if (instance instanceof Translator) {
                            translators.addElement(instance);
                        }
                        if (instance instanceof ModellingTool) {
                            modellingTools.addElement(instance);
                        }
                        if (instance instanceof Texture) {
                            textures.addElement(instance.getClass());
                        }
                        if (instance instanceof Material) {
                            materials.addElement(instance.getClass());
                        }
                        if (instance instanceof TextureMapping) {
                            textureMappings.addElement(instance.getClass());
                        }
                        if (instance instanceof MaterialMapping) {
                            materialMappings.addElement(instance.getClass());
                        }
                        if (instance instanceof ImageFilter) {
                            filters.addElement(instance.getClass());
                        }
                        if (instance instanceof Module) {
                            modules.addElement(instance.getClass());
                        }
                    }
                    catch (ClassNotFoundException ex) {
                    }
                    catch (IllegalAccessException ex) {
                    }
                    catch (InstantiationException ex) {
                        // empty catch block
                    }
                    name = in.readLine();
                }
                continue;
            }
            catch (IOException ex) {
                System.out.println("Error reading plugin file " + files[i]);
            }
        }
        if (j < files.length) {
            URLClassLoader[] temp = new URLClassLoader[j];
            for (i = 0; i < j; ++i) {
                temp[i] = pluginLoader[i];
            }
            pluginLoader = temp;
        }
    }

    private static void runStartupScripts() {
        String[] files = new File(STARTUP_SCRIPT_DIRECTORY).list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".bsh")) continue;
                try {
                    String script = ModellingApp.loadFile(new File(STARTUP_SCRIPT_DIRECTORY, files[i]));
                    ScriptRunner.executeScript(script);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static Class getClass(String name) throws ClassNotFoundException {
        try {
            return ModellingApp.lookupClass(name);
        }
        catch (ClassNotFoundException ex) {
            int i = name.indexOf(36);
            if (i == -1) {
                String newName = (String)classTranslations.get(name);
                if (newName == null) {
                    throw ex;
                }
                return ModellingApp.lookupClass(newName);
            }
            String newName = (String)classTranslations.get(name.substring(0, i));
            if (newName == null) {
                throw ex;
            }
            return ModellingApp.lookupClass(newName + name.substring(i));
        }
    }

    private static Class lookupClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            for (int i = 0; i < pluginLoader.length; ++i) {
                try {
                    return pluginLoader[i].loadClass(name);
                }
                catch (ClassNotFoundException ex2) {
                    if (i != pluginLoader.length - 1) continue;
                    throw ex2;
                }
            }
            return null;
        }
    }

    public static void centerWindow(Window win) {
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = win.getSize();
        int x = (d1.width - d2.width) / 2;
        int y = (d1.height - d2.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        win.setLocation(x, y);
    }

    public static void centerDialog(Dialog dlg, Window parent) {
        Rectangle r = parent.getBounds();
        Dimension d = dlg.getSize();
        int x = r.x + (r.width - d.width) / 2;
        int y = r.y + 20;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        dlg.setLocation(x, y);
    }

    public static String loadFile(File f) throws IOException {
        int c;
        BufferedReader in = new BufferedReader(new FileReader(f));
        StringBuffer buf = new StringBuffer();
        while ((c = in.read()) != -1) {
            buf.append((char)c);
        }
        in.close();
        return buf.toString();
    }

    public static boolean saveScene(Scene sc, LayoutWindow fr) {
        try {
            File f = new File(sc.getDirectory(), sc.getName());
            sc.writeToFile(f);
            for (int i = 0; i < plugins.size(); ++i) {
                ((Plugin)plugins.elementAt(i)).processMessage(4, new Object[]{f, fr});
            }
            RecentFiles.addRecentFile(f);
        }
        catch (IOException ex) {
            new BStandardDialog("", new String[]{Translate.text("errorSavingScene"), ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(fr);
            return false;
        }
        return true;
    }

    public static void openScene(BFrame fr) {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("openScene"));
        if (currentDirectory != null) {
            fc.setDirectory(new File(currentDirectory));
        }
        if (!fc.showDialog(fr)) {
            return;
        }
        currentDirectory = fc.getDirectory().getAbsolutePath();
        ModellingApp.openScene(fc.getSelectedFile(), fr);
    }

    public static void openScene(File f, BFrame fr) {
        try {
            DataInputStream in = new DataInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
            Scene sc = new Scene(in, true);
            sc.setName(f.getName());
            sc.setDirectory(f.getParent());
            ModellingApp.newWindow(sc);
            in.close();
            if (sc.errorsOccurredInLoading()) {
                new BStandardDialog("", UIUtilities.breakString(Translate.text("errorLoadingScenePart")), BStandardDialog.ERROR).showMessageDialog(fr);
            }
            RecentFiles.addRecentFile(f);
        }
        catch (InvalidObjectException ex) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("errorLoadingWholeScene")), BStandardDialog.ERROR).showMessageDialog(fr);
        }
        catch (IOException ex) {
            new BStandardDialog("", new String[]{Translate.text("errorLoadingFile"), ex.getMessage() == null ? "" : ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(fr);
        }
    }

    public static void copyToClipboard(ObjectInfo[] obj, Scene scene) {
        Vector<Texture> textures = new Vector<Texture>();
        for (int i = 0; i < obj.length; ++i) {
            Texture tex = obj[i].object.getTexture();
            if (tex instanceof LayeredTexture) {
                LayeredMapping map = (LayeredMapping)obj[i].object.getTextureMapping();
                Texture[] layer = map.getLayers();
                for (int j = 0; j < layer.length; ++j) {
                    Texture dup = layer[j].duplicate();
                    dup.setID(layer[j].getID());
                    TextureMapping dupMap = map.getLayerMapping(j);
                    textures.addElement(dup);
                    map.setLayer(j, dup);
                    map.setLayerMapping(j, map.getLayerMapping(j).duplicate(dup));
                }
                continue;
            }
            if (tex == null) continue;
            Texture dup = tex.duplicate();
            dup.setID(tex.getID());
            textures.addElement(dup);
            obj[i].object.setTexture(dup, obj[i].object.getTextureMapping().duplicate(dup));
        }
        Vector<Material> materials = new Vector<Material>();
        for (int i = 0; i < obj.length; ++i) {
            Material mat = obj[i].object.getMaterial();
            if (mat == null) continue;
            Material dup = mat.duplicate();
            dup.setID(mat.getID());
            materials.addElement(dup);
            obj[i].object.setMaterial(dup, obj[i].object.getMaterialMapping().duplicate(dup));
        }
        Vector<ImageMap> images = new Vector<ImageMap>();
        for (int i = 0; i < scene.getNumImages(); ++i) {
            int j;
            ImageMap map = scene.getImage(i);
            boolean used = false;
            for (j = 0; j < textures.size() && !used; ++j) {
                used = ((Texture)textures.elementAt(j)).usesImage(map);
            }
            for (j = 0; j < materials.size() && !used; ++j) {
                used = ((Material)materials.elementAt(j)).usesImage(map);
            }
            if (!used) continue;
            images.addElement(map);
        }
        clipboardObject = obj;
        clipboardTexture = new Texture[textures.size()];
        textures.copyInto(clipboardTexture);
        clipboardMaterial = new Material[materials.size()];
        materials.copyInto(clipboardMaterial);
        clipboardImage = new ImageMap[images.size()];
        images.copyInto(clipboardImage);
    }

    public static void pasteClipboard(LayoutWindow win) {
        Object current;
        int j;
        int i;
        if (clipboardObject == null) {
            return;
        }
        Scene scene = win.getScene();
        UndoRecord undo = new UndoRecord(win, false);
        win.setUndoRecord(undo);
        for (i = 0; i < clipboardImage.length; ++i) {
            int j2;
            for (j2 = 0; j2 < scene.getNumImages() && clipboardImage[i].getID() != scene.getImage(j2).getID(); ++j2) {
            }
            if (j2 != scene.getNumImages()) continue;
            scene.addImage(clipboardImage[i]);
        }
        for (i = 0; i < clipboardTexture.length; ++i) {
            Texture newtex;
            for (j = 0; j < scene.getNumTextures() && clipboardTexture[i].getID() != scene.getTexture(j).getID(); ++j) {
            }
            if (j == scene.getNumTextures()) {
                newtex = clipboardTexture[i].duplicate();
                newtex.setID(clipboardTexture[i].getID());
                scene.addTexture(newtex);
            } else {
                newtex = scene.getTexture(j);
            }
            for (j = 0; j < clipboardObject.length; ++j) {
                current = ModellingApp.clipboardObject[j].object.getTexture();
                if (current == clipboardTexture[i]) {
                    clipboardObject[j].setTexture(newtex, ModellingApp.clipboardObject[j].object.getTextureMapping().duplicate(newtex));
                    continue;
                }
                if (!(current instanceof LayeredTexture)) continue;
                LayeredMapping map = (LayeredMapping)ModellingApp.clipboardObject[j].object.getTextureMapping();
                map = (LayeredMapping)map.duplicate();
                clipboardObject[j].setTexture(new LayeredTexture(map), map);
                Texture[] layer = map.getLayers();
                for (int k = 0; k < layer.length; ++k) {
                    if (layer[k] != clipboardTexture[i]) continue;
                    map.setLayer(k, newtex);
                    map.setLayerMapping(k, map.getLayerMapping(k).duplicate(newtex));
                }
            }
        }
        for (i = 0; i < clipboardMaterial.length; ++i) {
            Material newmat;
            for (j = 0; j < scene.getNumMaterials() && clipboardMaterial[i].getID() != scene.getMaterial(j).getID(); ++j) {
            }
            if (j == scene.getNumMaterials()) {
                newmat = clipboardMaterial[i].duplicate();
                newmat.setID(clipboardMaterial[i].getID());
                scene.addMaterial(newmat);
            } else {
                newmat = scene.getMaterial(j);
            }
            for (j = 0; j < clipboardObject.length; ++j) {
                current = ModellingApp.clipboardObject[j].object.getMaterial();
                if (current != clipboardMaterial[i]) continue;
                clipboardObject[j].setMaterial(newmat, ModellingApp.clipboardObject[j].object.getMaterialMapping().duplicate(newmat));
            }
        }
        ObjectInfo[] obj = ObjectInfo.duplicateAll(clipboardObject);
        for (int i2 = 0; i2 < obj.length; ++i2) {
            win.addObject(obj[i2], undo);
        }
    }

    public static int getClipboardSize() {
        if (clipboardObject == null) {
            return 0;
        }
        return clipboardObject.length;
    }

    static {
        standardDialogInsets = 0;
        windows = new Vector();
        renderers = new Vector();
        translators = new Vector();
        modellingTools = new Vector();
        textures = new Vector();
        materials = new Vector();
        textureMappings = new Vector();
        materialMappings = new Vector();
        plugins = new Vector();
        filters = new Vector();
        modules = new Vector();
        classTranslations = new Hashtable();
        String dir2 = System.getProperty("user.dir");
        try {
            URL url = ModellingApp.class.getResource("/artofillusion/ModellingApp.class");
            if (url.toString().startsWith("jar:")) {
                String furl = url.getFile();
                dir2 = new File(new URL(furl = furl.substring(0, furl.indexOf(33))).getFile()).getParent();
                if (!new File(dir2).exists()) {
                    dir2 = System.getProperty("user.dir");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        APP_DIRECTORY = dir2;
        PLUGIN_DIRECTORY = new File(APP_DIRECTORY, "Plugins").getAbsolutePath();
        File scripts = new File(APP_DIRECTORY, "Scripts");
        TOOL_SCRIPT_DIRECTORY = new File(scripts, "Tools").getAbsolutePath();
        OBJECT_SCRIPT_DIRECTORY = new File(scripts, "Objects").getAbsolutePath();
        STARTUP_SCRIPT_DIRECTORY = new File(scripts, "Startup").getAbsolutePath();
        Image icon = null;
        try {
            ImageProducer ip = (ImageProducer)ModellingApp.class.getResource("/artofillusion/Icons/appIcon.png").getContent();
            icon = Toolkit.getDefaultToolkit().createImage(ip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        APP_ICON = icon;
        classTranslations.put("artofillusion.tools.CSGObject", "artofillusion.object.CSGObject");
        classTranslations.put("artofillusion.Cube", "artofillusion.object.Cube");
        classTranslations.put("artofillusion.Curve", "artofillusion.object.Curve");
        classTranslations.put("artofillusion.Cylinder", "artofillusion.object.Cylinder");
        classTranslations.put("artofillusion.DirectionalLight", "artofillusion.object.DirectionalLight");
        classTranslations.put("artofillusion.NullObject", "artofillusion.object.NullObject");
        classTranslations.put("artofillusion.PointLight", "artofillusion.object.PointLight");
        classTranslations.put("artofillusion.SceneCamera", "artofillusion.object.SceneCamera");
        classTranslations.put("artofillusion.Sphere", "artofillusion.object.Sphere");
        classTranslations.put("artofillusion.SplineMesh", "artofillusion.object.SplineMesh");
        classTranslations.put("artofillusion.SpotLight", "artofillusion.object.SpotLight");
        classTranslations.put("artofillusion.TriangleMesh", "artofillusion.object.TriangleMesh");
        classTranslations.put("artofillusion.Tube", "artofillusion.object.Tube");
        classTranslations.put("artofillusion.CylindricalMapping", "artofillusion.texture.CylindricalMapping");
        classTranslations.put("artofillusion.ImageMapTexture", "artofillusion.texture.ImageMapTexture");
        classTranslations.put("artofillusion.LayeredMapping", "artofillusion.texture.LayeredMapping");
        classTranslations.put("artofillusion.LayeredTexture", "artofillusion.texture.LayeredTexture");
        classTranslations.put("artofillusion.LinearMapping3D", "artofillusion.texture.LinearMapping3D");
        classTranslations.put("artofillusion.procedural.ProceduralTexture2D", "artofillusion.texture.ProceduralTexture2D");
        classTranslations.put("artofillusion.procedural.ProceduralTexture3D", "artofillusion.texture.ProceduralTexture3D");
        classTranslations.put("artofillusion.ProjectionMapping", "artofillusion.texture.ProjectionMapping");
        classTranslations.put("artofillusion.SphericalMapping", "artofillusion.texture.SphericalMapping");
        classTranslations.put("artofillusion.UniformMapping", "artofillusion.texture.UniformMapping");
        classTranslations.put("artofillusion.UniformTexture", "artofillusion.texture.UniformTexture");
        classTranslations.put("artofillusion.LinearMaterialMapping", "artofillusion.material.LinearMaterialMapping");
        classTranslations.put("artofillusion.procedural.ProceduralMaterial3D", "artofillusion.material.ProceduralMaterial3D");
        classTranslations.put("artofillusion.UniformMaterial", "artofillusion.material.UniformMaterial");
        classTranslations.put("artofillusion.UniformMaterialMapping", "artofillusion.material.UniformMaterialMapping");
        classTranslations.put("artofillusion.tools.tapDesigner.TapDesignerObjectCollection", "artofillusion.tapDesigner.TapDesignerObjectCollection");
        classTranslations.put("artofillusion.tools.tapDesigner.TapTube", "artofillusion.tapDesigner.TapTube");
        classTranslations.put("artofillusion.tools.tapDesigner.TapSplineMesh", "artofillusion.tapDesigner.TapSplineMesh");
        classTranslations.put("artofillusion.tools.tapDesigner.TapObject", "artofillusion.tapDesigner.TapObject");
        classTranslations.put("artofillusion.tools.tapDesigner.TapLeaf", "artofillusion.tapDesigner.TapLeaf");
    }
}

