/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModelListener;
import java.util.Hashtable;
import java.util.Vector;

public class ModelEvent
implements Cloneable {
    protected Vector listeners = new Vector();
    protected Object source = null;
    protected Object cause = null;
    protected Hashtable properties = null;
    protected ModelEvent parent = null;
    public static final Object NULL = new Object();
    public static final String CAUSE_UI = "user interface";
    public static final String CAUSE_PROGRAM = "programmatic";
    public static final String CHANGEDUR_DONTKNOW = "dont know";
    public static final String CHANGEDUR_OBJECTEDITORCOMMIT = "object editor commit";
    public static final String CHANGEDUR_OBJECTEDITORROLLBACK = "object editor rollback";
    public static final String CHANGEDUR_OBJECTEDITORDRAG = "object editor drag";
    public static final String CHANGEDUR_OBJECTEDITOR = "object editor";
    public static final String CHANGEDUR_TIMECHANGE = "time change";

    public Object getCause() {
        return this.cause;
    }

    public Object getSource() {
        return this.source;
    }

    public Object getValue(String key) {
        Object result = this.properties.get(key);
        if (result == NULL) {
            result = null;
        }
        return result;
    }

    public boolean hasKey(String key) {
        return this.properties.containsKey(key);
    }

    public ModelEvent getParent() {
        return this.parent;
    }

    public Object clone() {
        ModelEvent result;
        try {
            result = (ModelEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        result.listeners = (Vector)this.listeners.clone();
        if (this.properties != null) {
            result.properties = (Hashtable)this.properties.clone();
        }
        return result;
    }

    public void addListener(ModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    public ModelEvent put(String key, Object value) {
        if (this.getParent() == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            value = NULL;
        }
        this.properties.put(key, value);
        return this;
    }

    public ModelEvent remove(String key) {
        if (this.getParent() == null) {
            throw new IllegalArgumentException();
        }
        this.properties.remove(key);
        return this;
    }

    public ModelEvent put(String key) {
        return this.put(key, null);
    }

    public void processSend(ModelListener first) {
        if (this.getParent() == null) {
            throw new IllegalArgumentException();
        }
        if (first != null) {
            first.modelEventHappened(this);
        }
        Object[] l = this.listeners.toArray();
        for (int i = 0; i < l.length; ++i) {
            ((ModelListener)l[i]).modelEventHappened(this);
        }
    }

    public void processSend() {
        this.processSend(null);
    }

    public ModelEvent createClone(Object _source, Object _cause) {
        ModelEvent event = (ModelEvent)this.clone();
        if (event.properties == null) {
            event.properties = new Hashtable();
        }
        event.source = _source;
        event.cause = _cause;
        event.parent = this;
        return event;
    }

    public ModelEvent createClone(Object _source, String[] _keys, Object[] _values, Object _cause) {
        ModelEvent event = this.createClone(_source, _cause);
        for (int i = 0; i < _keys.length; ++i) {
            event.put(_keys[i], _values[i]);
        }
        return event;
    }

    public ModelEvent createClone(Object _source, String[] _keys, Object _cause) {
        Object[] values = new Object[_keys.length];
        return this.createClone(_source, _keys, values, _cause);
    }

    public ModelEvent createClone(Object _source, String _key, Object _value, Object _cause) {
        String[] keys = new String[]{_key};
        Object[] values = new Object[]{_value};
        return this.createClone(_source, keys, values, _cause);
    }

    public ModelEvent createClone(Object _source, String _key, Object _cause) {
        String[] keys = new String[]{_key};
        Object[] values = new Object[1];
        return this.createClone(_source, keys, values, _cause);
    }

    public void send(Object _source, String[] _keys, Object[] _values, Object _cause) {
        this.createClone(_source, _keys, _values, _cause).processSend();
    }

    public void send(Object _source, String[] _keys, Object _cause) {
        this.createClone(_source, _keys, _cause).processSend();
    }

    public void send(Object _source, String _key, Object _value, Object _cause) {
        this.createClone(_source, _key, _value, _cause).processSend();
    }

    public void send(Object _source, String _key, Object _cause) {
        this.createClone(_source, _key, _cause).processSend();
    }
}

