/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshSelectionHolder;
import artofillusion.ModelEvent;
import artofillusion.ObjectViewer;
import artofillusion.SkeletonControlHolder;
import artofillusion.animation.Skeleton;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.ObjectInfo;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Graphics;

public abstract class MeshViewer
extends ObjectViewer {
    public static final int HANDLE_SIZE = 5;
    protected boolean showMesh;
    protected boolean showSurface;
    protected boolean showSkeleton;
    protected boolean draggingAutosync;
    private static boolean lastShowMesh = true;
    private static boolean lastShowSurface = true;
    private static boolean lastShowSkeleton = true;
    private static boolean lastDraggingAutosync = true;
    int[] selectionDistance;
    int maxDistance;
    int deselect;
    protected MeshSelectionHolder selHolder;
    protected SkeletonControlHolder skelControlHolder;

    public MeshViewer(ObjectInfo obj, RowContainer p) {
        super(obj, p);
        this.setMeshVisible(lastShowMesh);
        this.setSurfaceVisible(lastShowSurface);
        this.setSkeletonVisible(lastShowSkeleton);
        this.setDraggingAutosync(lastDraggingAutosync);
        this.setSelectionHolder(new MeshSelectionHolder(obj));
        this.setSkeletonControlHolder(new SkeletonControlHolder(obj));
    }

    public void dispose() {
        this.setSelectionHolder(null);
        this.setSkeletonControlHolder(null);
        super.dispose();
    }

    public int getSelectionMode() {
        return this.getSelectionHolder().getSelectionMode();
    }

    public boolean[] getSelection() {
        return this.getSelectionHolder().getSelection();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleModelEvent(ModelEvent event) {
        if (super.handleModelEvent(event)) return true;
        if (event.hasKey("skeletoncontrol changed") && event.getCause() != this && this.isVisible()) {
            this.updateImage();
            this.repaint();
            return true;
        } else if (event.getSource() == this.theObject) {
            if (event.hasKey("object3d dragging") && event.getCause() != this && this.isVisible() && this.draggingAutosync) {
                Vec3[] v = (Vec3[])event.getValue("vertices");
                Graphics g = this.getComponent().getGraphics();
                Camera cam = this.getCamera();
                this.drawImage(g);
                g.setColor(Color.gray);
                this.drawDraggedSelection(g, cam, v, false);
                g.dispose();
                return true;
            } else {
                if (!event.hasKey("object3d changed") || event.getValue("happened during") != "object editor drag" || event.getCause() == this || !this.isVisible() || !this.draggingAutosync) return false;
                this.updateInternalState();
                this.updateImage();
                this.repaint();
            }
            return true;
        } else {
            if (event.getSource() != this.selHolder) return false;
            System.out.println("MeshViewer.handleModelEvent selection changed1");
            if (!event.hasKey("selection changed")) return true;
            this.invalidateSelectionDistance();
            System.out.println("MeshViewer.handleModelEvent selection changed2");
            if (!this.isVisible()) return true;
            System.out.println("MeshViewer.handleModelEvent selection changed3");
            this.updateImage();
            this.repaint();
        }
        return true;
    }

    public void setSelectionHolder(MeshSelectionHolder holder) {
        if (this.selHolder != null) {
            this.selHolder.decRefCount();
            this.selHolder.getModelEvent().removeListener(this);
        }
        this.selHolder = holder;
        if (this.selHolder != null) {
            this.selHolder.incRefCount();
            this.selHolder.getModelEvent().addListener(this);
            this.selHolder.setSelectionMode(0);
            Mesh mesh = (Mesh)((Object)this.theObject);
            if (this.selHolder.getSelection() == null || this.selHolder.getSelection().length != mesh.getVertices().length) {
                this.selHolder.setSelection(new boolean[mesh.getVertices().length]);
            }
        }
    }

    public MeshSelectionHolder getSelectionHolder() {
        return this.selHolder;
    }

    public void setSkeletonControlHolder(SkeletonControlHolder holder) {
        if (this.skelControlHolder != null) {
            this.skelControlHolder.getModelEvent().removeListener(this);
        }
        this.skelControlHolder = holder;
        if (this.skelControlHolder != null) {
            this.skelControlHolder.getModelEvent().addListener(this);
        }
    }

    public SkeletonControlHolder getSkeletonControlHolder() {
        return this.skelControlHolder;
    }

    public void informSelectionChanged(Object cause, String during) {
        if (this.selHolder != null) {
            this.selHolder.informChanged(cause, during);
        }
    }

    protected void broadcastDraggedSelection(Vec3[] v, boolean broadcast) {
        if (broadcast) {
            this.theObject.informDragging(this, v);
        }
    }

    public abstract void drawDraggedSelection(Graphics var1, Camera var2, Vec3[] var3, boolean var4);

    public int[] getSelectionDistance() {
        if (this.maxDistance != MeshEditorWindow.getTensionDistance() || this.selectionDistance == null) {
            this.findSelectionDistance();
        }
        return this.selectionDistance;
    }

    public void invalidateSelectionDistance() {
        this.selectionDistance = null;
    }

    protected abstract void findSelectionDistance();

    public abstract void setMesh(Mesh var1);

    public void updateInternalState() {
        this.setMesh((Mesh)((Object)this.theObject));
    }

    public void copyViewSettings(MeshViewer v) {
        this.setRenderMode(v.getRenderMode());
        this.setMeshVisible(v.getMeshVisible());
        this.setSurfaceVisible(v.getSurfaceVisible());
        this.setSkeletonVisible(v.getSkeletonVisible());
        this.setSceneVisible(v.getSceneVisible());
        this.setUseWorldCoords(v.getUseWorldCoords());
    }

    public int getSelectedJoint() {
        return this.getSkeletonControlHolder().getSelectedJoint();
    }

    public void setSelectedJoint(int id) {
        this.getSkeletonControlHolder().setSelectedJointE(id);
    }

    public boolean[] getLockedJoints() {
        Skeleton s = ((Mesh)((Object)this.theObject)).getSkeleton();
        if (s == null) {
            return new boolean[0];
        }
        return this.getSkeletonControlHolder().getLockedJoints(s);
    }

    public boolean isJointLocked(int id) {
        return this.getSkeletonControlHolder().isJointLocked(id);
    }

    public void lockJoint(int id) {
        SkeletonControlHolder sch = this.getSkeletonControlHolder();
        sch.lockJoint(id);
        sch.informChanged(this, "dont know");
    }

    public void unlockJoint(int id) {
        SkeletonControlHolder sch = this.getSkeletonControlHolder();
        sch.unlockJoint(id);
        sch.informChanged(this, "dont know");
    }

    public boolean getMeshVisible() {
        return this.showMesh;
    }

    public void setMeshVisible(boolean visible) {
        lastShowMesh = this.showMesh = visible;
    }

    public boolean getSurfaceVisible() {
        return this.showSurface;
    }

    public void setSurfaceVisible(boolean visible) {
        lastShowSurface = this.showSurface = visible;
    }

    public boolean getDraggingAutosync() {
        return this.draggingAutosync;
    }

    public void setDraggingAutosync(boolean das) {
        lastDraggingAutosync = this.draggingAutosync = das;
    }

    public boolean getSkeletonVisible() {
        return this.showSkeleton;
    }

    public void setSkeletonVisible(boolean visible) {
        lastShowSkeleton = this.showSkeleton = visible;
    }

    public boolean getSkeletonDetached() {
        Skeleton skel = ((Mesh)((Object)this.theObject)).getSkeleton();
        if (skel == null) {
            return true;
        }
        return skel.getSkeletonDetached();
    }

    public void setSkeletonDetached(boolean detached) {
        Skeleton skel = ((Mesh)((Object)this.theObject)).getSkeleton();
        if (skel == null) {
            return;
        }
        skel.setSkeletonDetached(detached);
    }
}

