/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModelEvent;
import artofillusion.object.Mesh;
import artofillusion.object.ObjectInfo;

public class MeshSelectionHolder {
    protected boolean[] selected;
    int refCount;
    protected transient ModelEvent modelevent;
    protected ObjectInfo objinfo;
    protected int selectMode;

    public MeshSelectionHolder(ObjectInfo objinfo) {
        this.objinfo = objinfo;
        Mesh mesh = (Mesh)((Object)objinfo.object);
        this.selected = new boolean[mesh.getVertices().length];
        this.refCount = 1;
    }

    public ModelEvent getModelEvent() {
        if (this.modelevent == null) {
            this.modelevent = new ModelEvent();
        }
        return this.modelevent;
    }

    protected ModelEvent createChangedModelEvent(Object cause, String during) {
        return this.getModelEvent().createClone(this, cause).put("selection changed", null).put("happened during", during);
    }

    public void informChanged(Object cause, String during) {
        this.createChangedModelEvent(cause, during).processSend();
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        --this.refCount;
        if (this.refCount < 0) {
            this.refCount = 0;
        }
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void setSelectionMode(int mode) {
        this.selectMode = mode;
    }

    public int getSelectionMode() {
        return this.selectMode;
    }

    public boolean[] getSelection() {
        return this.selected;
    }

    public void setSelection(boolean[] sel) {
        this.selected = sel;
    }

    protected MeshSelectionHolder createInstance() {
        return new MeshSelectionHolder(this.objinfo);
    }

    public MeshSelectionHolder getUniqueInstance() {
        if (this.refCount == 1) {
            return this;
        }
        boolean[] newsel = new boolean[this.selected.length];
        System.arraycopy(this.selected, 0, newsel, 0, this.selected.length);
        MeshSelectionHolder result = this.createInstance();
        result.setSelection(newsel);
        result.setSelectionMode(this.getSelectionMode());
        this.decRefCount();
        return result;
    }
}

