/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MeshSelectionHolder;
import artofillusion.MeshViewer;
import artofillusion.ModellingApp;
import artofillusion.MoveViewTool;
import artofillusion.RotateViewTool;
import artofillusion.Scene;
import artofillusion.SkeletonControlHolder;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.UndoStack;
import artofillusion.Utilities;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Joint;
import artofillusion.animation.JointEditorDialog;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MenuDescription;
import artofillusion.ui.MenuItemFactory;
import artofillusion.ui.ObjectTreeElement;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BComboBox;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.GridContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.MenuWidget;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;

public abstract class MeshEditorWindow
extends BFrame
implements EditingWindow,
MenuItemFactory {
    protected EditingWindow parentWindow;
    protected MeshViewer[] theView;
    BorderContainer[] viewPanel;
    GridContainer viewsContainer;
    int numViewsShown;
    int currentView;
    MeshSelectionHolder baseSelHolder;
    SkeletonControlHolder baseSkelControlHolder;
    protected BMenu viewMenu;
    protected ToolPalette tools;
    protected BorderContainer toolsPanel;
    protected EditingTool defaultTool;
    protected EditingTool currentTool;
    protected EditingTool metaTool;
    protected EditingTool altTool;
    protected BLabel helpText;
    protected Object3D oldObject;
    protected BMenuBar menubar;
    protected UndoStack undoStack;
    protected MenuWidget[] menuitemsCache;
    protected Runnable onClose;
    protected ObjectInfo objInConstructor;
    public static final int OPTION_ALLOWTOPOLOGY = 1;
    public static final int OPTION_ALLOWSOKCANCEL = 2;
    protected static int meshTension = 2;
    protected static int tensionDistance = 0;
    protected static final double[] tensionArray = new double[]{5.0, 3.0, 2.0, 1.0, 0.5};
    static int lastNumViewsShown = 1;
    private static final String[] MENUITEMS_CHECKBOXITEMS = new String[]{"wireframeDisplay", "shadedDisplay", "smoothDisplay", "texturedDisplay", "transparentDisplay", "coordinateSystem", "localCoords", "sceneCoords", "controlMesh", "surface", "skeleton", "entireScene", "autosyncDragging", "showCoordinateAxes"};
    static /* synthetic */ Class class$buoy$event$MouseClickedEvent;
    static /* synthetic */ Class class$buoy$event$CommandEvent;

    public MeshEditorWindow(EditingWindow parent, String title, ObjectInfo info, Runnable onClose) {
        super(title);
        this.objInConstructor = info;
        this.parentWindow = parent;
        System.out.println("MeshEditorWindow.MeshEditorWindow1 " + info.getObject3D().getClass().getName());
        this.oldObject = info.getObject3D().duplicate();
        System.out.println("MeshEditorWindow.MeshEditorWindow2 " + this.oldObject.getClass().getName());
        this.undoStack = new UndoStack();
        info.getObject3D().prepareForEditing();
        if (ModellingApp.APP_ICON != null) {
            ((Frame)this.getComponent()).setIconImage(ModellingApp.APP_ICON);
        }
        this.addEventLink(WindowClosingEvent.class, new Object(){

            public void processEvent() {
                BStandardDialog dlg = new BStandardDialog("", Translate.text("saveWindowChanges"), BStandardDialog.QUESTION);
                String[] options = new String[]{Translate.text("saveChanges"), Translate.text("discardChanges"), Translate.text("button.cancel")};
                int choice = dlg.showOptionDialog(MeshEditorWindow.this, options, options[0]);
                if (choice == 0) {
                    MeshEditorWindow.this.doOk();
                } else if (choice == 1) {
                    MeshEditorWindow.this.doCancel();
                }
            }
        });
        this.numViewsShown = 4;
        this.currentView = 0;
        this.theView = new MeshViewer[4];
        this.viewPanel = new BorderContainer[4];
        Object listen = new Object(){

            public void processEvent(MouseClickedEvent ev) {
                for (int i = 0; i < MeshEditorWindow.this.theView.length; ++i) {
                    if (MeshEditorWindow.this.currentView == i || ev.getSource() != MeshEditorWindow.this.theView[i]) continue;
                    MeshEditorWindow.this.theView[MeshEditorWindow.this.currentView].setDrawFocus(false);
                    MeshEditorWindow.this.theView[i].setDrawFocus(true);
                    MeshEditorWindow.this.currentView = i;
                    MeshEditorWindow.this.updateMenus();
                    MeshEditorWindow.this.updateImage();
                }
            }
        };
        this.baseSkelControlHolder = new SkeletonControlHolder(info);
        for (int i = 0; i < 4; ++i) {
            this.viewPanel[i] = new BorderContainer();
            RowContainer p = new RowContainer();
            this.viewPanel[i].add(p, BorderContainer.NORTH);
            this.theView[i] = this.createMeshViewer(info, p);
            this.viewPanel[i].add(this.theView[i], BorderContainer.CENTER);
            this.theView[i].setMetaTool(this.getMetaTool());
            this.theView[i].setAltTool(this.getAltTool());
            this.theView[i].setSkeletonControlHolder(this.baseSkelControlHolder);
            this.theView[i].addEventLink(class$buoy$event$MouseClickedEvent == null ? MeshEditorWindow.class$("buoy.event.MouseClickedEvent") : class$buoy$event$MouseClickedEvent, listen);
        }
        this.theView[1].selectOrientation(2);
        this.theView[2].selectOrientation(4);
        this.theView[3].selectOrientation(6);
        this.theView[3].setPerspective(true);
        this.theView[this.currentView].setDrawFocus(true);
        this.viewsContainer = new GridContainer(1, 1);
        this.viewsContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.onClose = onClose;
        FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{0.0, 1.0, 0.0, 0.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.helpText = new BLabel();
        content.add(this.helpText, 0, 3, 2, 1);
        FormContainer top = new FormContainer(new double[]{0.0, 1.0, 0.0, 0.0}, new double[]{1.0});
        content.add(top, 1, 0);
        RowContainer viewControls = new RowContainer();
        top.add(viewControls, 0, 0);
        content.add(this.viewsContainer, 1, 1, 1, 2);
        top.add(Translate.button("ok", this, "doOk"), 2, 0);
        top.add(Translate.button("cancel", this, "doCancel"), 3, 0);
        UIUtilities.applyDefaultFont(content);
        UIUtilities.applyDefaultBackground(content);
        this.initBaseSelectionHolder(info);
        this.initWindowMenus(info);
        this.toolsPanel = this.createToolbarPanel();
        System.out.println("MeshEditorWindow toolsPanel" + this.toolsPanel);
        content.add(this.toolsPanel, 0, 0, 1, 3);
        if (lastNumViewsShown == 1) {
            this.toggleViewsCommand();
        } else if (lastNumViewsShown == 4) {
            this.toggleViewsCommand();
            this.toggleViewsCommand();
        }
        UIUtilities.recursivelyAddKeyPressedListeners(this);
    }

    protected boolean isMenuItemAllowed(MenuWidget item) {
        return true;
    }

    protected boolean isMenuItemNameCheckbox(String itemname) {
        return Utilities.findIndexEqual(MENUITEMS_CHECKBOXITEMS, itemname) > -1;
    }

    public MenuWidget createMenuItem(MenuDescription menudesc) {
        String name = menudesc.internalName;
        BMenuItem result = this.isMenuItemNameCheckbox(name) ? Translate.checkboxMenuItem(name, this, "itemStateChanged", false) : Translate.menuItem(name, this, "actionPerformed");
        if (!this.isMenuItemAllowed(result)) {
            return null;
        }
        menudesc.applyTo(result);
        return result;
    }

    protected BMenu createMenu(Object[] itemnames) {
        return (BMenu)this.createMenuRecurs(itemnames);
    }

    protected MenuWidget createMenuRecurs(Object[] itemnames) {
        boolean separator = false;
        BMenu result = Translate.menu((String)itemnames[0]);
        for (int i = 1; i < itemnames.length; ++i) {
            if ("separator".equals(itemnames[i])) {
                separator = true;
                continue;
            }
            MenuWidget mi = null;
            if (itemnames[i] instanceof String) {
                MenuDescription desc = new MenuDescription();
                desc.internalName = (String)itemnames[i];
                mi = this.createMenuItem(desc);
            } else if (itemnames[i] instanceof Object[]) {
                mi = this.createMenuRecurs((Object[])itemnames[i]);
            }
            if (mi == null) continue;
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            result.add(mi);
        }
        return result;
    }

    protected void createViewMenu() {
        this.viewMenu = this.createMenu(new Object[]{"view", new Object[]{"displayMode", "wireframeDisplay", "shadedDisplay", "smoothDisplay", "texturedDisplay", "transparentDisplay"}, new Object[]{"show", "controlMesh", "surface", "skeleton", "entireScene"}, new Object[]{"coordinateSystem", "localCoords", "sceneCoords"}, "setViewSettingsForAllViews", "separator", "fourViews", "autosyncDragging", "separator", "grid", "createNewViewNewSelection", "showTemplate", "setTemplate"});
        this.menubar.add(this.viewMenu);
    }

    public void toggleViewsCommand() {
        this.viewsContainer.removeAll();
        if (this.numViewsShown == 4) {
            for (int i = 0; i < this.theView.length; ++i) {
                this.theView[i].setVisible(i == this.currentView);
            }
            this.numViewsShown = 1;
            this.viewsContainer.setRowCount(1);
            this.viewsContainer.setColumnCount(1);
            this.viewsContainer.add(this.viewPanel[this.currentView], 0, 0);
        } else {
            this.numViewsShown = 4;
            this.viewsContainer.setRowCount(2);
            this.viewsContainer.setColumnCount(2);
            this.viewsContainer.add(this.viewPanel[0], 0, 0);
            this.viewsContainer.add(this.viewPanel[1], 1, 0);
            this.viewsContainer.add(this.viewPanel[2], 0, 1);
            this.viewsContainer.add(this.viewPanel[3], 1, 1);
            for (int i = 0; i < this.theView.length; ++i) {
                this.theView[i].setVisible(true);
            }
        }
        this.viewsContainer.layoutChildren();
        this.updateMenus();
        this.updateImage();
        this.viewPanel[this.currentView].requestFocus();
        lastNumViewsShown = this.numViewsShown;
    }

    protected BMenu createShowMenu() {
        BMenu menu = Translate.menu("show");
        menu.add(Translate.checkboxMenuItem("controlMesh", this, "itemStateChanged", this.theView[0].getMeshVisible()));
        menu.add(Translate.checkboxMenuItem("surface", this, "itemStateChanged", this.theView[0].getSurfaceVisible()));
        menu.add(Translate.checkboxMenuItem("skeleton", this, "itemStateChanged", this.theView[0].getSkeletonVisible()));
        menu.add(Translate.checkboxMenuItem("entireScene", this, "itemStateChanged", this.theView[0].getSceneVisible()));
        return menu;
    }

    protected void updateMenuItem(MenuWidget item) {
        String itemname = ((Widget)((Object)item)).getName();
        MeshViewer currView = this.getCurrentView();
        BCheckBoxMenuItem cbitem = null;
        BMenuItem mnitem = null;
        if (item instanceof BCheckBoxMenuItem) {
            cbitem = (BCheckBoxMenuItem)item;
        } else if (item instanceof BMenuItem) {
            mnitem = (BMenuItem)item;
        } else {
            return;
        }
        if ("undo".equals(itemname)) {
            mnitem.setEnabled(this.undoStack.canUndo());
        } else if ("redo".equals(itemname)) {
            mnitem.setEnabled(this.undoStack.canRedo());
        } else if ("localCoords".equals(itemname)) {
            cbitem.setState(!currView.getUseWorldCoords());
        } else if ("sceneCoords".equals(itemname)) {
            cbitem.setState(currView.getUseWorldCoords());
        } else if ("wireframeDisplay".equals(itemname)) {
            cbitem.setState(currView.getRenderMode() == 0);
        } else if ("shadedDisplay".equals(itemname)) {
            cbitem.setState(currView.getRenderMode() == 1);
        } else if ("smoothDisplay".equals(itemname)) {
            cbitem.setState(currView.getRenderMode() == 2);
        } else if ("texturedDisplay".equals(itemname)) {
            cbitem.setState(currView.getRenderMode() == 3);
        } else if ("transparentDisplay".equals(itemname)) {
            cbitem.setState(currView.getRenderMode() == 4);
        } else if ("controlMesh".equals(itemname)) {
            cbitem.setState(currView.getMeshVisible());
        } else if ("surface".equals(itemname)) {
            cbitem.setState(currView.getSurfaceVisible());
        } else if ("skeleton".equals(itemname)) {
            cbitem.setState(currView.getSkeletonVisible());
        } else if ("entireScene".equals(itemname)) {
            cbitem.setState(currView.getSceneVisible());
        } else if ("autosyncDragging".equals(itemname)) {
            cbitem.setState(currView.getDraggingAutosync());
        } else if ("showTemplate".equals(itemname)) {
            if (currView.getTemplateImage() == null) {
                mnitem.setEnabled(false);
            } else {
                mnitem.setEnabled(true);
                boolean wasShown = currView.getTemplateShown();
                mnitem.setText(Translate.text(wasShown ? "menu.showTemplate" : "menu.hideTemplate"));
            }
        } else if ("showCoordinateAxes".equals(itemname)) {
            cbitem.setState(currView.getShowAxes());
        }
    }

    public void updateMenus() {
        if (this.menuitemsCache == null) {
            this.menuitemsCache = UIUtilities.getMenuItemList(this.getMenuBar());
        }
        for (int i = 0; i < this.menuitemsCache.length; ++i) {
            this.updateMenuItem(this.menuitemsCache[i]);
        }
    }

    public MeshViewer getCurrentView() {
        return this.theView[this.currentView];
    }

    public abstract MeshViewer createMeshViewer(ObjectInfo var1, RowContainer var2);

    public abstract void initBaseSelectionHolder(ObjectInfo var1);

    public void initWindowMenus(ObjectInfo obj) {
    }

    public EditingTool getMetaTool() {
        if (this.metaTool == null) {
            this.metaTool = new MoveViewTool(this);
        }
        return this.metaTool;
    }

    public EditingTool getAltTool() {
        if (this.altTool == null) {
            this.altTool = new RotateViewTool(this);
        }
        return this.altTool;
    }

    public abstract BorderContainer createToolbarPanel();

    public boolean confirmClose() {
        return true;
    }

    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    public void setSceneForViews(Scene sc, ObjectInfo thisObject) {
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setScene(sc, thisObject);
        }
    }

    public void setDraggingAutosyncForViews(boolean autosyncDragging) {
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setDraggingAutosync(autosyncDragging);
        }
    }

    public BFrame getFrame() {
        return this;
    }

    public void updateImage() {
        if (this.numViewsShown == 1) {
            this.theView[this.currentView].updateImage();
            this.theView[this.currentView].repaint();
        } else {
            for (int i = 0; i < this.numViewsShown; ++i) {
                this.theView[i].updateImage();
                this.theView[i].repaint();
            }
        }
    }

    public void setUndoRecord(UndoRecord command) {
        this.undoStack.addRecord(command);
        this.updateMenus();
    }

    protected boolean handleMenuAction(String command) {
        if (this.callCommandMethod(command + "Command")) {
            return true;
        }
        if (command.equals("ok")) {
            this.doOk();
        } else if (command.equals("cancel")) {
            this.doCancel();
        }
        return false;
    }

    protected boolean callCommandMethod(String methodname) {
        try {
            this.getClass().getMethod(methodname, null).invoke((Object)this, new Object[0]);
            return true;
        }
        catch (NoSuchMethodException nme) {
            return false;
        }
        catch (InvocationTargetException ite) {
            ite.getTargetException().printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected abstract MeshEditorWindow createNewViewNewSelection();

    protected MeshEditorWindow createNewViewSameSelection() {
        return null;
    }

    public Scene getScene() {
        return this.getCurrentView().getScene();
    }

    protected void keyPressed(KeyPressedEvent e) {
        int code = e.getKeyCode();
        if (e.isShiftDown() && (code == 37 || code == 39 || code == 38 || code == 40)) {
            this.tools.keyPressed(e);
        } else {
            this.currentTool.keyPressed(e, this.getCurrentView());
        }
    }

    protected void object3DChangedDuringEditor() {
        this.getCurrentView().getObject().object.informChanged(this, "object editor");
    }

    public void undoCommand() {
        this.undoStack.executeUndo();
        this.getCurrentView().setMesh((Mesh)((Object)this.getCurrentView().getObject().object));
        this.updateImage();
        this.updateMenus();
    }

    void redoCommand() {
        this.undoStack.executeRedo();
        this.getCurrentView().setMesh((Mesh)((Object)this.getCurrentView().getObject().object));
        this.updateImage();
        this.updateMenus();
        this.object3DChangedDuringEditor();
    }

    public void doOk() {
        Object3D theMesh = this.getCurrentView().getObject().getObject3D();
        if (this.oldObject.getMaterial() != null && !theMesh.isClosed()) {
            String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
            BStandardDialog dlg = new BStandardDialog("", UIUtilities.breakString(Translate.text("surfaceNoLongerClosed")), BStandardDialog.WARNING);
            int choice = dlg.showOptionDialog(this, options, options[0]);
            if (choice == 1) {
                return;
            }
            theMesh.setMaterial(null, null);
        }
        theMesh.unprepareAfterEditing();
        this.dispose();
        this.onClose.run();
        theMesh.informChanged(this, "object editor commit");
        this.parentWindow.updateImage();
        this.parentWindow.updateMenus();
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].dispose();
        }
    }

    public void doCancel() {
        Object3D theMesh = this.getCurrentView().getObject().getObject3D();
        theMesh.copyObject(this.oldObject);
        theMesh.informChanged(this, "object editor rollback");
        theMesh.unprepareAfterEditing();
        this.dispose();
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].dispose();
        }
    }

    public ViewerCanvas getView() {
        return this.getCurrentView();
    }

    public void itemStateChanged(CommandEvent e) {
        Object source = e.getSource();
        BCheckBoxMenuItem sourceitem = null;
        MeshViewer currView = this.getCurrentView();
        String itemname = "";
        if (source instanceof BCheckBoxMenuItem) {
            sourceitem = (BCheckBoxMenuItem)source;
            itemname = sourceitem.getName();
        }
        if ("localCoords".equals(itemname) || "sceneCoords".equals(itemname)) {
            currView.setUseWorldCoords("sceneCoords".equals(itemname));
        } else if ("controlMesh".equals(itemname)) {
            currView.setMeshVisible(sourceitem.getState());
        } else if ("surface".equals(itemname)) {
            currView.setSurfaceVisible(sourceitem.getState());
        } else if ("skeleton".equals(itemname)) {
            currView.setSkeletonVisible(sourceitem.getState());
        } else if ("entireScene".equals(itemname)) {
            currView.setSceneVisible(sourceitem.getState());
        } else if ("autosyncDragging".equals(itemname)) {
            this.setDraggingAutosyncForViews(sourceitem.getState());
        } else if ("wireframeDisplay".equals(itemname)) {
            currView.setRenderMode(0);
        } else if ("shadedDisplay".equals(itemname)) {
            currView.setRenderMode(1);
        } else if ("smoothDisplay".equals(itemname)) {
            currView.setRenderMode(2);
        } else if ("texturedDisplay".equals(itemname)) {
            currView.setRenderMode(3);
        } else if ("transparentDisplay".equals(itemname)) {
            currView.setRenderMode(4);
        } else if ("showCoordinateAxes".equals(itemname)) {
            for (int i = 0; i < this.theView.length; ++i) {
                this.theView[i].setShowAxes(sourceitem.getState());
            }
        }
        this.updateMenus();
        this.updateImage();
    }

    public void setPointsCommand() {
        ComponentsDialog dlg;
        String title;
        ValueField zField;
        ValueField yField;
        ValueField xField;
        int i;
        int j = 0;
        int num = 0;
        final Mesh theMesh = (Mesh)((Object)this.getCurrentView().getObject().object);
        Mesh oldMesh = (Mesh)((Object)theMesh.duplicate());
        Skeleton s = theMesh.getSkeleton();
        Joint[] jt = null;
        final int[] selected = this.getCurrentView().getSelectionDistance();
        final CoordinateSystem coords = this.getCurrentView().thisObjectInScene.coords;
        final MeshVertex[] vert = theMesh.getVertices();
        final Vec3[] points = new Vec3[vert.length];
        ValueSlider weightSlider = null;
        BComboBox jointChoice = null;
        double weight = -1.0;
        int joint = -2;
        for (i = 0; i < selected.length; ++i) {
            if (selected[i] != 0) continue;
            ++num;
            j = i;
            if (weight == -1.0) {
                weight = vert[i].ikWeight;
            } else if (vert[i].ikWeight != weight) {
                weight = Double.NaN;
            }
            if (joint == -2) {
                joint = vert[i].ikJoint;
                continue;
            }
            if (vert[i].ikJoint == joint) continue;
            joint = -3;
        }
        if (num == 0) {
            return;
        }
        if (num == 1) {
            Vec3 pos = vert[j].r;
            if (this.getCurrentView().getUseWorldCoords() && coords != null) {
                pos = coords.fromLocal().times(pos);
            }
            xField = new ValueField(pos.x, 0, 5);
            yField = new ValueField(pos.y, 0, 5);
            zField = new ValueField(pos.z, 0, 5);
            title = Translate.text("editVertSingle");
        } else {
            xField = new ValueField(Double.NaN, 0, 5);
            yField = new ValueField(Double.NaN, 0, 5);
            zField = new ValueField(Double.NaN, 0, 5);
            title = Translate.text("editVertMultiple");
        }
        Object listener = new Object(){

            void processEvent() {
                int i;
                for (i = 0; i < selected.length; ++i) {
                    points[i] = vert[i].r;
                    if (selected[i] != 0) continue;
                    if (MeshEditorWindow.this.getCurrentView().getUseWorldCoords() && coords != null) {
                        coords.fromLocal().transform(points[i]);
                    }
                    if (!Double.isNaN(xField.getValue())) {
                        points[i].x = xField.getValue();
                    }
                    if (!Double.isNaN(yField.getValue())) {
                        points[i].y = yField.getValue();
                    }
                    if (!Double.isNaN(zField.getValue())) {
                        points[i].z = zField.getValue();
                    }
                    if (!MeshEditorWindow.this.getCurrentView().getUseWorldCoords() || coords == null) continue;
                    coords.toLocal().transform(points[i]);
                }
                theMesh.setVertexPositions(points);
                for (i = 0; i < MeshEditorWindow.this.theView.length; ++i) {
                    MeshEditorWindow.this.theView[i].setMesh(theMesh);
                }
                MeshEditorWindow.this.updateImage();
            }
        };
        xField.addEventLink(ValueChangedEvent.class, listener);
        yField.addEventLink(ValueChangedEvent.class, listener);
        zField.addEventLink(ValueChangedEvent.class, listener);
        if (s == null) {
            dlg = new ComponentsDialog(this, title, new Widget[]{xField, yField, zField}, new String[]{"X", "Y", "Z"});
        } else {
            weightSlider = new ValueSlider(0.0, 1.0, 100, weight);
            jointChoice = new BComboBox();
            jointChoice.add(Translate.text("none"));
            jt = s.getJoints();
            for (i = 0; i < jt.length; ++i) {
                jointChoice.add(jt[i].name);
            }
            if (joint == -3) {
                jointChoice.add("");
            }
            jointChoice.setSelectedIndex(0);
            for (i = 0; i < jt.length; ++i) {
                if (jt[i].id != joint) continue;
                jointChoice.setSelectedIndex(i + 1);
            }
            if (joint == -3) {
                jointChoice.setSelectedIndex(jt.length + 1);
            }
            dlg = new ComponentsDialog(this, title, new Widget[]{xField, yField, zField, jointChoice, weightSlider}, new String[]{"X", "Y", "Z", Translate.text("ikBone"), Translate.text("ikWeight")});
        }
        if (dlg.clickedOk()) {
            for (i = 0; i < selected.length; ++i) {
                if (selected[i] != 0) continue;
                if (weightSlider != null && !Double.isNaN(weightSlider.getValue())) {
                    vert[i].ikWeight = weightSlider.getValue();
                }
                if (jointChoice == null) continue;
                if (jointChoice.getSelectedIndex() == 0) {
                    vert[i].ikJoint = -1;
                    continue;
                }
                if (jointChoice.getSelectedIndex() > jt.length) continue;
                vert[i].ikJoint = jt[jointChoice.getSelectedIndex() - 1].id;
            }
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, oldMesh}));
            this.object3DChangedDuringEditor();
        } else {
            theMesh.copyObject((Object3D)((Object)oldMesh));
            for (i = 0; i < this.theView.length; ++i) {
                this.theView[i].setMesh(theMesh);
            }
            this.updateImage();
        }
    }

    public void transformPointsCommand() {
        int i;
        Mesh theMesh = (Mesh)((Object)this.getCurrentView().getObject().object);
        int[] selected = this.getCurrentView().getSelectionDistance();
        MeshVertex[] vert = theMesh.getVertices();
        Vec3[] points = new Vec3[vert.length];
        CoordinateSystem coords = this.getCurrentView().thisObjectInScene.coords;
        for (i = 0; i < selected.length && selected[i] == -1; ++i) {
        }
        if (i == selected.length) {
            return;
        }
        FormContainer content = new FormContainer(4, 5);
        LayoutInfo eastLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        content.add(Translate.label("Move"), 0, 1, eastLayout);
        content.add(Translate.label("Rotate"), 0, 2, eastLayout);
        content.add(Translate.label("Scale"), 0, 3, eastLayout);
        content.add(new BLabel("X"), 1, 0);
        content.add(new BLabel("Y"), 2, 0);
        content.add(new BLabel("Z"), 3, 0);
        ValueField[] fields = new ValueField[9];
        for (i = 0; i < 9; ++i) {
            fields[i] = new ValueField(Double.NaN, 0);
            content.add(fields[i], i % 3 + 1, i / 3 + 1);
        }
        RowContainer row = new RowContainer();
        content.add(row, 0, 4, 4, 1);
        row.add(Translate.label("transformAround"));
        BComboBox centerChoice = new BComboBox(new String[]{Translate.text("centerOfSelection"), Translate.text("objectOrigin")});
        row.add(centerChoice);
        PanelDialog dlg = new PanelDialog((WindowWidget)this, Translate.text("transformPoints"), content);
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 13, new Object[]{theMesh, theMesh.getVertexPositions()}));
        double[] val = new double[9];
        for (i = 0; i < val.length; ++i) {
            val[i] = fields[i].getValue();
            if (!Double.isNaN(val[i])) continue;
            val[i] = i < 6 ? 0.0 : 1.0;
        }
        Mat4 m = Mat4.translation(val[0], val[1], val[2]);
        m = m.times(Mat4.xrotation(val[3] * Math.PI / 180.0));
        m = m.times(Mat4.yrotation(val[4] * Math.PI / 180.0));
        m = m.times(Mat4.zrotation(val[5] * Math.PI / 180.0));
        m = m.times(Mat4.scale(val[6], val[7], val[8]));
        if (this.getCurrentView().getUseWorldCoords() && coords != null) {
            m = coords.toLocal().times(m).times(coords.fromLocal());
        }
        if (centerChoice.getSelectedIndex() == 0) {
            Vec3 center = new Vec3();
            int j = 0;
            for (i = 0; i < selected.length; ++i) {
                if (selected[i] != 0) continue;
                center.add(vert[i].r);
                ++j;
            }
            center.scale(1.0 / (double)j);
            m = Mat4.translation(center.x, center.y, center.z).times(m).times(Mat4.translation(-center.x, -center.y, -center.z));
        }
        for (i = 0; i < selected.length; ++i) {
            points[i] = vert[i].r;
            if (selected[i] != 0) continue;
            points[i] = m.times(points[i]);
        }
        theMesh.setVertexPositions(points);
        this.object3DChangedDuringEditor();
    }

    public void randomizeCommand() {
        int i;
        Mesh theMesh = (Mesh)((Object)this.getCurrentView().getObject().object);
        int[] selected = this.getCurrentView().getSelectionDistance();
        CoordinateSystem coords = this.getCurrentView().thisObjectInScene.coords;
        MeshVertex[] vert = theMesh.getVertices();
        Vec3[] points = new Vec3[vert.length];
        for (i = 0; i < selected.length && selected[i] == -1; ++i) {
        }
        if (i == selected.length) {
            return;
        }
        ValueField xfield = new ValueField(0.0, 0);
        ValueField yfield = new ValueField(0.0, 0);
        ValueField zfield = new ValueField(0.0, 0);
        ComponentsDialog dlg = new ComponentsDialog(this, "Maximum random displacement:", new Widget[]{xfield, yfield, zfield}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 13, new Object[]{theMesh, theMesh.getVertexPositions()}));
        for (i = 0; i < selected.length; ++i) {
            points[i] = vert[i].r;
            if (selected[i] != 0) continue;
            if (this.getCurrentView().getUseWorldCoords() && coords != null) {
                coords.fromLocal().transform(points[i]);
            }
            points[i].x += (1.0 - 2.0 * Math.random()) * xfield.getValue();
            points[i].y += (1.0 - 2.0 * Math.random()) * yfield.getValue();
            points[i].z += (1.0 - 2.0 * Math.random()) * zfield.getValue();
            if (!this.getCurrentView().getUseWorldCoords() || coords == null) continue;
            coords.toLocal().transform(points[i]);
        }
        theMesh.setVertexPositions(points);
        this.object3DChangedDuringEditor();
    }

    public void centerCommand() {
        Mesh theMesh = (Mesh)((Object)this.getCurrentView().getObject().object);
        MeshVertex[] vert = theMesh.getVertices();
        CoordinateSystem coords = this.getCurrentView().thisObjectInScene.coords;
        Vec3 center = theMesh.getBounds().getCenter();
        Vec3[] points = new Vec3[vert.length];
        this.setUndoRecord(new UndoRecord(this, false, 13, new Object[]{theMesh, theMesh.getVertexPositions()}));
        if (this.getCurrentView().getUseWorldCoords() && coords != null) {
            coords.fromLocal().transform(center);
            coords.toLocal().transformDirection(center);
        }
        for (int i = 0; i < vert.length; ++i) {
            points[i] = vert[i].r.minus(center);
        }
        theMesh.setVertexPositions(points);
        Skeleton skeleton = theMesh.getSkeleton();
        if (skeleton != null) {
            Joint[] joint = skeleton.getJoints();
            for (int i = 0; i < joint.length; ++i) {
                joint[i].coords.setOrigin(joint[i].coords.getOrigin().minus(center));
            }
            this.object3DChangedDuringEditor();
        }
    }

    public void setTensionCommand() {
        ValueField distanceField = new ValueField((double)tensionDistance, 5);
        BComboBox tensionChoice = new BComboBox(new String[]{Translate.text("VeryLow"), Translate.text("Low"), Translate.text("Medium"), Translate.text("High"), Translate.text("VeryHigh")});
        tensionChoice.setSelectedIndex(meshTension);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("setTensionTitle"), new Widget[]{distanceField, tensionChoice}, new String[]{Translate.text("maxDistance"), Translate.text("Tension")});
        if (!dlg.clickedOk()) {
            return;
        }
        tensionDistance = (int)distanceField.getValue();
        meshTension = tensionChoice.getSelectedIndex();
    }

    public void createNewViewNewSelectionCommand() {
        this.createNewViewNewSelection().setVisible(true);
    }

    public void createNewViewSameSelectionCommand() {
        this.createNewViewSameSelection().setVisible(true);
    }

    public static double getMeshTension() {
        return tensionArray[meshTension];
    }

    public static int getTensionDistance() {
        return tensionDistance;
    }

    public void setParametersCommand() {
        PanelDialog dlg;
        int k;
        int i;
        int j;
        Mesh theMesh = (Mesh)((Object)this.getCurrentView().getObject().object);
        MeshVertex[] vert = theMesh.getVertices();
        ObjectInfo info = this.getCurrentView().getObject();
        TextureParameter[] param = info.object.getParameters();
        ParameterValue[] paramValue = info.object.getParameterValues();
        int[] paramIndex = null;
        int[] selected = this.getCurrentView().getSelectionDistance();
        for (j = 0; j < selected.length && selected[j] != 0; ++j) {
        }
        if (j == selected.length) {
            return;
        }
        if (param != null) {
            int num = 0;
            for (i = 0; i < param.length; ++i) {
                if (!(paramValue[i] instanceof VertexParameterValue)) continue;
                ++num;
            }
            paramIndex = new int[num];
            i = 0;
            for (k = 0; k < param.length; ++k) {
                if (!(paramValue[k] instanceof VertexParameterValue)) continue;
                paramIndex[i++] = k;
            }
        }
        if (paramIndex == null || paramIndex.length == 0) {
            new BStandardDialog("", Translate.text("noPerVertexParams"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        double[] value = new double[paramIndex.length];
        for (i = 0; i < paramIndex.length; ++i) {
            double[] currentVal = ((VertexParameterValue)paramValue[paramIndex[i]]).getValue();
            value[i] = currentVal[j];
            for (k = j; k < selected.length; ++k) {
                if (selected[k] != 0 || currentVal[k] == value[i]) continue;
                value[i] = Double.NaN;
            }
        }
        Widget[] editWidget = new Widget[paramIndex.length];
        ColumnContainer content = new ColumnContainer();
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
        LayoutInfo indent1 = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 10, 0, 0), null);
        LayoutInfo indent2 = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 20, 0, 0), null);
        RowContainer coordsPanel = null;
        class ResetButton
        extends BButton {
            VertexParameterValue xparamVal;
            VertexParameterValue yparamVal;
            VertexParameterValue zparamVal;
            double[] xvalList;
            double[] yvalList;
            double[] zvalList;
            ValueField xfield;
            ValueField yfield;
            ValueField zfield;
            private final /* synthetic */ ParameterValue[] val$paramValue;
            private final /* synthetic */ int[] val$selected;
            private final /* synthetic */ MeshVertex[] val$vert;

            public ResetButton(ParameterValue[] parameterValueArray, int[] nArray, MeshVertex[] meshVertexArray) {
                this.val$paramValue = parameterValueArray;
                this.val$selected = nArray;
                this.val$vert = meshVertexArray;
                super(Translate.text("Reset"));
                this.addEventLink(class$buoy$event$CommandEvent == null ? (class$buoy$event$CommandEvent = MeshEditorWindow.class$("buoy.event.CommandEvent")) : class$buoy$event$CommandEvent, this);
            }

            public void addParam(int index, int type, ValueField field) {
                if (type == 1) {
                    this.xparamVal = (VertexParameterValue)this.val$paramValue[index];
                    this.xvalList = this.xparamVal.getValue();
                    this.xfield = field;
                } else if (type == 2) {
                    this.yparamVal = (VertexParameterValue)this.val$paramValue[index];
                    this.yvalList = this.yparamVal.getValue();
                    this.yfield = field;
                } else if (type == 3) {
                    this.zparamVal = (VertexParameterValue)this.val$paramValue[index];
                    this.zvalList = this.zparamVal.getValue();
                    this.zfield = field;
                }
            }

            private void processEvent() {
                BStandardDialog dlg = new BStandardDialog("", Translate.text("resetCoordsToPos"), BStandardDialog.QUESTION);
                String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
                int choice = dlg.showOptionDialog(this, options, options[0]);
                if (choice == 1) {
                    return;
                }
                double xval = Double.NaN;
                double yval = Double.NaN;
                double zval = Double.NaN;
                for (int ind = 0; ind < this.val$selected.length; ++ind) {
                    if (this.val$selected[ind] != 0) continue;
                    if (this.xparamVal != null) {
                        this.xvalList[ind] = this.val$vert[ind].r.x;
                        if (Double.isNaN(xval)) {
                            xval = this.val$vert[ind].r.x;
                            this.xfield.setValue(xval);
                        } else if (xval != this.val$vert[ind].r.x) {
                            this.xfield.setValue(Double.NaN);
                        }
                    }
                    if (this.yparamVal != null) {
                        this.yvalList[ind] = this.val$vert[ind].r.y;
                        if (Double.isNaN(yval)) {
                            yval = this.val$vert[ind].r.y;
                            this.yfield.setValue(yval);
                        } else if (yval != this.val$vert[ind].r.y) {
                            this.yfield.setValue(Double.NaN);
                        }
                    }
                    if (this.zparamVal == null) continue;
                    this.zvalList[ind] = this.val$vert[ind].r.z;
                    if (Double.isNaN(zval)) {
                        zval = this.val$vert[ind].r.z;
                        this.zfield.setValue(zval);
                        continue;
                    }
                    if (zval == this.val$vert[ind].r.z) continue;
                    this.zfield.setValue(Double.NaN);
                }
                if (this.xparamVal != null) {
                    this.xparamVal.setValue(this.xvalList);
                }
                if (this.yparamVal != null) {
                    this.yparamVal.setValue(this.yvalList);
                }
                if (this.zparamVal != null) {
                    this.zparamVal.setValue(this.zvalList);
                }
            }
        }
        ResetButton reset = null;
        Object lastOwner = null;
        if (info.object.getTexture() instanceof LayeredTexture) {
            LayeredMapping map = (LayeredMapping)info.object.getTextureMapping();
            Texture[] layer = map.getLayers();
            for (k = 0; k < layer.length; ++k) {
                coordsPanel = null;
                content.add(new BLabel(Translate.text("layerLabel", Integer.toString(k + 1), layer[k].getName())));
                TextureParameter[] layerParam = map.getLayerParameters(k);
                boolean any = false;
                for (i = 0; i < paramIndex.length; ++i) {
                    int m;
                    TextureParameter pm = param[paramIndex[i]];
                    for (m = 0; m < layerParam.length && !layerParam[m].equals(pm); ++m) {
                    }
                    if (m == layerParam.length) continue;
                    any = true;
                    editWidget[i] = pm.getEditingWidget(value[i]);
                    if (pm.type == 0) {
                        RowContainer row = new RowContainer();
                        row.add(new BLabel(pm.name));
                        row.add(editWidget[i]);
                        content.add(row, indent1);
                        if (coordsPanel != null) {
                            coordsPanel.add(reset);
                        }
                        coordsPanel = null;
                        reset = null;
                        continue;
                    }
                    if (coordsPanel == null) {
                        coordsPanel = new RowContainer();
                        content.add(Translate.label("texMappingCoords"), indent1);
                        content.add(coordsPanel, indent2);
                        coordsPanel.add(new BLabel(pm.name));
                        coordsPanel.add(editWidget[i]);
                        reset = new ResetButton(paramValue, selected, vert);
                        reset.addParam(paramIndex[i], pm.type, (ValueField)editWidget[i]);
                        continue;
                    }
                    coordsPanel.add(new BLabel(pm.name));
                    coordsPanel.add(editWidget[i]);
                    reset.addParam(paramIndex[i], pm.type, (ValueField)editWidget[i]);
                }
                if (coordsPanel != null) {
                    coordsPanel.add(reset);
                }
                if (any) continue;
                content.add(Translate.label("noLayerPerVertexParams"), indent1);
            }
        } else {
            content.add(new BLabel(Translate.text("Texture") + ": " + info.object.getTexture().getName()));
            for (i = 0; i < paramIndex.length; ++i) {
                TextureParameter pm = param[paramIndex[i]];
                editWidget[i] = pm.getEditingWidget(value[i]);
                if (pm.type == 0) {
                    RowContainer row = new RowContainer();
                    row.add(new BLabel(pm.name));
                    row.add(editWidget[i]);
                    content.add(row, indent1);
                    if (coordsPanel != null) {
                        coordsPanel.add(reset);
                    }
                    coordsPanel = null;
                    coordsPanel = null;
                    continue;
                }
                if (coordsPanel == null) {
                    coordsPanel = new RowContainer();
                    content.add(Translate.label("texMappingCoords"), indent1);
                    content.add(coordsPanel, indent2);
                    coordsPanel.add(new BLabel(pm.name));
                    coordsPanel.add(editWidget[i]);
                    reset = new ResetButton(paramValue, selected, vert);
                    reset.addParam(paramIndex[i], pm.type, (ValueField)editWidget[i]);
                    continue;
                }
                coordsPanel.add(new BLabel(pm.name));
                coordsPanel.add(editWidget[i]);
                reset.addParam(paramIndex[i], pm.type, (ValueField)editWidget[i]);
            }
            if (coordsPanel != null) {
                coordsPanel.add(reset);
            }
        }
        if (!(dlg = new PanelDialog((WindowWidget)this, Translate.text("texParamsForSelectedPoints"), content)).clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        for (j = 0; j < editWidget.length; ++j) {
            double d = editWidget[j] instanceof ValueField ? ((ValueField)editWidget[j]).getValue() : ((ValueSlider)editWidget[j]).getValue();
            if (Double.isNaN(d)) continue;
            double[] val = ((VertexParameterValue)paramValue[paramIndex[j]]).getValue();
            for (i = 0; i < selected.length; ++i) {
                if (selected[i] != 0) continue;
                val[i] = d;
            }
            ((VertexParameterValue)paramValue[paramIndex[j]]).setValue(val);
        }
    }

    void showAxesCommand() {
        boolean wasShown = this.getCurrentView().getShowAxes();
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setShowAxes(!wasShown);
        }
        this.updateMenus();
        this.updateImage();
    }

    void showTemplateCommand() {
        boolean wasShown = this.getCurrentView().getTemplateShown();
        this.getCurrentView().setShowTemplate(!wasShown);
        this.updateMenus();
        this.updateImage();
    }

    public void setTemplateCommand() {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("selectTemplateImage"));
        if (!fc.showDialog(this)) {
            return;
        }
        try {
            this.getCurrentView().setTemplateImage(fc.getSelectedFile());
        }
        catch (InterruptedException ex) {
            new BStandardDialog("", Translate.text("errorLoadingImage", fc.getSelectedFile().getName()), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        this.getCurrentView().setShowTemplate(true);
        this.updateMenus();
        this.updateImage();
    }

    public void deleteJointCommand() {
        Mesh theMesh = (Mesh)((Object)this.getCurrentView().getObject().object);
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        Joint j = s.getJoint(this.getCurrentView().getSelectedJoint());
        if (j == null) {
            return;
        }
        String[] options = new String[]{Translate.text("Yes"), Translate.text("No")};
        BStandardDialog dlg = new BStandardDialog("", Translate.text(j.children.length == 0 ? "deleteBone" : "deleteBoneAndChildren", j.name), BStandardDialog.QUESTION);
        if (dlg.showOptionDialog(this, options, options[1]) == 1) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 14, new Object[]{theMesh.getSkeleton(), theMesh.getSkeleton().duplicate()}));
        s.deleteJoint(this.getCurrentView().getSelectedJoint());
        this.getCurrentView().setSelectedJoint(j.parent == null ? -1 : j.parent.id);
        this.object3DChangedDuringEditor();
        this.updateMenus();
    }

    public void setJointParentCommand() {
        MeshViewer theView = this.getCurrentView();
        Mesh theMesh = (Mesh)((Object)theView.getObject().object);
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        Joint j = s.getJoint(theView.getSelectedJoint());
        if (j == null) {
            return;
        }
        Joint[] joint = s.getJoints();
        boolean[] isChild = new boolean[joint.length];
        this.markChildJoints(s, j, isChild);
        Vector<Joint> options = new Vector<Joint>();
        for (int i = 0; i < isChild.length; ++i) {
            if (isChild[i]) continue;
            options.addElement(joint[i]);
        }
        BList ls = new BList();
        ls.setMultipleSelectionEnabled(false);
        ls.add("(" + Translate.text("None") + ")");
        ls.setSelected(0, true);
        for (int i = 0; i < options.size(); ++i) {
            ls.add(((Joint)options.elementAt((int)i)).name);
            if (options.elementAt(i) != j.parent) continue;
            ls.setSelected(i + 1, true);
        }
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("selectParentBone", j.name), new Widget[]{UIUtilities.createScrollingList(ls)}, new String[]{null});
        if (!dlg.clickedOk() || ls.getSelectedIndex() == -1) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 14, new Object[]{theMesh.getSkeleton(), theMesh.getSkeleton().duplicate()}));
        Joint oldParent = j.parent;
        if (ls.getSelectedIndex() == 0) {
            s.setJointParent(j, null);
        } else {
            s.setJointParent(j, (Joint)options.elementAt(ls.getSelectedIndex() - 1));
        }
        if (j.parent != null) {
            Vec3 ydir;
            Vec3 xdir;
            Vec3 oldZdir = j.coords.getZDirection();
            Vec3 oldYdir = j.coords.getUpDirection();
            Vec3 oldXdir = oldYdir.cross(oldZdir);
            Vec3 zdir = j.coords.getOrigin().minus(j.parent.coords.getOrigin());
            j.length.pos = zdir.length();
            zdir.normalize();
            if (Math.abs(oldXdir.dot(zdir)) < Math.abs(oldYdir.dot(zdir))) {
                xdir = oldXdir.minus(zdir.times(oldXdir.dot(zdir)));
                xdir.normalize();
                ydir = zdir.cross(xdir);
            } else {
                ydir = oldYdir.minus(zdir.times(oldYdir.dot(zdir)));
                ydir.normalize();
                xdir = ydir.cross(zdir);
            }
            j.coords.setOrientation(zdir, ydir);
            j.calcAnglesFromCoords(false);
            for (int i = 0; i < j.children.length; ++i) {
                j.children[i].calcAnglesFromCoords(false);
            }
        } else {
            j.calcAnglesFromCoords(false);
        }
        this.updateImage();
        this.updateMenus();
    }

    private void markChildJoints(Skeleton s, Joint j, boolean[] isChild) {
        isChild[s.findJointIndex((int)j.id)] = true;
        for (int i = 0; i < j.children.length; ++i) {
            this.markChildJoints(s, j.children[i], isChild);
        }
    }

    public void editJointCommand() {
        Mesh theMesh = (Mesh)((Object)this.getCurrentView().getObject().object);
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        Joint j = s.getJoint(this.getCurrentView().getSelectedJoint());
        if (j == null) {
            return;
        }
        new JointEditorDialog(this, this.getCurrentView(), j.id);
        this.updateImage();
        this.updateMenus();
    }

    public void bindSkeletonCommand() {
        int i;
        int j;
        Mesh theMesh = (Mesh)((Object)this.getCurrentView().getObject().object);
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        int[] selected = this.getCurrentView().getSelectionDistance();
        for (j = 0; j < selected.length && selected[j] != 0; ++j) {
        }
        if (j == selected.length) {
            return;
        }
        ValueSlider blendSlider = new ValueSlider(0.0, 1.0, 100, 0.5);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("bindPointsToSkeleton"), new Widget[]{blendSlider}, new String[]{Translate.text("ikWeightBlending")});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        double blend = blendSlider.getValue();
        Joint[] joint = s.getJoints();
        Vec3[] pos = new Vec3[joint.length];
        Vec3[] axis = new Vec3[joint.length];
        for (i = 0; i < joint.length; ++i) {
            pos[i] = joint[i].coords.getOrigin();
            if (joint[i].parent == null || joint[i].length.pos == 0.0) continue;
            axis[i] = joint[i].coords.getZDirection();
            axis[i] = axis[i].times(1.0 / axis[i].length());
        }
        MeshVertex[] vert = theMesh.getVertices();
        double[] dist = new double[joint.length];
        for (i = 0; i < selected.length; ++i) {
            if (selected[i] != 0) continue;
            int nearest = -1;
            for (j = 0; j < joint.length; ++j) {
                dist[j] = this.distToBone(vert[i].r, joint[j], axis[j]);
                if (nearest != -1 && !(dist[j] < dist[nearest])) continue;
                nearest = j;
            }
            if (nearest == -1) continue;
            int second = -1;
            if (joint[nearest].parent != null) {
                second = s.findJointIndex(joint[nearest].parent.id);
            }
            for (j = 0; j < joint[nearest].children.length; ++j) {
                int k = s.findJointIndex(joint[nearest].children[j].id);
                if (k == -1 || second != -1 && !(dist[k] < dist[second])) continue;
                second = k;
            }
            if (second == -1) {
                vert[i].ikJoint = joint[nearest].id;
                vert[i].ikWeight = 1.0;
            } else if (joint[nearest].parent != null && joint[second].id == joint[nearest].parent.id) {
                vert[i].ikJoint = joint[nearest].id;
                double ratio = dist[nearest] / dist[second];
                vert[i].ikWeight = ratio <= 1.0 - blend ? 1.0 : 0.5 + 0.5 * (1.0 - ratio) / blend;
            } else {
                double ratio = dist[nearest] / dist[second];
                if (ratio <= 1.0 - blend) {
                    vert[i].ikJoint = joint[nearest].id;
                    vert[i].ikWeight = 1.0;
                } else {
                    vert[i].ikJoint = joint[second].id;
                    vert[i].ikWeight = 0.5 - 0.5 * (1.0 - ratio) / blend;
                }
            }
            vert[i].ikWeight = 0.001 * (double)Math.round(vert[i].ikWeight * 1000.0);
        }
        this.object3DChangedDuringEditor();
    }

    private double distToBone(Vec3 v, Joint j, Vec3 axis) {
        Vec3 end = j.coords.getOrigin();
        if (axis == null) {
            return end.distance(v);
        }
        Vec3 base = j.parent.coords.getOrigin();
        Vec3 diff = v.minus(base);
        double dot = diff.dot(axis);
        if (dot < 0.0) {
            return base.distance(v);
        }
        if (dot > j.length.pos) {
            return end.distance(v);
        }
        diff.subtract(axis.times(dot));
        return diff.length();
    }

    protected void importSkeletonCommand() {
        TreeList tree = new TreeList(this);
        tree.setPreferredSize(new Dimension(130, 100));
        tree.setAllowMultiple(false);
        tree.setUpdateEnabled(false);
        Scene theScene = this.getScene();
        for (int i = 0; i < theScene.getNumObjects(); ++i) {
            ObjectInfo info = theScene.getObject(i);
            if (info.parent != null) continue;
            class TreeElem
            extends ObjectTreeElement {
                public TreeElem(ObjectInfo info, TreeElement parent, TreeList tree) {
                    super(info, parent, tree, false);
                    this.selectable = info != MeshEditorWindow.this.getCurrentView().thisObjectInScene && info.getSkeleton() != null;
                    for (int i = 0; i < info.children.length; ++i) {
                        this.children.addElement(new TreeElem(info.children[i], this, tree));
                    }
                }

                public boolean isGray() {
                    return !this.selectable;
                }

                public boolean canAcceptAsParent(TreeElement el) {
                    return false;
                }
            }
            tree.addElement(new TreeElem(info, null, tree));
        }
        tree.setUpdateEnabled(true);
        tree.setBackground(Color.white);
        BScrollPane sp = new BScrollPane(tree, BScrollPane.SCROLLBAR_ALWAYS, BScrollPane.SCROLLBAR_ALWAYS);
        sp.getVerticalScrollBar().setUnitIncrement(10);
        sp.setForceWidth(true);
        sp.setForceHeight(true);
        ComponentsDialog dlg = new ComponentsDialog(this, "selectImportSkeleton", new Widget[]{sp}, new String[]{null});
        if (!dlg.clickedOk() || tree.getSelectedObjects().length == 0) {
            return;
        }
        Mesh theMesh = (Mesh)((Object)this.getCurrentView().getObject().object);
        this.setUndoRecord(new UndoRecord(this, false, 14, new Object[]{theMesh.getSkeleton(), theMesh.getSkeleton().duplicate()}));
        ObjectInfo info = (ObjectInfo)tree.getSelectedObjects()[0];
        theMesh.getSkeleton().addAllJoints(info.object.getSkeleton());
        this.updateImage();
        this.updateMenus();
    }

    public void setGridCommand() {
        ValueField spaceField = new ValueField(this.getCurrentView().gridSpacing, 3);
        ValueField divField = new ValueField(this.getCurrentView().gridSubdivisions, 7);
        BCheckBox showBox = new BCheckBox(Translate.text("showGrid"), this.getCurrentView().showGrid);
        BCheckBox snapBox = new BCheckBox(Translate.text("snapToGrid"), this.getCurrentView().snapToGrid);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("gridTitle"), new Widget[]{spaceField, divField, showBox, snapBox}, new String[]{Translate.text("gridSpacing"), Translate.text("snapToSubdivisions"), null, null});
        if (!dlg.clickedOk()) {
            return;
        }
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].gridSpacing = spaceField.getValue();
            this.theView[i].gridSubdivisions = (int)divField.getValue();
            this.theView[i].showGrid = showBox.getState();
            this.theView[i].snapToGrid = snapBox.getState();
            this.theView[i].setGrid(spaceField.getValue(), (int)divField.getValue(), showBox.getState(), snapBox.getState());
        }
        this.updateImage();
    }

    public void setViewSettingsForAllViewsCommand() {
        MeshViewer cv = this.getCurrentView();
        for (int i = 0; i < this.theView.length; ++i) {
            if (cv == this.theView[i]) continue;
            this.theView[i].copyViewSettings(cv);
            this.theView[i].updateImage();
            this.theView[i].repaint();
        }
    }

    public abstract void adjustDeltas(Vec3[] var1);
}

