/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Sphere;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UniformTexture;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MouseEnteredEvent;
import buoy.event.MouseExitedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.widget.CustomWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;

public class MaterialPreviewer
extends CustomWidget
implements RenderListener {
    Scene theScene;
    Camera theCamera;
    Object3D theObject;
    ObjectInfo info;
    CoordinateSystem objectCoords;
    Image theImage;
    boolean mouseInside;
    boolean renderInProgress;
    Point clickPoint;
    Mat4 rotMatrix;
    public static final int HANDLE_SIZE = 5;
    static final double DRAG_SCALE = Math.PI / 360;

    public MaterialPreviewer(Texture tex, Material mat, int width, int height) {
        this(tex, mat, new Sphere(1.0, 1.0, 1.0), width, height);
    }

    public MaterialPreviewer(Texture tex, Material mat, Object3D obj, int width, int height) {
        ObjectInfo objInfo = new ObjectInfo(obj, new CoordinateSystem(), "");
        if (tex == null) {
            tex = UniformTexture.invisibleTexture();
        }
        objInfo.setTexture(tex, tex.getDefaultMapping());
        if (mat != null) {
            objInfo.setMaterial(mat, mat.getDefaultMapping());
        }
        this.init(objInfo, width, height);
    }

    public MaterialPreviewer(ObjectInfo obj, int width, int height) {
        this.init(obj.duplicate(), width, height);
    }

    private void init(ObjectInfo obj, int width, int height) {
        BoundingBox bounds = obj.getBounds();
        Vec3 size = bounds.getSize();
        double max = Math.max(size.x, Math.max(size.y, size.z)) / 2.0;
        double floor = -bounds.getSize().length() / 2.0;
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 10.0 * max), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        if (max > 10.0) {
            max = 10.0;
        }
        Vec3[] vert = new Vec3[]{new Vec3(100.0 * max, floor, 100.0 * max), new Vec3(-100.0 * max, floor, 100.0 * max), new Vec3(0.0, floor, -100.0 * max)};
        int[][] face = new int[][]{{0, 1, 2}};
        this.theScene = new Scene();
        this.theCamera = new Camera();
        this.theObject = obj.object;
        this.theCamera.setCameraCoordinates(coords);
        coords = new CoordinateSystem(new Vec3(), new Vec3(-0.5, -0.4, -1.0), Vec3.vy());
        this.theScene.addObject(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords, "", null);
        coords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        TriangleMesh tri = new TriangleMesh(vert, (int[][])face);
        this.theScene.addObject(tri, coords, "", null);
        Texture tex = this.theScene.getDefaultTexture();
        tri.setTexture(tex, tex.getDefaultMapping());
        this.info = obj;
        this.objectCoords = this.info.coords = new CoordinateSystem();
        this.theScene.addObject(this.info, null);
        this.setPreferredSize(new Dimension(width, height));
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.addEventLink(MouseEnteredEvent.class, (Object)this, "mouseEntered");
        this.addEventLink(MouseExitedEvent.class, (Object)this, "mouseExited");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        this.getComponent().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ev) {
                MaterialPreviewer.this.render();
            }
        });
        this.getComponent().addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent ev) {
                Renderer rend;
                if ((ev.getChangeFlags() & 2L) != 0L && !MaterialPreviewer.this.getComponent().isDisplayable() && (rend = ModellingApp.getPreferences().getTexturePreviewRenderer()) != null) {
                    rend.cancelRendering(MaterialPreviewer.this.theScene);
                }
            }
        });
        this.render();
    }

    public ObjectInfo getObject() {
        return this.info;
    }

    public void setTexture(Texture tex, TextureMapping map) {
        if (tex == null) {
            tex = UniformTexture.invisibleTexture();
        }
        if (map == null) {
            map = tex.getDefaultMapping();
        }
        this.info.setTexture(tex, map);
    }

    public void setMaterial(Material mat, MaterialMapping map) {
        this.theObject.setMaterial(mat, map);
    }

    public synchronized void render() {
        Renderer rend = ModellingApp.getPreferences().getTexturePreviewRenderer();
        if (rend == null) {
            return;
        }
        rend.cancelRendering(this.theScene);
        Rectangle bounds = this.getBounds();
        if (bounds.width == 0 || bounds.height == 0) {
            return;
        }
        this.theCamera.setSize(bounds.width, bounds.height);
        this.theCamera.setDistToScreen((double)bounds.height / 200.0 / Math.tan(0.14));
        rend.configurePreview();
        System.out.println("MaterialPreviewer.render1");
        rend.renderScene(this.theScene, this.theCamera, this, null);
        this.renderInProgress = true;
        this.repaint();
    }

    public synchronized void cancelRendering() {
        Renderer rend = ModellingApp.getPreferences().getTexturePreviewRenderer();
        if (rend != null) {
            rend.cancelRendering(this.theScene);
        }
    }

    private void paint(RepaintEvent ev) {
        Graphics2D g = ev.getGraphics();
        if (this.theImage != null) {
            g.drawImage(this.theImage, 0, 0, this.getComponent());
        }
        if (this.mouseInside) {
            this.drawHilight(g);
        }
        if (this.renderInProgress) {
            Rectangle bounds = this.getBounds();
            g.setColor(Color.red);
            g.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
        }
    }

    private void drawHilight(Graphics g) {
        Rectangle bounds = this.getBounds();
        g.setColor(Color.red);
        g.fillRect(0, 0, 5, 5);
        g.fillRect(bounds.width - 5, 0, 5, 5);
        g.fillRect(0, bounds.height - 5, 5, 5);
        g.fillRect(bounds.width - 5, bounds.height - 5, 5, 5);
    }

    private void drawObject(Graphics g) {
        g.setColor(Color.gray);
        this.theCamera.setObjectTransform(this.rotMatrix.times(this.objectCoords.fromLocal()));
        Object3D.draw(g, this.theCamera, this.theObject.getWireframeMesh(), this.theObject.getBounds());
    }

    public void imageUpdated(Image image) {
        this.theImage = image;
        this.repaint();
    }

    public void statusChanged(String status) {
    }

    public void imageComplete(ComplexImage image) {
        this.theImage = image.getImage();
        this.renderInProgress = false;
        this.repaint();
    }

    public void renderingCanceled() {
    }

    private void mouseEntered(MouseEnteredEvent e) {
        this.mouseInside = true;
        Graphics g = this.getComponent().getGraphics();
        this.drawHilight(g);
        g.dispose();
    }

    private void mouseExited(MouseExitedEvent e) {
        this.mouseInside = false;
        this.repaint();
    }

    private void mousePressed(MousePressedEvent e) {
        Graphics g = this.getComponent().getGraphics();
        this.clickPoint = e.getPoint();
        Renderer rend = ModellingApp.getPreferences().getTexturePreviewRenderer();
        if (rend != null) {
            rend.cancelRendering(this.theScene);
        }
        this.rotMatrix = Mat4.identity();
        this.drawObject(g);
        g.dispose();
    }

    private void mouseReleased(MouseReleasedEvent e) {
        Point dragPoint = e.getPoint();
        Vec3 rotAxis = new Vec3((double)(this.clickPoint.y - dragPoint.y) * (Math.PI / 360), (double)(dragPoint.x - this.clickPoint.x) * (Math.PI / 360), 0.0);
        double angle = rotAxis.length();
        if (angle != 0.0) {
            rotAxis = rotAxis.times(1.0 / angle);
            rotAxis = this.theCamera.getViewToWorld().timesDirection(rotAxis);
            this.rotMatrix = Mat4.axisRotation(rotAxis, angle);
            this.objectCoords.transformAxes(this.rotMatrix);
        }
        this.render();
    }

    private void mouseClicked(MouseClickedEvent e) {
        if (e.getClickCount() == 2) {
            this.objectCoords.setOrientation(0.0, 0.0, 0.0);
            this.render();
        }
    }

    private void mouseDragged(MouseDraggedEvent e) {
        Graphics g = this.getComponent().getGraphics();
        Point dragPoint = e.getPoint();
        Vec3 rotAxis = new Vec3((double)(this.clickPoint.y - dragPoint.y) * (Math.PI / 360), (double)(dragPoint.x - this.clickPoint.x) * (Math.PI / 360), 0.0);
        double angle = rotAxis.length();
        rotAxis = rotAxis.times(1.0 / angle);
        rotAxis = this.theCamera.getViewToWorld().timesDirection(rotAxis);
        this.rotMatrix = Mat4.axisRotation(rotAxis, angle);
        g.drawImage(this.theImage, 0, 0, this.getComponent());
        this.drawHilight(g);
        this.drawObject(g);
        g.dispose();
    }
}

