/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CreateCameraTool;
import artofillusion.CreateCubeTool;
import artofillusion.CreateCurveTool;
import artofillusion.CreateCylinderTool;
import artofillusion.CreateLightTool;
import artofillusion.CreatePolygonTool;
import artofillusion.CreateSphereTool;
import artofillusion.CreateSplineMeshTool;
import artofillusion.ModellingApp;
import artofillusion.ModellingTool;
import artofillusion.MoveObjectTool;
import artofillusion.MoveViewTool;
import artofillusion.ObjectMaterialDialog;
import artofillusion.ObjectTextureDialog;
import artofillusion.PreferencesWindow;
import artofillusion.RecentFiles;
import artofillusion.RenderSetupDialog;
import artofillusion.RotateObjectTool;
import artofillusion.RotateSceneViewTool;
import artofillusion.ScaleObjectTool;
import artofillusion.Scene;
import artofillusion.SceneEnvironmentData;
import artofillusion.SceneSubset;
import artofillusion.SceneViewer;
import artofillusion.TransformDialog;
import artofillusion.Translator;
import artofillusion.UndoRecord;
import artofillusion.UndoStack;
import artofillusion.Utilities;
import artofillusion.ViewerCanvas;
import artofillusion.animation.AnimationPreviewer;
import artofillusion.animation.ConstraintTrack;
import artofillusion.animation.EditKeyframesDialog;
import artofillusion.animation.IKTrack;
import artofillusion.animation.Joint;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.PathFromCurveDialog;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.ProceduralPositionTrack;
import artofillusion.animation.ProceduralRotationTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Score;
import artofillusion.animation.Skeleton;
import artofillusion.animation.TextureTrack;
import artofillusion.animation.Track;
import artofillusion.animation.VisibilityTrack;
import artofillusion.animation.distortion.BendTrack;
import artofillusion.animation.distortion.CustomDistortionTrack;
import artofillusion.animation.distortion.ScaleTrack;
import artofillusion.animation.distortion.ShatterTrack;
import artofillusion.animation.distortion.SkeletonShapeTrack;
import artofillusion.animation.distortion.TwistTrack;
import artofillusion.image.ImagesDialog;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.object.Curve;
import artofillusion.object.Cylinder;
import artofillusion.object.DirectionalLight;
import artofillusion.object.ExternalObject;
import artofillusion.object.NullObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.PointLight;
import artofillusion.object.SceneCamera;
import artofillusion.object.Sphere;
import artofillusion.object.SpotLight;
import artofillusion.object.TriangleMesh;
import artofillusion.script.ExecuteScriptWindow;
import artofillusion.script.ScriptRunner;
import artofillusion.script.ScriptedObject;
import artofillusion.script.ToolScript;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.ui.AutoScroller;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MenuDescription;
import artofillusion.ui.MenuEditDialog;
import artofillusion.ui.MenuItemFactory;
import artofillusion.ui.MenuStructure;
import artofillusion.ui.ObjectTreeElement;
import artofillusion.ui.PopupMenuManager;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowActivatedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BComboBox;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BPopupMenu;
import buoy.widget.BScrollPane;
import buoy.widget.BSplitPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.GridContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.MenuWidget;
import buoy.widget.OverlayContainer;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;

public class LayoutWindow
extends BFrame
implements EditingWindow,
PopupMenuManager,
MenuItemFactory {
    SceneViewer[] theView;
    BorderContainer[] viewPanel;
    GridContainer viewsContainer;
    FormContainer centerContainer;
    BSplitPane div1;
    BSplitPane div2;
    BScrollPane itemTreeScroller;
    Score theScore;
    ToolPalette tools;
    EditingTool defaultTool;
    EditingTool currentTool;
    BLabel helpText;
    BLabel timeFrameLabel;
    TreeList itemTree;
    Scene theScene;
    BMenuBar menubar;
    BPopupMenu popupMenu;
    BMenu recentFilesMenu;
    UndoStack undoStack;
    int numViewsShown;
    int currentView;
    boolean modified;
    final String[] MENUITEMS_CHECKBOXITEMS = new String[]{"wireframeDisplay", "shadedDisplay", "smoothDisplay", "texturedDisplay", "liveRenderSwitch", "showCoordinateAxes"};
    final String[] MENUITEMS_TRACKS = new String[]{"xyzOneTrack", "xyzThreeTracks", "proceduralTrack", "xyzOneTrack", "xyzThreeTracks", "quaternionTrack", "proceduralTrack", "poseTrack", "bendDistortion", "customDistortion", "scaleDistortion", "shatterDistortion", "twistDistortion", "constraintTrack", "visibilityTrack", "textureTrack"};
    final String[] CREATABLEOBJECTS = new String[]{"cube", "sphere", "cylinder", "cone", "pointLight", "directionalLight", "spotLight", "camera", "null"};
    static /* synthetic */ Class class$buoy$event$MousePressedEvent;

    public LayoutWindow(Scene s) {
        super(s.getName() == null ? "Untitled" : s.getName());
        this.theScene = s;
        this.helpText = new BLabel();
        this.theScore = new Score(this);
        this.undoStack = new UndoStack();
        this.createItemList();
        this.theView = new SceneViewer[4];
        this.viewPanel = new BorderContainer[4];
        Object listen = new Object(){

            void processEvent(MousePressedEvent ev) {
                for (int i = 0; i < LayoutWindow.this.theView.length; ++i) {
                    if (LayoutWindow.this.currentView == i || ev.getWidget() != LayoutWindow.this.theView[i]) continue;
                    LayoutWindow.this.theView[LayoutWindow.this.currentView].setDrawFocus(false);
                    LayoutWindow.this.theView[i].setDrawFocus(true);
                    LayoutWindow.this.currentView = i;
                    LayoutWindow.this.updateMenus();
                    LayoutWindow.this.updateImage();
                }
            }
        };
        for (int i = 0; i < 4; ++i) {
            this.viewPanel[i] = new BorderContainer();
            RowContainer row = new RowContainer();
            this.viewPanel[i].add(row, BorderContainer.NORTH);
            this.theView[i] = new SceneViewer(this.theScene, row, this);
            this.viewPanel[i].add(this.theView[i], BorderContainer.CENTER);
            this.theView[i].setGrid(this.theScene.getGridSpacing(), this.theScene.getGridSubdivisions(), this.theScene.getShowGrid(), this.theScene.getSnapToGrid());
            this.theView[i].addEventLink(class$buoy$event$MousePressedEvent == null ? LayoutWindow.class$("buoy.event.MousePressedEvent") : class$buoy$event$MousePressedEvent, listen);
        }
        this.theView[1].selectOrientation(2);
        this.theView[2].selectOrientation(4);
        this.theView[3].selectOrientation(6);
        this.theView[3].setPerspective(true);
        this.theView[this.currentView].setDrawFocus(true);
        this.viewsContainer = new GridContainer(1, 1);
        this.viewsContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.div1 = new BSplitPane(BSplitPane.HORIZONTAL, this.viewsContainer, this.itemTreeScroller);
        this.div1.setResizeWeight(1.0);
        this.div1.setOneTouchExpandable(true);
        this.centerContainer = new FormContainer(new double[]{0.0, 1.0}, new double[]{0.0, 1.0, 0.0, 0.0});
        this.centerContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.centerContainer.add(this.div1, 1, 0, 1, 3);
        this.centerContainer.add(this.helpText, 0, 3, 2, 1);
        this.div2 = new BSplitPane(BSplitPane.VERTICAL, this.centerContainer, this.theScore);
        this.div2.setResizeWeight(0.75);
        this.div2.setOneTouchExpandable(true);
        this.setContent(this.div2);
        this.numViewsShown = 1;
        this.tools = new ToolPalette(2, 7);
        this.defaultTool = new MoveObjectTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new RotateObjectTool(this));
        this.tools.addTool(new ScaleObjectTool(this));
        this.tools.addTool(new CreateCubeTool(this));
        this.tools.addTool(new CreateSphereTool(this));
        this.tools.addTool(new CreateCylinderTool(this));
        this.tools.addTool(new CreateSplineMeshTool(this));
        this.tools.addTool(new CreatePolygonTool(this));
        this.tools.addTool(new CreateCameraTool(this));
        this.tools.addTool(new CreateLightTool(this));
        this.tools.addTool(new CreateCurveTool(this, 2));
        this.tools.addTool(new CreateCurveTool(this, 3));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateSceneViewTool altTool = new RotateSceneViewTool(this, true);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setMetaTool(metaTool);
            this.theView[i].setAltTool(altTool);
        }
        this.centerContainer.add(this.tools, 0, 0);
        this.timeFrameLabel = new BLabel(Translate.text("timeFrameLabel", "0.0", "0"), BLabel.CENTER);
        this.centerContainer.add(this.timeFrameLabel, 0, 2, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.rebuildMenuBar();
        this.createPopupMenu();
        this.toggleViewsCommand();
        UIUtilities.recursivelyAddKeyPressedListeners(this);
        this.addEventLink(WindowActivatedEvent.class, (Object)this, "updateMenus");
        this.addEventLink(WindowClosingEvent.class, new Object(){

            void processEvent() {
                ModellingApp.closeWindow(LayoutWindow.this);
            }
        });
        this.itemTree.setPopupMenuManager(this);
        UIUtilities.applyDefaultFont(this.div2);
        UIUtilities.applyDefaultBackground(this.div2);
        this.itemTreeScroller.setBackground(Color.white);
        if (ModellingApp.APP_ICON != null) {
            ((Frame)this.getComponent()).setIconImage(ModellingApp.APP_ICON);
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getComponent().getGraphicsConfiguration());
        this.setBounds(new Rectangle(screenInsets.left, screenInsets.top, screenDim.width - screenInsets.left - screenInsets.right, screenDim.height - screenInsets.top - screenInsets.bottom));
        this.div1.addEventLink(ValueChangedEvent.class, (Object)this, "updateMenus");
        this.div2.addEventLink(ValueChangedEvent.class, (Object)this, "updateMenus");
        this.tools.requestFocus();
        this.div2.setDividerLocation(1.0);
    }

    public void rebuildMenuBar() {
        MenuStructure ms = new MenuStructure();
        ms.loadStructure("MainWindow", false);
        this.menubar = ms.createMenuBar(this);
        this.setMenuBar(this.menubar);
        this.getComponent().invalidate();
        this.getComponent().validate();
    }

    private void createItemList() {
        this.itemTree = new TreeList(this);
        this.itemTree.setPreferredSize(new Dimension(130, 100));
        this.itemTree.addEventLink(TreeList.ElementMovedEvent.class, (Object)this.theScore, "rebuildList");
        this.itemTree.addEventLink(TreeList.ElementDoubleClickedEvent.class, (Object)this, "editObjectCommand");
        System.out.println("LayoutWindow.createItemList itemTree events");
        this.itemTree.setUpdateEnabled(false);
        for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo info = this.theScene.getObject(i);
            if (info.parent != null) continue;
            this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree));
        }
        this.itemTree.setUpdateEnabled(true);
        this.itemTreeScroller = new BScrollPane(this.itemTree){

            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
        this.itemTreeScroller.setForceWidth(true);
        this.itemTreeScroller.setForceHeight(true);
        this.itemTreeScroller.getVerticalScrollBar().setUnitIncrement(10);
        this.itemTree.addEventLink(SelectionChangedEvent.class, (Object)this, "treeSelectionChanged");
        new AutoScroller(this.itemTreeScroller, 0, 10);
    }

    public void rebuildItemList() {
        TreeElement el;
        ObjectInfo info;
        int i;
        boolean[] expanded = new boolean[this.theScene.getNumObjects()];
        boolean[] selected = new boolean[this.theScene.getNumObjects()];
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            info = this.theScene.getObject(i);
            el = this.itemTree.findElement(info);
            if (el == null) continue;
            expanded[i] = el.isExpanded();
            selected[i] = el.isSelected();
        }
        this.itemTree.setUpdateEnabled(false);
        this.itemTree.removeAllElements();
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            info = this.theScene.getObject(i);
            if (info.parent != null) continue;
            this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree));
        }
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            info = this.theScene.getObject(i);
            el = this.itemTree.findElement(info);
            if (el == null) continue;
            el.setExpanded(expanded[i]);
            el.setSelected(selected[i]);
        }
        this.itemTree.setUpdateEnabled(true);
        this.theScore.rebuildList();
    }

    public BMenu createScriptsMenu() {
        BMenu scriptMenu = Translate.menu("allToolScripts");
        this.addScriptsToMenu(scriptMenu, new File(ModellingApp.TOOL_SCRIPT_DIRECTORY));
        return scriptMenu;
    }

    public BMenu createToolsMenu() {
        BMenu toolsMenu = Translate.menu("allTools");
        ModellingTool[] tools = ModellingApp.getModellingTools();
        for (int i = 0; i < tools.length; ++i) {
            BMenuItem item = new BMenuItem(tools[i].getName());
            toolsMenu.add(item);
            item.setActionCommand("modellingTool/" + tools[i].getClass().getName());
            item.setName("modellingTool/" + tools[i].getClass().getName());
            item.addEventLink(class$buoy$event$CommandEvent == null ? LayoutWindow.class$("buoy.event.CommandEvent") : class$buoy$event$CommandEvent, (Object)this, "actionPerformed");
        }
        return toolsMenu;
    }

    public BMenu createImportMenu() {
        BMenu importMenu = Translate.menu("import");
        Translator[] trans = ModellingApp.getTranslators();
        for (int i = 0; i < trans.length; ++i) {
            if (!trans[i].canImport()) continue;
            BMenuItem item = new BMenuItem(trans[i].getName());
            importMenu.add(item);
            item.setActionCommand("import/" + trans[i].getClass().getName());
            item.setName("import/" + trans[i].getClass().getName());
            item.addEventLink(class$buoy$event$CommandEvent == null ? LayoutWindow.class$("buoy.event.CommandEvent") : class$buoy$event$CommandEvent, (Object)this, "actionPerformed");
        }
        return importMenu;
    }

    public BMenu createExportMenu() {
        BMenu exportMenu = Translate.menu("export");
        Translator[] trans = ModellingApp.getTranslators();
        for (int i = 0; i < trans.length; ++i) {
            if (!trans[i].canExport()) continue;
            BMenuItem item = new BMenuItem(trans[i].getName());
            exportMenu.add(item);
            item.setActionCommand("export/" + trans[i].getClass().getName());
            item.setName("export/" + trans[i].getClass().getName());
            item.addEventLink(class$buoy$event$CommandEvent == null ? LayoutWindow.class$("buoy.event.CommandEvent") : class$buoy$event$CommandEvent, (Object)this, "actionPerformed");
        }
        return exportMenu;
    }

    private void addScriptsToMenu(BMenu menu, File dir2) {
        String[] files = dir2.list();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir2, files[i]);
            if (f.isDirectory()) {
                BMenu m = new BMenu(files[i]);
                menu.add(m);
                this.addScriptsToMenu(m, f);
                continue;
            }
            if (!files[i].endsWith(".bsh") || files[i].length() <= 4) continue;
            BMenuItem item = new BMenuItem(files[i].substring(0, files[i].length() - 4));
            item.setActionCommand("beanshell/" + f.getAbsolutePath());
            item.setName("beanshell/" + f.getAbsolutePath());
            item.addEventLink(class$buoy$event$CommandEvent == null ? LayoutWindow.class$("buoy.event.CommandEvent") : class$buoy$event$CommandEvent, (Object)this, "executeScriptCommand");
            menu.add(item);
        }
    }

    public static String getDefaultMenuLabel(String internalname) {
        if (internalname.startsWith("modellingTool/")) {
            String classname = internalname.substring(14);
            ModellingTool[] tools = ModellingApp.getModellingTools();
            for (int i = 0; i < tools.length; ++i) {
                if (!tools[i].getClass().getName().equals(classname)) continue;
                return tools[i].getName();
            }
        } else if (internalname.startsWith("import/")) {
            String classname = internalname.substring(7);
            Translator[] trans = ModellingApp.getTranslators();
            for (int i = 0; i < trans.length; ++i) {
                if (!trans[i].canImport() || !trans[i].getClass().getName().equals(classname)) continue;
                return trans[i].getName();
            }
        } else {
            if (internalname.startsWith("export/")) {
                String classname = internalname.substring(7);
                Translator[] trans = ModellingApp.getTranslators();
                for (int i = 0; i < trans.length; ++i) {
                    if (!trans[i].canExport() || !trans[i].getClass().getName().equals(classname)) continue;
                    return trans[i].getName();
                }
                return classname + "???";
            }
            return Translate.text("menu." + internalname);
        }
        return "";
    }

    public MenuWidget createMenuItem(MenuDescription menudesc) {
        Widget result = null;
        String name = menudesc.internalName;
        if (name.equals("allToolScripts")) {
            result = this.createScriptsMenu();
        } else if (name.equals("allTools")) {
            result = this.createToolsMenu();
        } else if (name.equals("import")) {
            result = this.createImportMenu();
        } else if (name.equals("export")) {
            result = this.createExportMenu();
        } else if (name.equals("openRecent")) {
            this.recentFilesMenu = new BMenu();
            RecentFiles.createMenu(this.recentFilesMenu);
            result = this.recentFilesMenu;
        } else if (name.startsWith("modellingTool/") || name.startsWith("import/") || name.startsWith("export/")) {
            result = new BMenuItem(LayoutWindow.getDefaultMenuLabel(name));
            ((Widget)result).addEventLink(CommandEvent.class, (Object)this, "actionPerformed");
            ((BMenuItem)result).setActionCommand(name);
            ((BMenuItem)result).setName(name);
        } else {
            result = Utilities.findIndexEqual(this.MENUITEMS_CHECKBOXITEMS, name) > -1 ? Translate.checkboxMenuItem(name, this, "itemStateChanged", false) : Translate.menuItem(name, this, "actionPerformed");
        }
        menudesc.applyTo((MenuWidget)((Object)result));
        return result;
    }

    private void createPopupMenu() {
        this.popupMenu = new BPopupMenu();
        this.popupMenu.add(Translate.menuItem("editObject", this, "actionPerformed", null));
        this.popupMenu.add(Translate.menuItem("objectLayout", this, "actionPerformed", null));
        this.popupMenu.add(Translate.menuItem("setTexture", this, "actionPerformed", null));
        this.popupMenu.add(Translate.menuItem("setMaterial", this, "actionPerformed", null));
        this.popupMenu.add(Translate.menuItem("renameObject", this, "actionPerformed", null));
        this.popupMenu.add(Translate.menuItem("convertToTriangle", this, "actionPerformed", null));
        this.popupMenu.add(Translate.menuItem("selectChildren", this, "actionPerformed", null));
        this.popupMenu.addSeparator();
        this.popupMenu.add(Translate.menuItem("hideSelection", this, "actionPerformed", null));
        this.popupMenu.add(Translate.menuItem("showSelection", this, "actionPerformed", null));
        this.popupMenu.addSeparator();
        this.popupMenu.add(Translate.menuItem("cut", this, "actionPerformed", null));
        this.popupMenu.add(Translate.menuItem("copy", this, "actionPerformed", null));
        this.popupMenu.add(Translate.menuItem("clear", this, "actionPerformed", null));
    }

    public void showPopupMenu(Widget w, int x, int y) {
        this.updateMenus();
        this.popupMenu.show(w, x, y);
    }

    public void setWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void clearWaitCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public boolean confirmClose() {
        if (this.modified) {
            String name = this.theScene.getName();
            if (name == null) {
                name = "Untitled";
            }
            BStandardDialog dlg = new BStandardDialog("", Translate.text("checkSaveChanges", name), BStandardDialog.QUESTION);
            String[] options = new String[]{Translate.text("button.save"), Translate.text("button.dontSave"), Translate.text("button.cancel")};
            int choice = dlg.showOptionDialog(this, options, options[0]);
            if (choice == 0) {
                this.saveCommand();
                if (this.modified) {
                    return false;
                }
            }
            if (choice == 2) {
                return false;
            }
        }
        this.dispose();
        return true;
    }

    public void setTool(EditingTool tool) {
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setTool(tool);
        }
        this.currentTool = tool;
    }

    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    public BFrame getFrame() {
        return this;
    }

    public void updateImage() {
        if (this.numViewsShown == 1) {
            this.theView[this.currentView].copyOrientationFromCamera();
            this.theView[this.currentView].updateImage();
            this.theView[this.currentView].repaint();
        } else {
            for (int i = 0; i < this.numViewsShown; ++i) {
                this.theView[i].copyOrientationFromCamera();
                this.theView[i].updateImage();
                this.theView[i].repaint();
            }
        }
    }

    public void updateMenus() {
        int i;
        MenuUpdateHelper helper = new MenuUpdateHelper();
        MenuWidget[] mis = UIUtilities.getMenuItemList(this.getMenuBar());
        for (i = 0; i < mis.length; ++i) {
            helper.updateMenuItem(mis[i]);
        }
        mis = UIUtilities.getMenuItemList(this.popupMenu);
        for (i = 0; i < mis.length; ++i) {
            helper.updateMenuItem(mis[i]);
        }
    }

    public void setUndoRecord(UndoRecord command) {
        this.undoStack.addRecord(command);
        this.modified = true;
        this.updateMenus();
    }

    public void setModified() {
        this.modified = true;
    }

    public void addObject(Object3D obj, CoordinateSystem coords, String name, UndoRecord undo) {
        this.addObject(new ObjectInfo(obj, coords, name), undo);
    }

    public void addObject(ObjectInfo info, UndoRecord undo) {
        this.theScene.addObject(info, undo);
        this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree));
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].rebuildCameraList();
        }
        this.theScore.rebuildList();
    }

    public void addObject(ObjectInfo info, int index, UndoRecord undo) {
        this.theScene.addObject(info, index, undo);
        this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree), index);
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].rebuildCameraList();
        }
        this.theScore.rebuildList();
    }

    public void removeObject(int which, UndoRecord undo) {
        int i;
        ObjectInfo info = this.theScene.getObject(which);
        ObjectInfo parent = info.parent;
        int childIndex = -1;
        if (parent != null) {
            for (i = 0; i < parent.children.length; ++i) {
                if (parent.children[i] != info) continue;
                childIndex = i;
            }
        }
        this.itemTree.removeObject(info);
        if (childIndex > -1 && info.parent == null) {
            undo.addCommandAtBeginning(7, new Object[]{parent, info, new Integer(childIndex)});
        }
        this.theScene.removeObject(which, undo);
        for (i = 0; i < this.theView.length; ++i) {
            this.theView[i].rebuildCameraList();
        }
        this.theScore.rebuildList();
    }

    public void setObjectName(int which, String name) {
        ObjectInfo info = this.theScene.getObject(which);
        this.setUndoRecord(new UndoRecord(this, false, 6, new Object[]{new Integer(which), info.name}));
        info.name = name;
        this.itemTree.repaint();
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].rebuildCameraList();
        }
        this.theScore.rebuildList();
    }

    public void setTime(double time) {
        this.theScene.setTime(time);
        this.theScore.setTime(time);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        this.timeFrameLabel.setText(Translate.text("timeFrameLabel", nf.format(time), Integer.toString((int)Math.round(time * (double)this.theScene.getFramesPerSecond()))));
        this.theScore.repaint();
        this.itemTree.repaint();
        this.updateImage();
    }

    public Scene getScene() {
        return this.theScene;
    }

    public ViewerCanvas getView() {
        return this.theView[this.currentView];
    }

    public Score getScore() {
        return this.theScore;
    }

    public void setObjectListVisible(boolean visible) {
        if (visible) {
            this.div1.resetToPreferredSizes();
        } else {
            this.div1.setDividerLocation(1.0);
        }
        this.div1.layoutChildren();
        this.updateMenus();
    }

    public void setScoreVisible(boolean visible) {
        this.div2.setDividerLocation(visible ? 0.75 : 1.0);
        this.div2.layoutChildren();
        this.updateMenus();
    }

    public void setSplitView(boolean split) {
        if (this.numViewsShown == 1 == split) {
            this.toggleViewsCommand();
        }
    }

    private void treeSelectionChanged() {
        System.out.println("LayoutWindow.treeSelectionChanged");
        Object[] sel = this.itemTree.getSelectedObjects();
        int[] which = new int[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            which[i] = this.theScene.indexOf((ObjectInfo)sel[i]);
        }
        this.setSelection(which);
        this.updateImage();
    }

    public void itemStateChanged(CommandEvent e) {
        Object source = e.getSource();
        if (source instanceof BCheckBoxMenuItem) {
            String command = ((BCheckBoxMenuItem)source).getName();
            if ("wireframeDisplay".equals(command)) {
                this.theView[this.currentView].setRenderMode(0);
            } else if ("shadedDisplay".equals(command)) {
                this.theView[this.currentView].setRenderMode(1);
            } else if ("smoothDisplay".equals(command)) {
                this.theView[this.currentView].setRenderMode(2);
            } else if ("texturedDisplay".equals(command)) {
                this.theView[this.currentView].setRenderMode(3);
            } else if ("liveRenderSwitch".equals(command)) {
                BCheckBoxMenuItem cbitem = (BCheckBoxMenuItem)source;
                this.theView[this.currentView].setLiveRendering(cbitem.getState());
            } else if ("showCoordinateAxes".equals(command)) {
                BCheckBoxMenuItem cbitem = (BCheckBoxMenuItem)source;
                for (int i = 0; i < this.theView.length; ++i) {
                    this.theView[i].setShowAxes(cbitem.getState());
                }
            }
            this.updateMenus();
            this.updateImage();
        }
    }

    private void keyPressed(KeyPressedEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            this.clearCommand();
        } else if (e.isShiftDown() && (code == 37 || code == 39 || code == 38 || code == 40)) {
            this.tools.keyPressed(e);
        } else {
            this.currentTool.keyPressed(e, this.theView[this.currentView]);
        }
    }

    public void setSelection(int which) {
        this.itemTree.setUpdateEnabled(false);
        this.clearSelection();
        this.theScene.setSelection(which);
        this.itemTree.setSelected(this.theScene.getObject(which), true);
        this.itemTree.setUpdateEnabled(true);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void setSelection(int[] which) {
        this.itemTree.setUpdateEnabled(false);
        this.clearSelection();
        this.theScene.setSelection(which);
        for (int i = 0; i < which.length; ++i) {
            this.itemTree.setSelected(this.theScene.getObject(which[i]), true);
        }
        this.itemTree.setUpdateEnabled(true);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void addToSelection(int which) {
        this.theScene.addToSelection(which);
        this.itemTree.setSelected(this.theScene.getObject(which), true);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void clearSelection() {
        this.theScene.clearSelection();
        this.itemTree.deselectAll();
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void removeFromSelection(int which) {
        this.theScene.removeFromSelection(which);
        this.itemTree.setSelected(this.theScene.getObject(which), false);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    private void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        Widget src = e.getWidget();
        WidgetContainer menu = src instanceof MenuWidget ? src.getParent() : null;
        this.setWaitCursor();
        if (command.equals("new")) {
            ModellingApp.newWindow();
        } else if (command.equals("open")) {
            ModellingApp.openScene(this);
        } else if (command.equals("close")) {
            ModellingApp.closeWindow(this);
        } else if (command.equals("save")) {
            this.saveCommand();
        } else if (command.equals("saveas")) {
            this.saveAsCommand();
        } else if (command.equals("quit")) {
            ModellingApp.quit();
        } else if (command.startsWith("import/")) {
            this.importCommand(command.substring(7));
        } else if (command.startsWith("export/")) {
            this.exportCommand(command.substring(7));
        } else if (command.startsWith("linkExternal")) {
            this.linkExternalCommand();
        } else if (command.equals("undo")) {
            this.undoCommand();
        } else if (command.equals("cut")) {
            this.cutCommand();
        } else if (command.equals("copy")) {
            this.copyCommand();
        } else if (command.equals("paste")) {
            this.pasteCommand();
        } else if (command.equals("clear")) {
            this.clearCommand();
        } else if (command.equals("selectChildren")) {
            this.setSelection(this.theScene.getSelectionWithChildren());
            this.updateImage();
        } else if (command.equals("selectAll")) {
            this.selectAllCommand();
        } else if (command.equals("duplicate")) {
            this.duplicateCommand();
        } else if (command.equals("sever")) {
            this.severCommand();
        } else if (command.equals("preferences")) {
            new PreferencesWindow(this);
        } else if (command.equals("editMenu")) {
            new MenuEditDialog((WindowWidget)this, this);
            this.rebuildMenuBar();
        } else if (command.equals("editObject")) {
            this.editObjectCommand();
        } else if (command.equals("objectLayout")) {
            this.objectLayoutCommand();
        } else if (command.equals("transformObject")) {
            this.transformObjectCommand();
        } else if (command.equals("alignObjects")) {
            this.alignObjectsCommand();
        } else if (command.equals("setTexture")) {
            this.setTextureCommand();
        } else if (command.equals("setMaterial")) {
            this.setMaterialCommand();
        } else if (command.equals("renameObject")) {
            this.renameObjectCommand();
        } else if (command.equals("convertToTriangle")) {
            this.convertToTriangleCommand();
        } else if (command.equals("convertToActor")) {
            this.convertToActorCommand();
        } else if (command.equals("hideSelection")) {
            this.setObjectVisibility(false, true);
        } else if (command.equals("showSelection")) {
            this.setObjectVisibility(true, true);
        } else if (command.equals("showAll")) {
            this.setObjectVisibility(true, false);
        } else if (Utilities.findIndexEqual(this.CREATABLEOBJECTS, command) > -1) {
            this.createObjectCommand(command);
        } else if (command.startsWith("modellingTool/")) {
            this.modellingToolCommand(command.substring(14));
        } else if (command.equals("createScriptObject")) {
            this.createScriptObjectCommand();
        } else if (command.equals("editScript")) {
            new ExecuteScriptWindow(this);
        } else if (command.equals("showScore")) {
            this.setScoreVisible(this.theScore.getBounds().height == 0);
        } else if (command.equals("previewAnimation")) {
            new AnimationPreviewer(this);
        } else if (command.equals("forwardFrame")) {
            double t = this.theScene.getTime() + 1.0 / (double)this.theScene.getFramesPerSecond();
            this.setTime(t);
        } else if (command.equals("backFrame")) {
            double t = this.theScene.getTime() - 1.0 / (double)this.theScene.getFramesPerSecond();
            this.setTime(t);
        } else if (command.equals("jumpToTime")) {
            this.jumpToTimeCommand();
        } else if (command.equals("editKeyframe")) {
            this.theScore.editSelectedKeyframe();
        } else if (command.equals("deleteSelectedKeyframes")) {
            this.theScore.deleteSelectedKeyframes();
        } else if (command.equals("editTrack")) {
            this.theScore.editSelectedTrack();
        } else if (command.equals("keyframe")) {
            this.theScore.keyframeSelectedTracks();
        } else if (command.equals("keyframeModified")) {
            this.theScore.keyframeModifiedTracks();
        } else if (command.equals("duplicateTracks")) {
            this.theScore.duplicateSelectedTracks();
        } else if (command.equals("deleteTracks")) {
            this.theScore.deleteSelectedTracks();
        } else if (command.equals("selectAllTracks")) {
            this.theScore.selectAllTracks();
        } else if (command.equals("enableTracks")) {
            this.theScore.setTracksEnabled(true);
        } else if (command.equals("disableTracks")) {
            this.theScore.setTracksEnabled(false);
        } else if (command.equals("pathFromCurve")) {
            new PathFromCurveDialog(this, this.itemTree.getSelectedObjects());
        } else if (command.equals("bindToParent")) {
            this.bindToParentCommand();
        } else if (command.equals("moveKeyframes")) {
            new EditKeyframesDialog(this, 0);
        } else if (command.equals("copyKeyframes")) {
            new EditKeyframesDialog(this, 1);
        } else if (command.equals("rescaleKeyframes")) {
            new EditKeyframesDialog(this, 2);
        } else if (command.equals("loopKeyframes")) {
            new EditKeyframesDialog(this, 3);
        } else if (command.equals("deleteKeyframes")) {
            new EditKeyframesDialog(this, 4);
        } else if (command.equals("poseTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), PoseTrack.class, null, true);
        } else if (command.equals("constraintTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), ConstraintTrack.class, null, true);
        } else if (command.equals("visibilityTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), VisibilityTrack.class, null, true);
        } else if (command.equals("textureTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), TextureTrack.class, null, true);
        } else if (command.equals("xyzOneTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), PositionTrack.class, null, true);
        } else if (command.equals("xyzThreeTracks")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), PositionTrack.class, new Object[]{"Z Position", Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}, true);
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), PositionTrack.class, new Object[]{"Y Position", Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}, false);
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), PositionTrack.class, new Object[]{"X Position", Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}, false);
        } else if (command.equals("proceduralTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), ProceduralPositionTrack.class, null, true);
        } else if (command.equals("xyzOneTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), RotationTrack.class, new Object[]{"Rotation", Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}, true);
        } else if (command.equals("xyzThreeTracks")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), RotationTrack.class, new Object[]{"Z Rotation", Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}, true);
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), RotationTrack.class, new Object[]{"Y Rotation", Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}, false);
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), RotationTrack.class, new Object[]{"X Rotation", Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}, false);
        } else if (command.equals("quaternionTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), RotationTrack.class, new Object[]{"Rotation", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}, true);
        } else if (command.equals("proceduralTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), ProceduralRotationTrack.class, null, true);
        } else if (command.equals("bendDistortion")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), BendTrack.class, null, true);
        } else if (command.equals("customDistortion")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), CustomDistortionTrack.class, null, true);
        } else if (command.equals("IKTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), IKTrack.class, null, true);
        } else if (command.equals("scaleDistortion")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), ScaleTrack.class, null, true);
        } else if (command.equals("shatterDistortion")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), ShatterTrack.class, null, true);
        } else if (command.equals("twistDistortion")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), TwistTrack.class, null, true);
        } else if (command.equals("IKTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), IKTrack.class, null, true);
        } else if (command.equals("skeletonShapeTrack")) {
            this.theScore.addTrack(this.itemTree.getSelectedObjects(), SkeletonShapeTrack.class, null, true);
        } else if ("editIterAnimationScript".equals(command)) {
            this.getScene().getIterAnimationHolder(0).edit(this);
            this.setModified();
        } else if ("deleteIterAnimationScript".equals(command)) {
            this.getScene().removeIterAnimationHolder(0);
            this.setModified();
        } else if ("setIterAnimationInitial".equals(command)) {
            this.getScene().getIterAnimationHolder(0).rebuildInitialState(this);
            this.setModified();
        } else if (command.equals("renderScene")) {
            this.renderCommand();
        } else if (command.equals("renderImmediately")) {
            this.renderImmediatelyCommand();
        } else if (command.equals("fourViews")) {
            this.toggleViewsCommand();
        } else if (command.equals("hideObjectList")) {
            this.setObjectListVisible(this.itemTree.getBounds().width == 0);
        } else if (command.equals("showTemplate")) {
            boolean wasShown = this.theView[this.currentView].getTemplateShown();
            this.theView[this.currentView].setShowTemplate(!wasShown);
            this.updateMenus();
            this.updateImage();
        } else if (command.equals("setTemplate")) {
            this.setTemplateCommand();
        } else if (command.equals("grid")) {
            this.setGridCommand();
        } else if (command.equals("frameSelection")) {
            this.frameWithCameraCommand(true);
        } else if (command.equals("frameScene")) {
            this.frameWithCameraCommand(false);
        } else if (command.equals("textures")) {
            this.texturesCommand();
        } else if (command.equals("materials")) {
            this.materialsCommand();
        } else if (command.equals("images")) {
            new ImagesDialog(this, this.theScene, null);
        } else if (command.equals("environment")) {
            this.environmentCommand();
        } else if (command.equals("setLiveRenderEnvironment")) {
            this.setLiveRenderEnvironmentCommand();
        } else if (command.equals("resetLiveRenderEnvironment")) {
            this.resetLiveRenderEnvironmentCommand();
        } else if (command.startsWith("beanshell/")) {
            this.executeScript(new File(command.substring(10)));
        }
        this.clearWaitCursor();
    }

    void importCommand(String transclass) {
        Translator[] trans = ModellingApp.getTranslators();
        for (int i = 0; i < trans.length; ++i) {
            if (!trans[i].canImport() || !trans[i].getClass().getName().equals(transclass)) continue;
            trans[i].importFile(this);
            return;
        }
    }

    void exportCommand(String transclass) {
        Translator[] trans = ModellingApp.getTranslators();
        for (int i = 0; i < trans.length; ++i) {
            if (!trans[i].canExport() || !trans[i].getClass().getName().equals(transclass)) continue;
            trans[i].exportFile(this, this.theScene);
            return;
        }
    }

    void linkExternalCommand() {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("externalObject.selectScene"));
        if (!fc.showDialog(this)) {
            return;
        }
        ExternalObject obj = new ExternalObject(fc.getSelectedFile(), "");
        ObjectInfo info = new ObjectInfo(obj, new CoordinateSystem(), "External Object");
        UndoRecord undo = new UndoRecord(this, false);
        this.addObject(info, undo);
        this.setUndoRecord(undo);
        this.setSelection(this.theScene.getNumObjects() - 1);
        this.editObjectCommand();
    }

    void modellingToolCommand(String toolclass) {
        ModellingTool[] tools = ModellingApp.getModellingTools();
        for (int i = 0; i < tools.length; ++i) {
            if (!tools[i].getClass().getName().equals(toolclass)) continue;
            tools[i].commandSelected(this);
        }
    }

    public void saveCommand() {
        if (this.theScene.getName() == null) {
            this.saveAsCommand();
        } else {
            this.modified = !ModellingApp.saveScene(this.theScene, this);
        }
    }

    public void saveAsCommand() {
        BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text("saveScene"));
        if (this.theScene.getName() == null) {
            fc.setSelectedFile(new File("Untitled.aoi"));
        } else {
            fc.setSelectedFile(new File(this.theScene.getName()));
        }
        if (this.theScene.getDirectory() != null) {
            fc.setDirectory(new File(this.theScene.getDirectory()));
        } else if (ModellingApp.currentDirectory != null) {
            fc.setDirectory(new File(ModellingApp.currentDirectory));
        }
        if (!fc.showDialog(this)) {
            return;
        }
        this.theScene.setName(fc.getSelectedFile().getName());
        this.theScene.setDirectory(fc.getDirectory().getAbsolutePath());
        this.setTitle(fc.getSelectedFile().getName());
        this.modified = !ModellingApp.saveScene(this.theScene, this);
    }

    public void undoCommand() {
        this.undoStack.executeUndo();
        this.rebuildItemList();
        this.updateImage();
        this.updateMenus();
    }

    public void redoCommand() {
        this.undoStack.executeRedo();
        this.rebuildItemList();
        this.updateImage();
        this.updateMenus();
    }

    public void cutCommand() {
        this.copyCommand();
        this.clearCommand();
    }

    public void copyCommand() {
        int[] sel = this.theScene.getSelectionWithChildren();
        if (sel.length == 0) {
            return;
        }
        ObjectInfo[] copy = new ObjectInfo[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            copy[i] = this.theScene.getObject(sel[i]);
        }
        copy = ObjectInfo.duplicateAll(copy);
        ModellingApp.copyToClipboard(copy, this.theScene);
        this.updateMenus();
    }

    public void pasteCommand() {
        int[] which = new int[ModellingApp.getClipboardSize()];
        int num = this.theScene.getNumObjects();
        for (int i = 0; i < which.length; ++i) {
            which[i] = num + i;
        }
        ModellingApp.pasteClipboard(this);
        this.setSelection(which);
        this.rebuildItemList();
        this.updateImage();
    }

    public void clearCommand() {
        boolean any;
        ObjectInfo info;
        int i;
        Object[] sel = this.itemTree.getSelectedObjects();
        if (sel.length == 0) {
            return;
        }
        this.theScene.clearSelection();
        UndoRecord undo = new UndoRecord(this, false);
        for (i = sel.length - 1; i >= 0; --i) {
            info = (ObjectInfo)sel[i];
            int index = this.theScene.indexOf(info);
            this.removeObject(index, undo);
        }
        do {
            any = false;
            for (i = 0; i < this.theScene.getNumObjects(); ++i) {
                info = this.theScene.getObject(i);
                if (info.parent == null || this.theScene.indexOf(info.parent) != -1) continue;
                this.removeObject(i, undo);
                --i;
                any = true;
            }
        } while (any);
        this.setUndoRecord(undo);
        this.updateMenus();
        this.updateImage();
    }

    public void selectAllCommand() {
        int[] which = new int[this.theScene.getNumObjects()];
        for (int i = 0; i < which.length; ++i) {
            which[i] = i;
        }
        this.setSelection(which);
        this.updateImage();
    }

    public void duplicateCommand() {
        Object[] sel = this.itemTree.getSelectedObjects();
        int[] which = new int[sel.length];
        int num = this.theScene.getNumObjects();
        UndoRecord undo = new UndoRecord(this, false);
        for (int i = 0; i < sel.length; ++i) {
            this.addObject(((ObjectInfo)sel[i]).duplicate(), undo);
            which[i] = num + i;
        }
        this.setSelection(which);
        this.setUndoRecord(undo);
        this.updateImage();
    }

    public void severCommand() {
        Object[] sel = this.itemTree.getSelectedObjects();
        UndoRecord undo = new UndoRecord(this, false);
        for (int i = 0; i < sel.length; ++i) {
            ObjectInfo info = (ObjectInfo)sel[i];
            undo.addCommand(2, new Object[]{info, info.duplicate()});
            info.object = info.object.duplicate();
        }
        this.setUndoRecord(undo);
    }

    public void editObjectCommand() {
        System.out.println("LayoutWindow.editObjectCommand");
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        final Object3D obj = this.theScene.getObject((int)sel[0]).object;
        if (obj.isEditable()) {
            final UndoRecord undo = new UndoRecord(this, false, 0, new Object[]{obj, obj.duplicate()});
            obj.edit(this, this.theScene.getObject(sel[0]), new Runnable(){

                public void run() {
                    LayoutWindow.this.setUndoRecord(undo);
                    LayoutWindow.this.theScene.objectModified(obj);
                    LayoutWindow.this.updateImage();
                    LayoutWindow.this.updateMenus();
                }
            });
        }
    }

    public void objectLayoutCommand() {
        int i;
        int[] sel = this.theScene.getSelection();
        ObjectInfo[] obj = new ObjectInfo[sel.length];
        if (sel.length == 0) {
            return;
        }
        UndoRecord undo = new UndoRecord(this, false);
        for (i = 0; i < sel.length; ++i) {
            obj[i] = this.theScene.getObject(sel[i]);
            undo.addCommand(0, new Object[]{obj[i].object, obj[i].object.duplicate()});
            undo.addCommand(1, new Object[]{obj[i].coords, obj[i].coords.duplicate()});
        }
        if (sel.length == 1) {
            Vec3 orig = obj[0].coords.getOrigin();
            double[] angles = obj[0].coords.getRotationAngles();
            Vec3 size = obj[0].object.getBounds().getSize();
            TransformDialog dlg = new TransformDialog(this, Translate.text("objectLayoutTitle", this.theScene.getObject((int)sel[0]).name), new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], size.x, size.y, size.z}, false, false);
            if (!dlg.clickedOk()) {
                return;
            }
            double[] values = dlg.getValues();
            if (!Double.isNaN(values[0])) {
                orig.x = values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y = values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z = values[2];
            }
            if (!Double.isNaN(values[3])) {
                angles[0] = values[3];
            }
            if (!Double.isNaN(values[4])) {
                angles[1] = values[4];
            }
            if (!Double.isNaN(values[5])) {
                angles[2] = values[5];
            }
            if (!Double.isNaN(values[6])) {
                size.x = values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y = values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z = values[8];
            }
            obj[0].coords.setOrigin(orig);
            obj[0].coords.setOrientation(angles[0], angles[1], angles[2]);
            obj[0].object.setSize(size.x, size.y, size.z);
            this.theScene.objectModified(obj[0].object);
            obj[0].object.sceneChanged(obj[0], this.theScene);
        } else {
            TransformDialog dlg = new TransformDialog(this, Translate.text("objectLayoutTitleMultiple"), false, false);
            if (!dlg.clickedOk()) {
                return;
            }
            double[] values = dlg.getValues();
            for (i = 0; i < sel.length; ++i) {
                Vec3 orig = obj[i].coords.getOrigin();
                double[] angles = obj[i].coords.getRotationAngles();
                Vec3 size = obj[i].object.getBounds().getSize();
                if (!Double.isNaN(values[0])) {
                    orig.x = values[0];
                }
                if (!Double.isNaN(values[1])) {
                    orig.y = values[1];
                }
                if (!Double.isNaN(values[2])) {
                    orig.z = values[2];
                }
                if (!Double.isNaN(values[3])) {
                    angles[0] = values[3];
                }
                if (!Double.isNaN(values[4])) {
                    angles[1] = values[4];
                }
                if (!Double.isNaN(values[5])) {
                    angles[2] = values[5];
                }
                if (!Double.isNaN(values[6])) {
                    size.x = values[6];
                }
                if (!Double.isNaN(values[7])) {
                    size.y = values[7];
                }
                if (!Double.isNaN(values[8])) {
                    size.z = values[8];
                }
                obj[i].coords.setOrigin(orig);
                obj[i].coords.setOrientation(angles[0], angles[1], angles[2]);
                obj[i].object.setSize(size.x, size.y, size.z);
            }
            for (i = 0; i < sel.length; ++i) {
                this.theScene.objectModified(obj[i].object);
                obj[i].object.sceneChanged(obj[i], this.theScene);
            }
        }
        this.setUndoRecord(undo);
        this.updateImage();
    }

    public void transformObjectCommand() {
        ObjectInfo info;
        int i;
        int[] sel = this.theScene.getSelection();
        if (sel.length == 0) {
            return;
        }
        TransformDialog dlg = sel.length == 1 ? new TransformDialog(this, Translate.text("transformObjectTitle", this.theScene.getObject((int)sel[0]).name), new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true) : new TransformDialog(this, Translate.text("transformObjectTitleMultiple"), new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true);
        if (!dlg.clickedOk()) {
            return;
        }
        double[] values = dlg.getValues();
        BoundingBox bounds = null;
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            bounds = bounds == null ? info.getBounds().transformAndOutset(info.coords.fromLocal()) : bounds.merge(info.getBounds().transformAndOutset(info.coords.fromLocal()));
        }
        Vec3 center = bounds.getCenter();
        if (dlg.applyToChildren()) {
            sel = this.theScene.getSelectionWithChildren();
        }
        Mat4 m = Mat4.identity();
        if (!Double.isNaN(values[3])) {
            m = m.times(Mat4.xrotation(values[3] * Math.PI / 180.0));
        }
        if (!Double.isNaN(values[4])) {
            m = m.times(Mat4.yrotation(values[4] * Math.PI / 180.0));
        }
        if (!Double.isNaN(values[5])) {
            m = m.times(Mat4.zrotation(values[5] * Math.PI / 180.0));
        }
        UndoRecord undo = new UndoRecord(this, false);
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            Object3D obj = info.object;
            CoordinateSystem coords = info.coords;
            undo.addCommand(0, new Object[]{obj, obj.duplicate()});
            undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            Vec3 orig = coords.getOrigin();
            Vec3 size = obj.getBounds().getSize();
            if (!Double.isNaN(values[0])) {
                orig.x += values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y += values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z += values[2];
            }
            if (!Double.isNaN(values[6])) {
                size.x *= values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y *= values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z *= values[8];
            }
            if (dlg.useSelectionCenter()) {
                Vec3 neworig = orig.minus(center);
                if (!Double.isNaN(values[6])) {
                    neworig.x *= values[6];
                }
                if (!Double.isNaN(values[7])) {
                    neworig.y *= values[7];
                }
                if (!Double.isNaN(values[8])) {
                    neworig.z *= values[8];
                }
                coords.setOrigin(neworig);
                coords.transformCoordinates(m);
                coords.setOrigin(coords.getOrigin().plus(center));
            } else {
                coords.setOrigin(orig);
                coords.transformAxes(m);
            }
            obj.setSize(size.x, size.y, size.z);
        }
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            this.theScene.objectModified(info.object);
            info.object.sceneChanged(info, this.theScene);
        }
        this.setUndoRecord(undo);
        this.updateImage();
    }

    public void alignObjectsCommand() {
        Vec3 orig;
        Vec3 center;
        BoundingBox bounds;
        CoordinateSystem coords;
        ObjectInfo info;
        int i;
        int[] sel = this.theScene.getSelection();
        RowContainer px = new RowContainer();
        RowContainer py = new RowContainer();
        RowContainer pz = new RowContainer();
        if (sel.length == 0) {
            return;
        }
        BComboBox xchoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Right"), Translate.text("Center"), Translate.text("Left"), Translate.text("Origin")});
        px.add(xchoice);
        px.add(Translate.label("alignTo"));
        ValueField vfx = new ValueField(Double.NaN, 0, 5);
        px.add(vfx);
        BComboBox ychoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Top"), Translate.text("Center"), Translate.text("Bottom"), Translate.text("Origin")});
        py.add(ychoice);
        py.add(Translate.label("alignTo"));
        ValueField vfy = new ValueField(Double.NaN, 0, 5);
        py.add(vfy);
        BComboBox zchoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Front"), Translate.text("Center"), Translate.text("Back"), Translate.text("Origin")});
        pz.add(zchoice);
        pz.add(Translate.label("alignTo"));
        ValueField vfz = new ValueField(Double.NaN, 0, 5);
        pz.add(vfz);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("alignObjectsTitle"), new Widget[]{px, py, pz}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        UndoRecord undo = new UndoRecord(this, false);
        Vec3 alignTo = new Vec3();
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            coords = info.coords;
            bounds = info.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            if (!Double.isNaN(vfx.getValue())) {
                alignTo.x += vfx.getValue();
            } else if (xchoice.getSelectedIndex() == 1) {
                alignTo.x += bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                alignTo.x += center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                alignTo.x += bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                alignTo.x += orig.x;
            }
            if (!Double.isNaN(vfy.getValue())) {
                alignTo.y += vfy.getValue();
            } else if (ychoice.getSelectedIndex() == 1) {
                alignTo.y += bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                alignTo.y += center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                alignTo.y += bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                alignTo.y += orig.y;
            }
            if (!Double.isNaN(vfz.getValue())) {
                alignTo.z += vfz.getValue();
                continue;
            }
            if (zchoice.getSelectedIndex() == 1) {
                alignTo.z += bounds.maxz;
                continue;
            }
            if (zchoice.getSelectedIndex() == 2) {
                alignTo.z += center.z;
                continue;
            }
            if (zchoice.getSelectedIndex() == 3) {
                alignTo.z += bounds.minz;
                continue;
            }
            if (zchoice.getSelectedIndex() != 4) continue;
            alignTo.z += orig.z;
        }
        alignTo.scale(1.0 / (double)sel.length);
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            coords = info.coords;
            bounds = info.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            if (xchoice.getSelectedIndex() == 1) {
                orig.x += alignTo.x - bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                orig.x += alignTo.x - center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                orig.x += alignTo.x - bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                orig.x += alignTo.x - orig.x;
            }
            if (ychoice.getSelectedIndex() == 1) {
                orig.y += alignTo.y - bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                orig.y += alignTo.y - center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                orig.y += alignTo.y - bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                orig.y += alignTo.y - orig.y;
            }
            if (zchoice.getSelectedIndex() == 1) {
                orig.z += alignTo.z - bounds.maxz;
            } else if (zchoice.getSelectedIndex() == 2) {
                orig.z += alignTo.z - center.z;
            } else if (zchoice.getSelectedIndex() == 3) {
                orig.z += alignTo.z - bounds.minz;
            } else if (zchoice.getSelectedIndex() == 4) {
                orig.z += alignTo.z - orig.z;
            }
            coords.setOrigin(orig);
        }
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            info.object.sceneChanged(info, this.theScene);
        }
        this.setUndoRecord(undo);
        this.updateImage();
    }

    public void setTextureCommand() {
        int i;
        int[] sel = this.theScene.getSelection();
        int count = 0;
        for (i = 0; i < sel.length; ++i) {
            if (!this.theScene.getObject((int)sel[i]).object.canSetTexture()) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        ObjectInfo[] obj = new ObjectInfo[count];
        for (i = 0; i < sel.length; ++i) {
            if (!this.theScene.getObject((int)sel[i]).object.canSetTexture()) continue;
            obj[i] = this.theScene.getObject(sel[i]);
        }
        new ObjectTextureDialog(this, this.theScene, obj);
        for (i = 0; i < sel.length; ++i) {
            this.theScene.objectModified(this.theScene.getObject((int)sel[i]).object);
        }
        this.modified = true;
        this.updateImage();
    }

    public void setMaterialCommand() {
        ObjectInfo info;
        int i;
        int[] sel = this.theScene.getSelection();
        int count = 0;
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            if (!info.object.canSetMaterial()) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        ObjectInfo[] obj = new ObjectInfo[count];
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            if (!info.object.canSetMaterial()) continue;
            obj[i] = info;
        }
        new ObjectMaterialDialog(this, this.theScene, obj);
        this.modified = true;
        this.updateImage();
    }

    public void renameObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = this.theScene.getObject(sel[0]);
        BStandardDialog dlg = new BStandardDialog("", Translate.text("renameObjectTitle"), BStandardDialog.PLAIN);
        String val = dlg.showInputDialog(this, null, info.name);
        if (val == null) {
            return;
        }
        this.setObjectName(sel[0], val);
    }

    public void convertToTriangleCommand() {
        Object3D obj;
        Object dlg;
        int seli;
        int[] sel = this.theScene.getSelection();
        TriangleMesh mesh = null;
        ObjectInfo info = null;
        boolean confirmed = false;
        boolean poseRemConfirmed = false;
        boolean hasPose = false;
        if (sel.length == 0) {
            return;
        }
        int convertmode = 1;
        for (seli = 0; seli < sel.length; ++seli) {
            info = this.theScene.getObject(sel[seli]);
            Object3D obj2 = info.object;
            if (obj2.canConvertToTriangleMesh() == 2) {
                convertmode = 2;
            } else if (obj2.canConvertToTriangleMesh() == 0) {
                convertmode = 0;
                break;
            }
            if (sel.length != 1) continue;
            for (int i = 0; i < info.tracks.length; ++i) {
                if (!(info.tracks[i] instanceof PoseTrack)) continue;
                if (!poseRemConfirmed && !info.tracks[i].isNullTrack()) {
                    String[] options;
                    hasPose = true;
                    dlg = new BStandardDialog("", Translate.text("convertLosesPosesWarning", info.name), BStandardDialog.QUESTION);
                    if (((BStandardDialog)dlg).showOptionDialog(this, options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")}, options[0]) == 1) {
                        return;
                    }
                    confirmed = true;
                    poseRemConfirmed = true;
                }
                if (info.tracks[i].getTimecourse() != null) {
                    info.tracks[i].getTimecourse().removeAllTimepoints();
                }
                info.pose = null;
            }
        }
        if (confirmed) {
            this.theScore.repaintAll();
        }
        double tol = 0.0;
        if (convertmode == 1) {
            String[] options;
            BStandardDialog dlg2;
            if (!confirmed && (dlg2 = new BStandardDialog("", Translate.text("confirmConvertToTriangle", info.name), BStandardDialog.QUESTION)).showOptionDialog(this, options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")}, options[0]) == 1) {
                return;
            }
            tol = 0.0;
        } else if (convertmode == 2) {
            ValueField errorField = new ValueField(0.1, 3);
            dlg = new ComponentsDialog(this, Translate.text("selectToleranceForMesh"), new Widget[]{errorField}, new String[]{Translate.text("maxError")});
            if (!((ComponentsDialog)dlg).clickedOk()) {
                return;
            }
            tol = errorField.getValue();
        } else if (convertmode == 0) {
            new BStandardDialog("", Translate.text("cannotTriangulate"), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        UndoRecord undo = new UndoRecord(this, false, 2, new Object[]{info, info.duplicate()});
        if (sel.length == 1) {
            info = this.theScene.getObject(sel[0]);
            obj = info.object;
            mesh = obj.convertToTriangleMesh(tol);
            if (mesh.getTexture() == null) {
                Texture tex = this.theScene.getDefaultTexture();
                mesh.setTexture(tex, tex.getDefaultMapping());
            }
            if (poseRemConfirmed) {
                this.theScene.replaceObject(obj, mesh.getPosableObject(), undo);
            }
            this.theScene.replaceObject(obj, mesh, undo);
        } else {
            info = this.theScene.getObject(sel[0]);
            obj = info.object.duplicate();
            Mat4 trans = info.getCoordinates().fromLocal();
            mesh = obj.convertToTriangleMesh(tol);
            mesh.transformVertices(trans);
            for (seli = 1; seli < sel.length; ++seli) {
                info = this.theScene.getObject(sel[seli]);
                obj = info.object.duplicate();
                trans = info.getCoordinates().fromLocal();
                TriangleMesh mesh2 = obj.convertToTriangleMesh(tol);
                mesh2.transformVertices(trans);
                mesh.addGeometry(mesh2);
            }
            mesh.refreshVertexData();
            Vec3 center = mesh.getBounds().getCenter();
            trans = Mat4.translation(-center.x, -center.y, -center.z);
            mesh.transformVertices(trans);
            Texture tex = this.theScene.getDefaultTexture();
            mesh.setTexture(tex, tex.getDefaultMapping());
            info = new ObjectInfo(mesh, new CoordinateSystem(center, Vec3.vz(), Vec3.vy()), "Combined Mesh");
            info.addTrack(new PositionTrack(info), 0);
            info.addTrack(new RotationTrack(info), 1);
            this.addObject(info, undo);
        }
        this.updateImage();
        this.updateMenus();
    }

    public void convertToActorCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = this.theScene.getObject(sel[0]);
        Object3D obj = info.object;
        Object3D posable = obj.getPosableObject();
        if (posable == null) {
            return;
        }
        BStandardDialog dlg = new BStandardDialog("", UIUtilities.breakString(Translate.text("confirmConvertToActor", info.name)), BStandardDialog.QUESTION);
        String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
        if (dlg.showOptionDialog(this, options, options[0]) == 1) {
            return;
        }
        UndoRecord undo = new UndoRecord(this, false, 2, new Object[]{info, info.duplicate()});
        this.theScene.replaceObject(obj, posable, undo);
        this.setUndoRecord(undo);
        this.updateImage();
        this.updateMenus();
    }

    void setObjectVisibility(boolean visible, boolean selectionOnly) {
        UndoRecord undo = new UndoRecord(this, false);
        if (selectionOnly) {
            int[] sel = this.theScene.getSelection();
            for (int i = 0; i < sel.length; ++i) {
                ObjectInfo info = this.theScene.getObject(sel[i]);
                undo.addCommand(2, new Object[]{info, info.duplicate()});
                info.visible = visible;
            }
        } else {
            for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
                ObjectInfo info = this.theScene.getObject(i);
                undo.addCommand(2, new Object[]{info, info.duplicate()});
                info.visible = visible;
            }
        }
        this.setUndoRecord(undo);
        this.updateImage();
        this.itemTree.repaint();
    }

    void createObjectCommand(String type) {
        String name;
        Object3D obj;
        if ("cube".equals(type)) {
            obj = new Cube(1.0, 1.0, 1.0);
            name = "Cube " + CreateCubeTool.counter++;
        } else if ("sphere".equals(type)) {
            obj = new Sphere(0.5, 0.5, 0.5);
            name = "Sphere " + CreateSphereTool.counter++;
        } else if ("cylinder".equals(type)) {
            obj = new Cylinder(1.0, 0.5, 0.5, 1.0);
            name = "Cylinder " + CreateCylinderTool.counter++;
        } else if ("cone".equals(type)) {
            obj = new Cylinder(1.0, 0.5, 0.5, 0.0);
            name = "Cone " + CreateCylinderTool.counter++;
        } else if ("pointLight".equals(type)) {
            obj = new PointLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f, 0.1);
            name = "Light " + CreateLightTool.counter++;
        } else if ("directionalLight".equals(type)) {
            obj = new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f);
            name = "Light " + CreateLightTool.counter++;
        } else if ("spotLight".equals(type)) {
            obj = new SpotLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f, 20.0, 0.0, 0.1);
            name = "Light " + CreateLightTool.counter++;
        } else if ("camera".equals(type)) {
            obj = new SceneCamera();
            name = "Camera " + CreateCameraTool.counter++;
        } else {
            obj = new NullObject();
            name = "Null";
        }
        CoordinateSystem coords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        ObjectInfo info = new ObjectInfo(obj, coords, name);
        if (obj.canSetTexture()) {
            info.setTexture(this.theScene.getDefaultTexture(), this.theScene.getDefaultTexture().getDefaultMapping());
        }
        Vec3 orig = coords.getOrigin();
        double[] angles = coords.getRotationAngles();
        Vec3 size = info.getBounds().getSize();
        TransformDialog dlg = new TransformDialog(this, Translate.text("objectLayoutTitle", name), new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], size.x, size.y, size.z}, false, false);
        if (!dlg.clickedOk()) {
            return;
        }
        double[] values = dlg.getValues();
        if (!Double.isNaN(values[0])) {
            orig.x = values[0];
        }
        if (!Double.isNaN(values[1])) {
            orig.y = values[1];
        }
        if (!Double.isNaN(values[2])) {
            orig.z = values[2];
        }
        if (!Double.isNaN(values[3])) {
            angles[0] = values[3];
        }
        if (!Double.isNaN(values[4])) {
            angles[1] = values[4];
        }
        if (!Double.isNaN(values[5])) {
            angles[2] = values[5];
        }
        if (!Double.isNaN(values[6])) {
            size.x = values[6];
        }
        if (!Double.isNaN(values[7])) {
            size.y = values[7];
        }
        if (!Double.isNaN(values[8])) {
            size.z = values[8];
        }
        coords.setOrigin(orig);
        coords.setOrientation(angles[0], angles[1], angles[2]);
        obj.setSize(size.x, size.y, size.z);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        UndoRecord undo = new UndoRecord(this, false);
        this.addObject(info, undo);
        this.setSelection(this.theScene.getNumObjects() - 1);
        this.setUndoRecord(undo);
        this.updateImage();
    }

    public void createScriptObjectCommand() {
        ComponentsDialog dlg;
        BTextField nameField = new BTextField(Translate.text("Script"));
        BComboBox scriptChoice = new BComboBox();
        scriptChoice.add(Translate.text("newScript"));
        String[] files = new File(ModellingApp.OBJECT_SCRIPT_DIRECTORY).list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".bsh") || files[i].length() <= 4) continue;
                scriptChoice.add(files[i].substring(0, files[i].length() - 4));
            }
        }
        if (!(dlg = new ComponentsDialog(this, Translate.text("newScriptedObject"), new Widget[]{nameField, scriptChoice}, new String[]{Translate.text("Name"), Translate.text("Script")})).clickedOk()) {
            return;
        }
        String scriptText = "";
        if (scriptChoice.getSelectedIndex() > 0) {
            try {
                String scriptName = scriptChoice.getSelectedValue() + ".bsh";
                File f = new File(ModellingApp.OBJECT_SCRIPT_DIRECTORY, scriptName);
                scriptText = ModellingApp.loadFile(f);
            }
            catch (IOException ex) {
                new BStandardDialog("", new String[]{Translate.text("errorReadingScript"), ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
                return;
            }
        }
        ScriptedObject obj = new ScriptedObject("");
        ObjectInfo info = new ObjectInfo(obj, new CoordinateSystem(), nameField.getText());
        UndoRecord undo = new UndoRecord(this, false);
        this.addObject(info, undo);
        this.setSelection(this.theScene.getNumObjects() - 1);
        this.setUndoRecord(undo);
        this.updateImage();
        obj.setScript(scriptText);
        obj.edit(this, info, null);
    }

    public void jumpToTimeCommand() {
        ValueField timeField = new ValueField(this.theScene.getTime(), 0);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("jumpToTimeTitle"), new Widget[]{timeField}, new String[]{Translate.text("Time")});
        if (!dlg.clickedOk()) {
            return;
        }
        double t = timeField.getValue();
        double fps = this.theScene.getFramesPerSecond();
        t = (double)Math.round(t * fps) / fps;
        this.setTime(t);
    }

    public void bindToParentCommand() {
        BStandardDialog dlg = new BStandardDialog("", UIUtilities.breakString(Translate.text("confirmBindParent")), BStandardDialog.QUESTION);
        String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
        if (dlg.showOptionDialog(this, options, options[0]) == 1) {
            return;
        }
        int[] sel = this.theScene.getSelection();
        UndoRecord undo = new UndoRecord(this, false);
        for (int i = 0; i < sel.length; ++i) {
            ObjectInfo info = this.theScene.getObject(sel[i]);
            if (info.parent == null) continue;
            Skeleton s = info.parent.getSkeleton();
            ObjectRef relObj = new ObjectRef(info.parent);
            if (s != null) {
                double nearest = Double.MAX_VALUE;
                Joint[] jt = s.getJoints();
                Vec3 pos = info.coords.getOrigin();
                for (int j = 0; j < jt.length; ++j) {
                    ObjectRef r = new ObjectRef(info.parent, jt[j]);
                    double dist = r.getCoords().getOrigin().distance2(pos);
                    if (!(dist < nearest)) continue;
                    relObj = r;
                    nearest = dist;
                }
            }
            undo.addCommand(2, new Object[]{info, info.duplicate()});
            PositionTrack pt = new PositionTrack(info);
            pt.setCoordsObject(relObj);
            info.addTrack(pt, 0);
            pt.setKeyframe(this.theScene.getTime(), this.theScene);
            RotationTrack rt = new RotationTrack(info);
            rt.setCoordsObject(relObj);
            info.addTrack(rt, 1);
            rt.setKeyframe(this.theScene.getTime(), this.theScene);
        }
        this.setUndoRecord(undo);
        this.theScore.rebuildList();
        this.theScore.repaint();
    }

    public void renderCommand() {
        new RenderSetupDialog(this, this.theScene);
    }

    public void renderImmediatelyCommand() {
        RenderSetupDialog.renderImmediately(this, this.theScene);
    }

    public void toggleViewsCommand() {
        if (this.numViewsShown == 4) {
            this.numViewsShown = 1;
            this.viewsContainer.setRowCount(1);
            this.viewsContainer.setColumnCount(1);
            this.viewsContainer.add(this.viewPanel[this.currentView], 0, 0);
        } else {
            this.numViewsShown = 4;
            this.viewsContainer.setRowCount(2);
            this.viewsContainer.setColumnCount(2);
            this.viewsContainer.add(this.viewPanel[0], 0, 0);
            this.viewsContainer.add(this.viewPanel[1], 1, 0);
            this.viewsContainer.add(this.viewPanel[2], 0, 1);
            this.viewsContainer.add(this.viewPanel[3], 1, 1);
        }
        this.viewsContainer.layoutChildren();
        this.updateMenus();
        this.updateImage();
        this.viewPanel[this.currentView].requestFocus();
    }

    public void setTemplateCommand() {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("selectTemplateImage"));
        if (!fc.showDialog(this)) {
            return;
        }
        File f = fc.getSelectedFile();
        try {
            this.theView[this.currentView].setTemplateImage(f);
        }
        catch (InterruptedException ex) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("errorLoadingImage", f.getName())), BStandardDialog.ERROR).showMessageDialog(this);
        }
        this.theView[this.currentView].setShowTemplate(true);
        this.updateMenus();
        this.updateImage();
    }

    public void setGridCommand() {
        ValueField spaceField = new ValueField(this.theScene.getGridSpacing(), 3);
        ValueField divField = new ValueField(this.theScene.getGridSubdivisions(), 7);
        BCheckBox showBox = new BCheckBox(Translate.text("showGrid"), this.theScene.getShowGrid());
        BCheckBox snapBox = new BCheckBox(Translate.text("snapToGrid"), this.theScene.getSnapToGrid());
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("gridTitle"), new Widget[]{spaceField, divField, showBox, snapBox}, new String[]{Translate.text("gridSpacing"), Translate.text("snapToSubdivisions"), null, null});
        if (!dlg.clickedOk()) {
            return;
        }
        this.theScene.setGridSpacing(spaceField.getValue());
        this.theScene.setGridSubdivisions((int)divField.getValue());
        this.theScene.setShowGrid(showBox.getState());
        this.theScene.setSnapToGrid(snapBox.getState());
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setGrid(this.theScene.getGridSpacing(), this.theScene.getGridSubdivisions(), this.theScene.getShowGrid(), this.theScene.getSnapToGrid());
        }
        this.updateImage();
    }

    public void frameWithCameraCommand(boolean selectionOnly) {
        BoundingBox bounds;
        ObjectInfo info;
        int i;
        int[] sel = this.theScene.getSelectionWithChildren();
        BoundingBox bb = null;
        if (selectionOnly) {
            for (i = 0; i < sel.length; ++i) {
                info = this.theScene.getObject(sel[i]);
                bounds = info.getBounds().transformAndOutset(info.coords.fromLocal());
                bb = bb == null ? bounds : bb.merge(bounds);
            }
        } else {
            for (i = 0; i < this.theScene.getNumObjects(); ++i) {
                info = this.theScene.getObject(i);
                bounds = info.getBounds().transformAndOutset(info.coords.fromLocal());
                bb = bb == null ? bounds : bb.merge(bounds);
            }
        }
        if (bb == null) {
            return;
        }
        if (this.numViewsShown == 1) {
            this.theView[this.currentView].frameBox(bb);
        } else {
            for (i = 0; i < this.theView.length; ++i) {
                this.theView[i].frameBox(bb);
            }
        }
        this.updateImage();
    }

    public void texturesCommand() {
        this.theScene.showTexturesDialog(this);
    }

    public void materialsCommand() {
        this.theScene.showMaterialsDialog(this);
    }

    public void environmentCommand() {
        this.changeEnvironmentByDialog(this.theScene);
    }

    public void setLiveRenderEnvironmentCommand() {
        this.changeEnvironmentByDialog(this.theView[this.currentView].getLiveRenderSubset());
    }

    public void resetLiveRenderEnvironmentCommand() {
        SceneSubset subset = this.theView[this.currentView].getLiveRenderSubset();
        subset.setAmbientColor(null);
        subset.setEnvironmentColor(null);
        subset.setEnvironmentMapping(null);
        subset.setEnvironmentParameterValues(new ParameterValue[0]);
        subset.setEnvironmentMode(256);
        subset.setEnvironmentTexture(null);
        subset.setFogColor(null);
    }

    public void changeEnvironmentByDialog(final SceneEnvironmentData sceneenv) {
        final RGBColor ambColor = sceneenv.getAmbientColor().duplicate();
        final RGBColor envColor = sceneenv.getEnvironmentColor().duplicate();
        final RGBColor fogColor = sceneenv.getFogColor().duplicate();
        final Widget ambPatch = ambColor.getSample(50, 30);
        final Widget envPatch = envColor.getSample(50, 30);
        final Widget fogPatch = fogColor.getSample(50, 30);
        final BCheckBox fogBox = new BCheckBox("Environment Fog", sceneenv.getFogState());
        final ValueField fogField = new ValueField(sceneenv.getFogDistance(), 3);
        final OverlayContainer envPanel = new OverlayContainer();
        BButton envButton = new BButton(Translate.text("Choose") + ":");
        final BLabel envLabel = new BLabel();
        final Sphere envSphere = new Sphere(1.0, 1.0, 1.0);
        final ObjectInfo envInfo = new ObjectInfo(envSphere, new CoordinateSystem(), "Environment");
        final BComboBox envChoice = new BComboBox(new String[]{Translate.text("solidColor"), Translate.text("textureDiffuse"), Translate.text("textureEmissive")});
        envChoice.setSelectedIndex(sceneenv.getEnvironmentMode());
        RowContainer row = new RowContainer();
        row.add(envButton);
        row.add(envLabel);
        envPanel.add(envPatch, 0);
        envPanel.add(row, 1);
        if (sceneenv.getEnvironmentMode() == 0) {
            envPanel.setVisibleChild(0);
        } else {
            envPanel.setVisibleChild(1);
        }
        envInfo.setTexture(sceneenv.getEnvironmentTexture(), sceneenv.getEnvironmentMapping());
        envSphere.setParameterValues(sceneenv.getEnvironmentParameterValues());
        envLabel.setText(envSphere.getTexture().getName());
        envChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                if (envChoice.getSelectedIndex() == 0) {
                    envPanel.setVisibleChild(0);
                } else {
                    envPanel.setVisibleChild(1);
                }
                envPanel.getParent().layoutChildren();
            }
        });
        final Runnable envTextureCallback = new Runnable(){

            public void run() {
                envLabel.setText(envSphere.getTexture().getName());
                envPanel.getParent().layoutChildren();
            }
        };
        envButton.addEventLink(CommandEvent.class, new Object(){

            void processEvent() {
                envPanel.getParent().setCursor(Cursor.getPredefinedCursor(3));
                ObjectTextureDialog otd = new ObjectTextureDialog(LayoutWindow.this, LayoutWindow.this.theScene, new ObjectInfo[]{envInfo});
                otd.setCallback(envTextureCallback);
                envPanel.getParent().setCursor(Cursor.getDefaultCursor());
            }
        });
        ambPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(LayoutWindow.this, Translate.text("ambientColor"), ambColor);
                ambPatch.setBackground(ambColor.getColor());
                ambPatch.repaint();
            }
        });
        envPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(LayoutWindow.this, Translate.text("environmentColor"), envColor);
                envPatch.setBackground(envColor.getColor());
                envPatch.repaint();
            }
        });
        fogPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(LayoutWindow.this, Translate.text("fogColor"), fogColor);
                fogPatch.setBackground(fogColor.getColor());
                fogPatch.repaint();
            }
        });
        Runnable okCallback = new Runnable(){

            public void run() {
                sceneenv.setFogColor(fogColor);
                sceneenv.setAmbientColor(ambColor);
                sceneenv.setEnvironmentColor(envColor);
                sceneenv.setFog(fogBox.getState(), fogField.getValue());
                sceneenv.setEnvironmentParameterValues(envSphere.getParameterValues());
                sceneenv.setEnvironmentMode(envChoice.getSelectedIndex());
                sceneenv.setEnvironmentTexture(envSphere.getTexture());
                sceneenv.setEnvironmentMapping(envSphere.getTextureMapping());
                LayoutWindow.this.modified = true;
            }
        };
        Runnable cancelCallback = new Runnable(){

            public void run() {
            }
        };
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("environmentTitle"), new Widget[]{ambPatch, envChoice, envPanel, fogBox, fogPatch, fogField}, new String[]{Translate.text("ambientColor"), Translate.text("environment"), "", "", Translate.text("fogColor"), Translate.text("fogDistance")}, okCallback, cancelCallback);
    }

    private void executeScriptCommand(CommandEvent ev) {
        this.executeScript(new File(ev.getActionCommand()));
    }

    public void executeScript(File f) {
        String scriptText = null;
        try {
            scriptText = ModellingApp.loadFile(f);
        }
        catch (IOException ex) {
            new BStandardDialog("", new String[]{Translate.text("errorReadingScript"), ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        try {
            ToolScript script = ScriptRunner.parseToolScript(scriptText);
            script.execute(this);
        }
        catch (Exception e) {
            ScriptRunner.displayError(e, 1);
        }
        this.updateImage();
    }

    private class MenuUpdateHelper {
        Object[] sel;
        int numSelObjects;
        Track[] selTrack;
        int numSelTracks;
        int numSelKeyframes;
        boolean canConvert;
        boolean canSetMaterial;
        boolean canSetTexture;
        boolean curve;
        boolean noncurve;
        boolean enable;
        boolean disable;
        boolean hasChildren;
        boolean hasParent;
        ObjectInfo info;
        Object3D obj;

        public MenuUpdateHelper() {
            int i;
            this.sel = LayoutWindow.this.itemTree.getSelectedObjects();
            this.numSelObjects = this.sel.length;
            this.selTrack = LayoutWindow.this.theScore.getSelectedTracks();
            this.numSelTracks = this.selTrack.length;
            this.numSelKeyframes = LayoutWindow.this.theScore.getSelectedKeyframes().length;
            this.canSetTexture = this.numSelObjects > 0;
            this.canSetMaterial = this.canSetTexture;
            this.canConvert = this.canSetTexture;
            this.hasParent = false;
            this.hasChildren = false;
            this.disable = false;
            this.enable = false;
            this.noncurve = false;
            this.curve = false;
            for (i = 0; i < this.numSelObjects; ++i) {
                this.info = (ObjectInfo)this.sel[i];
                this.obj = this.info.object;
                if (this.obj instanceof Curve) {
                    this.curve = true;
                } else {
                    this.noncurve = true;
                }
                if (this.obj.canConvertToTriangleMesh() == 0) {
                    this.canConvert = false;
                }
                if (!this.obj.canSetTexture()) {
                    this.canSetTexture = false;
                }
                if (!this.obj.canSetMaterial()) {
                    this.canSetMaterial = false;
                }
                if (this.info.children.length > 0) {
                    this.hasChildren = true;
                }
                if (this.info.parent == null) continue;
                this.hasParent = true;
            }
            for (i = 0; i < this.numSelTracks; ++i) {
                if (this.selTrack[i].isEnabled()) {
                    this.disable = true;
                    continue;
                }
                this.enable = true;
            }
        }

        protected void updateMenuItem(MenuWidget item) {
            String itemname = ((Widget)((Object)item)).getName();
            BCheckBoxMenuItem cbitem = null;
            BMenuItem mnitem = null;
            if (item instanceof BCheckBoxMenuItem) {
                cbitem = (BCheckBoxMenuItem)item;
            } else if (item instanceof BMenuItem) {
                mnitem = (BMenuItem)item;
            }
            if ("save".equals(itemname)) {
                mnitem.setEnabled(LayoutWindow.this.modified);
            } else if ("undo".equals(itemname)) {
                mnitem.setEnabled(LayoutWindow.this.undoStack.canUndo());
            } else if ("redo".equals(itemname)) {
                mnitem.setEnabled(LayoutWindow.this.undoStack.canRedo());
            } else if ("cut".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("copy".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("paste".equals(itemname)) {
                mnitem.setEnabled(ModellingApp.getClipboardSize() > 0);
            } else if ("clear".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("selectChildren".equals(itemname)) {
                mnitem.setEnabled(this.hasChildren);
            } else if ("duplicate".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("sever".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("editObject".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects == 1 && this.obj.isEditable());
            } else if ("objectLayout".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("transformObject".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("alignObjects".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0 && this.numSelObjects > 0);
            } else if ("setTexture".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0 && this.canSetTexture);
            } else if ("setMaterial".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0 && this.canSetMaterial);
            } else if ("renameObject".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects == 1);
            } else if ("convertToTriangle".equals(itemname)) {
                mnitem.setEnabled(this.canConvert && this.numSelObjects >= 1);
            } else if ("hideSelection".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("showSelection".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("showScore".equals(itemname)) {
                mnitem.setText(Translate.text(LayoutWindow.this.theScore.getBounds().height == 0 ? "menu.showScore" : "menu.hideScore"));
            } else if ("editKeyframe".equals(itemname)) {
                mnitem.setEnabled(this.numSelKeyframes == 1);
            } else if ("deleteSelectedKeyframes".equals(itemname)) {
                mnitem.setEnabled(this.numSelKeyframes > 0);
            } else if ("keyframe".equals(itemname)) {
                mnitem.setEnabled(this.numSelTracks > 0);
            } else if ("keyframeModified".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("editTrack".equals(itemname)) {
                mnitem.setEnabled(this.numSelTracks == 1);
            } else if ("duplicateTracks".equals(itemname)) {
                mnitem.setEnabled(this.numSelTracks > 0);
            } else if ("deleteTracks".equals(itemname)) {
                mnitem.setEnabled(this.numSelTracks > 0);
            } else if ("selectAllTracks".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("enableTracks".equals(itemname)) {
                mnitem.setEnabled(this.enable);
            } else if ("disableTracks".equals(itemname)) {
                mnitem.setEnabled(this.disable);
            } else if ("pathFromCurve".equals(itemname)) {
                mnitem.setEnabled(this.curve && this.noncurve);
            } else if ("bindToParent".equals(itemname)) {
                mnitem.setEnabled(this.hasParent);
            } else if (Utilities.findIndexEqual(LayoutWindow.this.MENUITEMS_TRACKS, itemname) > -1) {
                mnitem.setEnabled(this.numSelObjects > 0);
            } else if ("fourViews".equals(itemname)) {
                if (LayoutWindow.this.numViewsShown == 4) {
                    mnitem.setText(Translate.text("menu.fourViews"));
                } else {
                    mnitem.setText(Translate.text("menu.oneView"));
                }
            } else if ("hideObjectList".equals(itemname)) {
                mnitem.setText(Translate.text(LayoutWindow.this.itemTree.getBounds().width == 0 ? "menu.showObjectList" : "menu.hideObjectList"));
            } else if ("showTemplate".equals(itemname)) {
                mnitem.setText(Translate.text(LayoutWindow.this.theView[0].getTemplateShown() ? "menu.showTemplate" : "menu.hideTemplate"));
            } else if ("wireframeDisplay".equals(itemname)) {
                cbitem.setState(LayoutWindow.this.theView[LayoutWindow.this.currentView].getRenderMode() == 0);
            } else if ("shadedDisplay".equals(itemname)) {
                cbitem.setState(LayoutWindow.this.theView[LayoutWindow.this.currentView].getRenderMode() == 1);
            } else if ("smoothDisplay".equals(itemname)) {
                cbitem.setState(LayoutWindow.this.theView[LayoutWindow.this.currentView].getRenderMode() == 2);
            } else if ("texturedDisplay".equals(itemname)) {
                cbitem.setState(LayoutWindow.this.theView[LayoutWindow.this.currentView].getRenderMode() == 3);
            } else if ("liveRenderSwitch".equals(itemname)) {
                cbitem.setState(LayoutWindow.this.theView[LayoutWindow.this.currentView].isLiveRendering());
            } else if ("showTemplate".equals(itemname)) {
                if (LayoutWindow.this.theView[LayoutWindow.this.currentView].getTemplateImage() == null) {
                    mnitem.setEnabled(false);
                } else {
                    mnitem.setEnabled(true);
                    boolean wasShown = LayoutWindow.this.theView[LayoutWindow.this.currentView].getTemplateShown();
                    mnitem.setText(Translate.text(wasShown ? "menu.showTemplate" : "menu.hideTemplate"));
                }
                mnitem.setEnabled(LayoutWindow.this.theView[LayoutWindow.this.currentView].getTemplateImage() != null);
            } else if ("showCoordinateAxes".equals(itemname)) {
                cbitem.setState(LayoutWindow.this.theView[LayoutWindow.this.currentView].getShowAxes());
            } else if ("frameSelection".equals(itemname)) {
                mnitem.setEnabled(this.numSelObjects > 0);
            }
        }
    }
}

