/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.object.ExternalObject;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ObjectTreeElement;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeList;
import artofillusion.ui.UIUtilities;
import buoy.widget.BDialog;
import buoy.widget.BFileChooser;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.WindowWidget;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ExternalObjectEditingWindow
extends BDialog {
    EditingWindow parentWindow;
    ExternalObject theObject;
    ObjectInfo info;
    BTextField fileField;
    BTextField nameField;

    public ExternalObjectEditingWindow(EditingWindow parent, ExternalObject obj, ObjectInfo info) {
        super(parent.getFrame(), info.name, true);
        this.parentWindow = parent;
        this.theObject = obj;
        this.info = info;
        FormContainer content = new FormContainer(new double[]{0.0, 1.0, 0.0}, new double[]{1.0, 1.0, 1.0});
        this.setContent(BOutline.createEmptyBorder(content, ModellingApp.standardDialogInsets));
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        LayoutInfo labelLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null);
        content.add(Translate.label("externalObject.sceneFile"), 0, 0, labelLayout);
        content.add(Translate.label("externalObject.objectName"), 0, 1, labelLayout);
        this.fileField = new BTextField(this.theObject.getExternalSceneFile().getAbsolutePath(), 30);
        content.add(this.fileField, 1, 0);
        this.nameField = new BTextField(this.theObject.getExternalObjectName(), 30);
        content.add(this.nameField, 1, 1);
        content.add(Translate.button("browse", this, "doBrowseFile"), 2, 0);
        content.add(Translate.button("browse", this, "doBrowseObject"), 2, 1);
        RowContainer buttons = new RowContainer();
        content.add(buttons, 0, 2, 3, 1, new LayoutInfo());
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "dispose"));
        this.pack();
        UIUtilities.centerDialog(this, this.parentWindow.getFrame());
        this.setVisible(true);
    }

    private void doBrowseFile() {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("externalObject.selectScene"));
        File f = this.theObject.getExternalSceneFile();
        if (f.isFile()) {
            fc.setSelectedFile(f);
        }
        if (fc.showDialog(this)) {
            this.fileField.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void doBrowseObject() {
        PanelDialog dlg;
        File f = this.theObject.getExternalSceneFile();
        if (!f.isFile()) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("externalObject.sceneNotFound", this.theObject.getExternalSceneFile().getAbsolutePath())), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        Scene sc = null;
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            sc = new Scene(f, true);
        }
        catch (InvalidObjectException ex) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("errorLoadingWholeScene")), BStandardDialog.ERROR).showMessageDialog(this);
        }
        catch (IOException ex) {
            new BStandardDialog("", new String[]{Translate.text("errorLoadingFile"), ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
        }
        this.setCursor(Cursor.getDefaultCursor());
        if (sc == null) {
            return;
        }
        TreeList itemTree = new TreeList(this.parentWindow);
        itemTree.setPreferredSize(new Dimension(130, 100));
        itemTree.setUpdateEnabled(false);
        for (int i = 0; i < sc.getNumObjects(); ++i) {
            ObjectInfo info = sc.getObject(i);
            if (info.parent != null) continue;
            itemTree.addElement(new ObjectTreeElement(info, itemTree));
        }
        itemTree.setUpdateEnabled(true);
        itemTree.setAllowMultiple(false);
        BScrollPane itemTreeScroller = new BScrollPane(itemTree);
        itemTreeScroller.setForceWidth(true);
        itemTreeScroller.setForceHeight(true);
        itemTreeScroller.getVerticalScrollBar().setUnitIncrement(10);
        ObjectInfo oldSelection = sc.getObject(this.theObject.getExternalObjectName());
        if (oldSelection != null) {
            itemTree.setSelected(oldSelection, true);
            itemTree.expandToShowObject(oldSelection);
        }
        if ((dlg = new PanelDialog((WindowWidget)this, Translate.text("externalObject.selectObject"), BOutline.createBevelBorder(itemTreeScroller, false))).clickedOk()) {
            Object[] sel = itemTree.getSelectedObjects();
            if (sel.length == 0) {
                this.nameField.setText("");
            } else {
                this.nameField.setText(((ObjectInfo)sel[0]).name);
            }
        }
    }

    private void doOk() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.theObject.setExternalObjectName(this.nameField.getText());
        this.theObject.setExternalSceneFile(new File(this.fileField.getText()));
        this.theObject.reloadObject();
        if (this.theObject.getLoadingError() != null) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("externalObject.loadingError", this.theObject.getLoadingError())), BStandardDialog.ERROR).showMessageDialog(this);
        }
        this.info.clearCachedMeshes();
        this.dispose();
        this.parentWindow.updateImage();
    }
}

