/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.CurveEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.Utilities;
import artofillusion.WireframeMesh;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class CurveViewer
extends MeshViewer {
    boolean draggingSelectionBox;
    boolean dragging;

    public CurveViewer(ObjectInfo obj, RowContainer p) {
        super(obj, p);
    }

    protected void drawObject(Graphics g) {
        Color col;
        int i;
        if (!this.showMesh) {
            return;
        }
        MeshVertex[] v = ((Mesh)((Object)this.theObject)).getVertices();
        boolean[] selected = this.getSelection();
        if (this.renderMode == 0) {
            Object3D.draw(g, this.theCamera, this.objInfo.getWireframePreview(), this.objInfo.getBounds());
        } else {
            WireframeMesh wireframe = this.theObject.getWireframeMesh();
            for (i = 0; i < wireframe.from.length; ++i) {
                this.renderLine(wireframe.vert[wireframe.from[i]], wireframe.vert[wireframe.to[i]], this.theCamera, Color.black);
            }
        }
        for (int i2 = 0; i2 < v.length; ++i2) {
            if (selected[i2] || !(this.theCamera.getObjectToView().timesZ(v[i2].r) > this.theCamera.getClipDistance())) continue;
            Vec2 p = this.theCamera.getObjectToScreen().timesXY(v[i2].r);
            if (this.renderMode == 0) {
                g.fillRect((int)p.x - 2, (int)p.y - 2, 5, 5);
                continue;
            }
            double z = this.theCamera.getObjectToView().timesZ(v[i2].r);
            this.renderBox((int)p.x - 2, (int)p.y - 2, 5, 5, z, Color.black);
        }
        Color color = col = this.currentTool.hilightSelection() ? Color.magenta : Color.black;
        if (g != null) {
            g.setColor(col);
        }
        for (i = 0; i < v.length; ++i) {
            if (!selected[i] || !(this.theCamera.getObjectToView().timesZ(v[i].r) > this.theCamera.getClipDistance())) continue;
            Vec2 p = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            if (this.renderMode == 0) {
                g.fillRect((int)p.x - 2, (int)p.y - 2, 5, 5);
                continue;
            }
            double z = this.theCamera.getObjectToView().timesZ(v[i].r);
            this.renderBox((int)p.x - 2, (int)p.y - 2, 5, 5, z, col);
        }
    }

    public void drawDraggedSelection(Graphics g, Camera cam, Vec3[] v, boolean broadcast) {
        int i;
        MeshVertex[] vert = ((Curve)this.theObject).getVertices();
        for (i = 1; i < vert.length; ++i) {
            cam.drawClippedLine(g, v[i - 1], v[i]);
            Vec2 p = cam.getObjectToScreen().timesXY(v[i]);
            g.fillRect((int)p.x - 2, (int)p.y - 2, 5, 5);
        }
        if (((Curve)this.theObject).isClosed()) {
            cam.drawClippedLine(g, v[i - 1], v[0]);
        }
        this.broadcastDraggedSelection(v, broadcast);
    }

    public void setSelection(boolean[] sel) {
        this.getSelectionHolder().setSelection(sel);
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }

    protected void findSelectionDistance() {
        int i;
        Curve theCurve = (Curve)this.theObject;
        int[] dist = new int[theCurve.getVertices().length];
        boolean[] selected = this.getSelection();
        this.maxDistance = CurveEditorWindow.getTensionDistance();
        for (i = 0; i < dist.length; ++i) {
            dist[i] = selected[i] ? 0 : -1;
        }
        for (i = 0; i < this.maxDistance; ++i) {
            int j;
            for (j = 0; j < dist.length - 1; ++j) {
                if (dist[j] != -1 || dist[j + 1] != i) continue;
                dist[j] = i + 1;
            }
            for (j = 1; j < dist.length; ++j) {
                if (dist[j] != -1 || dist[j - 1] != i) continue;
                dist[j] = i + 1;
            }
            if (!theCurve.isClosed()) continue;
            if (dist[0] == -1 && dist[dist.length - 1] == i) {
                dist[0] = i + 1;
            }
            if (dist[0] != i || dist[dist.length - 1] != -1) continue;
            dist[dist.length - 1] = i + 1;
        }
        this.selectionDistance = dist;
    }

    public void setMesh(Mesh mesh) {
        Curve obj = (Curve)mesh;
        this.setObject(obj);
        this.getSelectionHolder().setSelection(Utilities.arrayEnsureLength(this.getSelection(), obj.getVertices().length));
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
    }

    protected void mousePressed(WidgetMouseEvent e) {
        int y;
        int x;
        Vec2 pos;
        int i;
        MeshVertex[] v = ((Curve)this.theObject).getVertices();
        boolean[] selected = this.getSelection();
        this.requestFocus();
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if (this.activeTool.whichClicks() == 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            return;
        }
        Point p = e.getPoint();
        for (i = 0; i < v.length; ++i) {
            if (!selected[i]) continue;
            pos = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            x = (int)pos.x;
            y = (int)pos.y;
            if (x >= p.x - 2 && x <= p.x + 2 && y >= p.y - 2 && y <= p.y + 2) break;
        }
        if (i < v.length) {
            if (e.isShiftDown()) {
                this.deselect = i;
            }
            this.activeTool.mousePressedOnHandle(e, this, 0, i);
            return;
        }
        int j = -1;
        double nearest = Double.MAX_VALUE;
        for (i = 0; i < v.length; ++i) {
            double z;
            pos = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            x = (int)pos.x;
            y = (int)pos.y;
            if (x < p.x - 2 || x > p.x + 2 || y < p.y - 2 || y > p.y + 2 || !((z = this.theCamera.getObjectToView().timesZ(v[i].r)) > 0.0) || !(z < nearest)) continue;
            nearest = z;
            j = i;
        }
        if (j > -1) {
            if (!e.isShiftDown()) {
                for (i = 0; i < selected.length; ++i) {
                    selected[i] = false;
                }
            }
            selected[j] = true;
            this.getSelectionHolder().informChanged(this, "object editor");
            this.findSelectionDistance();
            this.activeTool.getWindow().updateMenus();
            if (e.isShiftDown()) {
                this.sentClick = false;
                this.updateImage();
                this.repaint();
            } else {
                this.activeTool.mousePressedOnHandle(e, this, 0, j);
            }
            return;
        }
        this.draggingSelectionBox = true;
        this.beginDraggingSelection(p, false);
        this.sentClick = false;
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        int i;
        MeshVertex[] v = ((Curve)this.theObject).getVertices();
        boolean[] selected = this.getSelection();
        this.moveToGrid(e);
        this.endDraggingSelection();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            for (i = 0; i < selected.length; ++i) {
                selected[i] = false;
            }
        }
        if (this.selectBounds != null) {
            boolean newsel = !e.isControlDown();
            for (i = 0; i < v.length; ++i) {
                Vec2 pos = this.theCamera.getObjectToScreen().timesXY(v[i].r);
                int x = (int)pos.x;
                int y = (int)pos.y;
                if (!this.selectionRegionContains(new Point(x, y))) continue;
                selected[i] = newsel;
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            selected[this.deselect] = false;
        }
        this.getSelectionHolder().informChanged(this, "object editor");
        this.findSelectionDistance();
        this.activeTool.getWindow().updateMenus();
    }
}

