/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CurveViewer;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshSelectionHolder;
import artofillusion.MeshViewer;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.TaperMeshTool;
import artofillusion.UndoRecord;
import artofillusion.Utilities;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MenuStructure;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueSlider;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.MenuWidget;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class CurveEditorWindow
extends MeshEditorWindow {
    BMenu editMenu;
    BMenu meshMenu;
    BMenu smoothMenu;
    BMenuItem[] editMenuItem;
    BMenuItem[] meshMenuItem;
    BCheckBoxMenuItem[] smoothItem;
    private static final String[] MENUITEMS_CHECKBOXITEMS = new String[]{"tolerantSelection", "freehandSelection", "none", "interpolating", "approximating", "detachSkeleton", "closedEnds", "openEnds", "flatEnds"};

    public CurveEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Runnable onClose) {
        super(parent, title, obj, onClose);
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setMeshVisible(true);
        }
        MenuStructure ms = new MenuStructure();
        ms.loadStructure("Curve", false);
        this.menubar = ms.createMenuBar(this);
        this.setMenuBar(this.menubar);
        this.menuitemsCache = null;
        UIUtilities.recursivelyAddKeyPressedListeners(this);
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 3 / 4, d1.height * 3 / 4);
        this.setBounds(new Rectangle((d1.width - d2.width) / 2, (d1.height - d2.height) / 2, d2.width, d2.height));
        this.updateMenus();
    }

    protected CurveEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Runnable onClose, int dummy) {
        super(parent, title, obj, onClose);
    }

    protected boolean isMenuItemNameCheckbox(String itemname) {
        if (Utilities.findIndexEqual(MENUITEMS_CHECKBOXITEMS, itemname) > -1) {
            return true;
        }
        return super.isMenuItemNameCheckbox(itemname);
    }

    public void setTool(EditingTool tool) {
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setTool(tool);
        }
        this.currentTool = tool;
    }

    public boolean isSomethingSelected() {
        int i;
        boolean[] selected = ((CurveViewer)this.getCurrentView()).getSelection();
        for (i = 0; i < selected.length && !selected[i]; ++i) {
        }
        return i < selected.length;
    }

    protected void updateMenuItem(MenuWidget item) {
        String itemname = ((Widget)((Object)item)).getName();
        BCheckBoxMenuItem cbitem = null;
        BMenuItem mnitem = null;
        if (item instanceof BCheckBoxMenuItem) {
            cbitem = (BCheckBoxMenuItem)item;
        } else if (item instanceof BMenuItem) {
            mnitem = (BMenuItem)item;
        }
        Curve obj = (Curve)this.getCurrentView().getObject().object;
        if ("extendSelection".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("deletePoints".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("subdivide".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("editPoints".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("transformPoints".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("randomize".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("centerCurve".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("smoothness".equals(itemname)) {
            mnitem.setEnabled(this.isSomethingSelected());
        } else if ("closedEnds".equals(itemname)) {
            cbitem.setState(obj.isClosed());
        } else if ("none".equals(itemname)) {
            cbitem.setState(obj.getSmoothingMethod() == 0);
        } else if ("interpolating".equals(itemname)) {
            cbitem.setState(obj.getSmoothingMethod() == 2);
        } else if ("approximating".equals(itemname)) {
            cbitem.setState(obj.getSmoothingMethod() == 3);
        } else {
            super.updateMenuItem(item);
        }
    }

    protected void keyPressed(KeyPressedEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            this.deleteCommand();
        } else {
            super.keyPressed(e);
        }
    }

    public void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.handleMenuAction(command)) {
            if (command.equals("deletePoints")) {
                this.deleteCommand();
            } else if (command.equals("editPoints")) {
                this.setPointsCommand();
            } else if (command.equals("centerCurve")) {
                this.centerCommand();
            } else if (command.equals("smoothness")) {
                this.setSmoothnessCommand();
            } else if (command.equals("curveTension")) {
                this.setTensionCommand();
            } else if (command.equals("grid")) {
                this.setGridCommand();
            } else if (command.equals("fourViews")) {
                this.toggleViewsCommand();
            } else if (command.equals("showTemplate")) {
                boolean wasShown = this.getCurrentView().getTemplateShown();
                for (int i = 0; i < this.theView.length; ++i) {
                    this.theView[i].setShowTemplate(!wasShown);
                }
                this.updateMenus();
                this.updateImage();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemStateChanged(CommandEvent e) {
        Object source = e.getSource();
        BCheckBoxMenuItem sourceitem = null;
        String itemname = "";
        if (source instanceof BCheckBoxMenuItem) {
            sourceitem = (BCheckBoxMenuItem)source;
            itemname = sourceitem.getName();
        }
        if ("freehandSelection".equals(itemname)) {
            ((CurveViewer)this.getCurrentView()).setFreehandSelection(sourceitem.getState());
            return;
        }
        if ("none".equals(itemname)) {
            this.setSmoothingMethod(0);
        } else if ("interpolating".equals(itemname)) {
            this.setSmoothingMethod(2);
        } else if ("approximating".equals(itemname)) {
            this.setSmoothingMethod(3);
        } else if ("closedEnds".equals(itemname)) {
            this.toggleClosedCommand();
        }
        super.itemStateChanged(e);
    }

    protected MeshEditorWindow createNewViewNewSelection() {
        CurveEditorWindow w = new CurveEditorWindow(this.parentWindow, this.getTitle(), this.objInConstructor, this.onClose);
        return w;
    }

    public MeshViewer createMeshViewer(ObjectInfo obj, RowContainer p) {
        return new CurveViewer(obj, p);
    }

    public void initBaseSelectionHolder(ObjectInfo obj) {
        this.baseSelHolder = new MeshSelectionHolder(obj);
        Curve mesh = (Curve)obj.object;
        this.baseSelHolder.setSelection(new boolean[mesh.getVertices().length]);
        this.baseSelHolder.setSelectionMode(0);
        this.baseSelHolder.decRefCount();
        for (int i = 0; i < this.theView.length; ++i) {
            ((CurveViewer)this.theView[i]).setSelectionHolder(this.baseSelHolder);
        }
    }

    public BorderContainer createToolbarPanel() {
        BorderContainer p4 = new BorderContainer();
        this.tools = new ToolPalette(1, 7);
        p4.add(this.tools, BorderContainer.NORTH);
        this.defaultTool = new ReshapeMeshTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this));
        this.tools.addTool(new RotateMeshTool(this, false));
        this.tools.addTool(new SkewMeshTool(this));
        this.tools.addTool(new TaperMeshTool(this));
        this.tools.addTool(this.getMetaTool());
        this.tools.addTool(this.getAltTool());
        this.tools.selectTool(this.defaultTool);
        return p4;
    }

    public void selectAllCommand() {
        boolean[] selected = ((CurveViewer)this.getCurrentView()).getSelection();
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = true;
        }
        ((CurveViewer)this.getCurrentView()).setSelection(selected);
        ((CurveViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
    }

    public void extendSelectionCommand() {
        Curve theMesh = (Curve)this.getCurrentView().getObject().object;
        int oldDist = tensionDistance;
        tensionDistance = 1;
        int[] dist = ((CurveViewer)this.getCurrentView()).getSelectionDistance();
        boolean[] selected = new boolean[dist.length];
        tensionDistance = oldDist;
        for (int i = 0; i < dist.length; ++i) {
            selected[i] = dist[i] == 0 || dist[i] == 1;
        }
        ((CurveViewer)this.getCurrentView()).setSelection(selected);
        ((CurveViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
    }

    public void deleteCommand() {
        int i;
        int num = 0;
        Curve theCurve = (Curve)this.getCurrentView().getObject().object;
        boolean[] selected = ((CurveViewer)this.getCurrentView()).getSelection();
        MeshVertex[] vt = theCurve.getVertices();
        float[] s = theCurve.getSmoothness();
        for (i = 0; i < selected.length; ++i) {
            if (!selected[i]) continue;
            ++num;
        }
        if (num == 0) {
            return;
        }
        if (!theCurve.isClosed() && selected.length - num < 2) {
            new BStandardDialog("", Translate.text("curveNeeds2Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        if (theCurve.isClosed() && selected.length - num < 3) {
            new BStandardDialog("", Translate.text("curveNeeds3Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        Vec3[] v = new Vec3[vt.length - num];
        float[] news = new float[vt.length - num];
        boolean[] newsel = new boolean[vt.length - num];
        int j = 0;
        for (i = 0; i < vt.length; ++i) {
            if (selected[i]) continue;
            newsel[j] = selected[i];
            news[j] = s[i];
            v[j++] = vt[i].r;
        }
        theCurve.setShape(v, news);
        this.object3DChangedDuringEditor();
        ((CurveViewer)this.getCurrentView()).setSelection(newsel);
        ((CurveViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
    }

    public void subdivideCommand() {
        int i;
        Curve theCurve = (Curve)this.getCurrentView().getObject().object;
        MeshVertex[] vt = theCurve.getVertices();
        float[] s = theCurve.getSmoothness();
        boolean[] selected = ((CurveViewer)this.getCurrentView()).getSelection();
        int splitcount = 0;
        int method = theCurve.getSmoothingMethod();
        Vec3[] v = new Vec3[vt.length];
        for (i = 0; i < vt.length; ++i) {
            v[i] = vt[i].r;
        }
        boolean[] split = theCurve.isClosed() ? new boolean[vt.length] : new boolean[vt.length - 1];
        for (i = 0; i < split.length; ++i) {
            if (!selected[i] || !selected[(i + 1) % selected.length]) continue;
            split[i] = true;
            ++splitcount;
        }
        Vec3[] newpos = new Vec3[vt.length + splitcount];
        float[] news = new float[vt.length + splitcount];
        boolean[] newsel = new boolean[vt.length + splitcount];
        int j = 0;
        for (i = 0; i < split.length; ++i) {
            newsel[j] = selected[i];
            int p1 = i - 1;
            if (p1 < 0) {
                p1 = theCurve.isClosed() ? v.length - 1 : 0;
            }
            int p3 = i < v.length - 1 ? i + 1 : (theCurve.isClosed() ? 0 : v.length - 1);
            newpos[j] = selected[i] && method == 3 ? Curve.calcApproxPoint(v, s, p1, i, p3) : vt[i].r;
            news[j] = selected[i] ? Math.min(s[i] * 2.0f, 1.0f) : s[i];
            if (!split[i]) {
                ++j;
                continue;
            }
            if (method == 0) {
                newpos[j + 1] = v[i].plus(v[p3]).times(0.5);
            } else if (method == 2) {
                int p4 = i < v.length - 2 ? i + 2 : (theCurve.isClosed() ? (i + 2) % v.length : v.length - 1);
                newpos[j + 1] = Curve.calcInterpPoint(v, s, p1, i, p3, p4);
            } else {
                newpos[j + 1] = v[i].plus(v[p3]).times(0.5);
            }
            news[j + 1] = 1.0f;
            newsel[j + 1] = true;
            j += 2;
        }
        if (!theCurve.isClosed()) {
            newpos[0] = v[0];
            newpos[j] = v[i];
            news[j] = s[i];
            newsel[j] = selected[i];
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        theCurve.setShape(newpos, news);
        this.object3DChangedDuringEditor();
        ((CurveViewer)this.getCurrentView()).setSelection(newsel);
        ((CurveViewer)this.getCurrentView()).informSelectionChanged(this, "object editor");
    }

    public void setSmoothnessCommand() {
        int i;
        final Curve theCurve = (Curve)this.getCurrentView().getObject().object;
        Curve oldCurve = (Curve)theCurve.duplicate();
        final MeshVertex[] vt = theCurve.getVertices();
        final boolean[] selected = ((CurveViewer)this.getCurrentView()).getSelection();
        final float[] s = theCurve.getSmoothness();
        for (i = 0; i < selected.length && !selected[i]; ++i) {
        }
        if (i == selected.length) {
            return;
        }
        float value = 0.001f * (float)Math.round(s[i] * 1000.0f);
        final ValueSlider smoothness = new ValueSlider(0.0, 1.0, 100, value);
        smoothness.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                float sm = (float)smoothness.getValue();
                float[] news = new float[vt.length];
                for (int i = 0; i < selected.length; ++i) {
                    news[i] = selected[i] ? sm : s[i];
                }
                theCurve.setSmoothness(news);
                CurveEditorWindow.this.getCurrentView().objectChanged();
                CurveEditorWindow.this.getCurrentView().updateImage();
                CurveEditorWindow.this.getCurrentView().repaint();
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("setPointSmoothness"), new Widget[]{smoothness}, new String[]{Translate.text("Smoothness")});
        if (dlg.clickedOk()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, oldCurve}));
            this.object3DChangedDuringEditor();
        } else {
            theCurve.copyObject(oldCurve);
            this.getCurrentView().objectChanged();
            this.getCurrentView().updateImage();
            this.getCurrentView().repaint();
        }
    }

    void setSmoothingMethod(int method) {
        Curve theCurve = (Curve)this.getCurrentView().getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        theCurve.setSmoothingMethod(method);
        this.updateMenus();
        this.object3DChangedDuringEditor();
    }

    public void toggleClosedCommand() {
        Curve theCurve = (Curve)this.getCurrentView().getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        if (theCurve.isClosed()) {
            theCurve.setClosed(false);
            this.meshMenuItem[6].setText(Translate.text("menu.closedEnds"));
        } else {
            theCurve.setClosed(true);
            this.meshMenuItem[6].setText(Translate.text("menu.openEnds"));
        }
        this.object3DChangedDuringEditor();
    }

    public void adjustDeltas(Vec3[] delta) {
        int i;
        int[] dist = this.getCurrentView().getSelectionDistance();
        int[] count = new int[delta.length];
        Curve theCurve = (Curve)this.getCurrentView().getObject().object;
        int maxDistance = CurveEditorWindow.getTensionDistance();
        double tension = CurveEditorWindow.getMeshTension();
        double[] scale = new double[maxDistance + 1];
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] == 0) continue;
            delta[i].set(0.0, 0.0, 0.0);
        }
        for (i = 0; i < maxDistance; ++i) {
            int j;
            for (j = 0; j < count.length; ++j) {
                count[j] = 0;
            }
            for (j = 0; j < dist.length - 1; ++j) {
                if (dist[j] == i && dist[j + 1] == i + 1) {
                    int n = j + 1;
                    count[n] = count[n] + 1;
                    delta[j + 1].add(delta[j]);
                    continue;
                }
                if (dist[j + 1] != i || dist[j] != i + 1) continue;
                int n = j;
                count[n] = count[n] + 1;
                delta[j].add(delta[j + 1]);
            }
            if (theCurve.isClosed()) {
                if (dist[0] == i && dist[dist.length - 1] == i + 1) {
                    int n = dist.length - 1;
                    count[n] = count[n] + 1;
                    delta[dist.length - 1].add(delta[0]);
                } else if (dist[dist.length - 1] == i && dist[0] == i + 1) {
                    count[0] = count[0] + 1;
                    delta[0].add(delta[dist.length - 1]);
                }
            }
            for (j = 0; j < count.length; ++j) {
                if (count[j] <= 1) continue;
                delta[j].scale(1.0 / (double)count[j]);
            }
        }
        for (i = 0; i < scale.length; ++i) {
            scale[i] = Math.pow(((double)(maxDistance - i) + 1.0) / ((double)maxDistance + 1.0), tension);
        }
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] <= 0) continue;
            delta[i].scale(scale[dist[i]]);
        }
    }
}

