/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshViewer;
import artofillusion.ReshapeMeshTool;
import artofillusion.TriMeshEditorWindow;
import artofillusion.TriMeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BCheckBox;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class CreateVertexTool_ED
extends EditingTool {
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    ClickTarget target;
    boolean dragged;
    int vertexToMove;
    UndoRecord undo;
    boolean freeVert = true;
    boolean moveVert = true;
    boolean edgeSubdiv = true;
    boolean faceSubdiv = true;

    public CreateVertexTool_ED(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("sphere.gif");
        selectedIcon = this.loadImage("selected/sphere.gif");
    }

    public void activate() {
        super.activate();
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void iconDoubleClicked() {
        BCheckBox freeVertBox = new BCheckBox("Create free vertex", this.freeVert);
        BCheckBox moveVertBox = new BCheckBox("Move vertex", this.moveVert);
        BCheckBox edgeSubdivBox = new BCheckBox("Subdivide edge", this.edgeSubdiv);
        BCheckBox faceSubdivBox = new BCheckBox("Subdivide face", this.faceSubdiv);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, "Options for Create Vertex Tool:", new Widget[]{freeVertBox, moveVertBox, edgeSubdivBox, faceSubdivBox}, new String[]{"", "", "", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        this.freeVert = freeVertBox.getState();
        this.moveVert = moveVertBox.getState();
        this.edgeSubdiv = edgeSubdivBox.getState();
        this.faceSubdiv = faceSubdivBox.getState();
    }

    protected ClickTarget findClickTarget(Point pos, TriMeshViewer theView) {
        Vec3 objPos;
        double w;
        double u;
        double v;
        Point v2;
        double z;
        Point v1;
        int i;
        TriangleMesh theMesh = (TriangleMesh)theView.getObject().object;
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        TriangleMesh.Face[] fc = theMesh.getFaces();
        boolean[] visible = theView.getVisible();
        Point[] screenVert = theView.getScreenVert();
        int HANDLE_SIZE = 5;
        Camera theCamera = theView.getCamera();
        ClickTarget result = new ClickTarget();
        double closestz = Double.MAX_VALUE;
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        if (this.moveVert) {
            for (i = 0; i < vt.length; ++i) {
                if (!visible[i]) continue;
                v1 = screenVert[i];
                if (pos.x < v1.x - HANDLE_SIZE / 2 || pos.x > v1.x + HANDLE_SIZE / 2 || pos.y < v1.y - HANDLE_SIZE / 2 || pos.y > v1.y + HANDLE_SIZE / 2 || !((z = theCamera.getObjectToView().timesZ(vt[i].r)) < closestz)) continue;
                result.index = i;
                result.type = 1;
                result.clickPos = new Vec3(vt[i].r);
                closestz = z;
            }
        }
        if (result.index == -1 && this.edgeSubdiv) {
            for (i = 0; i < ed.length; ++i) {
                if (!visible[ed[i].v1] || !visible[ed[i].v2] || theView.isEdgeHidden(i)) continue;
                v1 = screenVert[ed[i].v1];
                v2 = screenVert[ed[i].v2];
                if (pos.x < v1.x - HANDLE_SIZE / 2 && pos.x < v2.x - HANDLE_SIZE / 2 || pos.x > v1.x + HANDLE_SIZE / 2 && pos.x > v2.x + HANDLE_SIZE / 2 || pos.y < v1.y - HANDLE_SIZE / 2 && pos.y < v2.y - HANDLE_SIZE / 2 || pos.y > v1.y + HANDLE_SIZE / 2 && pos.y > v2.y + HANDLE_SIZE / 2) continue;
                if (Math.abs(v1.x - v2.x) > Math.abs(v1.y - v2.y)) {
                    if (v2.x > v1.x) {
                        v = ((double)pos.x - (double)v1.x) / (double)(v2.x - v1.x);
                        u = 1.0 - v;
                    } else {
                        u = ((double)pos.x - (double)v2.x) / (double)(v1.x - v2.x);
                        v = 1.0 - u;
                    }
                    w = u * (double)v1.y + v * (double)v2.y - (double)pos.y;
                } else {
                    if (v2.y > v1.y) {
                        v = ((double)pos.y - (double)v1.y) / (double)(v2.y - v1.y);
                        u = 1.0 - v;
                    } else {
                        u = ((double)pos.y - (double)v2.y) / (double)(v1.y - v2.y);
                        v = 1.0 - u;
                    }
                    w = u * (double)v1.x + v * (double)v2.x - (double)pos.x;
                }
                if (Math.abs(w) > (double)(HANDLE_SIZE / 2)) continue;
                objPos = vt[ed[i].v1].r.times(u).plus(vt[ed[i].v2].r.times(v));
                z = theCamera.getObjectToView().timesZ(objPos);
                if (!(z < closestz)) continue;
                result.index = i;
                result.type = 2;
                result.clickPos = objPos;
                result.u = u;
                result.v = v;
                closestz = z;
            }
        }
        if (result.index == -1 && this.faceSubdiv) {
            for (i = 0; i < fc.length; ++i) {
                if (!visible[fc[i].v1] || !visible[fc[i].v2] || !visible[fc[i].v3]) continue;
                v1 = screenVert[fc[i].v1];
                v2 = screenVert[fc[i].v2];
                Point v3 = screenVert[fc[i].v3];
                if (pos.x < v1.x - HANDLE_SIZE / 2 && pos.x < v2.x - HANDLE_SIZE / 2 && pos.x < v3.x - HANDLE_SIZE / 2 || pos.x > v1.x + HANDLE_SIZE / 2 && pos.x > v2.x + HANDLE_SIZE / 2 && pos.x > v3.x + HANDLE_SIZE / 2 || pos.y < v1.y - HANDLE_SIZE / 2 && pos.y < v2.y - HANDLE_SIZE / 2 && pos.y < v3.y - HANDLE_SIZE / 2 || pos.y > v1.y + HANDLE_SIZE / 2 && pos.y > v2.y + HANDLE_SIZE / 2 && pos.y > v3.y + HANDLE_SIZE / 2) continue;
                double e1x = v1.x - v2.x;
                double e1y = v1.y - v2.y;
                double e2x = v1.x - v3.x;
                double e2y = v1.y - v3.y;
                double denom = 1.0 / (e1x * e2y - e1y * e2x);
                double vy = pos.y - v1.y;
                double vx = pos.x - v1.x;
                v = (e2x *= denom) * vy - (e2y *= denom) * vx;
                if (v < 0.0 || v > 1.0 || (w = vx * (e1y *= denom) - vy * (e1x *= denom)) < 0.0 || w > 1.0 || (u = 1.0 - v - w) < 0.0 || u > 1.0) continue;
                objPos = vt[fc[i].v1].r.times(u).plus(vt[fc[i].v2].r.times(v).plus(vt[fc[i].v3].r.times(w)));
                z = theCamera.getObjectToView().timesZ(objPos);
                if (!(z < closestz)) continue;
                result.index = i;
                result.type = 3;
                result.clickPos = objPos;
                result.u = u;
                result.v = v;
                closestz = z;
            }
        }
        return result;
    }

    int[] findSelectionDistance(ViewerCanvas viewcan) {
        int i;
        TriMeshViewer view = (TriMeshViewer)viewcan;
        TriangleMesh mesh = (TriangleMesh)view.getObject().object;
        int[] dist = new int[mesh.getVertices().length];
        TriangleMesh.Edge[] e = mesh.getEdges();
        TriangleMesh.Face[] f = mesh.getFaces();
        int maxDistance = TriMeshEditorWindow.getTensionDistance();
        for (i = 0; i < dist.length; ++i) {
            dist[i] = i == this.vertexToMove ? 0 : -1;
        }
        for (i = 0; i < maxDistance; ++i) {
            for (int j = 0; j < e.length; ++j) {
                if (view.isEdgeHidden(j)) continue;
                if (dist[e[j].v1] == -1 && dist[e[j].v2] == i) {
                    dist[e[j].v1] = i + 1;
                    continue;
                }
                if (dist[e[j].v2] != -1 || dist[e[j].v1] != i) continue;
                dist[e[j].v2] = i + 1;
            }
        }
        return dist;
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        TriMeshViewer tmv = (TriMeshViewer)view;
        System.out.println("CreateVertexTool.mousePressed" + view.hashCode());
        TriangleMesh mesh = (TriangleMesh)tmv.getObject().object;
        Camera cam = tmv.getCamera();
        this.clickPoint = e.getPoint();
        this.target = this.findClickTarget(this.clickPoint, tmv);
        System.out.println("CreateVertexTool.mousePressed findClickTarget " + this.target.index);
        if (this.target.index == -1) {
            if (this.freeVert) {
                double distToScreen = cam.getDistToScreen();
                this.target.clickPos = cam.convertScreenToWorld(this.clickPoint, distToScreen);
                mesh.addVertex(new TriangleMesh.Vertex(this.target.clickPos));
                this.vertexToMove = mesh.getVertices().length - 1;
            }
        } else if (this.target.type == 1) {
            this.vertexToMove = this.target.index;
        } else {
            TriangleMesh newmesh = null;
            if (this.target.type == 2) {
                boolean[] split = new boolean[mesh.getEdges().length];
                split[this.target.index] = true;
                newmesh = TriangleMesh.subdivideLinear(mesh, split, this.target.u);
            } else if (this.target.type == 3) {
                boolean[] split = new boolean[mesh.getFaces().length];
                split[this.target.index] = true;
                newmesh = TriangleMesh.subdivideFaces(mesh, split, this.target.u, this.target.v);
            }
            this.vertexToMove = newmesh.getVertices().length - 1;
            mesh.copyObject(newmesh);
            mesh.informChanged(this, "object editor");
            this.theWindow.updateMenus();
        }
        this.dragged = false;
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        Vec3[] vert = mesh.getVertexPositions();
        Graphics g = view.getComponent().getGraphics();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int size = 5;
        int[] selectDist = this.findSelectionDistance(view);
        if (this.dragged) {
            view.drawImage(g);
        }
        this.dragged = true;
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        Vec3[] v = ReshapeMeshTool.findDraggedPositions(this.target.clickPos, vert, dx, dy, (MeshViewer)view, e.isControlDown(), selectDist);
        Vec3 drag = e.isControlDown() ? view.getCamera().getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : view.getCamera().findDragVector(this.target.clickPos, dx, dy);
        g.setColor(Color.gray);
        ((MeshViewer)view).drawDraggedSelection(g, cam, v, true);
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.dragText", (double)Math.round(drag.x * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.y * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.z * 100000.0) / 100000.0));
        g.dispose();
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Object3D meshobj = ((MeshViewer)view).getObject().object;
        Mesh mesh = (Mesh)((Object)meshobj);
        Vec3[] vert = mesh.getVertexPositions();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int[] selectDist = this.findSelectionDistance(view);
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        if (dx != 0 || dy != 0) {
            Vec3[] v = ReshapeMeshTool.findDraggedPositions(this.target.clickPos, vert, dx, dy, (MeshViewer)view, e.isControlDown(), selectDist);
            mesh.setVertexPositions(v);
        }
        meshobj.informChanged(this, "object editor");
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.helpText"));
    }

    public static class ClickTarget {
        public static final int TYPE_VERTEX = 1;
        public static final int TYPE_EDGE = 2;
        public static final int TYPE_FACE = 3;
        public int type;
        public int index = -1;
        public Vec3 clickPos;
        public double u;
        public double v;
    }
}

