/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.SceneViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Cylinder;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueSlider;
import buoy.event.WidgetMouseEvent;
import buoy.widget.Widget;
import java.awt.Image;
import java.awt.Point;

public class CreateCylinderTool
extends EditingTool {
    static Image icon;
    static Image selectedIcon;
    static int counter;
    boolean shiftDown;
    Point clickPoint;
    double ratio = 1.0;

    public CreateCylinderTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("cylinder.gif");
        selectedIcon = this.loadImage("selected/cylinder.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("createCylinderTool.helpText"));
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("createCylinderTool.tipText");
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        this.clickPoint = e.getPoint();
        this.shiftDown = e.isShiftDown();
        ((SceneViewer)view).beginDraggingBox(this.clickPoint, this.shiftDown);
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Scene theScene = ((LayoutWindow)this.theWindow).getScene();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.shiftDown) {
            if (Math.abs(dragPoint.x - this.clickPoint.x) > Math.abs(dragPoint.y - this.clickPoint.y)) {
                dragPoint.y = dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(dragPoint.x - this.clickPoint.x);
            } else {
                dragPoint.x = dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(dragPoint.y - this.clickPoint.y);
            }
        }
        if (dragPoint.x == this.clickPoint.x || dragPoint.y == this.clickPoint.y) {
            ((SceneViewer)view).repaint();
            return;
        }
        Vec3 v1 = cam.convertScreenToWorld(this.clickPoint, 20.0);
        Vec3 v2 = cam.convertScreenToWorld(new Point(dragPoint.x, this.clickPoint.y), 20.0);
        Vec3 v3 = cam.convertScreenToWorld(dragPoint, 20.0);
        Vec3 orig = v1.plus(v3).times(0.5);
        Vec3 xdir = dragPoint.x < this.clickPoint.x ? v1.minus(v2) : v2.minus(v1);
        Vec3 ydir = dragPoint.y < this.clickPoint.y ? v3.minus(v2) : v2.minus(v3);
        double xsize = xdir.length();
        double ysize = ydir.length();
        xdir = xdir.times(1.0 / xsize);
        ydir = ydir.times(1.0 / ysize);
        Vec3 zdir = xdir.cross(ydir);
        double zsize = Math.min(xsize, ysize);
        Cylinder obj = new Cylinder(ysize, xsize / 2.0, zsize / 2.0, this.ratio);
        ObjectInfo info = new ObjectInfo(obj, new CoordinateSystem(orig, zdir, ydir), "Cylinder " + counter++);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        ((LayoutWindow)this.theWindow).addObject(info, undo);
        this.theWindow.setUndoRecord(undo);
        ((LayoutWindow)this.theWindow).setSelection(theScene.getNumObjects() - 1);
        this.theWindow.updateImage();
    }

    public void iconDoubleClicked() {
        ValueSlider ratioSlider = new ValueSlider(0.0, 1.0, 100, this.ratio);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("editCylinderTitle"), new Widget[]{ratioSlider}, new String[]{Translate.text("radiusRatio")});
        if (dlg.clickedOk()) {
            this.ratio = ratioSlider.getValue();
        }
    }

    static {
        counter = 1;
    }
}

