/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.SceneCamera;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.RepaintEvent;
import buoy.event.SelectionChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BList;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BorderContainer;
import buoy.widget.ColumnContainer;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.util.Vector;

public class CameraFilterDialog
extends BDialog
implements RenderListener {
    private SceneCamera theCamera;
    private Scene theScene;
    private CoordinateSystem cameraCoords;
    private Vector filters;
    private ImageFilter[] oldFilters;
    private Class[] filterClasses;
    private BList allFiltersList;
    private BList cameraFiltersList;
    private BButton addButton;
    private BButton deleteButton;
    private BButton upButton;
    private BButton downButton;
    private BButton previewButton;
    private BButton okButton;
    private BButton cancelButton;
    private BScrollPane editorPane;
    private CustomWidget preview;
    private ComplexImage unfilteredImage;
    private Image displayImage;
    private boolean doneRendering;
    private boolean doneFiltering;
    private static final int PREVIEW_WIDTH = 200;
    private static final int PREVIEW_HEIGHT = 150;

    public CameraFilterDialog(EditingWindow parent, SceneCamera camera, CoordinateSystem cameraCoords) {
        super(parent.getFrame(), Translate.text("Filters"), true);
        this.theCamera = camera;
        this.cameraCoords = cameraCoords;
        this.filters = new Vector();
        this.oldFilters = this.theCamera.getImageFilters();
        for (int i = 0; i < this.oldFilters.length; ++i) {
            this.filters.addElement(this.oldFilters[i]);
            this.oldFilters[i] = this.oldFilters[i].duplicate();
        }
        FormContainer content = new FormContainer(2, 3);
        this.setContent(content);
        LayoutInfo fillLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null);
        FormContainer listsPanel = new FormContainer(3, 1);
        BorderContainer previewPanel = new BorderContainer();
        RowContainer okPanel = new RowContainer();
        this.editorPane = new BScrollPane();
        this.editorPane.setPreferredViewSize(new Dimension(200, 150));
        content.add(listsPanel, 0, 0, fillLayout);
        content.add(BOutline.createBevelBorder(this.editorPane, false), 0, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(2, 2, 2, 2), null));
        content.add(previewPanel, 1, 0, 1, 2, new LayoutInfo());
        content.add(okPanel, 0, 2, 2, 1, new LayoutInfo());
        this.allFiltersList = new BList();
        listsPanel.add(UIUtilities.createScrollingList(this.allFiltersList), 0, 0, fillLayout);
        ColumnContainer buttonsPanel = new ColumnContainer();
        listsPanel.add(buttonsPanel, 1, 0);
        this.cameraFiltersList = new BList();
        listsPanel.add(UIUtilities.createScrollingList(this.cameraFiltersList), 2, 0, fillLayout);
        buttonsPanel.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
        this.addButton = Translate.button("add", " >>", this, "doAdd");
        buttonsPanel.add(this.addButton);
        this.deleteButton = Translate.button("delete", this, "doDelete");
        buttonsPanel.add(this.deleteButton);
        this.upButton = Translate.button("moveUp", this, "doMoveUp");
        buttonsPanel.add(this.upButton);
        this.downButton = Translate.button("moveDown", this, "doMoveDown");
        buttonsPanel.add(this.downButton);
        this.allFiltersList.addEventLink(SelectionChangedEvent.class, (Object)this, "updateComponents");
        this.cameraFiltersList.addEventLink(SelectionChangedEvent.class, (Object)this, "updateComponents");
        this.allFiltersList.setMultipleSelectionEnabled(false);
        this.cameraFiltersList.setMultipleSelectionEnabled(false);
        this.filterClasses = ModellingApp.getImageFilters();
        for (int i = 0; i < this.filterClasses.length; ++i) {
            try {
                this.allFiltersList.add(((ImageFilter)this.filterClasses[i].newInstance()).getName());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.rebuildFilterList();
        if (this.cameraFiltersList.getItemCount() > 0) {
            this.cameraFiltersList.setSelected(0, true);
        }
        ((BScrollPane)this.cameraFiltersList.getParent()).setPreferredViewSize(this.allFiltersList.getPreferredSize());
        this.preview = new CustomWidget();
        this.preview.addEventLink(RepaintEvent.class, (Object)this, "paintPreview");
        this.preview.setPreferredSize(new Dimension(200, 150));
        previewPanel.add(this.preview, BorderContainer.CENTER);
        this.previewButton = Translate.button("updatePreview", this, "applyFilters");
        previewPanel.add(this.previewButton, BorderContainer.SOUTH, new LayoutInfo());
        this.previewButton.setEnabled(false);
        this.okButton = Translate.button("ok", this, "doOk");
        okPanel.add(this.okButton);
        this.cancelButton = Translate.button("cancel", this, "doCancel");
        okPanel.add(this.cancelButton);
        this.updateComponents();
        Camera cam = this.theCamera.createCamera(200, 150, cameraCoords);
        SceneCamera renderCamera = new SceneCamera(){

            public int getComponentsForFilters() {
                return -1;
            }
        };
        renderCamera.copyObject(this.theCamera);
        this.theScene = parent.getScene();
        Renderer renderer = ModellingApp.getPreferences().getTexturePreviewRenderer();
        renderer.configurePreview();
        renderer.renderScene(this.theScene, cam, this, renderCamera);
        this.pack();
        UIUtilities.centerWindow(this);
        this.setVisible(true);
    }

    private void updateComponents() {
        this.addButton.setEnabled(this.allFiltersList.getSelectedIndex() > -1);
        int selection = this.cameraFiltersList.getSelectedIndex();
        this.deleteButton.setEnabled(selection > -1);
        this.upButton.setEnabled(selection > 0);
        this.downButton.setEnabled(selection > -1 && selection < this.filters.size() - 1);
        if (selection > -1) {
            this.editorPane.setContent(((ImageFilter)this.filters.elementAt(this.cameraFiltersList.getSelectedIndex())).getConfigPanel());
        } else {
            this.editorPane.setContent(null);
        }
        this.editorPane.layoutChildren();
    }

    private void rebuildFilterList() {
        this.cameraFiltersList.removeAll();
        for (int i = 0; i < this.filters.size(); ++i) {
            this.cameraFiltersList.add(((ImageFilter)this.filters.elementAt(i)).getName());
        }
    }

    private void doOk() {
        Object[] filt = new ImageFilter[this.filters.size()];
        this.filters.copyInto(filt);
        this.theCamera.setImageFilters((ImageFilter[])filt);
        this.dispose();
    }

    private void doCancel() {
        ImageFilter[] filt = this.theCamera.getImageFilters();
        for (int i = 0; i < filt.length; ++i) {
            filt[i].copy(this.oldFilters[i]);
        }
        this.dispose();
    }

    private void doAdd() {
        int sel = this.allFiltersList.getSelectedIndex();
        if (sel == -1) {
            return;
        }
        try {
            this.filters.addElement(this.filterClasses[sel].newInstance());
            this.rebuildFilterList();
            this.cameraFiltersList.setSelected(this.filters.size() - 1, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateComponents();
    }

    private void doDelete() {
        int sel = this.cameraFiltersList.getSelectedIndex();
        if (sel == -1) {
            return;
        }
        this.filters.removeElementAt(sel);
        this.rebuildFilterList();
        this.updateComponents();
    }

    private void doMoveUp() {
        int sel = this.cameraFiltersList.getSelectedIndex();
        if (sel < 1) {
            return;
        }
        ImageFilter filt = (ImageFilter)this.filters.elementAt(sel);
        this.filters.removeElementAt(sel);
        this.filters.insertElementAt(filt, sel - 1);
        this.rebuildFilterList();
        this.cameraFiltersList.setSelected(sel - 1, true);
        this.updateComponents();
    }

    private void doMoveDown() {
        int sel = this.cameraFiltersList.getSelectedIndex();
        if (sel == -1 || sel == this.filters.size() - 1) {
            return;
        }
        ImageFilter filt = (ImageFilter)this.filters.elementAt(sel);
        this.filters.removeElementAt(sel);
        this.filters.insertElementAt(filt, sel + 1);
        this.rebuildFilterList();
        this.cameraFiltersList.setSelected(sel + 1, true);
        this.updateComponents();
    }

    private void paintPreview(RepaintEvent ev) {
        Graphics2D g = ev.getGraphics();
        if (this.displayImage != null) {
            g.drawImage(this.displayImage, 0, 0, null);
        }
        String message = null;
        if (!this.doneRendering) {
            message = "Rendering Preview...";
        } else if (!this.doneFiltering) {
            message = "Applying Filter...";
        }
        if (message != null) {
            FontMetrics fm = g.getFontMetrics();
            int width = fm.stringWidth(message);
            g.setColor(Color.red);
            g.drawString(message, (200 - width) / 2, 75);
        }
    }

    private void applyFilters() {
        this.doneFiltering = false;
        this.preview.repaint();
        new Thread(){

            public void run() {
                ComplexImage img = CameraFilterDialog.this.unfilteredImage.duplicate();
                for (int i = 0; i < CameraFilterDialog.this.filters.size(); ++i) {
                    ((ImageFilter)CameraFilterDialog.this.filters.elementAt(i)).filterImage(img, CameraFilterDialog.this.theScene, CameraFilterDialog.this.theCamera, CameraFilterDialog.this.cameraCoords);
                }
                if (CameraFilterDialog.this.filters.size() > 0) {
                    img.rebuildImage();
                }
                CameraFilterDialog.this.displayImage = img.getImage();
                CameraFilterDialog.this.doneFiltering = true;
                CameraFilterDialog.this.preview.repaint();
            }
        }.start();
    }

    public void imageUpdated(Image image) {
        this.displayImage = image;
        this.preview.repaint();
    }

    public void statusChanged(String status) {
    }

    public void imageComplete(ComplexImage image) {
        this.unfilteredImage = image;
        this.displayImage = image.getImage();
        this.doneRendering = true;
        this.previewButton.setEnabled(true);
        this.applyFilters();
    }

    public void renderingCanceled() {
    }
}

