/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.WireframeMesh;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Camera
implements Cloneable {
    private Mat4 objectToWorld;
    private Mat4 objectToView;
    private Mat4 objectToScreen;
    private Mat4 worldToView = this.viewToWorld = Mat4.identity();
    private Mat4 worldToScreen;
    private Mat4 viewToScreen;
    private Mat4 viewToWorld;
    private double viewDist;
    private double distToScreen;
    private double scale;
    private double frontClipPlane;
    private double gridSpacing;
    private boolean perspective;
    private int hres;
    private int vres;
    private int lastX;
    private int lastY;
    private Vec3 lastPoint;
    private CoordinateSystem cameraCoords;
    private int smallObjectExtend = 4;
    private static int lineshow = 0;
    public static final int NOT_VISIBLE = 0;
    public static final int NEEDS_CLIPPING = 1;
    public static final int VISIBLE = 2;

    public Camera() {
        this.objectToView = this.viewToWorld;
        this.objectToWorld = this.viewToWorld;
        this.setDistToScreen(20.0);
        this.setScreenParams(0.0, 100.0, 100, 100);
    }

    public void setDistToScreen(double dist) {
        double oldScale = this.scale / this.distToScreen;
        this.distToScreen = dist;
        this.frontClipPlane = dist / 20.0;
        if (this.perspective) {
            this.setScreenParams(this.viewDist, oldScale, this.hres, this.vres);
        } else {
            this.setScreenParamsParallel(this.scale, this.hres, this.vres);
        }
    }

    public double getDistToScreen() {
        return this.distToScreen;
    }

    public double getClipDistance() {
        return this.frontClipPlane;
    }

    public boolean isPerspective() {
        return this.perspective;
    }

    public void setPerspective(boolean p) {
        this.perspective = p;
    }

    public Camera duplicate() {
        Camera c = null;
        try {
            c = (Camera)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        c.cameraCoords = this.cameraCoords.duplicate();
        return c;
    }

    public void setScreenParams(double newViewDist, double newScale, int newHres, int newVres) {
        this.viewDist = newViewDist;
        this.scale = newScale * this.distToScreen;
        this.hres = newHres;
        this.vres = newVres;
        this.perspective = true;
        this.viewToScreen = Mat4.perspective(this.viewDist);
        this.viewToScreen = Mat4.scale(-this.scale, -this.scale, this.scale).times(this.viewToScreen);
        this.viewToScreen = Mat4.translation((double)this.hres / 2.0, (double)this.vres / 2.0, 0.0).times(this.viewToScreen);
        this.worldToScreen = this.viewToScreen.times(this.worldToView);
        this.objectToScreen = this.worldToScreen.times(this.objectToWorld);
    }

    public void setScreenParamsParallel(double newScale, int newHres, int newVres) {
        this.scale = newScale;
        this.hres = newHres;
        this.vres = newVres;
        this.perspective = false;
        this.viewToScreen = Mat4.scale(-this.scale, -this.scale, this.scale);
        this.viewToScreen = Mat4.translation(0.5 * (double)this.hres, 0.5 * (double)this.vres, 0.0).times(this.viewToScreen);
        this.worldToScreen = this.viewToScreen.times(this.worldToView);
        this.objectToScreen = this.worldToScreen.times(this.objectToWorld);
    }

    public void setSize(int newHres, int newVres) {
        this.hres = newHres;
        this.vres = newVres;
        this.viewToScreen = this.perspective ? Mat4.perspective(this.viewDist) : Mat4.identity();
        this.viewToScreen = Mat4.scale(-this.scale, -this.scale, this.scale).times(this.viewToScreen);
        this.viewToScreen = Mat4.translation((double)this.hres / 2.0, (double)this.vres / 2.0, 0.0).times(this.viewToScreen);
        this.worldToScreen = this.viewToScreen.times(this.worldToView);
        this.objectToScreen = this.worldToScreen.times(this.objectToWorld);
    }

    public Dimension getSize() {
        return new Dimension(this.hres, this.vres);
    }

    public double getScale() {
        return this.scale;
    }

    public void setGrid(double spacing) {
        this.gridSpacing = spacing;
    }

    public void setCameraCoordinates(CoordinateSystem coords) {
        this.worldToView = coords.toLocal();
        this.viewToWorld = coords.fromLocal();
        this.objectToView = this.worldToView.times(this.objectToWorld);
        this.worldToScreen = this.viewToScreen.times(this.worldToView);
        this.objectToScreen = this.worldToScreen.times(this.objectToWorld);
        this.cameraCoords = coords;
    }

    public void setViewTransform(Mat4 worldToView, Mat4 viewToWorld) {
        this.worldToView = worldToView;
        this.viewToWorld = viewToWorld;
        this.objectToView = worldToView.times(this.objectToWorld);
        this.worldToScreen = this.viewToScreen.times(worldToView);
        this.objectToScreen = this.worldToScreen.times(this.objectToWorld);
    }

    public CoordinateSystem getCameraCoordinates() {
        return this.cameraCoords;
    }

    public void setObjectTransform(Mat4 m) {
        this.objectToWorld = m;
        this.objectToView = this.worldToView.times(this.objectToWorld);
        this.objectToScreen = this.worldToScreen.times(this.objectToWorld);
    }

    public final Mat4 getObjectToWorld() {
        return this.objectToWorld;
    }

    public final Mat4 getObjectToView() {
        return this.objectToView;
    }

    public final Mat4 getObjectToScreen() {
        return this.objectToScreen;
    }

    public final Mat4 getWorldToView() {
        return this.worldToView;
    }

    public final Mat4 getWorldToScreen() {
        return this.worldToScreen;
    }

    public final Mat4 getViewToScreen() {
        return this.viewToScreen;
    }

    public final Mat4 getViewToWorld() {
        return this.viewToWorld;
    }

    public Vec3 convertScreenToWorld(Point p, double depth) {
        return this.convertScreenToWorld(p, depth, true);
    }

    public Vec3 convertScreenToWorld(Point p, double depth, boolean snapToGrid) {
        Vec2 v1 = this.viewToScreen.timesXY(new Vec3(0.0, 0.0, depth));
        Vec2 v2 = this.viewToScreen.timesXY(new Vec3(1.0, 1.0, depth));
        Vec3 v3 = new Vec3(((double)p.x - v1.x) / (v2.x - v1.x), ((double)p.y - v1.y) / (v2.y - v1.y), depth);
        if (snapToGrid && this.gridSpacing > 0.0) {
            v3.x = Math.floor(v3.x / this.gridSpacing + 0.5) * this.gridSpacing;
            v3.y = Math.floor(v3.y / this.gridSpacing + 0.5) * this.gridSpacing;
        }
        return this.viewToWorld.times(v3);
    }

    public Vec3 findDragVector(Vec3 p, int dx, int dy) {
        Vec3 v1 = this.viewToWorld.timesDirection(Vec3.vx());
        Vec3 v2 = this.viewToWorld.timesDirection(Vec3.vy());
        Vec2 p1 = this.worldToScreen.timesXY(p);
        Vec2 v3 = this.worldToScreen.timesXY(p.plus(v1)).minus(p1);
        Vec2 v4 = this.worldToScreen.timesXY(p.plus(v2)).minus(p1);
        double b = (v3.x * (double)dy - v3.y * (double)dx) / (v3.x * v4.y - v4.x * v3.y);
        double a = ((double)dx - b * v4.x) / v3.x;
        if (this.gridSpacing > 0.0) {
            a = Math.floor(a / this.gridSpacing + 0.5) * this.gridSpacing;
            b = Math.floor(b / this.gridSpacing + 0.5) * this.gridSpacing;
        }
        return v1.times(a).plus(v2.times(b));
    }

    public Rectangle findScreenBounds(BoundingBox bb) {
        Vec3[] corner = bb.getCorners();
        double minx = this.hres;
        double miny = this.vres;
        double maxx = -1.0;
        double maxy = -1.0;
        boolean clipped = true;
        for (int i = 0; i < 8; ++i) {
            Vec2 p = this.objectToScreen.timesXY(corner[i]);
            double z = this.objectToView.timesZ(corner[i]);
            if (!this.perspective || z > this.frontClipPlane) {
                clipped = false;
                if (p.x < minx) {
                    minx = p.x;
                }
                if (p.x > maxx) {
                    maxx = p.x;
                }
                if (p.y < miny) {
                    miny = p.y;
                }
                if (!(p.y > maxy)) continue;
                maxy = p.y;
                continue;
            }
            if (p.x < (double)this.hres / 2.0) {
                maxx = this.hres;
            } else {
                minx = -1.0;
            }
            if (p.y < (double)this.vres / 2.0) {
                maxy = this.vres;
                continue;
            }
            miny = -1.0;
        }
        if (clipped || minx == (double)this.hres || miny == (double)this.vres || maxx == -1.0 || maxy == -1.0) {
            return null;
        }
        return new Rectangle((int)minx, (int)miny, (int)(Math.ceil(maxx) - minx), (int)(Math.ceil(maxy) - miny));
    }

    public int visibility(BoundingBox bb) {
        int i;
        Vec3[] corner = bb.getCorners();
        boolean offLeft = true;
        boolean offRight = true;
        boolean offTop = true;
        boolean offBottom = true;
        int clippedCount = 0;
        for (i = 0; i < 8; ++i) {
            if (!this.perspective || !(this.objectToView.timesZ(corner[i]) <= this.frontClipPlane)) continue;
            ++clippedCount;
        }
        if (clippedCount == 8) {
            return 0;
        }
        for (i = 0; i < 8; ++i) {
            Vec2 p = this.objectToScreen.timesXY(corner[i]);
            if (p.x > 0.0) {
                offLeft = false;
            }
            if (p.y > 0.0) {
                offTop = false;
            }
            if (p.x < (double)this.hres) {
                offRight = false;
            }
            if (p.y < (double)this.vres) {
                offBottom = false;
            }
            if (offLeft | offTop | offRight | offBottom) continue;
            if (clippedCount == 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public void drawLine(Graphics g, Vec3 from, Vec3 to) {
        Mat4 m = this.objectToScreen;
        double w = m.m41 * to.x + m.m42 * to.y + m.m43 * to.z + m.m44;
        this.lastX = (int)((m.m11 * to.x + m.m12 * to.y + m.m13 * to.z + m.m14) / w);
        this.lastY = (int)((m.m21 * to.x + m.m22 * to.y + m.m23 * to.z + m.m24) / w);
        w = m.m41 * from.x + m.m42 * from.y + m.m43 * from.z + m.m44;
        int x = (int)((m.m11 * from.x + m.m12 * from.y + m.m13 * from.z + m.m14) / w);
        int y = (int)((m.m21 * from.x + m.m22 * from.y + m.m23 * from.z + m.m24) / w);
        if (Math.abs(x - this.lastX) + Math.abs(y - this.lastY) > 2) {
            g.drawLine(x, y, this.lastX, this.lastY);
        } else if (++lineshow > 2) {
            g.drawLine(x, y, this.lastX, this.lastY);
            lineshow = 0;
        }
    }

    public void drawClippedLine(Graphics g, Vec3 from, Vec3 to) {
        Vec3 p2;
        Vec3 p1 = this.objectToView.times(from);
        this.lastPoint = p2 = this.objectToView.times(to);
        if (this.perspective) {
            if (p1.z <= this.frontClipPlane && p2.z <= this.frontClipPlane) {
                return;
            }
            if (p1.z < this.frontClipPlane) {
                double fract = (this.frontClipPlane - p1.z) / (p2.z - p1.z);
                p1 = p1.times(1.0 - fract).plus(p2.times(fract));
            } else if (p2.z < this.frontClipPlane) {
                double fract = (this.frontClipPlane - p2.z) / (p1.z - p2.z);
                p2 = p2.times(1.0 - fract).plus(p1.times(fract));
            }
        }
        Vec2 p3 = this.viewToScreen.timesXY(p1);
        Vec2 p4 = this.viewToScreen.timesXY(p2);
        g.drawLine((int)p3.x, (int)p3.y, (int)p4.x, (int)p4.y);
    }

    public void drawLineTo(Graphics g, Vec3 to) {
        Mat4 m = this.objectToScreen;
        double w = m.m41 * to.x + m.m42 * to.y + m.m43 * to.z + m.m44;
        int x = (int)((m.m11 * to.x + m.m12 * to.y + m.m13 * to.z + m.m14) / w);
        int y = (int)((m.m21 * to.x + m.m22 * to.y + m.m23 * to.z + m.m24) / w);
        if (Math.abs(x - this.lastX) + Math.abs(y - this.lastY) > 2) {
            g.drawLine(this.lastX, this.lastY, x, y);
            this.lastX = x;
            this.lastY = y;
        } else if (++lineshow > 2) {
            g.drawLine(x, y, this.lastX, this.lastY);
            this.lastX = x;
            this.lastY = y;
            lineshow = 0;
        }
    }

    public void drawClippedLineTo(Graphics g, Vec3 to) {
        Vec3 p2;
        Vec3 p1 = this.lastPoint;
        this.lastPoint = p2 = this.objectToView.times(to);
        if (this.perspective) {
            if (p1.z <= this.frontClipPlane && p2.z <= this.frontClipPlane) {
                return;
            }
            if (p1.z < this.frontClipPlane) {
                double fract = (this.frontClipPlane - p1.z) / (p2.z - p1.z);
                p1 = p1.times(1.0 - fract).plus(p2.times(fract));
            } else if (p2.z < this.frontClipPlane) {
                double fract = (this.frontClipPlane - p2.z) / (p1.z - p2.z);
                p2 = p2.times(1.0 - fract).plus(p1.times(fract));
            }
        }
        Vec2 p3 = this.viewToScreen.timesXY(p1);
        Vec2 p4 = this.viewToScreen.timesXY(p2);
        g.drawLine((int)p3.x, (int)p3.y, (int)p4.x, (int)p4.y);
    }

    public void drawWireframeMesh(Graphics g, WireframeMesh wmesh, BoundingBox bounds) {
        int vis = this.visibility(bounds);
        int[] from = wmesh.from;
        int[] to = wmesh.to;
        Vec3[] vert = wmesh.vert;
        int last = -1;
        Mat4 m = this.objectToScreen;
        if (vis == 0) {
            return;
        }
        if (vis == 1) {
            for (int i = 0; i < wmesh.from.length; ++i) {
                if (from[i] == last) {
                    last = to[i];
                    this.drawClippedLineTo(g, vert[last]);
                    continue;
                }
                last = to[i];
                this.drawClippedLine(g, vert[from[i]], vert[last]);
            }
        } else {
            int y;
            int x;
            int i;
            int[] screenvert = new int[vert.length * 2];
            for (i = 0; i < vert.length; ++i) {
                Vec3 pos = vert[i];
                double w = m.m41 * pos.x + m.m42 * pos.y + m.m43 * pos.z + m.m44;
                x = (int)((m.m11 * pos.x + m.m12 * pos.y + m.m13 * pos.z + m.m14) / w);
                y = (int)((m.m21 * pos.x + m.m22 * pos.y + m.m23 * pos.z + m.m24) / w);
                screenvert[i * 2] = x;
                screenvert[i * 2 + 1] = y;
            }
            for (i = 0; i < from.length; ++i) {
                int f = from[i];
                int t = to[i];
                x = screenvert[2 * f];
                y = screenvert[2 * f + 1];
                int x2 = screenvert[2 * t];
                int y2 = screenvert[2 * t + 1];
                if (Math.abs(x - x2) + Math.abs(y - y2) > 2) {
                    g.drawLine(x, y, x2, y2);
                    continue;
                }
                if (++lineshow <= 2) continue;
                g.drawLine(x, y, x2, y2);
                lineshow = 0;
            }
        }
    }

    public void drawBox(Graphics g, BoundingBox bb) {
        Vec3[] corner = bb.getCorners();
        int[] x = new int[8];
        int[] y = new int[8];
        for (int i = 0; i < 8; ++i) {
            Vec2 v = this.objectToScreen.timesXY(corner[i]);
            x[i] = (int)v.x;
            y[i] = (int)v.y;
        }
        g.drawLine(x[0], y[0], x[1], y[1]);
        g.drawLine(x[1], y[1], x[3], y[3]);
        g.drawLine(x[3], y[3], x[2], y[2]);
        g.drawLine(x[2], y[2], x[0], y[0]);
        g.drawLine(x[4], y[4], x[5], y[5]);
        g.drawLine(x[5], y[5], x[7], y[7]);
        g.drawLine(x[7], y[7], x[6], y[6]);
        g.drawLine(x[6], y[6], x[4], y[4]);
        g.drawLine(x[0], y[0], x[4], y[4]);
        g.drawLine(x[1], y[1], x[5], y[5]);
        g.drawLine(x[2], y[2], x[6], y[6]);
        g.drawLine(x[3], y[3], x[7], y[7]);
    }

    public void drawClippedBox(Graphics g, BoundingBox bb) {
        Vec3[] corner = bb.getCorners();
        this.drawClippedLine(g, corner[0], corner[1]);
        this.drawClippedLineTo(g, corner[3]);
        this.drawClippedLineTo(g, corner[2]);
        this.drawClippedLineTo(g, corner[0]);
        this.drawClippedLineTo(g, corner[4]);
        this.drawClippedLineTo(g, corner[5]);
        this.drawClippedLineTo(g, corner[7]);
        this.drawClippedLineTo(g, corner[6]);
        this.drawClippedLineTo(g, corner[4]);
        this.drawClippedLine(g, corner[1], corner[5]);
        this.drawClippedLine(g, corner[2], corner[6]);
        this.drawClippedLine(g, corner[3], corner[7]);
    }

    public void drawBezier(Graphics g, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4) {
        Mat4 m = this.objectToScreen;
        double x1 = m.m11 * v1.x + m.m12 * v1.y + m.m13 * v1.z + m.m14;
        double x2 = m.m11 * v2.x + m.m12 * v2.y + m.m13 * v2.z + m.m14;
        double x3 = m.m11 * v3.x + m.m12 * v3.y + m.m13 * v3.z + m.m14;
        double x4 = m.m11 * v4.x + m.m12 * v4.y + m.m13 * v4.z + m.m14;
        double y1 = m.m21 * v1.x + m.m22 * v1.y + m.m23 * v1.z + m.m24;
        double y2 = m.m21 * v2.x + m.m22 * v2.y + m.m23 * v2.z + m.m24;
        double y3 = m.m21 * v3.x + m.m22 * v3.y + m.m23 * v3.z + m.m24;
        double y4 = m.m21 * v4.x + m.m22 * v4.y + m.m23 * v4.z + m.m24;
        double w1 = m.m41 * v1.x + m.m42 * v1.y + m.m43 * v1.z + m.m44;
        double w2 = m.m41 * v2.x + m.m42 * v2.y + m.m43 * v2.z + m.m44;
        double w3 = m.m41 * v3.x + m.m42 * v3.y + m.m43 * v3.z + m.m44;
        double w4 = m.m41 * v4.x + m.m42 * v4.y + m.m43 * v4.z + m.m44;
        double dx1 = -0.330078125 * x1 + 0.287109375 * x2 + 0.041015625 * x3 + 0.001953125 * x4;
        double dx2 = 0.08203125 * x1 - 0.15234375 * x2 + 0.05859375 * x3 + 0.01171875 * x4;
        double dx3 = 0.01171875 * (x4 - x1) + 0.03515625 * (x2 - x3);
        double dy1 = -0.330078125 * y1 + 0.287109375 * y2 + 0.041015625 * y3 + 0.001953125 * y4;
        double dy2 = 0.08203125 * y1 - 0.15234375 * y2 + 0.05859375 * y3 + 0.01171875 * y4;
        double dy3 = 0.01171875 * (y4 - y1) + 0.03515625 * (y2 - y3);
        double dw1 = -0.330078125 * w1 + 0.287109375 * w2 + 0.041015625 * w3 + 0.001953125 * w4;
        double dw2 = 0.08203125 * w1 - 0.15234375 * w2 + 0.05859375 * w3 + 0.01171875 * w4;
        double dw3 = 0.01171875 * (w4 - w1) + 0.03515625 * (w2 - w3);
        int oldh = (int)(x1 / w1);
        int oldv = (int)(y1 / w1);
        for (int i = 0; i < 8; ++i) {
            x1 += dx1;
            dx1 += dx2;
            dx2 += dx3;
            dy1 += dy2;
            dy2 += dy3;
            dw2 += dw3;
            int h = (int)(x1 / (w1 += (dw1 += dw2)));
            int v = (int)((y1 += dy1) / w1);
            g.drawLine(oldh, oldv, h, v);
            oldh = h;
            oldv = v;
        }
    }

    public void drawClippedBezier(Graphics g, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4) {
        boolean clip4;
        boolean clip1 = this.perspective && this.objectToView.timesZ(v1) < this.frontClipPlane;
        boolean clip2 = this.perspective && this.objectToView.timesZ(v2) < this.frontClipPlane;
        boolean clip3 = this.perspective && this.objectToView.timesZ(v3) < this.frontClipPlane;
        boolean bl = clip4 = this.perspective && this.objectToView.timesZ(v4) < this.frontClipPlane;
        if (clip1 && clip2 && clip3 && clip4) {
            return;
        }
        if (!(clip1 || clip2 || clip3 || clip4)) {
            this.drawBezier(g, v1, v2, v3, v4);
        }
        double dx1 = -0.330078125 * v1.x + 0.287109375 * v2.x + 0.041015625 * v3.x + 0.001953125 * v4.x;
        double dx2 = 0.08203125 * v1.x - 0.15234375 * v2.x + 0.05859375 * v3.x + 0.01171875 * v4.x;
        double dx3 = 0.01171875 * (v4.x - v1.x) + 0.03515625 * (v2.x - v3.x);
        double dy1 = -0.330078125 * v1.y + 0.287109375 * v2.y + 0.041015625 * v3.y + 0.001953125 * v4.y;
        double dy2 = 0.08203125 * v1.y - 0.15234375 * v2.y + 0.05859375 * v3.y + 0.01171875 * v4.y;
        double dy3 = 0.01171875 * (v4.y - v1.y) + 0.03515625 * (v2.y - v3.y);
        double dz1 = -0.330078125 * v1.z + 0.287109375 * v2.z + 0.041015625 * v3.z + 0.001953125 * v4.z;
        double dz2 = 0.08203125 * v1.z - 0.15234375 * v2.z + 0.05859375 * v3.z + 0.01171875 * v4.z;
        double dz3 = 0.01171875 * (v4.z - v1.z) + 0.03515625 * (v2.z - v3.z);
        Vec3 pos = new Vec3(v1.x + dx1, v1.y + dy1, v1.z + dz1);
        dx1 += dx2;
        dx2 += dx3;
        dy1 += dy2;
        dy2 += dy3;
        dz1 += dz2;
        dz2 += dz3;
        this.drawClippedLine(g, v1, pos);
        for (int i = 0; i < 7; ++i) {
            pos.x += dx1;
            dx1 += dx2;
            dx2 += dx3;
            pos.y += dy1;
            dy1 += dy2;
            dy2 += dy3;
            pos.z += dz1;
            dz1 += dz2;
            dz2 += dz3;
            this.drawClippedLineTo(g, pos);
        }
    }

    public void drawBezier2(Graphics g, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4) {
        Mat4 m = this.objectToScreen;
        int x1 = (int)((m.m11 * v1.x + m.m12 * v1.y + m.m13 * v1.z + m.m14) * 65536.0);
        int x2 = (int)((m.m11 * v2.x + m.m12 * v2.y + m.m13 * v2.z + m.m14) * 65536.0);
        int x3 = (int)((m.m11 * v3.x + m.m12 * v3.y + m.m13 * v3.z + m.m14) * 65536.0);
        int x4 = (int)((m.m11 * v4.x + m.m12 * v4.y + m.m13 * v4.z + m.m14) * 65536.0);
        int y1 = (int)((m.m21 * v1.x + m.m22 * v1.y + m.m23 * v1.z + m.m24) * 65536.0);
        int y2 = (int)((m.m21 * v2.x + m.m22 * v2.y + m.m23 * v2.z + m.m24) * 65536.0);
        int y3 = (int)((m.m21 * v3.x + m.m22 * v3.y + m.m23 * v3.z + m.m24) * 65536.0);
        int y4 = (int)((m.m21 * v4.x + m.m22 * v4.y + m.m23 * v4.z + m.m24) * 65536.0);
        int w1 = (int)((m.m41 * v1.x + m.m42 * v1.y + m.m43 * v1.z + m.m44) * 65536.0);
        int w2 = (int)((m.m41 * v2.x + m.m42 * v2.y + m.m43 * v2.z + m.m44) * 65536.0);
        int w3 = (int)((m.m41 * v3.x + m.m42 * v3.y + m.m43 * v3.z + m.m44) * 65536.0);
        int w4 = (int)((m.m41 * v4.x + m.m42 * v4.y + m.m43 * v4.z + m.m44) * 65536.0);
        this.divideAndDraw(g, x1, x2, x3, x4, y1, y2, y3, y4, w1, w2, w3, w4, 3);
    }

    void divideAndDraw(Graphics g, int x1, int x2, int x3, int x4, int y1, int y2, int y3, int y4, int w1, int w2, int w3, int w4, int count) {
        int xl2 = x1 + x2 >> 1;
        int xh = x2 + x3 >> 1;
        int xl3 = xl2 + xh >> 1;
        int xr3 = x3 + x4 >> 1;
        int xr2 = xh + xr3 >> 1;
        int xl4 = xl3 + xr2 >> 1;
        int yl2 = y1 + y2 >> 1;
        int yh = y2 + y3 >> 1;
        int yl3 = yl2 + yh >> 1;
        int yr3 = y3 + y4 >> 1;
        int yr2 = yh + yr3 >> 1;
        int yl4 = yl3 + yr2 >> 1;
        int wl2 = w1 + w2 >> 1;
        int wh = w2 + w3 >> 1;
        int wl3 = wl2 + wh >> 1;
        int wr3 = w3 + w4 >> 1;
        int wr2 = wh + wr3 >> 1;
        int wl4 = wl3 + wr2 >> 1;
        if (count == 1) {
            g.drawLine(x1 / w1, y1 / w1, xl4 / wl4, yl4 / wl4);
            g.drawLine(x4 / w4, y4 / w4, xl4 / wl4, yl4 / wl4);
            return;
        }
        this.divideAndDraw(g, x1, xl2, xl3, xl4, y1, yl2, yl3, yl4, w1, wl2, wl3, wl4, count - 1);
        this.divideAndDraw(g, xl4, xr2, xr3, x4, yl4, yr2, yr3, y4, wl4, wr2, wr3, w4, count - 1);
    }
}

