/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CSGDialog;
import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.MoveObjectTool;
import artofillusion.MoveViewTool;
import artofillusion.Renderer;
import artofillusion.RenderingDialog;
import artofillusion.RotateObjectTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleObjectTool;
import artofillusion.Scene;
import artofillusion.SceneViewer;
import artofillusion.TransformDialog;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.CSGObject;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.KeyPressedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BComboBox;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BStandardDialog;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class CSGEditorWindow
extends BFrame
implements EditingWindow {
    EditingWindow parentWindow;
    SceneViewer theView;
    EditingTool defaultTool;
    EditingTool currentTool;
    BLabel helpText;
    CSGObject oldObject;
    CSGObject theObject;
    UndoRecord undo;
    ToolPalette tools;
    BMenuBar menubar;
    BMenu editMenu;
    BMenu objectMenu;
    BMenuItem undoItem;
    BMenuItem[] objectMenuItem;
    BCheckBoxMenuItem[] displayItem;
    Scene theScene;
    Runnable onClose;

    public CSGEditorWindow(EditingWindow parent, String title, CSGObject obj, Runnable onClose) {
        super(title);
        this.parentWindow = parent;
        this.oldObject = obj;
        this.theObject = (CSGObject)obj.duplicate();
        this.onClose = onClose;
        this.theScene = new Scene();
        this.theScene.addObject(obj.getObject1().object.duplicate(), obj.getObject1().coords.duplicate(), obj.getObject1().name, null);
        this.theScene.addObject(obj.getObject2().object.duplicate(), obj.getObject2().coords.duplicate(), obj.getObject2().name, null);
        FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{0.0, 1.0, 0.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.helpText = new BLabel();
        content.add(this.helpText, 0, 2, 2, 1);
        FormContainer top = new FormContainer(new double[]{0.0, 1.0, 0.0, 0.0}, new double[]{1.0});
        content.add(top, 1, 0);
        RowContainer viewControls = new RowContainer();
        top.add(viewControls, 0, 0);
        this.theView = new SceneViewer(this.theScene, viewControls, this);
        content.add(this.theView, 1, 1);
        top.add(Translate.button("ok", this, "doOk"), 2, 0);
        top.add(Translate.button("cancel", this, "doCancel"), 3, 0);
        this.tools = new ToolPalette(1, 5);
        content.add(this.tools, 0, 0, 1, 2, new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.NONE, null, null));
        this.defaultTool = new MoveObjectTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new RotateObjectTool(this));
        this.tools.addTool(new ScaleObjectTool(this));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        this.theView.setMetaTool(metaTool);
        this.theView.setAltTool(altTool);
        UIUtilities.applyDefaultFont(content);
        UIUtilities.applyDefaultBackground(content);
        this.menubar = new BMenuBar();
        this.setMenuBar(this.menubar);
        this.createEditMenu();
        this.createObjectMenu();
        UIUtilities.recursivelyAddKeyPressedListeners(this);
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 3 / 4, d1.height * 3 / 4);
        this.setBounds(new Rectangle((d1.width - d2.width) / 2, (d1.height - d2.height) / 2, d2.width, d2.height));
        this.tools.requestFocus();
        this.updateMenus();
        this.setVisible(true);
    }

    void createEditMenu() {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.undoItem = Translate.menuItem("undo", this, "undoCommand");
        this.editMenu.add(this.undoItem);
        this.undoItem.setEnabled(false);
        this.editMenu.addSeparator();
        this.editMenu.add(Translate.menuItem("selectAll", this, "selectAllCommand"));
        this.editMenu.add(Translate.menuItem("properties", this, "propertiesCommand"));
    }

    void createObjectMenu() {
        this.objectMenu = Translate.menu("object");
        this.menubar.add(this.objectMenu);
        this.objectMenuItem = new BMenuItem[5];
        this.objectMenuItem[0] = Translate.menuItem("editObject", this, "editObjectCommand");
        this.objectMenu.add(this.objectMenuItem[0]);
        this.objectMenuItem[1] = Translate.menuItem("objectLayout", this, "objectLayoutCommand");
        this.objectMenu.add(this.objectMenuItem[1]);
        this.objectMenuItem[2] = Translate.menuItem("transformObject", this, "transformObjectCommand");
        this.objectMenu.add(this.objectMenuItem[2]);
        this.objectMenuItem[3] = Translate.menuItem("alignObjects", this, "alignObjectsCommand");
        this.objectMenu.add(this.objectMenuItem[3]);
        this.objectMenu.add(Translate.menuItem("centerObjects", this, "centerObjectsCommand"));
        this.objectMenuItem[4] = Translate.menuItem("convertToTriangle", this, "convertToTriangleCommand");
        this.objectMenu.add(this.objectMenuItem[4]);
        this.objectMenu.addSeparator();
        if (ModellingApp.getPreferences().getObjectPreviewRenderer() != null) {
            this.objectMenu.add(Translate.menuItem("renderPreview", this, "renderPreviewCommand"));
        }
        BMenu displayMenu = Translate.menu("displayMode");
        this.objectMenu.add(displayMenu);
        this.displayItem = new BCheckBoxMenuItem[3];
        this.displayItem[0] = Translate.checkboxMenuItem("wireframeDisplay", this, "displayModeChanged", this.theView.getRenderMode() == 0);
        displayMenu.add(this.displayItem[0]);
        this.displayItem[1] = Translate.checkboxMenuItem("shadedDisplay", this, "displayModeChanged", this.theView.getRenderMode() == 1);
        displayMenu.add(this.displayItem[1]);
        this.displayItem[2] = Translate.checkboxMenuItem("smoothDisplay", this, "displayModeChanged", this.theView.getRenderMode() == 2);
        displayMenu.add(this.displayItem[2]);
    }

    public boolean confirmClose() {
        return true;
    }

    public void setTool(EditingTool tool) {
        this.theView.setTool(tool);
        this.currentTool = tool;
    }

    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    public BFrame getFrame() {
        return this;
    }

    public void updateImage() {
        this.theView.updateImage();
        this.theView.repaint();
    }

    public void updateMenus() {
        int[] selected = this.theScene.getSelection();
        this.objectMenuItem[0].setEnabled(selected.length == 1);
        this.objectMenuItem[1].setEnabled(selected.length > 0);
        this.objectMenuItem[2].setEnabled(selected.length > 0);
        this.objectMenuItem[3].setEnabled(selected.length > 1);
        this.objectMenuItem[4].setEnabled(selected.length == 1);
    }

    public void setUndoRecord(UndoRecord command) {
        this.undo = command;
        this.undoItem.setEnabled(true);
        if (this.undo.isRedo()) {
            this.undoItem.setText(Translate.text("menu.redo"));
        } else {
            this.undoItem.setText(Translate.text("menu.undo"));
        }
        this.updateMenus();
    }

    public Scene getScene() {
        return this.theScene;
    }

    public ViewerCanvas getView() {
        return this.theView;
    }

    private void keyPressed(KeyPressedEvent e) {
        int code = e.getKeyCode();
        if (e.isShiftDown() && (code == 37 || code == 39 || code == 38 || code == 40)) {
            this.tools.keyPressed(e);
        } else {
            this.currentTool.keyPressed(e, this.theView);
        }
    }

    private void doOk() {
        this.updateFromScene();
        this.oldObject.copyObject(this.theObject);
        this.theObject = null;
        this.oldObject = null;
        this.theScene = null;
        this.dispose();
        this.onClose.run();
        this.parentWindow.updateImage();
        this.parentWindow.updateMenus();
    }

    private void doCancel() {
        this.theObject = null;
        this.oldObject = null;
        this.theScene = null;
        this.dispose();
    }

    private void displayModeChanged(WidgetEvent ev) {
        Widget source = ev.getWidget();
        for (int i = 0; i < this.displayItem.length; ++i) {
            this.displayItem[i].setState(source == this.displayItem[i]);
        }
        if (source == this.displayItem[0]) {
            this.theView.setRenderMode(0);
        } else if (source == this.displayItem[1]) {
            this.theView.setRenderMode(1);
        } else if (source == this.displayItem[2]) {
            this.theView.setRenderMode(2);
        }
        this.updateImage();
    }

    private void updateFromScene() {
        this.theObject.setComponentObjects(this.theScene.getObject(0), this.theScene.getObject(1));
    }

    void undoCommand() {
        if (this.undo == null) {
            return;
        }
        this.setUndoRecord(this.undo.execute());
        this.updateImage();
        this.updateMenus();
    }

    void selectAllCommand() {
        this.theScene.setSelection(new int[]{0, 1});
        this.updateImage();
        this.updateMenus();
    }

    void propertiesCommand() {
        this.updateFromScene();
        CSGDialog dial = new CSGDialog(this, this.theObject);
    }

    void editObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        Object3D obj = this.theScene.getObject((int)sel[0]).object;
        if (obj.isEditable()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{obj, obj.duplicate()}));
            obj.edit(this, this.theScene.getObject(sel[0]), null);
        }
    }

    void objectLayoutCommand() {
        int i;
        int[] sel = this.theScene.getSelection();
        Object3D[] obj = new Object3D[sel.length];
        CoordinateSystem[] coords = new CoordinateSystem[sel.length];
        if (sel.length == 0) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false));
        for (i = 0; i < sel.length; ++i) {
            obj[i] = this.theScene.getObject((int)sel[i]).object;
            coords[i] = this.theScene.getObject((int)sel[i]).coords;
            this.undo.addCommand(0, new Object[]{obj[i], obj[i].duplicate()});
            this.undo.addCommand(1, new Object[]{coords[i], coords[i].duplicate()});
        }
        if (sel.length == 1) {
            Vec3 orig = coords[0].getOrigin();
            double[] angles = coords[0].getRotationAngles();
            Vec3 size = this.theScene.getObject(sel[0]).getBounds().getSize();
            TransformDialog dlg = new TransformDialog(this, Translate.text("objectLayoutTitle", this.theScene.getObject((int)sel[0]).name), new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], size.x, size.y, size.z}, false, false);
            double[] values = dlg.getValues();
            if (!Double.isNaN(values[0])) {
                orig.x = values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y = values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z = values[2];
            }
            if (!Double.isNaN(values[3])) {
                angles[0] = values[3];
            }
            if (!Double.isNaN(values[4])) {
                angles[1] = values[4];
            }
            if (!Double.isNaN(values[5])) {
                angles[2] = values[5];
            }
            if (!Double.isNaN(values[6])) {
                size.x = values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y = values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z = values[8];
            }
            coords[0].setOrigin(orig);
            coords[0].setOrientation(angles[0], angles[1], angles[2]);
            obj[0].setSize(size.x, size.y, size.z);
        } else {
            TransformDialog dlg = new TransformDialog(this, Translate.text("objectLayoutTitleMultiple"), false, false);
            double[] values = dlg.getValues();
            for (i = 0; i < sel.length; ++i) {
                Vec3 orig = coords[i].getOrigin();
                double[] angles = coords[i].getRotationAngles();
                Vec3 size = this.theScene.getObject(sel[i]).getBounds().getSize();
                if (!Double.isNaN(values[0])) {
                    orig.x = values[0];
                }
                if (!Double.isNaN(values[1])) {
                    orig.y = values[1];
                }
                if (!Double.isNaN(values[2])) {
                    orig.z = values[2];
                }
                if (!Double.isNaN(values[3])) {
                    angles[0] = values[3];
                }
                if (!Double.isNaN(values[4])) {
                    angles[1] = values[4];
                }
                if (!Double.isNaN(values[5])) {
                    angles[2] = values[5];
                }
                if (!Double.isNaN(values[6])) {
                    size.x = values[6];
                }
                if (!Double.isNaN(values[7])) {
                    size.y = values[7];
                }
                if (!Double.isNaN(values[8])) {
                    size.z = values[8];
                }
                coords[i].setOrigin(orig);
                coords[i].setOrientation(angles[0], angles[1], angles[2]);
                obj[i].setSize(size.x, size.y, size.z);
            }
        }
        this.updateImage();
    }

    void transformObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length == 0) {
            return;
        }
        TransformDialog dlg = sel.length == 1 ? new TransformDialog(this, Translate.text("transformObjectTitle", this.theScene.getObject((int)sel[0]).name), new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true) : new TransformDialog(this, Translate.text("transformObjectTitleMultiple"), new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true);
        double[] values = dlg.getValues();
        this.setUndoRecord(new UndoRecord(this, false));
        for (int i = 0; i < sel.length; ++i) {
            Object3D obj = this.theScene.getObject((int)sel[i]).object;
            CoordinateSystem coords = this.theScene.getObject((int)sel[i]).coords;
            this.undo.addCommand(0, new Object[]{obj, obj.duplicate()});
            this.undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            Vec3 orig = coords.getOrigin();
            Vec3 size = obj.getBounds().getSize();
            if (!Double.isNaN(values[0])) {
                orig.x += values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y += values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z += values[2];
            }
            Mat4 m = Mat4.identity();
            if (!Double.isNaN(values[3])) {
                m = m.times(Mat4.xrotation(values[3] * Math.PI / 180.0));
            }
            if (!Double.isNaN(values[4])) {
                m = m.times(Mat4.yrotation(values[4] * Math.PI / 180.0));
            }
            if (!Double.isNaN(values[5])) {
                m = m.times(Mat4.zrotation(values[5] * Math.PI / 180.0));
            }
            if (!Double.isNaN(values[6])) {
                size.x *= values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y *= values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z *= values[8];
            }
            coords.setOrigin(orig);
            coords.transformAxes(m);
            obj.setSize(size.x, size.y, size.z);
        }
        this.updateImage();
    }

    void alignObjectsCommand() {
        Vec3 orig;
        Vec3 center;
        BoundingBox bounds;
        CoordinateSystem coords;
        Object3D obj;
        int i;
        int[] sel = this.theScene.getSelection();
        RowContainer px = new RowContainer();
        RowContainer py = new RowContainer();
        RowContainer pz = new RowContainer();
        if (sel.length == 0) {
            return;
        }
        BComboBox xchoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Right"), Translate.text("Center"), Translate.text("Left"), Translate.text("Origin")});
        px.add(xchoice);
        px.add(Translate.label("alignTo"));
        ValueField vfx = new ValueField(Double.NaN, 0, 5);
        px.add(vfx);
        BComboBox ychoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Top"), Translate.text("Center"), Translate.text("Bottom"), Translate.text("Origin")});
        py.add(ychoice);
        py.add(Translate.label("alignTo"));
        ValueField vfy = new ValueField(Double.NaN, 0, 5);
        py.add(vfy);
        BComboBox zchoice = new BComboBox(new String[]{Translate.text("doNotAlign"), Translate.text("Front"), Translate.text("Center"), Translate.text("Back"), Translate.text("Origin")});
        pz.add(zchoice);
        pz.add(Translate.label("alignTo"));
        ValueField vfz = new ValueField(Double.NaN, 0, 5);
        pz.add(vfz);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("alignObjectsTitle"), new Widget[]{px, py, pz}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false));
        Vec3 alignTo = new Vec3();
        for (i = 0; i < sel.length; ++i) {
            obj = this.theScene.getObject((int)sel[i]).object;
            coords = this.theScene.getObject((int)sel[i]).coords;
            bounds = obj.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            if (!Double.isNaN(vfx.getValue())) {
                alignTo.x += vfx.getValue();
            } else if (xchoice.getSelectedIndex() == 1) {
                alignTo.x += bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                alignTo.x += center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                alignTo.x += bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                alignTo.x += orig.x;
            }
            if (!Double.isNaN(vfy.getValue())) {
                alignTo.y += vfy.getValue();
            } else if (ychoice.getSelectedIndex() == 1) {
                alignTo.y += bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                alignTo.y += center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                alignTo.y += bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                alignTo.y += orig.y;
            }
            if (!Double.isNaN(vfz.getValue())) {
                alignTo.z += vfz.getValue();
                continue;
            }
            if (zchoice.getSelectedIndex() == 1) {
                alignTo.z += bounds.maxz;
                continue;
            }
            if (zchoice.getSelectedIndex() == 2) {
                alignTo.z += center.z;
                continue;
            }
            if (zchoice.getSelectedIndex() == 3) {
                alignTo.z += bounds.minz;
                continue;
            }
            if (zchoice.getSelectedIndex() != 4) continue;
            alignTo.z += orig.z;
        }
        alignTo.scale(1.0 / (double)sel.length);
        for (i = 0; i < sel.length; ++i) {
            obj = this.theScene.getObject((int)sel[i]).object;
            coords = this.theScene.getObject((int)sel[i]).coords;
            bounds = obj.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            this.undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            if (xchoice.getSelectedIndex() == 1) {
                orig.x += alignTo.x - bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                orig.x += alignTo.x - center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                orig.x += alignTo.x - bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                orig.x += alignTo.x - orig.x;
            }
            if (ychoice.getSelectedIndex() == 1) {
                orig.y += alignTo.y - bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                orig.y += alignTo.y - center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                orig.y += alignTo.y - bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                orig.y += alignTo.y - orig.y;
            }
            if (zchoice.getSelectedIndex() == 1) {
                orig.z += alignTo.z - bounds.maxz;
            } else if (zchoice.getSelectedIndex() == 2) {
                orig.z += alignTo.z - center.z;
            } else if (zchoice.getSelectedIndex() == 3) {
                orig.z += alignTo.z - bounds.minz;
            } else if (zchoice.getSelectedIndex() == 4) {
                orig.z += alignTo.z - orig.z;
            }
            coords.setOrigin(orig);
        }
        this.updateImage();
    }

    void centerObjectsCommand() {
        BoundingBox bounds = null;
        for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo info = this.theScene.getObject(i);
            BoundingBox b = info.getBounds().transformAndOutset(info.coords.fromLocal());
            bounds = bounds == null ? b : bounds.merge(b);
        }
        Vec3 center = bounds.getCenter();
        this.setUndoRecord(new UndoRecord(this, false));
        for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo info = this.theScene.getObject(i);
            this.undo.addCommand(1, new Object[]{info.coords, info.coords.duplicate()});
            info.coords.setOrigin(info.coords.getOrigin().minus(center));
        }
        this.updateImage();
    }

    void convertToTriangleCommand() {
        TriangleMesh mesh;
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = this.theScene.getObject(sel[0]);
        Object3D obj = info.object;
        if (obj.canConvertToTriangleMesh() == 0) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 2, new Object[]{info, info.duplicate()}));
        if (obj.canConvertToTriangleMesh() == 1) {
            mesh = obj.convertToTriangleMesh(0.0);
        } else {
            ValueField errorField = new ValueField(0.1, 3);
            ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("selectToleranceForMesh"), new Widget[]{errorField}, new String[]{Translate.text("maxError")});
            if (!dlg.clickedOk()) {
                return;
            }
            mesh = obj.convertToTriangleMesh(errorField.getValue());
        }
        if (mesh == null) {
            new BStandardDialog("", Translate.text("cannotTriangulate"), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        ((Object3D)mesh).setTexture(obj.getTexture(), obj.getTextureMapping());
        mesh.setMaterial(obj.getMaterial(), obj.getMaterialMapping());
        this.theScene.getObject((int)sel[0]).object = mesh;
        this.theView.updateImage();
        this.updateMenus();
    }

    public void renderPreviewCommand() {
        Scene sc = new Scene();
        Camera theCamera = this.theView.getCamera();
        double dist = theCamera.getDistToScreen();
        Renderer rend = ModellingApp.getPreferences().getObjectPreviewRenderer();
        if (rend == null) {
            return;
        }
        this.updateFromScene();
        sc.addObject(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), theCamera.getCameraCoordinates(), "", null);
        sc.addObject(this.theObject, new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy()), "", null);
        this.theView.adjustCamera(true);
        rend.configurePreview();
        ObjectInfo cameraInfo = new ObjectInfo(new SceneCamera(), theCamera.getCameraCoordinates(), "");
        new RenderingDialog(this, rend, sc, theCamera, cameraInfo);
    }
}

