/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.Scene;
import artofillusion.object.CSGModeller;
import artofillusion.object.CSGObject;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BorderContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Dimension;

public class CSGDialog
extends BDialog {
    private CSGObject theObject;
    private CSGModeller modeller;
    private Texture texture;
    private BComboBox opChoice;
    private BButton okButton;
    private BButton cancelButton;
    private ObjectPreviewCanvas preview;
    private int[] operation;
    private boolean ok;
    private static int counter = 1;

    public CSGDialog(EditingWindow window, CSGObject obj) {
        super(window.getFrame(), true);
        this.theObject = obj;
        Scene scene = window.getScene();
        this.texture = scene.getDefaultTexture();
        BorderContainer content = new BorderContainer();
        this.setContent(content);
        RowContainer opRow = new RowContainer();
        content.add(opRow, BorderContainer.NORTH);
        opRow.add(new BLabel(Translate.text("Operation") + ":"));
        this.opChoice = new BComboBox();
        opRow.add(this.opChoice);
        int i = 0;
        this.operation = new int[5];
        if (obj.getObject1().object.isClosed() && obj.getObject2().object.isClosed()) {
            this.opChoice.add(Translate.text("Union"));
            this.operation[i++] = 0;
        }
        this.opChoice.add(Translate.text("Intersection"));
        this.operation[i++] = 1;
        if (obj.getObject2().object.isClosed()) {
            this.opChoice.add(Translate.text("firstSecond"));
            this.operation[i++] = 2;
        }
        if (obj.getObject1().object.isClosed()) {
            this.opChoice.add(Translate.text("secondFirst"));
            this.operation[i++] = 3;
        }
        for (int j = 0; j < i; ++j) {
            if (obj.getOperation() != this.operation[j]) continue;
            this.opChoice.setSelectedIndex(j);
        }
        this.opChoice.addEventLink(ValueChangedEvent.class, (Object)this, "makePreview");
        this.preview = new ObjectPreviewCanvas(null);
        content.add(this.preview, BorderContainer.CENTER);
        this.preview.setPreferredSize(new Dimension(200, 200));
        RowContainer buttons = new RowContainer();
        this.okButton = Translate.button("ok", this, "doOk");
        buttons.add(this.okButton);
        this.cancelButton = Translate.button("cancel", this, "dispose");
        buttons.add(this.cancelButton);
        content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
        this.makePreview();
        this.pack();
        UIUtilities.centerDialog(this, window.getFrame());
        this.setVisible(true);
    }

    private void doOk() {
        this.theObject.setOperation(this.operation[this.opChoice.getSelectedIndex()]);
        this.ok = true;
        this.dispose();
    }

    private void makePreview() {
        if (this.modeller == null) {
            double tol = ModellingApp.getPreferences().getInteractiveSurfaceError();
            TriangleMesh mesh1 = this.theObject.getObject1().object.convertToTriangleMesh(tol);
            TriangleMesh mesh2 = this.theObject.getObject2().object.convertToTriangleMesh(tol);
            this.modeller = new CSGModeller(mesh1, mesh2, this.theObject.getObject1().coords, this.theObject.getObject2().coords);
        }
        TriangleMesh trimesh = this.modeller.getMesh(this.operation[this.opChoice.getSelectedIndex()]);
        trimesh.setTexture(this.texture, this.texture.getDefaultMapping());
        this.preview.setObject(trimesh);
        this.preview.updateImage();
        this.preview.repaint();
    }

    public boolean clickedOk() {
        return this.ok;
    }
}

