/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.TriMeshBeveler;
import artofillusion.TriMeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.Vec3;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BComboBox;
import buoy.widget.Widget;
import java.awt.Image;
import java.awt.Point;

public class BevelExtrudeTool
extends EditingTool {
    private boolean[] selected;
    private boolean noSelection;
    private boolean separateFaces;
    private static Image icon;
    private static Image selectedIcon;
    private TriangleMesh origMesh;
    private TriMeshBeveler beveler;
    private Point clickPoint;
    private double width;
    private double height;

    public BevelExtrudeTool(EditingWindow fr) {
        super(fr);
        if (icon == null) {
            icon = this.loadImage("bevel.gif");
        }
        if (selectedIcon == null) {
            selectedIcon = this.loadImage("selected/bevel.gif");
        }
    }

    private void recordSelection() {
        TriMeshViewer view = (TriMeshViewer)this.theWindow.getView();
        this.selected = view.getSelection();
        this.noSelection = false;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            return;
        }
        this.noSelection = true;
    }

    public void activate() {
        super.activate();
        this.recordSelection();
        if (this.noSelection) {
            this.theWindow.setHelpText(Translate.text("bevelExtrudeTool.errorText"));
        } else {
            this.theWindow.setHelpText(Translate.text("bevelExtrudeTool.helpText"));
        }
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("bevelExtrudeTool.tipText");
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        this.recordSelection();
        if (this.noSelection) {
            return;
        }
        TriMeshViewer mv = (TriMeshViewer)view;
        this.selected = mv.getSelection();
        TriangleMesh mesh = (TriangleMesh)mv.getObject().object;
        this.origMesh = (TriangleMesh)mesh.duplicate();
        int selectMode = mv.getSelectionMode();
        int mode = selectMode == 0 ? 3 : (selectMode == 1 ? 2 : (this.separateFaces ? 0 : 1));
        this.beveler = new TriMeshBeveler(this.origMesh, this.selected, mode);
        this.clickPoint = e.getPoint();
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.noSelection) {
            return;
        }
        TriMeshViewer mv = (TriMeshViewer)view;
        TriangleMesh mesh = (TriangleMesh)mv.getObject().object;
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        Vec3 dragVec = cam.convertScreenToWorld(dragPoint, cam.getDistToScreen()).minus(cam.convertScreenToWorld(this.clickPoint, cam.getDistToScreen()));
        this.width = 0.5 * dragVec.x;
        this.height = dragVec.y;
        this.width = (double)(dragPoint.x - this.clickPoint.x) / cam.getScale();
        this.height = (double)(this.clickPoint.y - dragPoint.y) / cam.getScale();
        if (mv.getSelectionMode() == 2) {
            if (e.isShiftDown()) {
                if (Math.abs(this.width) > Math.abs(this.height)) {
                    this.height = 0.0;
                } else {
                    this.width = 0.0;
                }
            }
        } else {
            if (e.isShiftDown()) {
                this.height = 0.0;
            }
            if (this.width < 0.0) {
                this.width = 0.0;
            }
        }
        mesh.copyObject(this.beveler.bevelMesh(this.height, this.width));
        mv.setMesh(mesh);
        mv.setSelection(this.beveler.getNewSelection());
        this.theWindow.setHelpText(Translate.text("bevelExtrudeTool.dragText", new Double(this.width), new Double(this.height)));
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.noSelection || this.width == 0.0 && this.height == 0.0) {
            return;
        }
        TriMeshViewer mv = (TriMeshViewer)view;
        TriangleMesh mesh = (TriangleMesh)mv.getObject().object;
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{mesh, this.origMesh}));
        mv.objectChanged();
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("bevelExtrudeTool.helpText"));
    }

    public void iconDoubleClicked() {
        BComboBox c = new BComboBox(new String[]{Translate.text("selectionAsWhole"), Translate.text("individualFaces")});
        c.setSelectedIndex(this.separateFaces ? 1 : 0);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("applyExtrudeTo"), new Widget[]{c}, new String[]{null});
        if (dlg.clickedOk()) {
            this.separateFaces = c.getSelectedIndex() == 1;
        }
    }
}

